// DO NOT EDIT: This file is autogenerated via the builtin command.

package usage

import (
	ast "github.com/influxdata/flux/ast"
	runtime "github.com/influxdata/flux/runtime"
)

func init() {
	runtime.RegisterPackage(pkgAST)
}

var pkgAST = &ast.Package{
	BaseNode: ast.BaseNode{
		Comments: nil,
		Errors:   nil,
		Loc:      nil,
	},
	Files: []*ast.File{&ast.File{
		BaseNode: ast.BaseNode{
			Comments: nil,
			Errors:   nil,
			Loc: &ast.SourceLocation{
				End: ast.Position{
					Column: 2,
					Line:   57,
				},
				File:   "usage.flux",
				Source: "package usage\n\n\nimport \"csv\"\nimport \"experimental/influxdb\"\nimport \"experimental/json\"\nimport \"http\"\n\n// from returns an organization's usage data. The time range to query is\n// bounded by start and stop arguments. Optional orgID, host and token arguments\n// allow cross-org and/or cross-cluster queries. Setting the raw parameter will\n// return raw usage data rather than the downsampled data returned by default.\n// Note that unlike the range function, the stop argument is required here,\n// pending implementation of https://github.com/influxdata/flux/issues/3629.\nfrom = (\n        start,\n        stop,\n        host=\"\",\n        orgID=\"\",\n        token=\"\",\n        raw=false,\n) => {\n    id = if orgID == \"\" then \"{orgID}\" else http.pathEscape(inputString: orgID)\n    response = influxdb.api(\n        method: \"get\",\n        path: \"/api/v2/orgs/\" + id + \"/usage\",\n        host: host,\n        token: token,\n        query: [\n            \"start\": string(v: start),\n            \"stop\": string(v: stop),\n            \"raw\": string(v: raw),\n        ],\n    )\n\n    return if response.statusCode > 299 then\n        die(msg: \"organization usage request returned status \" + string(v: response.statusCode) + \": \" + string(v: response.body))\n    else\n        csv.from(csv: string(v: response.body))\n}\n\n// limits returns an organization's usage limits. Optional orgID, host\n// and token arguments allow cross-org and/or cross-cluster calls.\nlimits = (host=\"\", orgID=\"\", token=\"\") => {\n    id = if orgID == \"\" then \"{orgID}\" else http.pathEscape(inputString: orgID)\n    response = influxdb.api(\n        method: \"get\",\n        path: \"/api/v2/orgs/\" + id + \"/limits\",\n        host: host,\n        token: token,\n    )\n\n    return if response.statusCode > 299 then\n        die(msg: \"organization limits request returned status \" + string(v: response.statusCode) + \": \" + string(v: response.body))\n    else\n        json.parse(data: response.body).limits\n}",
				Start: ast.Position{
					Column: 1,
					Line:   1,
				},
			},
		},
		Body: []ast.Statement{&ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   40,
					},
					File:   "usage.flux",
					Source: "from = (\n        start,\n        stop,\n        host=\"\",\n        orgID=\"\",\n        token=\"\",\n        raw=false,\n) => {\n    id = if orgID == \"\" then \"{orgID}\" else http.pathEscape(inputString: orgID)\n    response = influxdb.api(\n        method: \"get\",\n        path: \"/api/v2/orgs/\" + id + \"/usage\",\n        host: host,\n        token: token,\n        query: [\n            \"start\": string(v: start),\n            \"stop\": string(v: stop),\n            \"raw\": string(v: raw),\n        ],\n    )\n\n    return if response.statusCode > 299 then\n        die(msg: \"organization usage request returned status \" + string(v: response.statusCode) + \": \" + string(v: response.body))\n    else\n        csv.from(csv: string(v: response.body))\n}",
					Start: ast.Position{
						Column: 1,
						Line:   15,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// from returns an organization's usage data. The time range to query is\n"}, ast.Comment{Text: "// bounded by start and stop arguments. Optional orgID, host and token arguments\n"}, ast.Comment{Text: "// allow cross-org and/or cross-cluster queries. Setting the raw parameter will\n"}, ast.Comment{Text: "// return raw usage data rather than the downsampled data returned by default.\n"}, ast.Comment{Text: "// Note that unlike the range function, the stop argument is required here,\n"}, ast.Comment{Text: "// pending implementation of https://github.com/influxdata/flux/issues/3629.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 5,
							Line:   15,
						},
						File:   "usage.flux",
						Source: "from",
						Start: ast.Position{
							Column: 1,
							Line:   15,
						},
					},
				},
				Name: "from",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   40,
						},
						File:   "usage.flux",
						Source: "(\n        start,\n        stop,\n        host=\"\",\n        orgID=\"\",\n        token=\"\",\n        raw=false,\n) => {\n    id = if orgID == \"\" then \"{orgID}\" else http.pathEscape(inputString: orgID)\n    response = influxdb.api(\n        method: \"get\",\n        path: \"/api/v2/orgs/\" + id + \"/usage\",\n        host: host,\n        token: token,\n        query: [\n            \"start\": string(v: start),\n            \"stop\": string(v: stop),\n            \"raw\": string(v: raw),\n        ],\n    )\n\n    return if response.statusCode > 299 then\n        die(msg: \"organization usage request returned status \" + string(v: response.statusCode) + \": \" + string(v: response.body))\n    else\n        csv.from(csv: string(v: response.body))\n}",
						Start: ast.Position{
							Column: 8,
							Line:   15,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   40,
							},
							File:   "usage.flux",
							Source: "{\n    id = if orgID == \"\" then \"{orgID}\" else http.pathEscape(inputString: orgID)\n    response = influxdb.api(\n        method: \"get\",\n        path: \"/api/v2/orgs/\" + id + \"/usage\",\n        host: host,\n        token: token,\n        query: [\n            \"start\": string(v: start),\n            \"stop\": string(v: stop),\n            \"raw\": string(v: raw),\n        ],\n    )\n\n    return if response.statusCode > 299 then\n        die(msg: \"organization usage request returned status \" + string(v: response.statusCode) + \": \" + string(v: response.body))\n    else\n        csv.from(csv: string(v: response.body))\n}",
							Start: ast.Position{
								Column: 6,
								Line:   22,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 80,
									Line:   23,
								},
								File:   "usage.flux",
								Source: "id = if orgID == \"\" then \"{orgID}\" else http.pathEscape(inputString: orgID)",
								Start: ast.Position{
									Column: 5,
									Line:   23,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 7,
										Line:   23,
									},
									File:   "usage.flux",
									Source: "id",
									Start: ast.Position{
										Column: 5,
										Line:   23,
									},
								},
							},
							Name: "id",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 79,
												Line:   23,
											},
											File:   "usage.flux",
											Source: "inputString: orgID",
											Start: ast.Position{
												Column: 61,
												Line:   23,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   23,
												},
												File:   "usage.flux",
												Source: "inputString: orgID",
												Start: ast.Position{
													Column: 61,
													Line:   23,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 72,
														Line:   23,
													},
													File:   "usage.flux",
													Source: "inputString",
													Start: ast.Position{
														Column: 61,
														Line:   23,
													},
												},
											},
											Name: "inputString",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   23,
													},
													File:   "usage.flux",
													Source: "orgID",
													Start: ast.Position{
														Column: 74,
														Line:   23,
													},
												},
											},
											Name: "orgID",
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   23,
										},
										File:   "usage.flux",
										Source: "http.pathEscape(inputString: orgID)",
										Start: ast.Position{
											Column: 45,
											Line:   23,
										},
									},
								},
								Callee: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 60,
												Line:   23,
											},
											File:   "usage.flux",
											Source: "http.pathEscape",
											Start: ast.Position{
												Column: 45,
												Line:   23,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   23,
												},
												File:   "usage.flux",
												Source: "http",
												Start: ast.Position{
													Column: 45,
													Line:   23,
												},
											},
										},
										Name: "http",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 60,
													Line:   23,
												},
												File:   "usage.flux",
												Source: "pathEscape",
												Start: ast.Position{
													Column: 50,
													Line:   23,
												},
											},
										},
										Name: "pathEscape",
									},
									Rbrack: nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 80,
										Line:   23,
									},
									File:   "usage.flux",
									Source: "if orgID == \"\" then \"{orgID}\" else http.pathEscape(inputString: orgID)",
									Start: ast.Position{
										Column: 10,
										Line:   23,
									},
								},
							},
							Consequent: &ast.StringLiteral{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   23,
										},
										File:   "usage.flux",
										Source: "\"{orgID}\"",
										Start: ast.Position{
											Column: 30,
											Line:   23,
										},
									},
								},
								Value: "{orgID}",
							},
							Test: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   23,
										},
										File:   "usage.flux",
										Source: "orgID == \"\"",
										Start: ast.Position{
											Column: 13,
											Line:   23,
										},
									},
								},
								Left: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   23,
											},
											File:   "usage.flux",
											Source: "orgID",
											Start: ast.Position{
												Column: 13,
												Line:   23,
											},
										},
									},
									Name: "orgID",
								},
								Operator: 17,
								Right: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   23,
											},
											File:   "usage.flux",
											Source: "\"\"",
											Start: ast.Position{
												Column: 22,
												Line:   23,
											},
										},
									},
									Value: "",
								},
							},
							Tk_else: nil,
							Tk_if:   nil,
							Tk_then: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   34,
								},
								File:   "usage.flux",
								Source: "response = influxdb.api(\n        method: \"get\",\n        path: \"/api/v2/orgs/\" + id + \"/usage\",\n        host: host,\n        token: token,\n        query: [\n            \"start\": string(v: start),\n            \"stop\": string(v: stop),\n            \"raw\": string(v: raw),\n        ],\n    )",
								Start: ast.Position{
									Column: 5,
									Line:   24,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   24,
									},
									File:   "usage.flux",
									Source: "response",
									Start: ast.Position{
										Column: 5,
										Line:   24,
									},
								},
							},
							Name: "response",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 10,
											Line:   33,
										},
										File:   "usage.flux",
										Source: "method: \"get\",\n        path: \"/api/v2/orgs/\" + id + \"/usage\",\n        host: host,\n        token: token,\n        query: [\n            \"start\": string(v: start),\n            \"stop\": string(v: stop),\n            \"raw\": string(v: raw),\n        ]",
										Start: ast.Position{
											Column: 9,
											Line:   25,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   25,
											},
											File:   "usage.flux",
											Source: "method: \"get\"",
											Start: ast.Position{
												Column: 9,
												Line:   25,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   25,
												},
												File:   "usage.flux",
												Source: "method",
												Start: ast.Position{
													Column: 9,
													Line:   25,
												},
											},
										},
										Name: "method",
									},
									Separator: nil,
									Value: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 22,
													Line:   25,
												},
												File:   "usage.flux",
												Source: "\"get\"",
												Start: ast.Position{
													Column: 17,
													Line:   25,
												},
											},
										},
										Value: "get",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 46,
												Line:   26,
											},
											File:   "usage.flux",
											Source: "path: \"/api/v2/orgs/\" + id + \"/usage\"",
											Start: ast.Position{
												Column: 9,
												Line:   26,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   26,
												},
												File:   "usage.flux",
												Source: "path",
												Start: ast.Position{
													Column: 9,
													Line:   26,
												},
											},
										},
										Name: "path",
									},
									Separator: nil,
									Value: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 46,
													Line:   26,
												},
												File:   "usage.flux",
												Source: "\"/api/v2/orgs/\" + id + \"/usage\"",
												Start: ast.Position{
													Column: 15,
													Line:   26,
												},
											},
										},
										Left: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   26,
													},
													File:   "usage.flux",
													Source: "\"/api/v2/orgs/\" + id",
													Start: ast.Position{
														Column: 15,
														Line:   26,
													},
												},
											},
											Left: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   26,
														},
														File:   "usage.flux",
														Source: "\"/api/v2/orgs/\"",
														Start: ast.Position{
															Column: 15,
															Line:   26,
														},
													},
												},
												Value: "/api/v2/orgs/",
											},
											Operator: 5,
											Right: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   26,
														},
														File:   "usage.flux",
														Source: "id",
														Start: ast.Position{
															Column: 33,
															Line:   26,
														},
													},
												},
												Name: "id",
											},
										},
										Operator: 5,
										Right: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 46,
														Line:   26,
													},
													File:   "usage.flux",
													Source: "\"/usage\"",
													Start: ast.Position{
														Column: 38,
														Line:   26,
													},
												},
											},
											Value: "/usage",
										},
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   27,
											},
											File:   "usage.flux",
											Source: "host: host",
											Start: ast.Position{
												Column: 9,
												Line:   27,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   27,
												},
												File:   "usage.flux",
												Source: "host",
												Start: ast.Position{
													Column: 9,
													Line:   27,
												},
											},
										},
										Name: "host",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   27,
												},
												File:   "usage.flux",
												Source: "host",
												Start: ast.Position{
													Column: 15,
													Line:   27,
												},
											},
										},
										Name: "host",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   28,
											},
											File:   "usage.flux",
											Source: "token: token",
											Start: ast.Position{
												Column: 9,
												Line:   28,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   28,
												},
												File:   "usage.flux",
												Source: "token",
												Start: ast.Position{
													Column: 9,
													Line:   28,
												},
											},
										},
										Name: "token",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   28,
												},
												File:   "usage.flux",
												Source: "token",
												Start: ast.Position{
													Column: 16,
													Line:   28,
												},
											},
										},
										Name: "token",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 10,
												Line:   33,
											},
											File:   "usage.flux",
											Source: "query: [\n            \"start\": string(v: start),\n            \"stop\": string(v: stop),\n            \"raw\": string(v: raw),\n        ]",
											Start: ast.Position{
												Column: 9,
												Line:   29,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   29,
												},
												File:   "usage.flux",
												Source: "query",
												Start: ast.Position{
													Column: 9,
													Line:   29,
												},
											},
										},
										Name: "query",
									},
									Separator: nil,
									Value: &ast.DictExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 10,
													Line:   33,
												},
												File:   "usage.flux",
												Source: "[\n            \"start\": string(v: start),\n            \"stop\": string(v: stop),\n            \"raw\": string(v: raw),\n        ]",
												Start: ast.Position{
													Column: 16,
													Line:   29,
												},
											},
										},
										Elements: []*ast.DictItem{&ast.DictItem{
											Comma: nil,
											Key: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 20,
															Line:   30,
														},
														File:   "usage.flux",
														Source: "\"start\"",
														Start: ast.Position{
															Column: 13,
															Line:   30,
														},
													},
												},
												Value: "start",
											},
											Val: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 37,
																Line:   30,
															},
															File:   "usage.flux",
															Source: "v: start",
															Start: ast.Position{
																Column: 29,
																Line:   30,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 37,
																	Line:   30,
																},
																File:   "usage.flux",
																Source: "v: start",
																Start: ast.Position{
																	Column: 29,
																	Line:   30,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 30,
																		Line:   30,
																	},
																	File:   "usage.flux",
																	Source: "v",
																	Start: ast.Position{
																		Column: 29,
																		Line:   30,
																	},
																},
															},
															Name: "v",
														},
														Separator: nil,
														Value: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 37,
																		Line:   30,
																	},
																	File:   "usage.flux",
																	Source: "start",
																	Start: ast.Position{
																		Column: 32,
																		Line:   30,
																	},
																},
															},
															Name: "start",
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 38,
															Line:   30,
														},
														File:   "usage.flux",
														Source: "string(v: start)",
														Start: ast.Position{
															Column: 22,
															Line:   30,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 28,
																Line:   30,
															},
															File:   "usage.flux",
															Source: "string",
															Start: ast.Position{
																Column: 22,
																Line:   30,
															},
														},
													},
													Name: "string",
												},
												Lparen: nil,
												Rparen: nil,
											},
										}, &ast.DictItem{
											Comma: nil,
											Key: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 19,
															Line:   31,
														},
														File:   "usage.flux",
														Source: "\"stop\"",
														Start: ast.Position{
															Column: 13,
															Line:   31,
														},
													},
												},
												Value: "stop",
											},
											Val: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 35,
																Line:   31,
															},
															File:   "usage.flux",
															Source: "v: stop",
															Start: ast.Position{
																Column: 28,
																Line:   31,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 35,
																	Line:   31,
																},
																File:   "usage.flux",
																Source: "v: stop",
																Start: ast.Position{
																	Column: 28,
																	Line:   31,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 29,
																		Line:   31,
																	},
																	File:   "usage.flux",
																	Source: "v",
																	Start: ast.Position{
																		Column: 28,
																		Line:   31,
																	},
																},
															},
															Name: "v",
														},
														Separator: nil,
														Value: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 35,
																		Line:   31,
																	},
																	File:   "usage.flux",
																	Source: "stop",
																	Start: ast.Position{
																		Column: 31,
																		Line:   31,
																	},
																},
															},
															Name: "stop",
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 36,
															Line:   31,
														},
														File:   "usage.flux",
														Source: "string(v: stop)",
														Start: ast.Position{
															Column: 21,
															Line:   31,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 27,
																Line:   31,
															},
															File:   "usage.flux",
															Source: "string",
															Start: ast.Position{
																Column: 21,
																Line:   31,
															},
														},
													},
													Name: "string",
												},
												Lparen: nil,
												Rparen: nil,
											},
										}, &ast.DictItem{
											Comma: nil,
											Key: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 18,
															Line:   32,
														},
														File:   "usage.flux",
														Source: "\"raw\"",
														Start: ast.Position{
															Column: 13,
															Line:   32,
														},
													},
												},
												Value: "raw",
											},
											Val: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 33,
																Line:   32,
															},
															File:   "usage.flux",
															Source: "v: raw",
															Start: ast.Position{
																Column: 27,
																Line:   32,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 33,
																	Line:   32,
																},
																File:   "usage.flux",
																Source: "v: raw",
																Start: ast.Position{
																	Column: 27,
																	Line:   32,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 28,
																		Line:   32,
																	},
																	File:   "usage.flux",
																	Source: "v",
																	Start: ast.Position{
																		Column: 27,
																		Line:   32,
																	},
																},
															},
															Name: "v",
														},
														Separator: nil,
														Value: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 33,
																		Line:   32,
																	},
																	File:   "usage.flux",
																	Source: "raw",
																	Start: ast.Position{
																		Column: 30,
																		Line:   32,
																	},
																},
															},
															Name: "raw",
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 34,
															Line:   32,
														},
														File:   "usage.flux",
														Source: "string(v: raw)",
														Start: ast.Position{
															Column: 20,
															Line:   32,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 26,
																Line:   32,
															},
															File:   "usage.flux",
															Source: "string",
															Start: ast.Position{
																Column: 20,
																Line:   32,
															},
														},
													},
													Name: "string",
												},
												Lparen: nil,
												Rparen: nil,
											},
										}},
										Lbrack: nil,
										Rbrack: nil,
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   34,
									},
									File:   "usage.flux",
									Source: "influxdb.api(\n        method: \"get\",\n        path: \"/api/v2/orgs/\" + id + \"/usage\",\n        host: host,\n        token: token,\n        query: [\n            \"start\": string(v: start),\n            \"stop\": string(v: stop),\n            \"raw\": string(v: raw),\n        ],\n    )",
									Start: ast.Position{
										Column: 16,
										Line:   24,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   24,
										},
										File:   "usage.flux",
										Source: "influxdb.api",
										Start: ast.Position{
											Column: 16,
											Line:   24,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   24,
											},
											File:   "usage.flux",
											Source: "influxdb",
											Start: ast.Position{
												Column: 16,
												Line:   24,
											},
										},
									},
									Name: "influxdb",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   24,
											},
											File:   "usage.flux",
											Source: "api",
											Start: ast.Position{
												Column: 25,
												Line:   24,
											},
										},
									},
									Name: "api",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.ConditionalExpression{
							Alternate: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 47,
												Line:   39,
											},
											File:   "usage.flux",
											Source: "csv: string(v: response.body)",
											Start: ast.Position{
												Column: 18,
												Line:   39,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 47,
													Line:   39,
												},
												File:   "usage.flux",
												Source: "csv: string(v: response.body)",
												Start: ast.Position{
													Column: 18,
													Line:   39,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 21,
														Line:   39,
													},
													File:   "usage.flux",
													Source: "csv",
													Start: ast.Position{
														Column: 18,
														Line:   39,
													},
												},
											},
											Name: "csv",
										},
										Separator: nil,
										Value: &ast.CallExpression{
											Arguments: []ast.Expression{&ast.ObjectExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 46,
															Line:   39,
														},
														File:   "usage.flux",
														Source: "v: response.body",
														Start: ast.Position{
															Column: 30,
															Line:   39,
														},
													},
												},
												Lbrace: nil,
												Properties: []*ast.Property{&ast.Property{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 46,
																Line:   39,
															},
															File:   "usage.flux",
															Source: "v: response.body",
															Start: ast.Position{
																Column: 30,
																Line:   39,
															},
														},
													},
													Comma: nil,
													Key: &ast.Identifier{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 31,
																	Line:   39,
																},
																File:   "usage.flux",
																Source: "v",
																Start: ast.Position{
																	Column: 30,
																	Line:   39,
																},
															},
														},
														Name: "v",
													},
													Separator: nil,
													Value: &ast.MemberExpression{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 46,
																	Line:   39,
																},
																File:   "usage.flux",
																Source: "response.body",
																Start: ast.Position{
																	Column: 33,
																	Line:   39,
																},
															},
														},
														Lbrack: nil,
														Object: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 41,
																		Line:   39,
																	},
																	File:   "usage.flux",
																	Source: "response",
																	Start: ast.Position{
																		Column: 33,
																		Line:   39,
																	},
																},
															},
															Name: "response",
														},
														Property: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 46,
																		Line:   39,
																	},
																	File:   "usage.flux",
																	Source: "body",
																	Start: ast.Position{
																		Column: 42,
																		Line:   39,
																	},
																},
															},
															Name: "body",
														},
														Rbrack: nil,
													},
												}},
												Rbrace: nil,
												With:   nil,
											}},
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   39,
													},
													File:   "usage.flux",
													Source: "string(v: response.body)",
													Start: ast.Position{
														Column: 23,
														Line:   39,
													},
												},
											},
											Callee: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 29,
															Line:   39,
														},
														File:   "usage.flux",
														Source: "string",
														Start: ast.Position{
															Column: 23,
															Line:   39,
														},
													},
												},
												Name: "string",
											},
											Lparen: nil,
											Rparen: nil,
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 48,
											Line:   39,
										},
										File:   "usage.flux",
										Source: "csv.from(csv: string(v: response.body))",
										Start: ast.Position{
											Column: 9,
											Line:   39,
										},
									},
								},
								Callee: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 17,
												Line:   39,
											},
											File:   "usage.flux",
											Source: "csv.from",
											Start: ast.Position{
												Column: 9,
												Line:   39,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 12,
													Line:   39,
												},
												File:   "usage.flux",
												Source: "csv",
												Start: ast.Position{
													Column: 9,
													Line:   39,
												},
											},
										},
										Name: "csv",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 17,
													Line:   39,
												},
												File:   "usage.flux",
												Source: "from",
												Start: ast.Position{
													Column: 13,
													Line:   39,
												},
											},
										},
										Name: "from",
									},
									Rbrack: nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 48,
										Line:   39,
									},
									File:   "usage.flux",
									Source: "if response.statusCode > 299 then\n        die(msg: \"organization usage request returned status \" + string(v: response.statusCode) + \": \" + string(v: response.body))\n    else\n        csv.from(csv: string(v: response.body))",
									Start: ast.Position{
										Column: 12,
										Line:   36,
									},
								},
							},
							Consequent: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 130,
												Line:   37,
											},
											File:   "usage.flux",
											Source: "msg: \"organization usage request returned status \" + string(v: response.statusCode) + \": \" + string(v: response.body)",
											Start: ast.Position{
												Column: 13,
												Line:   37,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 130,
													Line:   37,
												},
												File:   "usage.flux",
												Source: "msg: \"organization usage request returned status \" + string(v: response.statusCode) + \": \" + string(v: response.body)",
												Start: ast.Position{
													Column: 13,
													Line:   37,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   37,
													},
													File:   "usage.flux",
													Source: "msg",
													Start: ast.Position{
														Column: 13,
														Line:   37,
													},
												},
											},
											Name: "msg",
										},
										Separator: nil,
										Value: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 130,
														Line:   37,
													},
													File:   "usage.flux",
													Source: "\"organization usage request returned status \" + string(v: response.statusCode) + \": \" + string(v: response.body)",
													Start: ast.Position{
														Column: 18,
														Line:   37,
													},
												},
											},
											Left: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 103,
															Line:   37,
														},
														File:   "usage.flux",
														Source: "\"organization usage request returned status \" + string(v: response.statusCode) + \": \"",
														Start: ast.Position{
															Column: 18,
															Line:   37,
														},
													},
												},
												Left: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 96,
																Line:   37,
															},
															File:   "usage.flux",
															Source: "\"organization usage request returned status \" + string(v: response.statusCode)",
															Start: ast.Position{
																Column: 18,
																Line:   37,
															},
														},
													},
													Left: &ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 63,
																	Line:   37,
																},
																File:   "usage.flux",
																Source: "\"organization usage request returned status \"",
																Start: ast.Position{
																	Column: 18,
																	Line:   37,
																},
															},
														},
														Value: "organization usage request returned status ",
													},
													Operator: 5,
													Right: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 95,
																		Line:   37,
																	},
																	File:   "usage.flux",
																	Source: "v: response.statusCode",
																	Start: ast.Position{
																		Column: 73,
																		Line:   37,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 95,
																			Line:   37,
																		},
																		File:   "usage.flux",
																		Source: "v: response.statusCode",
																		Start: ast.Position{
																			Column: 73,
																			Line:   37,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 74,
																				Line:   37,
																			},
																			File:   "usage.flux",
																			Source: "v",
																			Start: ast.Position{
																				Column: 73,
																				Line:   37,
																			},
																		},
																	},
																	Name: "v",
																},
																Separator: nil,
																Value: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 95,
																				Line:   37,
																			},
																			File:   "usage.flux",
																			Source: "response.statusCode",
																			Start: ast.Position{
																				Column: 76,
																				Line:   37,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 84,
																					Line:   37,
																				},
																				File:   "usage.flux",
																				Source: "response",
																				Start: ast.Position{
																					Column: 76,
																					Line:   37,
																				},
																			},
																		},
																		Name: "response",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 95,
																					Line:   37,
																				},
																				File:   "usage.flux",
																				Source: "statusCode",
																				Start: ast.Position{
																					Column: 85,
																					Line:   37,
																				},
																			},
																		},
																		Name: "statusCode",
																	},
																	Rbrack: nil,
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 96,
																	Line:   37,
																},
																File:   "usage.flux",
																Source: "string(v: response.statusCode)",
																Start: ast.Position{
																	Column: 66,
																	Line:   37,
																},
															},
														},
														Callee: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 72,
																		Line:   37,
																	},
																	File:   "usage.flux",
																	Source: "string",
																	Start: ast.Position{
																		Column: 66,
																		Line:   37,
																	},
																},
															},
															Name: "string",
														},
														Lparen: nil,
														Rparen: nil,
													},
												},
												Operator: 5,
												Right: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 103,
																Line:   37,
															},
															File:   "usage.flux",
															Source: "\": \"",
															Start: ast.Position{
																Column: 99,
																Line:   37,
															},
														},
													},
													Value: ": ",
												},
											},
											Operator: 5,
											Right: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 129,
																Line:   37,
															},
															File:   "usage.flux",
															Source: "v: response.body",
															Start: ast.Position{
																Column: 113,
																Line:   37,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 129,
																	Line:   37,
																},
																File:   "usage.flux",
																Source: "v: response.body",
																Start: ast.Position{
																	Column: 113,
																	Line:   37,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 114,
																		Line:   37,
																	},
																	File:   "usage.flux",
																	Source: "v",
																	Start: ast.Position{
																		Column: 113,
																		Line:   37,
																	},
																},
															},
															Name: "v",
														},
														Separator: nil,
														Value: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 129,
																		Line:   37,
																	},
																	File:   "usage.flux",
																	Source: "response.body",
																	Start: ast.Position{
																		Column: 116,
																		Line:   37,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 124,
																			Line:   37,
																		},
																		File:   "usage.flux",
																		Source: "response",
																		Start: ast.Position{
																			Column: 116,
																			Line:   37,
																		},
																	},
																},
																Name: "response",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 129,
																			Line:   37,
																		},
																		File:   "usage.flux",
																		Source: "body",
																		Start: ast.Position{
																			Column: 125,
																			Line:   37,
																		},
																	},
																},
																Name: "body",
															},
															Rbrack: nil,
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 130,
															Line:   37,
														},
														File:   "usage.flux",
														Source: "string(v: response.body)",
														Start: ast.Position{
															Column: 106,
															Line:   37,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 112,
																Line:   37,
															},
															File:   "usage.flux",
															Source: "string",
															Start: ast.Position{
																Column: 106,
																Line:   37,
															},
														},
													},
													Name: "string",
												},
												Lparen: nil,
												Rparen: nil,
											},
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 131,
											Line:   37,
										},
										File:   "usage.flux",
										Source: "die(msg: \"organization usage request returned status \" + string(v: response.statusCode) + \": \" + string(v: response.body))",
										Start: ast.Position{
											Column: 9,
											Line:   37,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   37,
											},
											File:   "usage.flux",
											Source: "die",
											Start: ast.Position{
												Column: 9,
												Line:   37,
											},
										},
									},
									Name: "die",
								},
								Lparen: nil,
								Rparen: nil,
							},
							Test: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   36,
										},
										File:   "usage.flux",
										Source: "response.statusCode > 299",
										Start: ast.Position{
											Column: 15,
											Line:   36,
										},
									},
								},
								Left: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   36,
											},
											File:   "usage.flux",
											Source: "response.statusCode",
											Start: ast.Position{
												Column: 15,
												Line:   36,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   36,
												},
												File:   "usage.flux",
												Source: "response",
												Start: ast.Position{
													Column: 15,
													Line:   36,
												},
											},
										},
										Name: "response",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 34,
													Line:   36,
												},
												File:   "usage.flux",
												Source: "statusCode",
												Start: ast.Position{
													Column: 24,
													Line:   36,
												},
											},
										},
										Name: "statusCode",
									},
									Rbrack: nil,
								},
								Operator: 10,
								Right: &ast.IntegerLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   36,
											},
											File:   "usage.flux",
											Source: "299",
											Start: ast.Position{
												Column: 37,
												Line:   36,
											},
										},
									},
									Value: int64(299),
								},
							},
							Tk_else: nil,
							Tk_if:   nil,
							Tk_then: nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 48,
									Line:   39,
								},
								File:   "usage.flux",
								Source: "return if response.statusCode > 299 then\n        die(msg: \"organization usage request returned status \" + string(v: response.statusCode) + \": \" + string(v: response.body))\n    else\n        csv.from(csv: string(v: response.body))",
								Start: ast.Position{
									Column: 5,
									Line:   36,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 14,
								Line:   16,
							},
							File:   "usage.flux",
							Source: "start",
							Start: ast.Position{
								Column: 9,
								Line:   16,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   16,
								},
								File:   "usage.flux",
								Source: "start",
								Start: ast.Position{
									Column: 9,
									Line:   16,
								},
							},
						},
						Name: "start",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 13,
								Line:   17,
							},
							File:   "usage.flux",
							Source: "stop",
							Start: ast.Position{
								Column: 9,
								Line:   17,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   17,
								},
								File:   "usage.flux",
								Source: "stop",
								Start: ast.Position{
									Column: 9,
									Line:   17,
								},
							},
						},
						Name: "stop",
					},
					Separator: nil,
					Value:     nil,
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 16,
								Line:   18,
							},
							File:   "usage.flux",
							Source: "host=\"\"",
							Start: ast.Position{
								Column: 9,
								Line:   18,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 13,
									Line:   18,
								},
								File:   "usage.flux",
								Source: "host",
								Start: ast.Position{
									Column: 9,
									Line:   18,
								},
							},
						},
						Name: "host",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 16,
									Line:   18,
								},
								File:   "usage.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 14,
									Line:   18,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   19,
							},
							File:   "usage.flux",
							Source: "orgID=\"\"",
							Start: ast.Position{
								Column: 9,
								Line:   19,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   19,
								},
								File:   "usage.flux",
								Source: "orgID",
								Start: ast.Position{
									Column: 9,
									Line:   19,
								},
							},
						},
						Name: "orgID",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   19,
								},
								File:   "usage.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 15,
									Line:   19,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 17,
								Line:   20,
							},
							File:   "usage.flux",
							Source: "token=\"\"",
							Start: ast.Position{
								Column: 9,
								Line:   20,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 14,
									Line:   20,
								},
								File:   "usage.flux",
								Source: "token",
								Start: ast.Position{
									Column: 9,
									Line:   20,
								},
							},
						},
						Name: "token",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 17,
									Line:   20,
								},
								File:   "usage.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 15,
									Line:   20,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   21,
							},
							File:   "usage.flux",
							Source: "raw=false",
							Start: ast.Position{
								Column: 9,
								Line:   21,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 12,
									Line:   21,
								},
								File:   "usage.flux",
								Source: "raw",
								Start: ast.Position{
									Column: 9,
									Line:   21,
								},
							},
						},
						Name: "raw",
					},
					Separator: nil,
					Value: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   21,
								},
								File:   "usage.flux",
								Source: "false",
								Start: ast.Position{
									Column: 13,
									Line:   21,
								},
							},
						},
						Name: "false",
					},
				}},
				Rparan: nil,
			},
		}, &ast.VariableAssignment{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 2,
						Line:   57,
					},
					File:   "usage.flux",
					Source: "limits = (host=\"\", orgID=\"\", token=\"\") => {\n    id = if orgID == \"\" then \"{orgID}\" else http.pathEscape(inputString: orgID)\n    response = influxdb.api(\n        method: \"get\",\n        path: \"/api/v2/orgs/\" + id + \"/limits\",\n        host: host,\n        token: token,\n    )\n\n    return if response.statusCode > 299 then\n        die(msg: \"organization limits request returned status \" + string(v: response.statusCode) + \": \" + string(v: response.body))\n    else\n        json.parse(data: response.body).limits\n}",
					Start: ast.Position{
						Column: 1,
						Line:   44,
					},
				},
			},
			ID: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: []ast.Comment{ast.Comment{Text: "// limits returns an organization's usage limits. Optional orgID, host\n"}, ast.Comment{Text: "// and token arguments allow cross-org and/or cross-cluster calls.\n"}},
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 7,
							Line:   44,
						},
						File:   "usage.flux",
						Source: "limits",
						Start: ast.Position{
							Column: 1,
							Line:   44,
						},
					},
				},
				Name: "limits",
			},
			Init: &ast.FunctionExpression{
				Arrow: nil,
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 2,
							Line:   57,
						},
						File:   "usage.flux",
						Source: "(host=\"\", orgID=\"\", token=\"\") => {\n    id = if orgID == \"\" then \"{orgID}\" else http.pathEscape(inputString: orgID)\n    response = influxdb.api(\n        method: \"get\",\n        path: \"/api/v2/orgs/\" + id + \"/limits\",\n        host: host,\n        token: token,\n    )\n\n    return if response.statusCode > 299 then\n        die(msg: \"organization limits request returned status \" + string(v: response.statusCode) + \": \" + string(v: response.body))\n    else\n        json.parse(data: response.body).limits\n}",
						Start: ast.Position{
							Column: 10,
							Line:   44,
						},
					},
				},
				Body: &ast.Block{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 2,
								Line:   57,
							},
							File:   "usage.flux",
							Source: "{\n    id = if orgID == \"\" then \"{orgID}\" else http.pathEscape(inputString: orgID)\n    response = influxdb.api(\n        method: \"get\",\n        path: \"/api/v2/orgs/\" + id + \"/limits\",\n        host: host,\n        token: token,\n    )\n\n    return if response.statusCode > 299 then\n        die(msg: \"organization limits request returned status \" + string(v: response.statusCode) + \": \" + string(v: response.body))\n    else\n        json.parse(data: response.body).limits\n}",
							Start: ast.Position{
								Column: 43,
								Line:   44,
							},
						},
					},
					Body: []ast.Statement{&ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 80,
									Line:   45,
								},
								File:   "usage.flux",
								Source: "id = if orgID == \"\" then \"{orgID}\" else http.pathEscape(inputString: orgID)",
								Start: ast.Position{
									Column: 5,
									Line:   45,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 7,
										Line:   45,
									},
									File:   "usage.flux",
									Source: "id",
									Start: ast.Position{
										Column: 5,
										Line:   45,
									},
								},
							},
							Name: "id",
						},
						Init: &ast.ConditionalExpression{
							Alternate: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 79,
												Line:   45,
											},
											File:   "usage.flux",
											Source: "inputString: orgID",
											Start: ast.Position{
												Column: 61,
												Line:   45,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 79,
													Line:   45,
												},
												File:   "usage.flux",
												Source: "inputString: orgID",
												Start: ast.Position{
													Column: 61,
													Line:   45,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 72,
														Line:   45,
													},
													File:   "usage.flux",
													Source: "inputString",
													Start: ast.Position{
														Column: 61,
														Line:   45,
													},
												},
											},
											Name: "inputString",
										},
										Separator: nil,
										Value: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 79,
														Line:   45,
													},
													File:   "usage.flux",
													Source: "orgID",
													Start: ast.Position{
														Column: 74,
														Line:   45,
													},
												},
											},
											Name: "orgID",
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 80,
											Line:   45,
										},
										File:   "usage.flux",
										Source: "http.pathEscape(inputString: orgID)",
										Start: ast.Position{
											Column: 45,
											Line:   45,
										},
									},
								},
								Callee: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 60,
												Line:   45,
											},
											File:   "usage.flux",
											Source: "http.pathEscape",
											Start: ast.Position{
												Column: 45,
												Line:   45,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 49,
													Line:   45,
												},
												File:   "usage.flux",
												Source: "http",
												Start: ast.Position{
													Column: 45,
													Line:   45,
												},
											},
										},
										Name: "http",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 60,
													Line:   45,
												},
												File:   "usage.flux",
												Source: "pathEscape",
												Start: ast.Position{
													Column: 50,
													Line:   45,
												},
											},
										},
										Name: "pathEscape",
									},
									Rbrack: nil,
								},
								Lparen: nil,
								Rparen: nil,
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 80,
										Line:   45,
									},
									File:   "usage.flux",
									Source: "if orgID == \"\" then \"{orgID}\" else http.pathEscape(inputString: orgID)",
									Start: ast.Position{
										Column: 10,
										Line:   45,
									},
								},
							},
							Consequent: &ast.StringLiteral{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 39,
											Line:   45,
										},
										File:   "usage.flux",
										Source: "\"{orgID}\"",
										Start: ast.Position{
											Column: 30,
											Line:   45,
										},
									},
								},
								Value: "{orgID}",
							},
							Test: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 24,
											Line:   45,
										},
										File:   "usage.flux",
										Source: "orgID == \"\"",
										Start: ast.Position{
											Column: 13,
											Line:   45,
										},
									},
								},
								Left: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 18,
												Line:   45,
											},
											File:   "usage.flux",
											Source: "orgID",
											Start: ast.Position{
												Column: 13,
												Line:   45,
											},
										},
									},
									Name: "orgID",
								},
								Operator: 17,
								Right: &ast.StringLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   45,
											},
											File:   "usage.flux",
											Source: "\"\"",
											Start: ast.Position{
												Column: 22,
												Line:   45,
											},
										},
									},
									Value: "",
								},
							},
							Tk_else: nil,
							Tk_if:   nil,
							Tk_then: nil,
						},
					}, &ast.VariableAssignment{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 6,
									Line:   51,
								},
								File:   "usage.flux",
								Source: "response = influxdb.api(\n        method: \"get\",\n        path: \"/api/v2/orgs/\" + id + \"/limits\",\n        host: host,\n        token: token,\n    )",
								Start: ast.Position{
									Column: 5,
									Line:   46,
								},
							},
						},
						ID: &ast.Identifier{
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 13,
										Line:   46,
									},
									File:   "usage.flux",
									Source: "response",
									Start: ast.Position{
										Column: 5,
										Line:   46,
									},
								},
							},
							Name: "response",
						},
						Init: &ast.CallExpression{
							Arguments: []ast.Expression{&ast.ObjectExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 21,
											Line:   50,
										},
										File:   "usage.flux",
										Source: "method: \"get\",\n        path: \"/api/v2/orgs/\" + id + \"/limits\",\n        host: host,\n        token: token",
										Start: ast.Position{
											Column: 9,
											Line:   47,
										},
									},
								},
								Lbrace: nil,
								Properties: []*ast.Property{&ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 22,
												Line:   47,
											},
											File:   "usage.flux",
											Source: "method: \"get\"",
											Start: ast.Position{
												Column: 9,
												Line:   47,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 15,
													Line:   47,
												},
												File:   "usage.flux",
												Source: "method",
												Start: ast.Position{
													Column: 9,
													Line:   47,
												},
											},
										},
										Name: "method",
									},
									Separator: nil,
									Value: &ast.StringLiteral{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 22,
													Line:   47,
												},
												File:   "usage.flux",
												Source: "\"get\"",
												Start: ast.Position{
													Column: 17,
													Line:   47,
												},
											},
										},
										Value: "get",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 47,
												Line:   48,
											},
											File:   "usage.flux",
											Source: "path: \"/api/v2/orgs/\" + id + \"/limits\"",
											Start: ast.Position{
												Column: 9,
												Line:   48,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   48,
												},
												File:   "usage.flux",
												Source: "path",
												Start: ast.Position{
													Column: 9,
													Line:   48,
												},
											},
										},
										Name: "path",
									},
									Separator: nil,
									Value: &ast.BinaryExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 47,
													Line:   48,
												},
												File:   "usage.flux",
												Source: "\"/api/v2/orgs/\" + id + \"/limits\"",
												Start: ast.Position{
													Column: 15,
													Line:   48,
												},
											},
										},
										Left: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 35,
														Line:   48,
													},
													File:   "usage.flux",
													Source: "\"/api/v2/orgs/\" + id",
													Start: ast.Position{
														Column: 15,
														Line:   48,
													},
												},
											},
											Left: &ast.StringLiteral{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 30,
															Line:   48,
														},
														File:   "usage.flux",
														Source: "\"/api/v2/orgs/\"",
														Start: ast.Position{
															Column: 15,
															Line:   48,
														},
													},
												},
												Value: "/api/v2/orgs/",
											},
											Operator: 5,
											Right: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 35,
															Line:   48,
														},
														File:   "usage.flux",
														Source: "id",
														Start: ast.Position{
															Column: 33,
															Line:   48,
														},
													},
												},
												Name: "id",
											},
										},
										Operator: 5,
										Right: &ast.StringLiteral{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 47,
														Line:   48,
													},
													File:   "usage.flux",
													Source: "\"/limits\"",
													Start: ast.Position{
														Column: 38,
														Line:   48,
													},
												},
											},
											Value: "/limits",
										},
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 19,
												Line:   49,
											},
											File:   "usage.flux",
											Source: "host: host",
											Start: ast.Position{
												Column: 9,
												Line:   49,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 13,
													Line:   49,
												},
												File:   "usage.flux",
												Source: "host",
												Start: ast.Position{
													Column: 9,
													Line:   49,
												},
											},
										},
										Name: "host",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   49,
												},
												File:   "usage.flux",
												Source: "host",
												Start: ast.Position{
													Column: 15,
													Line:   49,
												},
											},
										},
										Name: "host",
									},
								}, &ast.Property{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 21,
												Line:   50,
											},
											File:   "usage.flux",
											Source: "token: token",
											Start: ast.Position{
												Column: 9,
												Line:   50,
											},
										},
									},
									Comma: nil,
									Key: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 14,
													Line:   50,
												},
												File:   "usage.flux",
												Source: "token",
												Start: ast.Position{
													Column: 9,
													Line:   50,
												},
											},
										},
										Name: "token",
									},
									Separator: nil,
									Value: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 21,
													Line:   50,
												},
												File:   "usage.flux",
												Source: "token",
												Start: ast.Position{
													Column: 16,
													Line:   50,
												},
											},
										},
										Name: "token",
									},
								}},
								Rbrace: nil,
								With:   nil,
							}},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 6,
										Line:   51,
									},
									File:   "usage.flux",
									Source: "influxdb.api(\n        method: \"get\",\n        path: \"/api/v2/orgs/\" + id + \"/limits\",\n        host: host,\n        token: token,\n    )",
									Start: ast.Position{
										Column: 16,
										Line:   46,
									},
								},
							},
							Callee: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 28,
											Line:   46,
										},
										File:   "usage.flux",
										Source: "influxdb.api",
										Start: ast.Position{
											Column: 16,
											Line:   46,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 24,
												Line:   46,
											},
											File:   "usage.flux",
											Source: "influxdb",
											Start: ast.Position{
												Column: 16,
												Line:   46,
											},
										},
									},
									Name: "influxdb",
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 28,
												Line:   46,
											},
											File:   "usage.flux",
											Source: "api",
											Start: ast.Position{
												Column: 25,
												Line:   46,
											},
										},
									},
									Name: "api",
								},
								Rbrack: nil,
							},
							Lparen: nil,
							Rparen: nil,
						},
					}, &ast.ReturnStatement{
						Argument: &ast.ConditionalExpression{
							Alternate: &ast.MemberExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 47,
											Line:   56,
										},
										File:   "usage.flux",
										Source: "json.parse(data: response.body).limits",
										Start: ast.Position{
											Column: 9,
											Line:   56,
										},
									},
								},
								Lbrack: nil,
								Object: &ast.CallExpression{
									Arguments: []ast.Expression{&ast.ObjectExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 39,
													Line:   56,
												},
												File:   "usage.flux",
												Source: "data: response.body",
												Start: ast.Position{
													Column: 20,
													Line:   56,
												},
											},
										},
										Lbrace: nil,
										Properties: []*ast.Property{&ast.Property{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 39,
														Line:   56,
													},
													File:   "usage.flux",
													Source: "data: response.body",
													Start: ast.Position{
														Column: 20,
														Line:   56,
													},
												},
											},
											Comma: nil,
											Key: &ast.Identifier{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 24,
															Line:   56,
														},
														File:   "usage.flux",
														Source: "data",
														Start: ast.Position{
															Column: 20,
															Line:   56,
														},
													},
												},
												Name: "data",
											},
											Separator: nil,
											Value: &ast.MemberExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 39,
															Line:   56,
														},
														File:   "usage.flux",
														Source: "response.body",
														Start: ast.Position{
															Column: 26,
															Line:   56,
														},
													},
												},
												Lbrack: nil,
												Object: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 34,
																Line:   56,
															},
															File:   "usage.flux",
															Source: "response",
															Start: ast.Position{
																Column: 26,
																Line:   56,
															},
														},
													},
													Name: "response",
												},
												Property: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 39,
																Line:   56,
															},
															File:   "usage.flux",
															Source: "body",
															Start: ast.Position{
																Column: 35,
																Line:   56,
															},
														},
													},
													Name: "body",
												},
												Rbrack: nil,
											},
										}},
										Rbrace: nil,
										With:   nil,
									}},
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   56,
											},
											File:   "usage.flux",
											Source: "json.parse(data: response.body)",
											Start: ast.Position{
												Column: 9,
												Line:   56,
											},
										},
									},
									Callee: &ast.MemberExpression{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 19,
													Line:   56,
												},
												File:   "usage.flux",
												Source: "json.parse",
												Start: ast.Position{
													Column: 9,
													Line:   56,
												},
											},
										},
										Lbrack: nil,
										Object: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 13,
														Line:   56,
													},
													File:   "usage.flux",
													Source: "json",
													Start: ast.Position{
														Column: 9,
														Line:   56,
													},
												},
											},
											Name: "json",
										},
										Property: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 19,
														Line:   56,
													},
													File:   "usage.flux",
													Source: "parse",
													Start: ast.Position{
														Column: 14,
														Line:   56,
													},
												},
											},
											Name: "parse",
										},
										Rbrack: nil,
									},
									Lparen: nil,
									Rparen: nil,
								},
								Property: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 47,
												Line:   56,
											},
											File:   "usage.flux",
											Source: "limits",
											Start: ast.Position{
												Column: 41,
												Line:   56,
											},
										},
									},
									Name: "limits",
								},
								Rbrack: nil,
							},
							BaseNode: ast.BaseNode{
								Comments: nil,
								Errors:   nil,
								Loc: &ast.SourceLocation{
									End: ast.Position{
										Column: 47,
										Line:   56,
									},
									File:   "usage.flux",
									Source: "if response.statusCode > 299 then\n        die(msg: \"organization limits request returned status \" + string(v: response.statusCode) + \": \" + string(v: response.body))\n    else\n        json.parse(data: response.body).limits",
									Start: ast.Position{
										Column: 12,
										Line:   53,
									},
								},
							},
							Consequent: &ast.CallExpression{
								Arguments: []ast.Expression{&ast.ObjectExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 131,
												Line:   54,
											},
											File:   "usage.flux",
											Source: "msg: \"organization limits request returned status \" + string(v: response.statusCode) + \": \" + string(v: response.body)",
											Start: ast.Position{
												Column: 13,
												Line:   54,
											},
										},
									},
									Lbrace: nil,
									Properties: []*ast.Property{&ast.Property{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 131,
													Line:   54,
												},
												File:   "usage.flux",
												Source: "msg: \"organization limits request returned status \" + string(v: response.statusCode) + \": \" + string(v: response.body)",
												Start: ast.Position{
													Column: 13,
													Line:   54,
												},
											},
										},
										Comma: nil,
										Key: &ast.Identifier{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 16,
														Line:   54,
													},
													File:   "usage.flux",
													Source: "msg",
													Start: ast.Position{
														Column: 13,
														Line:   54,
													},
												},
											},
											Name: "msg",
										},
										Separator: nil,
										Value: &ast.BinaryExpression{
											BaseNode: ast.BaseNode{
												Comments: nil,
												Errors:   nil,
												Loc: &ast.SourceLocation{
													End: ast.Position{
														Column: 131,
														Line:   54,
													},
													File:   "usage.flux",
													Source: "\"organization limits request returned status \" + string(v: response.statusCode) + \": \" + string(v: response.body)",
													Start: ast.Position{
														Column: 18,
														Line:   54,
													},
												},
											},
											Left: &ast.BinaryExpression{
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 104,
															Line:   54,
														},
														File:   "usage.flux",
														Source: "\"organization limits request returned status \" + string(v: response.statusCode) + \": \"",
														Start: ast.Position{
															Column: 18,
															Line:   54,
														},
													},
												},
												Left: &ast.BinaryExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 97,
																Line:   54,
															},
															File:   "usage.flux",
															Source: "\"organization limits request returned status \" + string(v: response.statusCode)",
															Start: ast.Position{
																Column: 18,
																Line:   54,
															},
														},
													},
													Left: &ast.StringLiteral{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 64,
																	Line:   54,
																},
																File:   "usage.flux",
																Source: "\"organization limits request returned status \"",
																Start: ast.Position{
																	Column: 18,
																	Line:   54,
																},
															},
														},
														Value: "organization limits request returned status ",
													},
													Operator: 5,
													Right: &ast.CallExpression{
														Arguments: []ast.Expression{&ast.ObjectExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 96,
																		Line:   54,
																	},
																	File:   "usage.flux",
																	Source: "v: response.statusCode",
																	Start: ast.Position{
																		Column: 74,
																		Line:   54,
																	},
																},
															},
															Lbrace: nil,
															Properties: []*ast.Property{&ast.Property{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 96,
																			Line:   54,
																		},
																		File:   "usage.flux",
																		Source: "v: response.statusCode",
																		Start: ast.Position{
																			Column: 74,
																			Line:   54,
																		},
																	},
																},
																Comma: nil,
																Key: &ast.Identifier{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 75,
																				Line:   54,
																			},
																			File:   "usage.flux",
																			Source: "v",
																			Start: ast.Position{
																				Column: 74,
																				Line:   54,
																			},
																		},
																	},
																	Name: "v",
																},
																Separator: nil,
																Value: &ast.MemberExpression{
																	BaseNode: ast.BaseNode{
																		Comments: nil,
																		Errors:   nil,
																		Loc: &ast.SourceLocation{
																			End: ast.Position{
																				Column: 96,
																				Line:   54,
																			},
																			File:   "usage.flux",
																			Source: "response.statusCode",
																			Start: ast.Position{
																				Column: 77,
																				Line:   54,
																			},
																		},
																	},
																	Lbrack: nil,
																	Object: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 85,
																					Line:   54,
																				},
																				File:   "usage.flux",
																				Source: "response",
																				Start: ast.Position{
																					Column: 77,
																					Line:   54,
																				},
																			},
																		},
																		Name: "response",
																	},
																	Property: &ast.Identifier{
																		BaseNode: ast.BaseNode{
																			Comments: nil,
																			Errors:   nil,
																			Loc: &ast.SourceLocation{
																				End: ast.Position{
																					Column: 96,
																					Line:   54,
																				},
																				File:   "usage.flux",
																				Source: "statusCode",
																				Start: ast.Position{
																					Column: 86,
																					Line:   54,
																				},
																			},
																		},
																		Name: "statusCode",
																	},
																	Rbrack: nil,
																},
															}},
															Rbrace: nil,
															With:   nil,
														}},
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 97,
																	Line:   54,
																},
																File:   "usage.flux",
																Source: "string(v: response.statusCode)",
																Start: ast.Position{
																	Column: 67,
																	Line:   54,
																},
															},
														},
														Callee: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 73,
																		Line:   54,
																	},
																	File:   "usage.flux",
																	Source: "string",
																	Start: ast.Position{
																		Column: 67,
																		Line:   54,
																	},
																},
															},
															Name: "string",
														},
														Lparen: nil,
														Rparen: nil,
													},
												},
												Operator: 5,
												Right: &ast.StringLiteral{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 104,
																Line:   54,
															},
															File:   "usage.flux",
															Source: "\": \"",
															Start: ast.Position{
																Column: 100,
																Line:   54,
															},
														},
													},
													Value: ": ",
												},
											},
											Operator: 5,
											Right: &ast.CallExpression{
												Arguments: []ast.Expression{&ast.ObjectExpression{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 130,
																Line:   54,
															},
															File:   "usage.flux",
															Source: "v: response.body",
															Start: ast.Position{
																Column: 114,
																Line:   54,
															},
														},
													},
													Lbrace: nil,
													Properties: []*ast.Property{&ast.Property{
														BaseNode: ast.BaseNode{
															Comments: nil,
															Errors:   nil,
															Loc: &ast.SourceLocation{
																End: ast.Position{
																	Column: 130,
																	Line:   54,
																},
																File:   "usage.flux",
																Source: "v: response.body",
																Start: ast.Position{
																	Column: 114,
																	Line:   54,
																},
															},
														},
														Comma: nil,
														Key: &ast.Identifier{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 115,
																		Line:   54,
																	},
																	File:   "usage.flux",
																	Source: "v",
																	Start: ast.Position{
																		Column: 114,
																		Line:   54,
																	},
																},
															},
															Name: "v",
														},
														Separator: nil,
														Value: &ast.MemberExpression{
															BaseNode: ast.BaseNode{
																Comments: nil,
																Errors:   nil,
																Loc: &ast.SourceLocation{
																	End: ast.Position{
																		Column: 130,
																		Line:   54,
																	},
																	File:   "usage.flux",
																	Source: "response.body",
																	Start: ast.Position{
																		Column: 117,
																		Line:   54,
																	},
																},
															},
															Lbrack: nil,
															Object: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 125,
																			Line:   54,
																		},
																		File:   "usage.flux",
																		Source: "response",
																		Start: ast.Position{
																			Column: 117,
																			Line:   54,
																		},
																	},
																},
																Name: "response",
															},
															Property: &ast.Identifier{
																BaseNode: ast.BaseNode{
																	Comments: nil,
																	Errors:   nil,
																	Loc: &ast.SourceLocation{
																		End: ast.Position{
																			Column: 130,
																			Line:   54,
																		},
																		File:   "usage.flux",
																		Source: "body",
																		Start: ast.Position{
																			Column: 126,
																			Line:   54,
																		},
																	},
																},
																Name: "body",
															},
															Rbrack: nil,
														},
													}},
													Rbrace: nil,
													With:   nil,
												}},
												BaseNode: ast.BaseNode{
													Comments: nil,
													Errors:   nil,
													Loc: &ast.SourceLocation{
														End: ast.Position{
															Column: 131,
															Line:   54,
														},
														File:   "usage.flux",
														Source: "string(v: response.body)",
														Start: ast.Position{
															Column: 107,
															Line:   54,
														},
													},
												},
												Callee: &ast.Identifier{
													BaseNode: ast.BaseNode{
														Comments: nil,
														Errors:   nil,
														Loc: &ast.SourceLocation{
															End: ast.Position{
																Column: 113,
																Line:   54,
															},
															File:   "usage.flux",
															Source: "string",
															Start: ast.Position{
																Column: 107,
																Line:   54,
															},
														},
													},
													Name: "string",
												},
												Lparen: nil,
												Rparen: nil,
											},
										},
									}},
									Rbrace: nil,
									With:   nil,
								}},
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 132,
											Line:   54,
										},
										File:   "usage.flux",
										Source: "die(msg: \"organization limits request returned status \" + string(v: response.statusCode) + \": \" + string(v: response.body))",
										Start: ast.Position{
											Column: 9,
											Line:   54,
										},
									},
								},
								Callee: &ast.Identifier{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 12,
												Line:   54,
											},
											File:   "usage.flux",
											Source: "die",
											Start: ast.Position{
												Column: 9,
												Line:   54,
											},
										},
									},
									Name: "die",
								},
								Lparen: nil,
								Rparen: nil,
							},
							Test: &ast.BinaryExpression{
								BaseNode: ast.BaseNode{
									Comments: nil,
									Errors:   nil,
									Loc: &ast.SourceLocation{
										End: ast.Position{
											Column: 40,
											Line:   53,
										},
										File:   "usage.flux",
										Source: "response.statusCode > 299",
										Start: ast.Position{
											Column: 15,
											Line:   53,
										},
									},
								},
								Left: &ast.MemberExpression{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 34,
												Line:   53,
											},
											File:   "usage.flux",
											Source: "response.statusCode",
											Start: ast.Position{
												Column: 15,
												Line:   53,
											},
										},
									},
									Lbrack: nil,
									Object: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 23,
													Line:   53,
												},
												File:   "usage.flux",
												Source: "response",
												Start: ast.Position{
													Column: 15,
													Line:   53,
												},
											},
										},
										Name: "response",
									},
									Property: &ast.Identifier{
										BaseNode: ast.BaseNode{
											Comments: nil,
											Errors:   nil,
											Loc: &ast.SourceLocation{
												End: ast.Position{
													Column: 34,
													Line:   53,
												},
												File:   "usage.flux",
												Source: "statusCode",
												Start: ast.Position{
													Column: 24,
													Line:   53,
												},
											},
										},
										Name: "statusCode",
									},
									Rbrack: nil,
								},
								Operator: 10,
								Right: &ast.IntegerLiteral{
									BaseNode: ast.BaseNode{
										Comments: nil,
										Errors:   nil,
										Loc: &ast.SourceLocation{
											End: ast.Position{
												Column: 40,
												Line:   53,
											},
											File:   "usage.flux",
											Source: "299",
											Start: ast.Position{
												Column: 37,
												Line:   53,
											},
										},
									},
									Value: int64(299),
								},
							},
							Tk_else: nil,
							Tk_if:   nil,
							Tk_then: nil,
						},
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 47,
									Line:   56,
								},
								File:   "usage.flux",
								Source: "return if response.statusCode > 299 then\n        die(msg: \"organization limits request returned status \" + string(v: response.statusCode) + \": \" + string(v: response.body))\n    else\n        json.parse(data: response.body).limits",
								Start: ast.Position{
									Column: 5,
									Line:   53,
								},
							},
						},
					}},
					Lbrace: nil,
					Rbrace: nil,
				},
				Lparen: nil,
				Params: []*ast.Property{&ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 18,
								Line:   44,
							},
							File:   "usage.flux",
							Source: "host=\"\"",
							Start: ast.Position{
								Column: 11,
								Line:   44,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 15,
									Line:   44,
								},
								File:   "usage.flux",
								Source: "host",
								Start: ast.Position{
									Column: 11,
									Line:   44,
								},
							},
						},
						Name: "host",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 18,
									Line:   44,
								},
								File:   "usage.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 16,
									Line:   44,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 28,
								Line:   44,
							},
							File:   "usage.flux",
							Source: "orgID=\"\"",
							Start: ast.Position{
								Column: 20,
								Line:   44,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 25,
									Line:   44,
								},
								File:   "usage.flux",
								Source: "orgID",
								Start: ast.Position{
									Column: 20,
									Line:   44,
								},
							},
						},
						Name: "orgID",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 28,
									Line:   44,
								},
								File:   "usage.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 26,
									Line:   44,
								},
							},
						},
						Value: "",
					},
				}, &ast.Property{
					BaseNode: ast.BaseNode{
						Comments: nil,
						Errors:   nil,
						Loc: &ast.SourceLocation{
							End: ast.Position{
								Column: 38,
								Line:   44,
							},
							File:   "usage.flux",
							Source: "token=\"\"",
							Start: ast.Position{
								Column: 30,
								Line:   44,
							},
						},
					},
					Comma: nil,
					Key: &ast.Identifier{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 35,
									Line:   44,
								},
								File:   "usage.flux",
								Source: "token",
								Start: ast.Position{
									Column: 30,
									Line:   44,
								},
							},
						},
						Name: "token",
					},
					Separator: nil,
					Value: &ast.StringLiteral{
						BaseNode: ast.BaseNode{
							Comments: nil,
							Errors:   nil,
							Loc: &ast.SourceLocation{
								End: ast.Position{
									Column: 38,
									Line:   44,
								},
								File:   "usage.flux",
								Source: "\"\"",
								Start: ast.Position{
									Column: 36,
									Line:   44,
								},
							},
						},
						Value: "",
					},
				}},
				Rparan: nil,
			},
		}},
		Eof: nil,
		Imports: []*ast.ImportDeclaration{&ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 13,
						Line:   4,
					},
					File:   "usage.flux",
					Source: "import \"csv\"",
					Start: ast.Position{
						Column: 1,
						Line:   4,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 13,
							Line:   4,
						},
						File:   "usage.flux",
						Source: "\"csv\"",
						Start: ast.Position{
							Column: 8,
							Line:   4,
						},
					},
				},
				Value: "csv",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 31,
						Line:   5,
					},
					File:   "usage.flux",
					Source: "import \"experimental/influxdb\"",
					Start: ast.Position{
						Column: 1,
						Line:   5,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 31,
							Line:   5,
						},
						File:   "usage.flux",
						Source: "\"experimental/influxdb\"",
						Start: ast.Position{
							Column: 8,
							Line:   5,
						},
					},
				},
				Value: "experimental/influxdb",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 27,
						Line:   6,
					},
					File:   "usage.flux",
					Source: "import \"experimental/json\"",
					Start: ast.Position{
						Column: 1,
						Line:   6,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 27,
							Line:   6,
						},
						File:   "usage.flux",
						Source: "\"experimental/json\"",
						Start: ast.Position{
							Column: 8,
							Line:   6,
						},
					},
				},
				Value: "experimental/json",
			},
		}, &ast.ImportDeclaration{
			As: nil,
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   7,
					},
					File:   "usage.flux",
					Source: "import \"http\"",
					Start: ast.Position{
						Column: 1,
						Line:   7,
					},
				},
			},
			Path: &ast.StringLiteral{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   7,
						},
						File:   "usage.flux",
						Source: "\"http\"",
						Start: ast.Position{
							Column: 8,
							Line:   7,
						},
					},
				},
				Value: "http",
			},
		}},
		Metadata: "parser-type=rust",
		Name:     "usage.flux",
		Package: &ast.PackageClause{
			BaseNode: ast.BaseNode{
				Comments: nil,
				Errors:   nil,
				Loc: &ast.SourceLocation{
					End: ast.Position{
						Column: 14,
						Line:   1,
					},
					File:   "usage.flux",
					Source: "package usage",
					Start: ast.Position{
						Column: 1,
						Line:   1,
					},
				},
			},
			Name: &ast.Identifier{
				BaseNode: ast.BaseNode{
					Comments: nil,
					Errors:   nil,
					Loc: &ast.SourceLocation{
						End: ast.Position{
							Column: 14,
							Line:   1,
						},
						File:   "usage.flux",
						Source: "usage",
						Start: ast.Position{
							Column: 9,
							Line:   1,
						},
					},
				},
				Name: "usage",
			},
		},
	}},
	Package: "usage",
	Path:    "experimental/usage",
}
