// SPDX-License-Identifier: Unlicense OR BSD-3-Clause

package language

// Code generated by typesettings-utils/generators/unicodedata/cmd/main.go DO NOT EDIT.

const (
	Adlam                        = Script(0x61646c6d) // adlm
	Afaka                        = Script(0x6166616b) // afak
	Ahom                         = Script(0x61686f6d) // ahom
	Anatolian_Hieroglyphs        = Script(0x686c7577) // hluw
	Arabic                       = Script(0x61726162) // arab
	Armenian                     = Script(0x61726d6e) // armn
	Avestan                      = Script(0x61767374) // avst
	Balinese                     = Script(0x62616c69) // bali
	Bamum                        = Script(0x62616d75) // bamu
	Bassa_Vah                    = Script(0x62617373) // bass
	Batak                        = Script(0x6261746b) // batk
	Bengali                      = Script(0x62656e67) // beng
	Bhaiksuki                    = Script(0x62686b73) // bhks
	Blissymbols                  = Script(0x626c6973) // blis
	Book_Pahlavi                 = Script(0x70686c76) // phlv
	Bopomofo                     = Script(0x626f706f) // bopo
	Brahmi                       = Script(0x62726168) // brah
	Braille                      = Script(0x62726169) // brai
	Buginese                     = Script(0x62756769) // bugi
	Buhid                        = Script(0x62756864) // buhd
	Canadian_Aboriginal          = Script(0x63616e73) // cans
	Carian                       = Script(0x63617269) // cari
	Caucasian_Albanian           = Script(0x61676862) // aghb
	Chakma                       = Script(0x63616b6d) // cakm
	Cham                         = Script(0x6368616d) // cham
	Cherokee                     = Script(0x63686572) // cher
	Chorasmian                   = Script(0x63687273) // chrs
	Cirth                        = Script(0x63697274) // cirt
	Code_for_unwritten_documents = Script(0x7a787878) // zxxx
	Common                       = Script(0x7a797979) // zyyy
	Coptic                       = Script(0x636f7074) // copt
	Cuneiform                    = Script(0x78737578) // xsux
	Cypriot                      = Script(0x63707274) // cprt
	Cypro_Minoan                 = Script(0x63706d6e) // cpmn
	Cyrillic                     = Script(0x6379726c) // cyrl
	Deseret                      = Script(0x64737274) // dsrt
	Devanagari                   = Script(0x64657661) // deva
	Dives_Akuru                  = Script(0x6469616b) // diak
	Dogra                        = Script(0x646f6772) // dogr
	Duployan                     = Script(0x6475706c) // dupl
	Egyptian_Hieroglyphs         = Script(0x65677970) // egyp
	Egyptian_demotic             = Script(0x65677964) // egyd
	Egyptian_hieratic            = Script(0x65677968) // egyh
	Elbasan                      = Script(0x656c6261) // elba
	Elymaic                      = Script(0x656c796d) // elym
	Ethiopic                     = Script(0x65746869) // ethi
	Georgian                     = Script(0x67656f72) // geor
	Glagolitic                   = Script(0x676c6167) // glag
	Gothic                       = Script(0x676f7468) // goth
	Grantha                      = Script(0x6772616e) // gran
	Greek                        = Script(0x6772656b) // grek
	Gujarati                     = Script(0x67756a72) // gujr
	Gunjala_Gondi                = Script(0x676f6e67) // gong
	Gurmukhi                     = Script(0x67757275) // guru
	Han                          = Script(0x68616e69) // hani
	Hangul                       = Script(0x68616e67) // hang
	Hanifi_Rohingya              = Script(0x726f6867) // rohg
	Hanunoo                      = Script(0x68616e6f) // hano
	Hatran                       = Script(0x68617472) // hatr
	Hebrew                       = Script(0x68656272) // hebr
	Hiragana                     = Script(0x68697261) // hira
	Imperial_Aramaic             = Script(0x61726d69) // armi
	Inherited                    = Script(0x7a696e68) // zinh
	Inscriptional_Pahlavi        = Script(0x70686c69) // phli
	Inscriptional_Parthian       = Script(0x70727469) // prti
	Javanese                     = Script(0x6a617661) // java
	Jurchen                      = Script(0x6a757263) // jurc
	Kaithi                       = Script(0x6b746869) // kthi
	Kannada                      = Script(0x6b6e6461) // knda
	Katakana                     = Script(0x6b616e61) // kana
	Katakana_Or_Hiragana         = Script(0x68726b74) // hrkt
	Kawi                         = Script(0x6b617769) // kawi
	Kayah_Li                     = Script(0x6b616c69) // kali
	Kharoshthi                   = Script(0x6b686172) // khar
	Khitan_Small_Script          = Script(0x6b697473) // kits
	Khitan_large_script          = Script(0x6b69746c) // kitl
	Khmer                        = Script(0x6b686d72) // khmr
	Khojki                       = Script(0x6b686f6a) // khoj
	Khudawadi                    = Script(0x73696e64) // sind
	Kpelle                       = Script(0x6b70656c) // kpel
	Lao                          = Script(0x6c616f6f) // laoo
	Latin                        = Script(0x6c61746e) // latn
	Leke                         = Script(0x6c656b65) // leke
	Lepcha                       = Script(0x6c657063) // lepc
	Limbu                        = Script(0x6c696d62) // limb
	Linear_A                     = Script(0x6c696e61) // lina
	Linear_B                     = Script(0x6c696e62) // linb
	Lisu                         = Script(0x6c697375) // lisu
	Loma                         = Script(0x6c6f6d61) // loma
	Lycian                       = Script(0x6c796369) // lyci
	Lydian                       = Script(0x6c796469) // lydi
	Mahajani                     = Script(0x6d61686a) // mahj
	Makasar                      = Script(0x6d616b61) // maka
	Malayalam                    = Script(0x6d6c796d) // mlym
	Mandaic                      = Script(0x6d616e64) // mand
	Manichaean                   = Script(0x6d616e69) // mani
	Marchen                      = Script(0x6d617263) // marc
	Masaram_Gondi                = Script(0x676f6e6d) // gonm
	Mathematical_notation        = Script(0x7a6d7468) // zmth
	Mayan_hieroglyphs            = Script(0x6d617961) // maya
	Medefaidrin                  = Script(0x6d656466) // medf
	Meetei_Mayek                 = Script(0x6d746569) // mtei
	Mende_Kikakui                = Script(0x6d656e64) // mend
	Meroitic_Cursive             = Script(0x6d657263) // merc
	Meroitic_Hieroglyphs         = Script(0x6d65726f) // mero
	Miao                         = Script(0x706c7264) // plrd
	Modi                         = Script(0x6d6f6469) // modi
	Mongolian                    = Script(0x6d6f6e67) // mong
	Mro                          = Script(0x6d726f6f) // mroo
	Multani                      = Script(0x6d756c74) // mult
	Myanmar                      = Script(0x6d796d72) // mymr
	Nabataean                    = Script(0x6e626174) // nbat
	Nag_Mundari                  = Script(0x6e61676d) // nagm
	Nandinagari                  = Script(0x6e616e64) // nand
	New_Tai_Lue                  = Script(0x74616c75) // talu
	Newa                         = Script(0x6e657761) // newa
	Nko                          = Script(0x6e6b6f6f) // nkoo
	Nushu                        = Script(0x6e736875) // nshu
	Nyiakeng_Puachue_Hmong       = Script(0x686d6e70) // hmnp
	Ogham                        = Script(0x6f67616d) // ogam
	Ol_Chiki                     = Script(0x6f6c636b) // olck
	Old_Hungarian                = Script(0x68756e67) // hung
	Old_Italic                   = Script(0x6974616c) // ital
	Old_North_Arabian            = Script(0x6e617262) // narb
	Old_Permic                   = Script(0x7065726d) // perm
	Old_Persian                  = Script(0x7870656f) // xpeo
	Old_Sogdian                  = Script(0x736f676f) // sogo
	Old_South_Arabian            = Script(0x73617262) // sarb
	Old_Turkic                   = Script(0x6f726b68) // orkh
	Old_Uyghur                   = Script(0x6f756772) // ougr
	Oriya                        = Script(0x6f727961) // orya
	Osage                        = Script(0x6f736765) // osge
	Osmanya                      = Script(0x6f736d61) // osma
	Pahawh_Hmong                 = Script(0x686d6e67) // hmng
	Palmyrene                    = Script(0x70616c6d) // palm
	Pau_Cin_Hau                  = Script(0x70617563) // pauc
	Phags_Pa                     = Script(0x70686167) // phag
	Phoenician                   = Script(0x70686e78) // phnx
	Psalter_Pahlavi              = Script(0x70686c70) // phlp
	Ranjana                      = Script(0x72616e6a) // ranj
	Rejang                       = Script(0x726a6e67) // rjng
	Rongorongo                   = Script(0x726f726f) // roro
	Runic                        = Script(0x72756e72) // runr
	Samaritan                    = Script(0x73616d72) // samr
	Sarati                       = Script(0x73617261) // sara
	Saurashtra                   = Script(0x73617572) // saur
	Sharada                      = Script(0x73687264) // shrd
	Shavian                      = Script(0x73686177) // shaw
	Shuishu                      = Script(0x73687569) // shui
	Siddham                      = Script(0x73696464) // sidd
	SignWriting                  = Script(0x73676e77) // sgnw
	Sinhala                      = Script(0x73696e68) // sinh
	Sogdian                      = Script(0x736f6764) // sogd
	Sora_Sompeng                 = Script(0x736f7261) // sora
	Soyombo                      = Script(0x736f796f) // soyo
	Sundanese                    = Script(0x73756e64) // sund
	Sunuwar                      = Script(0x73756e75) // sunu
	Syloti_Nagri                 = Script(0x73796c6f) // sylo
	Symbols                      = Script(0x7a73796d) // zsym
	Syriac                       = Script(0x73797263) // syrc
	Tagalog                      = Script(0x74676c67) // tglg
	Tagbanwa                     = Script(0x74616762) // tagb
	Tai_Le                       = Script(0x74616c65) // tale
	Tai_Tham                     = Script(0x6c616e61) // lana
	Tai_Viet                     = Script(0x74617674) // tavt
	Takri                        = Script(0x74616b72) // takr
	Tamil                        = Script(0x74616d6c) // taml
	Tangsa                       = Script(0x746e7361) // tnsa
	Tangut                       = Script(0x74616e67) // tang
	Telugu                       = Script(0x74656c75) // telu
	Tengwar                      = Script(0x74656e67) // teng
	Thaana                       = Script(0x74686161) // thaa
	Thai                         = Script(0x74686169) // thai
	Tibetan                      = Script(0x74696274) // tibt
	Tifinagh                     = Script(0x74666e67) // tfng
	Tirhuta                      = Script(0x74697268) // tirh
	Toto                         = Script(0x746f746f) // toto
	Ugaritic                     = Script(0x75676172) // ugar
	Unknown                      = Script(0x7a7a7a7a) // zzzz
	Vai                          = Script(0x76616969) // vaii
	Visible_Speech               = Script(0x76697370) // visp
	Vithkuqi                     = Script(0x76697468) // vith
	Wancho                       = Script(0x7763686f) // wcho
	Warang_Citi                  = Script(0x77617261) // wara
	Woleai                       = Script(0x776f6c65) // wole
	Yezidi                       = Script(0x79657a69) // yezi
	Yi                           = Script(0x79696969) // yiii
	Zanabazar_Square             = Script(0x7a616e62) // zanb
)

var scriptToTag = map[string]Script{
	"Adlam":                        1633971309,
	"Afaka":                        1634099563,
	"Ahom":                         1634234221,
	"Anatolian_Hieroglyphs":        1751938423,
	"Arabic":                       1634885986,
	"Armenian":                     1634889070,
	"Avestan":                      1635152756,
	"Balinese":                     1650551913,
	"Bamum":                        1650552181,
	"Bassa_Vah":                    1650553715,
	"Batak":                        1650553963,
	"Bengali":                      1650814567,
	"Bhaiksuki":                    1651010419,
	"Blissymbols":                  1651272051,
	"Book_Pahlavi":                 1885891702,
	"Bopomofo":                     1651470447,
	"Brahmi":                       1651663208,
	"Braille":                      1651663209,
	"Buginese":                     1651861353,
	"Buhid":                        1651861604,
	"Canadian_Aboriginal":          1667329651,
	"Carian":                       1667330665,
	"Caucasian_Albanian":           1634166882,
	"Chakma":                       1667328877,
	"Cham":                         1667785069,
	"Cherokee":                     1667786098,
	"Chorasmian":                   1667789427,
	"Cirth":                        1667854964,
	"Code_for_unwritten_documents": 2054715512,
	"Common":                       2054781305,
	"Coptic":                       1668247668,
	"Cuneiform":                    2020832632,
	"Cypriot":                      1668313716,
	"Cypro_Minoan":                 1668312430,
	"Cyrillic":                     1668903532,
	"Deseret":                      1685287540,
	"Devanagari":                   1684371041,
	"Dives_Akuru":                  1684627819,
	"Dogra":                        1685022578,
	"Duployan":                     1685418092,
	"Egyptian_Hieroglyphs":         1701280112,
	"Egyptian_demotic":             1701280100,
	"Egyptian_hieratic":            1701280104,
	"Elbasan":                      1701601889,
	"Elymaic":                      1701607789,
	"Ethiopic":                     1702127721,
	"Georgian":                     1734700914,
	"Glagolitic":                   1735156071,
	"Gothic":                       1735357544,
	"Grantha":                      1735549294,
	"Greek":                        1735550315,
	"Gujarati":                     1735748210,
	"Gunjala_Gondi":                1735356007,
	"Gurmukhi":                     1735750261,
	"Han":                          1751215721,
	"Hangul":                       1751215719,
	"Hanifi_Rohingya":              1919903847,
	"Hanunoo":                      1751215727,
	"Hatran":                       1751217266,
	"Hebrew":                       1751474802,
	"Hiragana":                     1751741025,
	"Imperial_Aramaic":             1634889065,
	"Inherited":                    2053729896,
	"Inscriptional_Pahlavi":        1885891689,
	"Inscriptional_Parthian":       1886549097,
	"Javanese":                     1784772193,
	"Jurchen":                      1786081891,
	"Kaithi":                       1802791017,
	"Kannada":                      1802396769,
	"Katakana":                     1801547361,
	"Katakana_Or_Hiragana":         1752329076,
	"Kawi":                         1801549673,
	"Kayah_Li":                     1801546857,
	"Kharoshthi":                   1802002802,
	"Khitan_Small_Script":          1802073203,
	"Khitan_large_script":          1802073196,
	"Khmer":                        1802005874,
	"Khojki":                       1802006378,
	"Khudawadi":                    1936289380,
	"Kpelle":                       1802528108,
	"Lao":                          1818324847,
	"Latin":                        1818326126,
	"Leke":                         1818585957,
	"Lepcha":                       1818587235,
	"Limbu":                        1818848610,
	"Linear_A":                     1818848865,
	"Linear_B":                     1818848866,
	"Lisu":                         1818850165,
	"Loma":                         1819241825,
	"Lycian":                       1819894633,
	"Lydian":                       1819894889,
	"Mahajani":                     1835100266,
	"Makasar":                      1835101025,
	"Malayalam":                    1835825517,
	"Mandaic":                      1835101796,
	"Manichaean":                   1835101801,
	"Marchen":                      1835102819,
	"Masaram_Gondi":                1735356013,
	"Mathematical_notation":        2053993576,
	"Mayan_hieroglyphs":            1835104609,
	"Medefaidrin":                  1835361382,
	"Meetei_Mayek":                 1836344681,
	"Mende_Kikakui":                1835363940,
	"Meroitic_Cursive":             1835364963,
	"Meroitic_Hieroglyphs":         1835364975,
	"Miao":                         1886155364,
	"Modi":                         1836016745,
	"Mongolian":                    1836019303,
	"Mro":                          1836216175,
	"Multani":                      1836412020,
	"Myanmar":                      1836674418,
	"Nabataean":                    1851941236,
	"Nag_Mundari":                  1851877229,
	"Nandinagari":                  1851879012,
	"New_Tai_Lue":                  1952541813,
	"Newa":                         1852143457,
	"Nko":                          1852534639,
	"Nushu":                        1853057141,
	"Nyiakeng_Puachue_Hmong":       1752002160,
	"Ogham":                        1869046125,
	"Ol_Chiki":                     1869374315,
	"Old_Hungarian":                1752526439,
	"Old_Italic":                   1769234796,
	"Old_North_Arabian":            1851880034,
	"Old_Permic":                   1885696621,
	"Old_Persian":                  2020631919,
	"Old_Sogdian":                  1936680815,
	"Old_South_Arabian":            1935766114,
	"Old_Turkic":                   1869769576,
	"Old_Uyghur":                   1869965170,
	"Oriya":                        1869773153,
	"Osage":                        1869834085,
	"Osmanya":                      1869835617,
	"Pahawh_Hmong":                 1752002151,
	"Palmyrene":                    1885432941,
	"Pau_Cin_Hau":                  1885435235,
	"Phags_Pa":                     1885888871,
	"Phoenician":                   1885892216,
	"Psalter_Pahlavi":              1885891696,
	"Ranjana":                      1918987882,
	"Rejang":                       1919577703,
	"Rongorongo":                   1919906415,
	"Runic":                        1920298610,
	"Samaritan":                    1935764850,
	"Sarati":                       1935766113,
	"Saurashtra":                   1935766898,
	"Sharada":                      1936224868,
	"Shavian":                      1936220535,
	"Shuishu":                      1936225641,
	"Siddham":                      1936286820,
	"SignWriting":                  1936158327,
	"Sinhala":                      1936289384,
	"Sogdian":                      1936680804,
	"Sora_Sompeng":                 1936683617,
	"Soyombo":                      1936685423,
	"Sundanese":                    1937075812,
	"Sunuwar":                      1937075829,
	"Syloti_Nagri":                 1937337455,
	"Symbols":                      2054388077,
	"Syriac":                       1937338979,
	"Tagalog":                      1952935015,
	"Tagbanwa":                     1952540514,
	"Tai_Le":                       1952541797,
	"Tai_Tham":                     1818324577,
	"Tai_Viet":                     1952544372,
	"Takri":                        1952541554,
	"Tamil":                        1952542060,
	"Tangsa":                       1953395553,
	"Tangut":                       1952542311,
	"Telugu":                       1952803957,
	"Tengwar":                      1952804455,
	"Thaana":                       1952997729,
	"Thai":                         1952997737,
	"Tibetan":                      1953063540,
	"Tifinagh":                     1952869991,
	"Tirhuta":                      1953067624,
	"Toto":                         1953461359,
	"Ugaritic":                     1969709426,
	"Unknown":                      2054847098,
	"Vai":                          1986095465,
	"Visible_Speech":               1986622320,
	"Vithkuqi":                     1986622568,
	"Wancho":                       2003003503,
	"Warang_Citi":                  2002874977,
	"Woleai":                       2003790949,
	"Yezidi":                       2036693609,
	"Yi":                           2036951401,
	"Zanabazar_Square":             2053205602,
}

// ScriptRange is an inclusive range of runes
// with constant script.
type ScriptRange struct {
	Start, End rune
	Script     Script
}

// ScriptRanges is a sorted list of script ranges.
var ScriptRanges = [...]ScriptRange{
	{0x0, 0x40, 0x7a797979},
	{0x41, 0x5a, 0x6c61746e},
	{0x5b, 0x60, 0x7a797979},
	{0x61, 0x7a, 0x6c61746e},
	{0x7b, 0xa9, 0x7a797979},
	{0xaa, 0xaa, 0x6c61746e},
	{0xab, 0xb9, 0x7a797979},
	{0xba, 0xba, 0x6c61746e},
	{0xbb, 0xbf, 0x7a797979},
	{0xc0, 0xd6, 0x6c61746e},
	{0xd7, 0xd7, 0x7a797979},
	{0xd8, 0xf6, 0x6c61746e},
	{0xf7, 0xf7, 0x7a797979},
	{0xf8, 0x2b8, 0x6c61746e},
	{0x2b9, 0x2df, 0x7a797979},
	{0x2e0, 0x2e4, 0x6c61746e},
	{0x2e5, 0x2e9, 0x7a797979},
	{0x2ea, 0x2eb, 0x626f706f},
	{0x2ec, 0x2ff, 0x7a797979},
	{0x300, 0x36f, 0x7a696e68},
	{0x370, 0x373, 0x6772656b},
	{0x374, 0x374, 0x7a797979},
	{0x375, 0x377, 0x6772656b},
	{0x37a, 0x37d, 0x6772656b},
	{0x37e, 0x37e, 0x7a797979},
	{0x37f, 0x37f, 0x6772656b},
	{0x384, 0x384, 0x6772656b},
	{0x385, 0x385, 0x7a797979},
	{0x386, 0x386, 0x6772656b},
	{0x387, 0x387, 0x7a797979},
	{0x388, 0x38a, 0x6772656b},
	{0x38c, 0x38c, 0x6772656b},
	{0x38e, 0x3a1, 0x6772656b},
	{0x3a3, 0x3e1, 0x6772656b},
	{0x3e2, 0x3ef, 0x636f7074},
	{0x3f0, 0x3ff, 0x6772656b},
	{0x400, 0x484, 0x6379726c},
	{0x485, 0x486, 0x7a696e68},
	{0x487, 0x52f, 0x6379726c},
	{0x531, 0x556, 0x61726d6e},
	{0x559, 0x58a, 0x61726d6e},
	{0x58d, 0x58f, 0x61726d6e},
	{0x591, 0x5c7, 0x68656272},
	{0x5d0, 0x5ea, 0x68656272},
	{0x5ef, 0x5f4, 0x68656272},
	{0x600, 0x604, 0x61726162},
	{0x605, 0x605, 0x7a797979},
	{0x606, 0x60b, 0x61726162},
	{0x60c, 0x60c, 0x7a797979},
	{0x60d, 0x61a, 0x61726162},
	{0x61b, 0x61b, 0x7a797979},
	{0x61c, 0x61e, 0x61726162},
	{0x61f, 0x61f, 0x7a797979},
	{0x620, 0x63f, 0x61726162},
	{0x640, 0x640, 0x7a797979},
	{0x641, 0x64a, 0x61726162},
	{0x64b, 0x655, 0x7a696e68},
	{0x656, 0x66f, 0x61726162},
	{0x670, 0x670, 0x7a696e68},
	{0x671, 0x6dc, 0x61726162},
	{0x6dd, 0x6dd, 0x7a797979},
	{0x6de, 0x6ff, 0x61726162},
	{0x700, 0x70d, 0x73797263},
	{0x70f, 0x74a, 0x73797263},
	{0x74d, 0x74f, 0x73797263},
	{0x750, 0x77f, 0x61726162},
	{0x780, 0x7b1, 0x74686161},
	{0x7c0, 0x7fa, 0x6e6b6f6f},
	{0x7fd, 0x7ff, 0x6e6b6f6f},
	{0x800, 0x82d, 0x73616d72},
	{0x830, 0x83e, 0x73616d72},
	{0x840, 0x85b, 0x6d616e64},
	{0x85e, 0x85e, 0x6d616e64},
	{0x860, 0x86a, 0x73797263},
	{0x870, 0x88e, 0x61726162},
	{0x890, 0x891, 0x61726162},
	{0x898, 0x8e1, 0x61726162},
	{0x8e2, 0x8e2, 0x7a797979},
	{0x8e3, 0x8ff, 0x61726162},
	{0x900, 0x950, 0x64657661},
	{0x951, 0x954, 0x7a696e68},
	{0x955, 0x963, 0x64657661},
	{0x964, 0x965, 0x7a797979},
	{0x966, 0x97f, 0x64657661},
	{0x980, 0x983, 0x62656e67},
	{0x985, 0x98c, 0x62656e67},
	{0x98f, 0x990, 0x62656e67},
	{0x993, 0x9a8, 0x62656e67},
	{0x9aa, 0x9b0, 0x62656e67},
	{0x9b2, 0x9b2, 0x62656e67},
	{0x9b6, 0x9b9, 0x62656e67},
	{0x9bc, 0x9c4, 0x62656e67},
	{0x9c7, 0x9c8, 0x62656e67},
	{0x9cb, 0x9ce, 0x62656e67},
	{0x9d7, 0x9d7, 0x62656e67},
	{0x9dc, 0x9dd, 0x62656e67},
	{0x9df, 0x9e3, 0x62656e67},
	{0x9e6, 0x9fe, 0x62656e67},
	{0xa01, 0xa03, 0x67757275},
	{0xa05, 0xa0a, 0x67757275},
	{0xa0f, 0xa10, 0x67757275},
	{0xa13, 0xa28, 0x67757275},
	{0xa2a, 0xa30, 0x67757275},
	{0xa32, 0xa33, 0x67757275},
	{0xa35, 0xa36, 0x67757275},
	{0xa38, 0xa39, 0x67757275},
	{0xa3c, 0xa3c, 0x67757275},
	{0xa3e, 0xa42, 0x67757275},
	{0xa47, 0xa48, 0x67757275},
	{0xa4b, 0xa4d, 0x67757275},
	{0xa51, 0xa51, 0x67757275},
	{0xa59, 0xa5c, 0x67757275},
	{0xa5e, 0xa5e, 0x67757275},
	{0xa66, 0xa76, 0x67757275},
	{0xa81, 0xa83, 0x67756a72},
	{0xa85, 0xa8d, 0x67756a72},
	{0xa8f, 0xa91, 0x67756a72},
	{0xa93, 0xaa8, 0x67756a72},
	{0xaaa, 0xab0, 0x67756a72},
	{0xab2, 0xab3, 0x67756a72},
	{0xab5, 0xab9, 0x67756a72},
	{0xabc, 0xac5, 0x67756a72},
	{0xac7, 0xac9, 0x67756a72},
	{0xacb, 0xacd, 0x67756a72},
	{0xad0, 0xad0, 0x67756a72},
	{0xae0, 0xae3, 0x67756a72},
	{0xae6, 0xaf1, 0x67756a72},
	{0xaf9, 0xaff, 0x67756a72},
	{0xb01, 0xb03, 0x6f727961},
	{0xb05, 0xb0c, 0x6f727961},
	{0xb0f, 0xb10, 0x6f727961},
	{0xb13, 0xb28, 0x6f727961},
	{0xb2a, 0xb30, 0x6f727961},
	{0xb32, 0xb33, 0x6f727961},
	{0xb35, 0xb39, 0x6f727961},
	{0xb3c, 0xb44, 0x6f727961},
	{0xb47, 0xb48, 0x6f727961},
	{0xb4b, 0xb4d, 0x6f727961},
	{0xb55, 0xb57, 0x6f727961},
	{0xb5c, 0xb5d, 0x6f727961},
	{0xb5f, 0xb63, 0x6f727961},
	{0xb66, 0xb77, 0x6f727961},
	{0xb82, 0xb83, 0x74616d6c},
	{0xb85, 0xb8a, 0x74616d6c},
	{0xb8e, 0xb90, 0x74616d6c},
	{0xb92, 0xb95, 0x74616d6c},
	{0xb99, 0xb9a, 0x74616d6c},
	{0xb9c, 0xb9c, 0x74616d6c},
	{0xb9e, 0xb9f, 0x74616d6c},
	{0xba3, 0xba4, 0x74616d6c},
	{0xba8, 0xbaa, 0x74616d6c},
	{0xbae, 0xbb9, 0x74616d6c},
	{0xbbe, 0xbc2, 0x74616d6c},
	{0xbc6, 0xbc8, 0x74616d6c},
	{0xbca, 0xbcd, 0x74616d6c},
	{0xbd0, 0xbd0, 0x74616d6c},
	{0xbd7, 0xbd7, 0x74616d6c},
	{0xbe6, 0xbfa, 0x74616d6c},
	{0xc00, 0xc0c, 0x74656c75},
	{0xc0e, 0xc10, 0x74656c75},
	{0xc12, 0xc28, 0x74656c75},
	{0xc2a, 0xc39, 0x74656c75},
	{0xc3c, 0xc44, 0x74656c75},
	{0xc46, 0xc48, 0x74656c75},
	{0xc4a, 0xc4d, 0x74656c75},
	{0xc55, 0xc56, 0x74656c75},
	{0xc58, 0xc5a, 0x74656c75},
	{0xc5d, 0xc5d, 0x74656c75},
	{0xc60, 0xc63, 0x74656c75},
	{0xc66, 0xc6f, 0x74656c75},
	{0xc77, 0xc7f, 0x74656c75},
	{0xc80, 0xc8c, 0x6b6e6461},
	{0xc8e, 0xc90, 0x6b6e6461},
	{0xc92, 0xca8, 0x6b6e6461},
	{0xcaa, 0xcb3, 0x6b6e6461},
	{0xcb5, 0xcb9, 0x6b6e6461},
	{0xcbc, 0xcc4, 0x6b6e6461},
	{0xcc6, 0xcc8, 0x6b6e6461},
	{0xcca, 0xccd, 0x6b6e6461},
	{0xcd5, 0xcd6, 0x6b6e6461},
	{0xcdd, 0xcde, 0x6b6e6461},
	{0xce0, 0xce3, 0x6b6e6461},
	{0xce6, 0xcef, 0x6b6e6461},
	{0xcf1, 0xcf3, 0x6b6e6461},
	{0xd00, 0xd0c, 0x6d6c796d},
	{0xd0e, 0xd10, 0x6d6c796d},
	{0xd12, 0xd44, 0x6d6c796d},
	{0xd46, 0xd48, 0x6d6c796d},
	{0xd4a, 0xd4f, 0x6d6c796d},
	{0xd54, 0xd63, 0x6d6c796d},
	{0xd66, 0xd7f, 0x6d6c796d},
	{0xd81, 0xd83, 0x73696e68},
	{0xd85, 0xd96, 0x73696e68},
	{0xd9a, 0xdb1, 0x73696e68},
	{0xdb3, 0xdbb, 0x73696e68},
	{0xdbd, 0xdbd, 0x73696e68},
	{0xdc0, 0xdc6, 0x73696e68},
	{0xdca, 0xdca, 0x73696e68},
	{0xdcf, 0xdd4, 0x73696e68},
	{0xdd6, 0xdd6, 0x73696e68},
	{0xdd8, 0xddf, 0x73696e68},
	{0xde6, 0xdef, 0x73696e68},
	{0xdf2, 0xdf4, 0x73696e68},
	{0xe01, 0xe3a, 0x74686169},
	{0xe3f, 0xe3f, 0x7a797979},
	{0xe40, 0xe5b, 0x74686169},
	{0xe81, 0xe82, 0x6c616f6f},
	{0xe84, 0xe84, 0x6c616f6f},
	{0xe86, 0xe8a, 0x6c616f6f},
	{0xe8c, 0xea3, 0x6c616f6f},
	{0xea5, 0xea5, 0x6c616f6f},
	{0xea7, 0xebd, 0x6c616f6f},
	{0xec0, 0xec4, 0x6c616f6f},
	{0xec6, 0xec6, 0x6c616f6f},
	{0xec8, 0xece, 0x6c616f6f},
	{0xed0, 0xed9, 0x6c616f6f},
	{0xedc, 0xedf, 0x6c616f6f},
	{0xf00, 0xf47, 0x74696274},
	{0xf49, 0xf6c, 0x74696274},
	{0xf71, 0xf97, 0x74696274},
	{0xf99, 0xfbc, 0x74696274},
	{0xfbe, 0xfcc, 0x74696274},
	{0xfce, 0xfd4, 0x74696274},
	{0xfd5, 0xfd8, 0x7a797979},
	{0xfd9, 0xfda, 0x74696274},
	{0x1000, 0x109f, 0x6d796d72},
	{0x10a0, 0x10c5, 0x67656f72},
	{0x10c7, 0x10c7, 0x67656f72},
	{0x10cd, 0x10cd, 0x67656f72},
	{0x10d0, 0x10fa, 0x67656f72},
	{0x10fb, 0x10fb, 0x7a797979},
	{0x10fc, 0x10ff, 0x67656f72},
	{0x1100, 0x11ff, 0x68616e67},
	{0x1200, 0x1248, 0x65746869},
	{0x124a, 0x124d, 0x65746869},
	{0x1250, 0x1256, 0x65746869},
	{0x1258, 0x1258, 0x65746869},
	{0x125a, 0x125d, 0x65746869},
	{0x1260, 0x1288, 0x65746869},
	{0x128a, 0x128d, 0x65746869},
	{0x1290, 0x12b0, 0x65746869},
	{0x12b2, 0x12b5, 0x65746869},
	{0x12b8, 0x12be, 0x65746869},
	{0x12c0, 0x12c0, 0x65746869},
	{0x12c2, 0x12c5, 0x65746869},
	{0x12c8, 0x12d6, 0x65746869},
	{0x12d8, 0x1310, 0x65746869},
	{0x1312, 0x1315, 0x65746869},
	{0x1318, 0x135a, 0x65746869},
	{0x135d, 0x137c, 0x65746869},
	{0x1380, 0x1399, 0x65746869},
	{0x13a0, 0x13f5, 0x63686572},
	{0x13f8, 0x13fd, 0x63686572},
	{0x1400, 0x167f, 0x63616e73},
	{0x1680, 0x169c, 0x6f67616d},
	{0x16a0, 0x16ea, 0x72756e72},
	{0x16eb, 0x16ed, 0x7a797979},
	{0x16ee, 0x16f8, 0x72756e72},
	{0x1700, 0x1715, 0x74676c67},
	{0x171f, 0x171f, 0x74676c67},
	{0x1720, 0x1734, 0x68616e6f},
	{0x1735, 0x1736, 0x7a797979},
	{0x1740, 0x1753, 0x62756864},
	{0x1760, 0x176c, 0x74616762},
	{0x176e, 0x1770, 0x74616762},
	{0x1772, 0x1773, 0x74616762},
	{0x1780, 0x17dd, 0x6b686d72},
	{0x17e0, 0x17e9, 0x6b686d72},
	{0x17f0, 0x17f9, 0x6b686d72},
	{0x1800, 0x1801, 0x6d6f6e67},
	{0x1802, 0x1803, 0x7a797979},
	{0x1804, 0x1804, 0x6d6f6e67},
	{0x1805, 0x1805, 0x7a797979},
	{0x1806, 0x1819, 0x6d6f6e67},
	{0x1820, 0x1878, 0x6d6f6e67},
	{0x1880, 0x18aa, 0x6d6f6e67},
	{0x18b0, 0x18f5, 0x63616e73},
	{0x1900, 0x191e, 0x6c696d62},
	{0x1920, 0x192b, 0x6c696d62},
	{0x1930, 0x193b, 0x6c696d62},
	{0x1940, 0x1940, 0x6c696d62},
	{0x1944, 0x194f, 0x6c696d62},
	{0x1950, 0x196d, 0x74616c65},
	{0x1970, 0x1974, 0x74616c65},
	{0x1980, 0x19ab, 0x74616c75},
	{0x19b0, 0x19c9, 0x74616c75},
	{0x19d0, 0x19da, 0x74616c75},
	{0x19de, 0x19df, 0x74616c75},
	{0x19e0, 0x19ff, 0x6b686d72},
	{0x1a00, 0x1a1b, 0x62756769},
	{0x1a1e, 0x1a1f, 0x62756769},
	{0x1a20, 0x1a5e, 0x6c616e61},
	{0x1a60, 0x1a7c, 0x6c616e61},
	{0x1a7f, 0x1a89, 0x6c616e61},
	{0x1a90, 0x1a99, 0x6c616e61},
	{0x1aa0, 0x1aad, 0x6c616e61},
	{0x1ab0, 0x1ace, 0x7a696e68},
	{0x1b00, 0x1b4c, 0x62616c69},
	{0x1b50, 0x1b7e, 0x62616c69},
	{0x1b80, 0x1bbf, 0x73756e64},
	{0x1bc0, 0x1bf3, 0x6261746b},
	{0x1bfc, 0x1bff, 0x6261746b},
	{0x1c00, 0x1c37, 0x6c657063},
	{0x1c3b, 0x1c49, 0x6c657063},
	{0x1c4d, 0x1c4f, 0x6c657063},
	{0x1c50, 0x1c7f, 0x6f6c636b},
	{0x1c80, 0x1c88, 0x6379726c},
	{0x1c90, 0x1cba, 0x67656f72},
	{0x1cbd, 0x1cbf, 0x67656f72},
	{0x1cc0, 0x1cc7, 0x73756e64},
	{0x1cd0, 0x1cd2, 0x7a696e68},
	{0x1cd3, 0x1cd3, 0x7a797979},
	{0x1cd4, 0x1ce0, 0x7a696e68},
	{0x1ce1, 0x1ce1, 0x7a797979},
	{0x1ce2, 0x1ce8, 0x7a696e68},
	{0x1ce9, 0x1cec, 0x7a797979},
	{0x1ced, 0x1ced, 0x7a696e68},
	{0x1cee, 0x1cf3, 0x7a797979},
	{0x1cf4, 0x1cf4, 0x7a696e68},
	{0x1cf5, 0x1cf7, 0x7a797979},
	{0x1cf8, 0x1cf9, 0x7a696e68},
	{0x1cfa, 0x1cfa, 0x7a797979},
	{0x1d00, 0x1d25, 0x6c61746e},
	{0x1d26, 0x1d2a, 0x6772656b},
	{0x1d2b, 0x1d2b, 0x6379726c},
	{0x1d2c, 0x1d5c, 0x6c61746e},
	{0x1d5d, 0x1d61, 0x6772656b},
	{0x1d62, 0x1d65, 0x6c61746e},
	{0x1d66, 0x1d6a, 0x6772656b},
	{0x1d6b, 0x1d77, 0x6c61746e},
	{0x1d78, 0x1d78, 0x6379726c},
	{0x1d79, 0x1dbe, 0x6c61746e},
	{0x1dbf, 0x1dbf, 0x6772656b},
	{0x1dc0, 0x1dff, 0x7a696e68},
	{0x1e00, 0x1eff, 0x6c61746e},
	{0x1f00, 0x1f15, 0x6772656b},
	{0x1f18, 0x1f1d, 0x6772656b},
	{0x1f20, 0x1f45, 0x6772656b},
	{0x1f48, 0x1f4d, 0x6772656b},
	{0x1f50, 0x1f57, 0x6772656b},
	{0x1f59, 0x1f59, 0x6772656b},
	{0x1f5b, 0x1f5b, 0x6772656b},
	{0x1f5d, 0x1f5d, 0x6772656b},
	{0x1f5f, 0x1f7d, 0x6772656b},
	{0x1f80, 0x1fb4, 0x6772656b},
	{0x1fb6, 0x1fc4, 0x6772656b},
	{0x1fc6, 0x1fd3, 0x6772656b},
	{0x1fd6, 0x1fdb, 0x6772656b},
	{0x1fdd, 0x1fef, 0x6772656b},
	{0x1ff2, 0x1ff4, 0x6772656b},
	{0x1ff6, 0x1ffe, 0x6772656b},
	{0x2000, 0x200b, 0x7a797979},
	{0x200c, 0x200d, 0x7a696e68},
	{0x200e, 0x2064, 0x7a797979},
	{0x2066, 0x2070, 0x7a797979},
	{0x2071, 0x2071, 0x6c61746e},
	{0x2074, 0x207e, 0x7a797979},
	{0x207f, 0x207f, 0x6c61746e},
	{0x2080, 0x208e, 0x7a797979},
	{0x2090, 0x209c, 0x6c61746e},
	{0x20a0, 0x20c0, 0x7a797979},
	{0x20d0, 0x20f0, 0x7a696e68},
	{0x2100, 0x2125, 0x7a797979},
	{0x2126, 0x2126, 0x6772656b},
	{0x2127, 0x2129, 0x7a797979},
	{0x212a, 0x212b, 0x6c61746e},
	{0x212c, 0x2131, 0x7a797979},
	{0x2132, 0x2132, 0x6c61746e},
	{0x2133, 0x214d, 0x7a797979},
	{0x214e, 0x214e, 0x6c61746e},
	{0x214f, 0x215f, 0x7a797979},
	{0x2160, 0x2188, 0x6c61746e},
	{0x2189, 0x218b, 0x7a797979},
	{0x2190, 0x2426, 0x7a797979},
	{0x2440, 0x244a, 0x7a797979},
	{0x2460, 0x27ff, 0x7a797979},
	{0x2800, 0x28ff, 0x62726169},
	{0x2900, 0x2b73, 0x7a797979},
	{0x2b76, 0x2b95, 0x7a797979},
	{0x2b97, 0x2bff, 0x7a797979},
	{0x2c00, 0x2c5f, 0x676c6167},
	{0x2c60, 0x2c7f, 0x6c61746e},
	{0x2c80, 0x2cf3, 0x636f7074},
	{0x2cf9, 0x2cff, 0x636f7074},
	{0x2d00, 0x2d25, 0x67656f72},
	{0x2d27, 0x2d27, 0x67656f72},
	{0x2d2d, 0x2d2d, 0x67656f72},
	{0x2d30, 0x2d67, 0x74666e67},
	{0x2d6f, 0x2d70, 0x74666e67},
	{0x2d7f, 0x2d7f, 0x74666e67},
	{0x2d80, 0x2d96, 0x65746869},
	{0x2da0, 0x2da6, 0x65746869},
	{0x2da8, 0x2dae, 0x65746869},
	{0x2db0, 0x2db6, 0x65746869},
	{0x2db8, 0x2dbe, 0x65746869},
	{0x2dc0, 0x2dc6, 0x65746869},
	{0x2dc8, 0x2dce, 0x65746869},
	{0x2dd0, 0x2dd6, 0x65746869},
	{0x2dd8, 0x2dde, 0x65746869},
	{0x2de0, 0x2dff, 0x6379726c},
	{0x2e00, 0x2e5d, 0x7a797979},
	{0x2e80, 0x2e99, 0x68616e69},
	{0x2e9b, 0x2ef3, 0x68616e69},
	{0x2f00, 0x2fd5, 0x68616e69},
	{0x2ff0, 0x2ffb, 0x7a797979},
	{0x3000, 0x3004, 0x7a797979},
	{0x3005, 0x3005, 0x68616e69},
	{0x3006, 0x3006, 0x7a797979},
	{0x3007, 0x3007, 0x68616e69},
	{0x3008, 0x3020, 0x7a797979},
	{0x3021, 0x3029, 0x68616e69},
	{0x302a, 0x302d, 0x7a696e68},
	{0x302e, 0x302f, 0x68616e67},
	{0x3030, 0x3037, 0x7a797979},
	{0x3038, 0x303b, 0x68616e69},
	{0x303c, 0x303f, 0x7a797979},
	{0x3041, 0x3096, 0x68697261},
	{0x3099, 0x309a, 0x7a696e68},
	{0x309b, 0x309c, 0x7a797979},
	{0x309d, 0x309f, 0x68697261},
	{0x30a0, 0x30a0, 0x7a797979},
	{0x30a1, 0x30fa, 0x6b616e61},
	{0x30fb, 0x30fc, 0x7a797979},
	{0x30fd, 0x30ff, 0x6b616e61},
	{0x3105, 0x312f, 0x626f706f},
	{0x3131, 0x318e, 0x68616e67},
	{0x3190, 0x319f, 0x7a797979},
	{0x31a0, 0x31bf, 0x626f706f},
	{0x31c0, 0x31e3, 0x7a797979},
	{0x31f0, 0x31ff, 0x6b616e61},
	{0x3200, 0x321e, 0x68616e67},
	{0x3220, 0x325f, 0x7a797979},
	{0x3260, 0x327e, 0x68616e67},
	{0x327f, 0x32cf, 0x7a797979},
	{0x32d0, 0x32fe, 0x6b616e61},
	{0x32ff, 0x32ff, 0x7a797979},
	{0x3300, 0x3357, 0x6b616e61},
	{0x3358, 0x33ff, 0x7a797979},
	{0x3400, 0x4dbf, 0x68616e69},
	{0x4dc0, 0x4dff, 0x7a797979},
	{0x4e00, 0x9fff, 0x68616e69},
	{0xa000, 0xa48c, 0x79696969},
	{0xa490, 0xa4c6, 0x79696969},
	{0xa4d0, 0xa4ff, 0x6c697375},
	{0xa500, 0xa62b, 0x76616969},
	{0xa640, 0xa69f, 0x6379726c},
	{0xa6a0, 0xa6f7, 0x62616d75},
	{0xa700, 0xa721, 0x7a797979},
	{0xa722, 0xa787, 0x6c61746e},
	{0xa788, 0xa78a, 0x7a797979},
	{0xa78b, 0xa7ca, 0x6c61746e},
	{0xa7d0, 0xa7d1, 0x6c61746e},
	{0xa7d3, 0xa7d3, 0x6c61746e},
	{0xa7d5, 0xa7d9, 0x6c61746e},
	{0xa7f2, 0xa7ff, 0x6c61746e},
	{0xa800, 0xa82c, 0x73796c6f},
	{0xa830, 0xa839, 0x7a797979},
	{0xa840, 0xa877, 0x70686167},
	{0xa880, 0xa8c5, 0x73617572},
	{0xa8ce, 0xa8d9, 0x73617572},
	{0xa8e0, 0xa8ff, 0x64657661},
	{0xa900, 0xa92d, 0x6b616c69},
	{0xa92e, 0xa92e, 0x7a797979},
	{0xa92f, 0xa92f, 0x6b616c69},
	{0xa930, 0xa953, 0x726a6e67},
	{0xa95f, 0xa95f, 0x726a6e67},
	{0xa960, 0xa97c, 0x68616e67},
	{0xa980, 0xa9cd, 0x6a617661},
	{0xa9cf, 0xa9cf, 0x7a797979},
	{0xa9d0, 0xa9d9, 0x6a617661},
	{0xa9de, 0xa9df, 0x6a617661},
	{0xa9e0, 0xa9fe, 0x6d796d72},
	{0xaa00, 0xaa36, 0x6368616d},
	{0xaa40, 0xaa4d, 0x6368616d},
	{0xaa50, 0xaa59, 0x6368616d},
	{0xaa5c, 0xaa5f, 0x6368616d},
	{0xaa60, 0xaa7f, 0x6d796d72},
	{0xaa80, 0xaac2, 0x74617674},
	{0xaadb, 0xaadf, 0x74617674},
	{0xaae0, 0xaaf6, 0x6d746569},
	{0xab01, 0xab06, 0x65746869},
	{0xab09, 0xab0e, 0x65746869},
	{0xab11, 0xab16, 0x65746869},
	{0xab20, 0xab26, 0x65746869},
	{0xab28, 0xab2e, 0x65746869},
	{0xab30, 0xab5a, 0x6c61746e},
	{0xab5b, 0xab5b, 0x7a797979},
	{0xab5c, 0xab64, 0x6c61746e},
	{0xab65, 0xab65, 0x6772656b},
	{0xab66, 0xab69, 0x6c61746e},
	{0xab6a, 0xab6b, 0x7a797979},
	{0xab70, 0xabbf, 0x63686572},
	{0xabc0, 0xabed, 0x6d746569},
	{0xabf0, 0xabf9, 0x6d746569},
	{0xac00, 0xd7a3, 0x68616e67},
	{0xd7b0, 0xd7c6, 0x68616e67},
	{0xd7cb, 0xd7fb, 0x68616e67},
	{0xf900, 0xfa6d, 0x68616e69},
	{0xfa70, 0xfad9, 0x68616e69},
	{0xfb00, 0xfb06, 0x6c61746e},
	{0xfb13, 0xfb17, 0x61726d6e},
	{0xfb1d, 0xfb36, 0x68656272},
	{0xfb38, 0xfb3c, 0x68656272},
	{0xfb3e, 0xfb3e, 0x68656272},
	{0xfb40, 0xfb41, 0x68656272},
	{0xfb43, 0xfb44, 0x68656272},
	{0xfb46, 0xfb4f, 0x68656272},
	{0xfb50, 0xfbc2, 0x61726162},
	{0xfbd3, 0xfd3d, 0x61726162},
	{0xfd3e, 0xfd3f, 0x7a797979},
	{0xfd40, 0xfd8f, 0x61726162},
	{0xfd92, 0xfdc7, 0x61726162},
	{0xfdcf, 0xfdcf, 0x61726162},
	{0xfdf0, 0xfdff, 0x61726162},
	{0xfe00, 0xfe0f, 0x7a696e68},
	{0xfe10, 0xfe19, 0x7a797979},
	{0xfe20, 0xfe2d, 0x7a696e68},
	{0xfe2e, 0xfe2f, 0x6379726c},
	{0xfe30, 0xfe52, 0x7a797979},
	{0xfe54, 0xfe66, 0x7a797979},
	{0xfe68, 0xfe6b, 0x7a797979},
	{0xfe70, 0xfe74, 0x61726162},
	{0xfe76, 0xfefc, 0x61726162},
	{0xfeff, 0xfeff, 0x7a797979},
	{0xff01, 0xff20, 0x7a797979},
	{0xff21, 0xff3a, 0x6c61746e},
	{0xff3b, 0xff40, 0x7a797979},
	{0xff41, 0xff5a, 0x6c61746e},
	{0xff5b, 0xff65, 0x7a797979},
	{0xff66, 0xff6f, 0x6b616e61},
	{0xff70, 0xff70, 0x7a797979},
	{0xff71, 0xff9d, 0x6b616e61},
	{0xff9e, 0xff9f, 0x7a797979},
	{0xffa0, 0xffbe, 0x68616e67},
	{0xffc2, 0xffc7, 0x68616e67},
	{0xffca, 0xffcf, 0x68616e67},
	{0xffd2, 0xffd7, 0x68616e67},
	{0xffda, 0xffdc, 0x68616e67},
	{0xffe0, 0xffe6, 0x7a797979},
	{0xffe8, 0xffee, 0x7a797979},
	{0xfff9, 0xfffd, 0x7a797979},
	{0x10000, 0x1000b, 0x6c696e62},
	{0x1000d, 0x10026, 0x6c696e62},
	{0x10028, 0x1003a, 0x6c696e62},
	{0x1003c, 0x1003d, 0x6c696e62},
	{0x1003f, 0x1004d, 0x6c696e62},
	{0x10050, 0x1005d, 0x6c696e62},
	{0x10080, 0x100fa, 0x6c696e62},
	{0x10100, 0x10102, 0x7a797979},
	{0x10107, 0x10133, 0x7a797979},
	{0x10137, 0x1013f, 0x7a797979},
	{0x10140, 0x1018e, 0x6772656b},
	{0x10190, 0x1019c, 0x7a797979},
	{0x101a0, 0x101a0, 0x6772656b},
	{0x101d0, 0x101fc, 0x7a797979},
	{0x101fd, 0x101fd, 0x7a696e68},
	{0x10280, 0x1029c, 0x6c796369},
	{0x102a0, 0x102d0, 0x63617269},
	{0x102e0, 0x102e0, 0x7a696e68},
	{0x102e1, 0x102fb, 0x7a797979},
	{0x10300, 0x10323, 0x6974616c},
	{0x1032d, 0x1032f, 0x6974616c},
	{0x10330, 0x1034a, 0x676f7468},
	{0x10350, 0x1037a, 0x7065726d},
	{0x10380, 0x1039d, 0x75676172},
	{0x1039f, 0x1039f, 0x75676172},
	{0x103a0, 0x103c3, 0x7870656f},
	{0x103c8, 0x103d5, 0x7870656f},
	{0x10400, 0x1044f, 0x64737274},
	{0x10450, 0x1047f, 0x73686177},
	{0x10480, 0x1049d, 0x6f736d61},
	{0x104a0, 0x104a9, 0x6f736d61},
	{0x104b0, 0x104d3, 0x6f736765},
	{0x104d8, 0x104fb, 0x6f736765},
	{0x10500, 0x10527, 0x656c6261},
	{0x10530, 0x10563, 0x61676862},
	{0x1056f, 0x1056f, 0x61676862},
	{0x10570, 0x1057a, 0x76697468},
	{0x1057c, 0x1058a, 0x76697468},
	{0x1058c, 0x10592, 0x76697468},
	{0x10594, 0x10595, 0x76697468},
	{0x10597, 0x105a1, 0x76697468},
	{0x105a3, 0x105b1, 0x76697468},
	{0x105b3, 0x105b9, 0x76697468},
	{0x105bb, 0x105bc, 0x76697468},
	{0x10600, 0x10736, 0x6c696e61},
	{0x10740, 0x10755, 0x6c696e61},
	{0x10760, 0x10767, 0x6c696e61},
	{0x10780, 0x10785, 0x6c61746e},
	{0x10787, 0x107b0, 0x6c61746e},
	{0x107b2, 0x107ba, 0x6c61746e},
	{0x10800, 0x10805, 0x63707274},
	{0x10808, 0x10808, 0x63707274},
	{0x1080a, 0x10835, 0x63707274},
	{0x10837, 0x10838, 0x63707274},
	{0x1083c, 0x1083c, 0x63707274},
	{0x1083f, 0x1083f, 0x63707274},
	{0x10840, 0x10855, 0x61726d69},
	{0x10857, 0x1085f, 0x61726d69},
	{0x10860, 0x1087f, 0x70616c6d},
	{0x10880, 0x1089e, 0x6e626174},
	{0x108a7, 0x108af, 0x6e626174},
	{0x108e0, 0x108f2, 0x68617472},
	{0x108f4, 0x108f5, 0x68617472},
	{0x108fb, 0x108ff, 0x68617472},
	{0x10900, 0x1091b, 0x70686e78},
	{0x1091f, 0x1091f, 0x70686e78},
	{0x10920, 0x10939, 0x6c796469},
	{0x1093f, 0x1093f, 0x6c796469},
	{0x10980, 0x1099f, 0x6d65726f},
	{0x109a0, 0x109b7, 0x6d657263},
	{0x109bc, 0x109cf, 0x6d657263},
	{0x109d2, 0x109ff, 0x6d657263},
	{0x10a00, 0x10a03, 0x6b686172},
	{0x10a05, 0x10a06, 0x6b686172},
	{0x10a0c, 0x10a13, 0x6b686172},
	{0x10a15, 0x10a17, 0x6b686172},
	{0x10a19, 0x10a35, 0x6b686172},
	{0x10a38, 0x10a3a, 0x6b686172},
	{0x10a3f, 0x10a48, 0x6b686172},
	{0x10a50, 0x10a58, 0x6b686172},
	{0x10a60, 0x10a7f, 0x73617262},
	{0x10a80, 0x10a9f, 0x6e617262},
	{0x10ac0, 0x10ae6, 0x6d616e69},
	{0x10aeb, 0x10af6, 0x6d616e69},
	{0x10b00, 0x10b35, 0x61767374},
	{0x10b39, 0x10b3f, 0x61767374},
	{0x10b40, 0x10b55, 0x70727469},
	{0x10b58, 0x10b5f, 0x70727469},
	{0x10b60, 0x10b72, 0x70686c69},
	{0x10b78, 0x10b7f, 0x70686c69},
	{0x10b80, 0x10b91, 0x70686c70},
	{0x10b99, 0x10b9c, 0x70686c70},
	{0x10ba9, 0x10baf, 0x70686c70},
	{0x10c00, 0x10c48, 0x6f726b68},
	{0x10c80, 0x10cb2, 0x68756e67},
	{0x10cc0, 0x10cf2, 0x68756e67},
	{0x10cfa, 0x10cff, 0x68756e67},
	{0x10d00, 0x10d27, 0x726f6867},
	{0x10d30, 0x10d39, 0x726f6867},
	{0x10e60, 0x10e7e, 0x61726162},
	{0x10e80, 0x10ea9, 0x79657a69},
	{0x10eab, 0x10ead, 0x79657a69},
	{0x10eb0, 0x10eb1, 0x79657a69},
	{0x10efd, 0x10eff, 0x61726162},
	{0x10f00, 0x10f27, 0x736f676f},
	{0x10f30, 0x10f59, 0x736f6764},
	{0x10f70, 0x10f89, 0x6f756772},
	{0x10fb0, 0x10fcb, 0x63687273},
	{0x10fe0, 0x10ff6, 0x656c796d},
	{0x11000, 0x1104d, 0x62726168},
	{0x11052, 0x11075, 0x62726168},
	{0x1107f, 0x1107f, 0x62726168},
	{0x11080, 0x110c2, 0x6b746869},
	{0x110cd, 0x110cd, 0x6b746869},
	{0x110d0, 0x110e8, 0x736f7261},
	{0x110f0, 0x110f9, 0x736f7261},
	{0x11100, 0x11134, 0x63616b6d},
	{0x11136, 0x11147, 0x63616b6d},
	{0x11150, 0x11176, 0x6d61686a},
	{0x11180, 0x111df, 0x73687264},
	{0x111e1, 0x111f4, 0x73696e68},
	{0x11200, 0x11211, 0x6b686f6a},
	{0x11213, 0x11241, 0x6b686f6a},
	{0x11280, 0x11286, 0x6d756c74},
	{0x11288, 0x11288, 0x6d756c74},
	{0x1128a, 0x1128d, 0x6d756c74},
	{0x1128f, 0x1129d, 0x6d756c74},
	{0x1129f, 0x112a9, 0x6d756c74},
	{0x112b0, 0x112ea, 0x73696e64},
	{0x112f0, 0x112f9, 0x73696e64},
	{0x11300, 0x11303, 0x6772616e},
	{0x11305, 0x1130c, 0x6772616e},
	{0x1130f, 0x11310, 0x6772616e},
	{0x11313, 0x11328, 0x6772616e},
	{0x1132a, 0x11330, 0x6772616e},
	{0x11332, 0x11333, 0x6772616e},
	{0x11335, 0x11339, 0x6772616e},
	{0x1133b, 0x1133b, 0x7a696e68},
	{0x1133c, 0x11344, 0x6772616e},
	{0x11347, 0x11348, 0x6772616e},
	{0x1134b, 0x1134d, 0x6772616e},
	{0x11350, 0x11350, 0x6772616e},
	{0x11357, 0x11357, 0x6772616e},
	{0x1135d, 0x11363, 0x6772616e},
	{0x11366, 0x1136c, 0x6772616e},
	{0x11370, 0x11374, 0x6772616e},
	{0x11400, 0x1145b, 0x6e657761},
	{0x1145d, 0x11461, 0x6e657761},
	{0x11480, 0x114c7, 0x74697268},
	{0x114d0, 0x114d9, 0x74697268},
	{0x11580, 0x115b5, 0x73696464},
	{0x115b8, 0x115dd, 0x73696464},
	{0x11600, 0x11644, 0x6d6f6469},
	{0x11650, 0x11659, 0x6d6f6469},
	{0x11660, 0x1166c, 0x6d6f6e67},
	{0x11680, 0x116b9, 0x74616b72},
	{0x116c0, 0x116c9, 0x74616b72},
	{0x11700, 0x1171a, 0x61686f6d},
	{0x1171d, 0x1172b, 0x61686f6d},
	{0x11730, 0x11746, 0x61686f6d},
	{0x11800, 0x1183b, 0x646f6772},
	{0x118a0, 0x118f2, 0x77617261},
	{0x118ff, 0x118ff, 0x77617261},
	{0x11900, 0x11906, 0x6469616b},
	{0x11909, 0x11909, 0x6469616b},
	{0x1190c, 0x11913, 0x6469616b},
	{0x11915, 0x11916, 0x6469616b},
	{0x11918, 0x11935, 0x6469616b},
	{0x11937, 0x11938, 0x6469616b},
	{0x1193b, 0x11946, 0x6469616b},
	{0x11950, 0x11959, 0x6469616b},
	{0x119a0, 0x119a7, 0x6e616e64},
	{0x119aa, 0x119d7, 0x6e616e64},
	{0x119da, 0x119e4, 0x6e616e64},
	{0x11a00, 0x11a47, 0x7a616e62},
	{0x11a50, 0x11aa2, 0x736f796f},
	{0x11ab0, 0x11abf, 0x63616e73},
	{0x11ac0, 0x11af8, 0x70617563},
	{0x11b00, 0x11b09, 0x64657661},
	{0x11c00, 0x11c08, 0x62686b73},
	{0x11c0a, 0x11c36, 0x62686b73},
	{0x11c38, 0x11c45, 0x62686b73},
	{0x11c50, 0x11c6c, 0x62686b73},
	{0x11c70, 0x11c8f, 0x6d617263},
	{0x11c92, 0x11ca7, 0x6d617263},
	{0x11ca9, 0x11cb6, 0x6d617263},
	{0x11d00, 0x11d06, 0x676f6e6d},
	{0x11d08, 0x11d09, 0x676f6e6d},
	{0x11d0b, 0x11d36, 0x676f6e6d},
	{0x11d3a, 0x11d3a, 0x676f6e6d},
	{0x11d3c, 0x11d3d, 0x676f6e6d},
	{0x11d3f, 0x11d47, 0x676f6e6d},
	{0x11d50, 0x11d59, 0x676f6e6d},
	{0x11d60, 0x11d65, 0x676f6e67},
	{0x11d67, 0x11d68, 0x676f6e67},
	{0x11d6a, 0x11d8e, 0x676f6e67},
	{0x11d90, 0x11d91, 0x676f6e67},
	{0x11d93, 0x11d98, 0x676f6e67},
	{0x11da0, 0x11da9, 0x676f6e67},
	{0x11ee0, 0x11ef8, 0x6d616b61},
	{0x11f00, 0x11f10, 0x6b617769},
	{0x11f12, 0x11f3a, 0x6b617769},
	{0x11f3e, 0x11f59, 0x6b617769},
	{0x11fb0, 0x11fb0, 0x6c697375},
	{0x11fc0, 0x11ff1, 0x74616d6c},
	{0x11fff, 0x11fff, 0x74616d6c},
	{0x12000, 0x12399, 0x78737578},
	{0x12400, 0x1246e, 0x78737578},
	{0x12470, 0x12474, 0x78737578},
	{0x12480, 0x12543, 0x78737578},
	{0x12f90, 0x12ff2, 0x63706d6e},
	{0x13000, 0x13455, 0x65677970},
	{0x14400, 0x14646, 0x686c7577},
	{0x16800, 0x16a38, 0x62616d75},
	{0x16a40, 0x16a5e, 0x6d726f6f},
	{0x16a60, 0x16a69, 0x6d726f6f},
	{0x16a6e, 0x16a6f, 0x6d726f6f},
	{0x16a70, 0x16abe, 0x746e7361},
	{0x16ac0, 0x16ac9, 0x746e7361},
	{0x16ad0, 0x16aed, 0x62617373},
	{0x16af0, 0x16af5, 0x62617373},
	{0x16b00, 0x16b45, 0x686d6e67},
	{0x16b50, 0x16b59, 0x686d6e67},
	{0x16b5b, 0x16b61, 0x686d6e67},
	{0x16b63, 0x16b77, 0x686d6e67},
	{0x16b7d, 0x16b8f, 0x686d6e67},
	{0x16e40, 0x16e9a, 0x6d656466},
	{0x16f00, 0x16f4a, 0x706c7264},
	{0x16f4f, 0x16f87, 0x706c7264},
	{0x16f8f, 0x16f9f, 0x706c7264},
	{0x16fe0, 0x16fe0, 0x74616e67},
	{0x16fe1, 0x16fe1, 0x6e736875},
	{0x16fe2, 0x16fe3, 0x68616e69},
	{0x16fe4, 0x16fe4, 0x6b697473},
	{0x16ff0, 0x16ff1, 0x68616e69},
	{0x17000, 0x187f7, 0x74616e67},
	{0x18800, 0x18aff, 0x74616e67},
	{0x18b00, 0x18cd5, 0x6b697473},
	{0x18d00, 0x18d08, 0x74616e67},
	{0x1aff0, 0x1aff3, 0x6b616e61},
	{0x1aff5, 0x1affb, 0x6b616e61},
	{0x1affd, 0x1affe, 0x6b616e61},
	{0x1b000, 0x1b000, 0x6b616e61},
	{0x1b001, 0x1b11f, 0x68697261},
	{0x1b120, 0x1b122, 0x6b616e61},
	{0x1b132, 0x1b132, 0x68697261},
	{0x1b150, 0x1b152, 0x68697261},
	{0x1b155, 0x1b155, 0x6b616e61},
	{0x1b164, 0x1b167, 0x6b616e61},
	{0x1b170, 0x1b2fb, 0x6e736875},
	{0x1bc00, 0x1bc6a, 0x6475706c},
	{0x1bc70, 0x1bc7c, 0x6475706c},
	{0x1bc80, 0x1bc88, 0x6475706c},
	{0x1bc90, 0x1bc99, 0x6475706c},
	{0x1bc9c, 0x1bc9f, 0x6475706c},
	{0x1bca0, 0x1bca3, 0x7a797979},
	{0x1cf00, 0x1cf2d, 0x7a696e68},
	{0x1cf30, 0x1cf46, 0x7a696e68},
	{0x1cf50, 0x1cfc3, 0x7a797979},
	{0x1d000, 0x1d0f5, 0x7a797979},
	{0x1d100, 0x1d126, 0x7a797979},
	{0x1d129, 0x1d166, 0x7a797979},
	{0x1d167, 0x1d169, 0x7a696e68},
	{0x1d16a, 0x1d17a, 0x7a797979},
	{0x1d17b, 0x1d182, 0x7a696e68},
	{0x1d183, 0x1d184, 0x7a797979},
	{0x1d185, 0x1d18b, 0x7a696e68},
	{0x1d18c, 0x1d1a9, 0x7a797979},
	{0x1d1aa, 0x1d1ad, 0x7a696e68},
	{0x1d1ae, 0x1d1ea, 0x7a797979},
	{0x1d200, 0x1d245, 0x6772656b},
	{0x1d2c0, 0x1d2d3, 0x7a797979},
	{0x1d2e0, 0x1d2f3, 0x7a797979},
	{0x1d300, 0x1d356, 0x7a797979},
	{0x1d360, 0x1d378, 0x7a797979},
	{0x1d400, 0x1d454, 0x7a797979},
	{0x1d456, 0x1d49c, 0x7a797979},
	{0x1d49e, 0x1d49f, 0x7a797979},
	{0x1d4a2, 0x1d4a2, 0x7a797979},
	{0x1d4a5, 0x1d4a6, 0x7a797979},
	{0x1d4a9, 0x1d4ac, 0x7a797979},
	{0x1d4ae, 0x1d4b9, 0x7a797979},
	{0x1d4bb, 0x1d4bb, 0x7a797979},
	{0x1d4bd, 0x1d4c3, 0x7a797979},
	{0x1d4c5, 0x1d505, 0x7a797979},
	{0x1d507, 0x1d50a, 0x7a797979},
	{0x1d50d, 0x1d514, 0x7a797979},
	{0x1d516, 0x1d51c, 0x7a797979},
	{0x1d51e, 0x1d539, 0x7a797979},
	{0x1d53b, 0x1d53e, 0x7a797979},
	{0x1d540, 0x1d544, 0x7a797979},
	{0x1d546, 0x1d546, 0x7a797979},
	{0x1d54a, 0x1d550, 0x7a797979},
	{0x1d552, 0x1d6a5, 0x7a797979},
	{0x1d6a8, 0x1d7cb, 0x7a797979},
	{0x1d7ce, 0x1d7ff, 0x7a797979},
	{0x1d800, 0x1da8b, 0x73676e77},
	{0x1da9b, 0x1da9f, 0x73676e77},
	{0x1daa1, 0x1daaf, 0x73676e77},
	{0x1df00, 0x1df1e, 0x6c61746e},
	{0x1df25, 0x1df2a, 0x6c61746e},
	{0x1e000, 0x1e006, 0x676c6167},
	{0x1e008, 0x1e018, 0x676c6167},
	{0x1e01b, 0x1e021, 0x676c6167},
	{0x1e023, 0x1e024, 0x676c6167},
	{0x1e026, 0x1e02a, 0x676c6167},
	{0x1e030, 0x1e06d, 0x6379726c},
	{0x1e08f, 0x1e08f, 0x6379726c},
	{0x1e100, 0x1e12c, 0x686d6e70},
	{0x1e130, 0x1e13d, 0x686d6e70},
	{0x1e140, 0x1e149, 0x686d6e70},
	{0x1e14e, 0x1e14f, 0x686d6e70},
	{0x1e290, 0x1e2ae, 0x746f746f},
	{0x1e2c0, 0x1e2f9, 0x7763686f},
	{0x1e2ff, 0x1e2ff, 0x7763686f},
	{0x1e4d0, 0x1e4f9, 0x6e61676d},
	{0x1e7e0, 0x1e7e6, 0x65746869},
	{0x1e7e8, 0x1e7eb, 0x65746869},
	{0x1e7ed, 0x1e7ee, 0x65746869},
	{0x1e7f0, 0x1e7fe, 0x65746869},
	{0x1e800, 0x1e8c4, 0x6d656e64},
	{0x1e8c7, 0x1e8d6, 0x6d656e64},
	{0x1e900, 0x1e94b, 0x61646c6d},
	{0x1e950, 0x1e959, 0x61646c6d},
	{0x1e95e, 0x1e95f, 0x61646c6d},
	{0x1ec71, 0x1ecb4, 0x7a797979},
	{0x1ed01, 0x1ed3d, 0x7a797979},
	{0x1ee00, 0x1ee03, 0x61726162},
	{0x1ee05, 0x1ee1f, 0x61726162},
	{0x1ee21, 0x1ee22, 0x61726162},
	{0x1ee24, 0x1ee24, 0x61726162},
	{0x1ee27, 0x1ee27, 0x61726162},
	{0x1ee29, 0x1ee32, 0x61726162},
	{0x1ee34, 0x1ee37, 0x61726162},
	{0x1ee39, 0x1ee39, 0x61726162},
	{0x1ee3b, 0x1ee3b, 0x61726162},
	{0x1ee42, 0x1ee42, 0x61726162},
	{0x1ee47, 0x1ee47, 0x61726162},
	{0x1ee49, 0x1ee49, 0x61726162},
	{0x1ee4b, 0x1ee4b, 0x61726162},
	{0x1ee4d, 0x1ee4f, 0x61726162},
	{0x1ee51, 0x1ee52, 0x61726162},
	{0x1ee54, 0x1ee54, 0x61726162},
	{0x1ee57, 0x1ee57, 0x61726162},
	{0x1ee59, 0x1ee59, 0x61726162},
	{0x1ee5b, 0x1ee5b, 0x61726162},
	{0x1ee5d, 0x1ee5d, 0x61726162},
	{0x1ee5f, 0x1ee5f, 0x61726162},
	{0x1ee61, 0x1ee62, 0x61726162},
	{0x1ee64, 0x1ee64, 0x61726162},
	{0x1ee67, 0x1ee6a, 0x61726162},
	{0x1ee6c, 0x1ee72, 0x61726162},
	{0x1ee74, 0x1ee77, 0x61726162},
	{0x1ee79, 0x1ee7c, 0x61726162},
	{0x1ee7e, 0x1ee7e, 0x61726162},
	{0x1ee80, 0x1ee89, 0x61726162},
	{0x1ee8b, 0x1ee9b, 0x61726162},
	{0x1eea1, 0x1eea3, 0x61726162},
	{0x1eea5, 0x1eea9, 0x61726162},
	{0x1eeab, 0x1eebb, 0x61726162},
	{0x1eef0, 0x1eef1, 0x61726162},
	{0x1f000, 0x1f02b, 0x7a797979},
	{0x1f030, 0x1f093, 0x7a797979},
	{0x1f0a0, 0x1f0ae, 0x7a797979},
	{0x1f0b1, 0x1f0bf, 0x7a797979},
	{0x1f0c1, 0x1f0cf, 0x7a797979},
	{0x1f0d1, 0x1f0f5, 0x7a797979},
	{0x1f100, 0x1f1ad, 0x7a797979},
	{0x1f1e6, 0x1f1ff, 0x7a797979},
	{0x1f200, 0x1f200, 0x68697261},
	{0x1f201, 0x1f202, 0x7a797979},
	{0x1f210, 0x1f23b, 0x7a797979},
	{0x1f240, 0x1f248, 0x7a797979},
	{0x1f250, 0x1f251, 0x7a797979},
	{0x1f260, 0x1f265, 0x7a797979},
	{0x1f300, 0x1f6d7, 0x7a797979},
	{0x1f6dc, 0x1f6ec, 0x7a797979},
	{0x1f6f0, 0x1f6fc, 0x7a797979},
	{0x1f700, 0x1f776, 0x7a797979},
	{0x1f77b, 0x1f7d9, 0x7a797979},
	{0x1f7e0, 0x1f7eb, 0x7a797979},
	{0x1f7f0, 0x1f7f0, 0x7a797979},
	{0x1f800, 0x1f80b, 0x7a797979},
	{0x1f810, 0x1f847, 0x7a797979},
	{0x1f850, 0x1f859, 0x7a797979},
	{0x1f860, 0x1f887, 0x7a797979},
	{0x1f890, 0x1f8ad, 0x7a797979},
	{0x1f8b0, 0x1f8b1, 0x7a797979},
	{0x1f900, 0x1fa53, 0x7a797979},
	{0x1fa60, 0x1fa6d, 0x7a797979},
	{0x1fa70, 0x1fa7c, 0x7a797979},
	{0x1fa80, 0x1fa88, 0x7a797979},
	{0x1fa90, 0x1fabd, 0x7a797979},
	{0x1fabf, 0x1fac5, 0x7a797979},
	{0x1face, 0x1fadb, 0x7a797979},
	{0x1fae0, 0x1fae8, 0x7a797979},
	{0x1faf0, 0x1faf8, 0x7a797979},
	{0x1fb00, 0x1fb92, 0x7a797979},
	{0x1fb94, 0x1fbca, 0x7a797979},
	{0x1fbf0, 0x1fbf9, 0x7a797979},
	{0x20000, 0x2a6df, 0x68616e69},
	{0x2a700, 0x2b739, 0x68616e69},
	{0x2b740, 0x2b81d, 0x68616e69},
	{0x2b820, 0x2cea1, 0x68616e69},
	{0x2ceb0, 0x2ebe0, 0x68616e69},
	{0x2f800, 0x2fa1d, 0x68616e69},
	{0x30000, 0x3134a, 0x68616e69},
	{0x31350, 0x323af, 0x68616e69},
	{0xe0001, 0xe0001, 0x7a797979},
	{0xe0020, 0xe007f, 0x7a797979},
	{0xe0100, 0xe01ef, 0x7a696e68},
}
