// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/aiplatform/v1beta1/feature_monitor.proto

package aiplatformpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	interval "google.golang.org/genproto/googleapis/type/interval"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	structpb "google.golang.org/protobuf/types/known/structpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Vertex AI Feature Monitor.
type FeatureMonitor struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. Name of the FeatureMonitor. Format:
	// `projects/{project}/locations/{location}/featureGroups/{featureGroup}/featureMonitors/{featureMonitor}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Timestamp when this FeatureMonitor was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Timestamp when this FeatureMonitor was last updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. Used to perform consistent read-modify-write updates. If not set,
	// a blind "overwrite" update happens.
	Etag string `protobuf:"bytes,4,opt,name=etag,proto3" json:"etag,omitempty"`
	// Optional. The labels with user-defined metadata to organize your
	// FeatureMonitor.
	//
	// Label keys and values can be no longer than 64 characters
	// (Unicode codepoints), can only contain lowercase letters, numeric
	// characters, underscores and dashes. International characters are allowed.
	//
	// See https://goo.gl/xmQnxf for more information on and examples of labels.
	// No more than 64 user labels can be associated with one
	// FeatureMonitor(System labels are excluded)." System reserved label keys
	// are prefixed with "aiplatform.googleapis.com/" and are immutable.
	Labels map[string]string `protobuf:"bytes,5,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. Description of the FeatureMonitor.
	Description string `protobuf:"bytes,6,opt,name=description,proto3" json:"description,omitempty"`
	// Required. Schedule config for the FeatureMonitor.
	ScheduleConfig *ScheduleConfig `protobuf:"bytes,7,opt,name=schedule_config,json=scheduleConfig,proto3" json:"schedule_config,omitempty"`
	// Required. Feature selection config for the FeatureMonitor.
	FeatureSelectionConfig *FeatureSelectionConfig `protobuf:"bytes,8,opt,name=feature_selection_config,json=featureSelectionConfig,proto3" json:"feature_selection_config,omitempty"`
}

func (x *FeatureMonitor) Reset() {
	*x = FeatureMonitor{}
	mi := &file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FeatureMonitor) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeatureMonitor) ProtoMessage() {}

func (x *FeatureMonitor) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeatureMonitor.ProtoReflect.Descriptor instead.
func (*FeatureMonitor) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_rawDescGZIP(), []int{0}
}

func (x *FeatureMonitor) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *FeatureMonitor) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *FeatureMonitor) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *FeatureMonitor) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

func (x *FeatureMonitor) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *FeatureMonitor) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *FeatureMonitor) GetScheduleConfig() *ScheduleConfig {
	if x != nil {
		return x.ScheduleConfig
	}
	return nil
}

func (x *FeatureMonitor) GetFeatureSelectionConfig() *FeatureSelectionConfig {
	if x != nil {
		return x.FeatureSelectionConfig
	}
	return nil
}

// Schedule configuration for the FeatureMonitor.
type ScheduleConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Cron schedule (https://en.wikipedia.org/wiki/Cron) to launch scheduled
	// runs. To explicitly set a timezone to the cron tab, apply a prefix in
	// the cron tab: "CRON_TZ=${IANA_TIME_ZONE}" or "TZ=${IANA_TIME_ZONE}".
	// The ${IANA_TIME_ZONE} may only be a valid string from IANA time zone
	// database. For example, "CRON_TZ=America/New_York 1 * * * *", or
	// "TZ=America/New_York 1 * * * *".
	Cron string `protobuf:"bytes,1,opt,name=cron,proto3" json:"cron,omitempty"`
}

func (x *ScheduleConfig) Reset() {
	*x = ScheduleConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ScheduleConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ScheduleConfig) ProtoMessage() {}

func (x *ScheduleConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ScheduleConfig.ProtoReflect.Descriptor instead.
func (*ScheduleConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_rawDescGZIP(), []int{1}
}

func (x *ScheduleConfig) GetCron() string {
	if x != nil {
		return x.Cron
	}
	return ""
}

// Feature selection configuration for the FeatureMonitor.
type FeatureSelectionConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. A list of features to be monitored and each feature's drift
	// threshold.
	FeatureConfigs []*FeatureSelectionConfig_FeatureConfig `protobuf:"bytes,1,rep,name=feature_configs,json=featureConfigs,proto3" json:"feature_configs,omitempty"`
}

func (x *FeatureSelectionConfig) Reset() {
	*x = FeatureSelectionConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FeatureSelectionConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeatureSelectionConfig) ProtoMessage() {}

func (x *FeatureSelectionConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeatureSelectionConfig.ProtoReflect.Descriptor instead.
func (*FeatureSelectionConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_rawDescGZIP(), []int{2}
}

func (x *FeatureSelectionConfig) GetFeatureConfigs() []*FeatureSelectionConfig_FeatureConfig {
	if x != nil {
		return x.FeatureConfigs
	}
	return nil
}

// Stats and Anomaly generated by FeatureMonitorJobs. Anomaly only includes
// Drift.
type FeatureStatsAndAnomaly struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Feature Id.
	FeatureId string `protobuf:"bytes,1,opt,name=feature_id,json=featureId,proto3" json:"feature_id,omitempty"`
	// Feature stats. e.g. histogram buckets.
	// In the format of tensorflow.metadata.v0.DatasetFeatureStatistics.
	FeatureStats *structpb.Value `protobuf:"bytes,2,opt,name=feature_stats,json=featureStats,proto3" json:"feature_stats,omitempty"`
	// Deviation from the current stats to baseline stats.
	//  1. For categorical feature, the distribution distance is calculated by
	//     L-inifinity norm.
	//  2. For numerical feature, the distribution distance is calculated by
	//     Jensen–Shannon divergence.
	DistributionDeviation float64 `protobuf:"fixed64,3,opt,name=distribution_deviation,json=distributionDeviation,proto3" json:"distribution_deviation,omitempty"`
	// This is the threshold used when detecting drifts, which is set in
	// FeatureMonitor.FeatureSelectionConfig.FeatureConfig.drift_threshold
	DriftDetectionThreshold float64 `protobuf:"fixed64,4,opt,name=drift_detection_threshold,json=driftDetectionThreshold,proto3" json:"drift_detection_threshold,omitempty"`
	// If set to true, indicates current stats is detected as and comparing
	// with baseline stats.
	DriftDetected bool `protobuf:"varint,5,opt,name=drift_detected,json=driftDetected,proto3" json:"drift_detected,omitempty"`
	// The timestamp we take snapshot for feature values to generate stats.
	StatsTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=stats_time,json=statsTime,proto3" json:"stats_time,omitempty"`
	// The ID of the FeatureMonitorJob that generated this FeatureStatsAndAnomaly.
	FeatureMonitorJobId int64 `protobuf:"varint,7,opt,name=feature_monitor_job_id,json=featureMonitorJobId,proto3" json:"feature_monitor_job_id,omitempty"`
	// The ID of the FeatureMonitor that this FeatureStatsAndAnomaly generated
	// according to.
	FeatureMonitorId string `protobuf:"bytes,8,opt,name=feature_monitor_id,json=featureMonitorId,proto3" json:"feature_monitor_id,omitempty"`
}

func (x *FeatureStatsAndAnomaly) Reset() {
	*x = FeatureStatsAndAnomaly{}
	mi := &file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FeatureStatsAndAnomaly) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeatureStatsAndAnomaly) ProtoMessage() {}

func (x *FeatureStatsAndAnomaly) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeatureStatsAndAnomaly.ProtoReflect.Descriptor instead.
func (*FeatureStatsAndAnomaly) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_rawDescGZIP(), []int{3}
}

func (x *FeatureStatsAndAnomaly) GetFeatureId() string {
	if x != nil {
		return x.FeatureId
	}
	return ""
}

func (x *FeatureStatsAndAnomaly) GetFeatureStats() *structpb.Value {
	if x != nil {
		return x.FeatureStats
	}
	return nil
}

func (x *FeatureStatsAndAnomaly) GetDistributionDeviation() float64 {
	if x != nil {
		return x.DistributionDeviation
	}
	return 0
}

func (x *FeatureStatsAndAnomaly) GetDriftDetectionThreshold() float64 {
	if x != nil {
		return x.DriftDetectionThreshold
	}
	return 0
}

func (x *FeatureStatsAndAnomaly) GetDriftDetected() bool {
	if x != nil {
		return x.DriftDetected
	}
	return false
}

func (x *FeatureStatsAndAnomaly) GetStatsTime() *timestamppb.Timestamp {
	if x != nil {
		return x.StatsTime
	}
	return nil
}

func (x *FeatureStatsAndAnomaly) GetFeatureMonitorJobId() int64 {
	if x != nil {
		return x.FeatureMonitorJobId
	}
	return 0
}

func (x *FeatureStatsAndAnomaly) GetFeatureMonitorId() string {
	if x != nil {
		return x.FeatureMonitorId
	}
	return ""
}

// Defines how to select FeatureStatsAndAnomaly to be populated in response.
// If set, retrieves FeatureStatsAndAnomaly generated by FeatureMonitors based
// on this spec.
type FeatureStatsAndAnomalySpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. If set, returns the most recent count of stats. Valid value is
	// [0, 100]. If stats_time_range is set, return most recent count of stats
	// within the stats_time_range.
	LatestStatsCount *int32 `protobuf:"varint,1,opt,name=latest_stats_count,json=latestStatsCount,proto3,oneof" json:"latest_stats_count,omitempty"`
	// Optional. If set, return all stats generated between [start_time,
	// end_time). If latest_stats_count is set, return the most recent count of
	// stats within the stats_time_range.
	StatsTimeRange *interval.Interval `protobuf:"bytes,2,opt,name=stats_time_range,json=statsTimeRange,proto3" json:"stats_time_range,omitempty"`
}

func (x *FeatureStatsAndAnomalySpec) Reset() {
	*x = FeatureStatsAndAnomalySpec{}
	mi := &file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FeatureStatsAndAnomalySpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeatureStatsAndAnomalySpec) ProtoMessage() {}

func (x *FeatureStatsAndAnomalySpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeatureStatsAndAnomalySpec.ProtoReflect.Descriptor instead.
func (*FeatureStatsAndAnomalySpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_rawDescGZIP(), []int{4}
}

func (x *FeatureStatsAndAnomalySpec) GetLatestStatsCount() int32 {
	if x != nil && x.LatestStatsCount != nil {
		return *x.LatestStatsCount
	}
	return 0
}

func (x *FeatureStatsAndAnomalySpec) GetStatsTimeRange() *interval.Interval {
	if x != nil {
		return x.StatsTimeRange
	}
	return nil
}

// Feature configuration.
type FeatureSelectionConfig_FeatureConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the feature resource. Final component of the
	// Feature's resource name.
	FeatureId string `protobuf:"bytes,1,opt,name=feature_id,json=featureId,proto3" json:"feature_id,omitempty"`
	// Optional. Drift threshold. If calculated difference with baseline data
	// larger than threshold, it will be considered as the feature has drift. If
	// not present, the threshold will be default to 0.3.
	DriftThreshold float64 `protobuf:"fixed64,2,opt,name=drift_threshold,json=driftThreshold,proto3" json:"drift_threshold,omitempty"`
}

func (x *FeatureSelectionConfig_FeatureConfig) Reset() {
	*x = FeatureSelectionConfig_FeatureConfig{}
	mi := &file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *FeatureSelectionConfig_FeatureConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FeatureSelectionConfig_FeatureConfig) ProtoMessage() {}

func (x *FeatureSelectionConfig_FeatureConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FeatureSelectionConfig_FeatureConfig.ProtoReflect.Descriptor instead.
func (*FeatureSelectionConfig_FeatureConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_rawDescGZIP(), []int{2, 0}
}

func (x *FeatureSelectionConfig_FeatureConfig) GetFeatureId() string {
	if x != nil {
		return x.FeatureId
	}
	return ""
}

func (x *FeatureSelectionConfig_FeatureConfig) GetDriftThreshold() float64 {
	if x != nil {
		return x.DriftThreshold
	}
	return 0
}

var File_google_cloud_aiplatform_v1beta1_feature_monitor_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_rawDesc = []byte{
	0x0a, 0x35, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x1a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65,
	0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0x94, 0x06, 0x0a, 0x0e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4d, 0x6f, 0x6e, 0x69, 0x74,
	0x6f, 0x72, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a,
	0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12,
	0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x12, 0x58, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x12, 0x25, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65,
	0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x5d, 0x0a, 0x0f, 0x73, 0x63, 0x68,
	0x65, 0x64, 0x75, 0x6c, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0e, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75,
	0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x76, 0x0a, 0x18, 0x66, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x5f, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x16, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x3a, 0xb8, 0x01, 0xea, 0x41,
	0xb4, 0x01, 0x0a, 0x28, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x12, 0x67, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x47, 0x72, 0x6f,
	0x75, 0x70, 0x73, 0x2f, 0x7b, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x67, 0x72, 0x6f,
	0x75, 0x70, 0x7d, 0x2f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4d, 0x6f, 0x6e, 0x69, 0x74,
	0x6f, 0x72, 0x73, 0x2f, 0x7b, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x6d, 0x6f, 0x6e,
	0x69, 0x74, 0x6f, 0x72, 0x7d, 0x2a, 0x0f, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4d, 0x6f,
	0x6e, 0x69, 0x74, 0x6f, 0x72, 0x73, 0x32, 0x0e, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x4d,
	0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x22, 0x24, 0x0a, 0x0e, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75,
	0x6c, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x12, 0x0a, 0x04, 0x63, 0x72, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x63, 0x72, 0x6f, 0x6e, 0x22, 0xf0, 0x01, 0x0a,
	0x16, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x73, 0x0a, 0x0f, 0x66, 0x65, 0x61, 0x74, 0x75,
	0x72, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x66, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x1a, 0x61, 0x0a, 0x0d,
	0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x22, 0x0a,
	0x0a, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x49,
	0x64, 0x12, 0x2c, 0x0a, 0x0f, 0x64, 0x72, 0x69, 0x66, 0x74, 0x5f, 0x74, 0x68, 0x72, 0x65, 0x73,
	0x68, 0x6f, 0x6c, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x0e, 0x64, 0x72, 0x69, 0x66, 0x74, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x22,
	0xac, 0x03, 0x0a, 0x16, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73,
	0x41, 0x6e, 0x64, 0x41, 0x6e, 0x6f, 0x6d, 0x61, 0x6c, 0x79, 0x12, 0x1d, 0x0a, 0x0a, 0x66, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09,
	0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x49, 0x64, 0x12, 0x3b, 0x0a, 0x0d, 0x66, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x0c, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x12, 0x35, 0x0a, 0x16, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69,
	0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x76, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x15, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75,
	0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x76, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3a, 0x0a,
	0x19, 0x64, 0x72, 0x69, 0x66, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x01,
	0x52, 0x17, 0x64, 0x72, 0x69, 0x66, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x64, 0x72, 0x69,
	0x66, 0x74, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x0d, 0x64, 0x72, 0x69, 0x66, 0x74, 0x44, 0x65, 0x74, 0x65, 0x63, 0x74, 0x65, 0x64,
	0x12, 0x39, 0x0a, 0x0a, 0x73, 0x74, 0x61, 0x74, 0x73, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x06,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70,
	0x52, 0x09, 0x73, 0x74, 0x61, 0x74, 0x73, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x33, 0x0a, 0x16, 0x66,
	0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x5f, 0x6a,
	0x6f, 0x62, 0x5f, 0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x13, 0x66, 0x65, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x4a, 0x6f, 0x62, 0x49, 0x64,
	0x12, 0x2c, 0x0a, 0x12, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f, 0x6d, 0x6f, 0x6e, 0x69,
	0x74, 0x6f, 0x72, 0x5f, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x66, 0x65,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x49, 0x64, 0x22, 0xb1,
	0x01, 0x0a, 0x1a, 0x46, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x53, 0x74, 0x61, 0x74, 0x73, 0x41,
	0x6e, 0x64, 0x41, 0x6e, 0x6f, 0x6d, 0x61, 0x6c, 0x79, 0x53, 0x70, 0x65, 0x63, 0x12, 0x36, 0x0a,
	0x12, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x5f, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00,
	0x52, 0x10, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x53, 0x74, 0x61, 0x74, 0x73, 0x43, 0x6f, 0x75,
	0x6e, 0x74, 0x88, 0x01, 0x01, 0x12, 0x44, 0x0a, 0x10, 0x73, 0x74, 0x61, 0x74, 0x73, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x5f, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x15, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x2e, 0x49, 0x6e,
	0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0e, 0x73, 0x74, 0x61,
	0x74, 0x73, 0x54, 0x69, 0x6d, 0x65, 0x52, 0x61, 0x6e, 0x67, 0x65, 0x42, 0x15, 0x0a, 0x13, 0x5f,
	0x6c, 0x61, 0x74, 0x65, 0x73, 0x74, 0x5f, 0x73, 0x74, 0x61, 0x74, 0x73, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x42, 0xea, 0x01, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x42, 0x13, 0x46, 0x65, 0x61, 0x74,
	0x75, 0x72, 0x65, 0x4d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50,
	0x01, 0x5a, 0x43, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41, 0x49, 0x50, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x62,
	0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_goTypes = []any{
	(*FeatureMonitor)(nil),                       // 0: google.cloud.aiplatform.v1beta1.FeatureMonitor
	(*ScheduleConfig)(nil),                       // 1: google.cloud.aiplatform.v1beta1.ScheduleConfig
	(*FeatureSelectionConfig)(nil),               // 2: google.cloud.aiplatform.v1beta1.FeatureSelectionConfig
	(*FeatureStatsAndAnomaly)(nil),               // 3: google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly
	(*FeatureStatsAndAnomalySpec)(nil),           // 4: google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomalySpec
	nil,                                          // 5: google.cloud.aiplatform.v1beta1.FeatureMonitor.LabelsEntry
	(*FeatureSelectionConfig_FeatureConfig)(nil), // 6: google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig
	(*timestamppb.Timestamp)(nil),                // 7: google.protobuf.Timestamp
	(*structpb.Value)(nil),                       // 8: google.protobuf.Value
	(*interval.Interval)(nil),                    // 9: google.type.Interval
}
var file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_depIdxs = []int32{
	7, // 0: google.cloud.aiplatform.v1beta1.FeatureMonitor.create_time:type_name -> google.protobuf.Timestamp
	7, // 1: google.cloud.aiplatform.v1beta1.FeatureMonitor.update_time:type_name -> google.protobuf.Timestamp
	5, // 2: google.cloud.aiplatform.v1beta1.FeatureMonitor.labels:type_name -> google.cloud.aiplatform.v1beta1.FeatureMonitor.LabelsEntry
	1, // 3: google.cloud.aiplatform.v1beta1.FeatureMonitor.schedule_config:type_name -> google.cloud.aiplatform.v1beta1.ScheduleConfig
	2, // 4: google.cloud.aiplatform.v1beta1.FeatureMonitor.feature_selection_config:type_name -> google.cloud.aiplatform.v1beta1.FeatureSelectionConfig
	6, // 5: google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.feature_configs:type_name -> google.cloud.aiplatform.v1beta1.FeatureSelectionConfig.FeatureConfig
	8, // 6: google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly.feature_stats:type_name -> google.protobuf.Value
	7, // 7: google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly.stats_time:type_name -> google.protobuf.Timestamp
	9, // 8: google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomalySpec.stats_time_range:type_name -> google.type.Interval
	9, // [9:9] is the sub-list for method output_type
	9, // [9:9] is the sub-list for method input_type
	9, // [9:9] is the sub-list for extension type_name
	9, // [9:9] is the sub-list for extension extendee
	0, // [0:9] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_init() }
func file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_feature_monitor_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_msgTypes[4].OneofWrappers = []any{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_depIdxs,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_feature_monitor_proto = out.File
	file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_feature_monitor_proto_depIdxs = nil
}
