package goparquet

import (
	"testing"

	"github.com/stretchr/testify/require"
)

func TestDictStore(t *testing.T) {
	d := &dictStore{useDict: true}
	d.init()
	require.Equal(t, d.allValuesSize, int64(0))
	require.Equal(t, d.uniqueValuesSize, int64(0))

	d.addValue(int32(1), 4)
	d.addValue(int32(2), 4)
	d.addValue(int32(3), 4)
	d.addValue(int32(4), 4)
	d.addValue(int32(1), 4)
	d.addValue(int32(2), 4)
	d.addValue(int32(3), 4)
	d.addValue(int32(4), 4)
	require.Equal(t, d.allValuesSize, int64(32))
	require.Equal(t, d.uniqueValuesSize, int64(16))
	d.addValue(nil, 4)
	require.Equal(t, d.allValuesSize, int64(32))

	d.init()
	require.Equal(t, d.allValuesSize, int64(0))
	require.Equal(t, d.uniqueValuesSize, int64(0))
}

func TestFuzzCrashDictDecoderDecodeValues(t *testing.T) {
	data := []byte("PAR1\x15\x04\x15\x80\x13\x15\x80\x13L\x15\xe0\x04\x15\x04\x12\x00" +
		"\x009\xf9\xff\xff \xeb\xff\xff\xd3\x0e\x00\x00\xf8\x1c\x00\x00\xe1\x02\x00" +
		"\x00\xc3\xee\xff\xff\x85\x12\x00\x00\x1b\x1f\x00\x00&\xea\xff\xff\x9b\r\x00" +
		"\x00\xdd\xe9\xff\xff\r\xdf\xff\xff\xc6\xec\xff\xff\xdb\xeb\xff\xff\xce\x05\x00" +
		"\x00\x8e\xf3\xff\xff\xfe\xe5\xff\xff\x98\x06\x00\x001\f\x00\x00\x02\xeb\xff" +
		"\xff\xf2\xeb\xff\xff\xad\xf9\xff\xff\x8b\xfe\xff\xff\x11\x00\x00\x00%\xf0\xff" +
		"\xff\xb5\xe8\xff\xff\xac%\x00\x002\x14\x00\x00\xeb\x18\x00\x00\xa5\xf7\xff" +
		"\xff\x9e%\x00\x00\xd6\xfa\xff\xff\xdf\x1b\x00\x00?\x15\x00\x00$\xf5\xff" +
		"\xff\x1a\xf4\xff\xff\xfd\xf9\xff\xffw \x00\x00\x06%\x00\x00\x05\xe8\xff" +
		"\xff\xdf&\x00\x00\xc8\xf9\xff\xffB&\x00\x00\x86\xee\xff\xffA\x0e\x00" +
		"\x00\xe0\a\x00\x00$\x18\x00\x00\xf4\xf3\xff\xff\x00\xee\xff\xff\xd5\xfa\xff" +
		"\xff\xdd\x12\x00\x00\x14\xe7\xff\xff\xdc\b\x00\x00\x91\x1f\x00\x00y\xde\xff" +
		"\xffg\x14\x00\x00\x0e\xf1\xff\xff\a%\x00\x00\xa9\xe5\xff\xff\xc8!\x00" +
		"\x00\x8d\xf3\xff\xff\xba\xf9\xff\xff\xc8\n\x00\x00\xf5\x18\x00\x00\xfb\x01\x00" +
		"\x00@\xeb\xff\xff\x19\x1f\x00\x008\n\x00\x00\xc4\x03\x00\x00\x83\xee\xff" +
		"\xff\xa7\t\x00\x00\x11\xdd\xff\xff?\xf4\xff\xff,\xeb\xff\xff$\x04\x00" +
		"\x00\x8f\x1e\x00\x00\x10\x0e\x00\x00\xa3\x03\x00\x00}\x01\x00\x00\xef\r\x00" +
		"\x00\xa7\x1c\x00\x00~\xf2\xff\xff\x10\xec\xff\xff\xfe\xe9\xff\xff\xac\xeb\xff" +
		"\xffT\xfc\xff\xff\xb7\xda\xff\xff\xc7\x12\x00\x003\xf4\xff\xff&!\x00" +
		"\x00\xe4\x11\x00\x00\x84\f\x00\x00\x89\x10\x00\x00\xeb\x12\x00\x00@\xfa\xff" +
		"\xff]\x17\x00\x00\xa7\x1d\x00\x00\xf3\xe2\xff\xff\xf9\xf3\xff\xff\a\xfb\xff" +
		"\xffl\x1d\x00\x00+$\x00\x00A\xfc\xff\xff\xaa\xeb\xff\xff8\x1c\x00" +
		"\x00\xce\xf9\xff\xffB#\x00\x00\u007f\xeb\xff\xff\xf1\x1b\x00\x00_\x06\x00" +
		"\x00\xad#\x00\x00\xc8\b\x00\x00\x1a\x02\x00\x00`\xf2\xff\xff>\x01\x00" +
		"\x00;\xdc\xff\xff\xce\x13\x00\x00\x90\b\x00\x00\x1c\x03\x00\x00\xbc\x01\x00" +
		"\x006\xef\xff\xff\xdd\x04\x00\x00f\xe8\xff\xffw\x18\x00\x00N\xe6\xff" +
		"\xff\xfd\x11\x00\x00R%\x00\x00\x89 \x00\x00\xd5\"\x00\x00m\"\x00" +
		"\x00\x9e\xef\xff\xff\xaf\"\x00\x00\xc9\xfd\xff\xffr\xe0\xff\xffo\x00\x00" +
		"\x00D#\x00\x00\xf4\x01\x00\x00\x1b\x12\x00\x00E\x18\x00\x00\"\x10\x00" +
		"\x00\xd3\xde\xff\xff\x91\x03\x00\x00\t%\x00\x00h\xdf\xff\xff\xcd\x0e\x00" +
		"\x00'\xe5\xff\xff\xba\xf1\xff\xffg\x02\x00\x00`\xf8\xff\xff`\xe3\xff" +
		"\xff*\xe5\xff\xff\xeb\x14\x00\x00\x83\x06\x00\x00\x9d\xf7\xff\xff1\v\x00" +
		"\x00V\xf1\xff\xff\x02\xe4\xff\xff\xa3\x1a\x00\x00a\x05\x00\x00x\x1a\x00" +
		"\x00\x02\x15\x00\x00\xbc\xdd\xff\xff\xbe\x05\x00\x00\xf8!\x00\x00\x11\x1b\x00" +
		"\x00\x04\x14\x00\x00p\xe7\xff\xff(\xdc\xff\xff\xec$\x00\x00h\x13\x00" +
		"\x00\x9e\x03\x00\x00O\xec\xff\xff\n\xf3\xff\xff\x16\xf4\xff\xff\"\xf3\xff" +
		"\xff8\xf9\xff\xff\xba\x15\x00\x00'\r\x00\x00\x1e\xf6\xff\xff\xb1%\x00" +
		"\x00.\xde\xff\xff\x13\xf5\xff\xff\xfe\v\x00\x00\xbc\t\x00\x000\x18\x00" +
		"\x00\x9d\x1c\x00\x00d\x1a\x00\x00i\x1a\x00\x00\xde\xfe\xff\xffV\x0e\x00" +
		"\x00\x1c\xe4\xff\xff\xb9\x1a\x00\x002\xd9\xff\xff\x8e\xd9\xff\xff%\x02\x00" +
		"\x00\x04\xe3\xff\xff\x1b\xf0\xff\xff\x1f\xed\xff\xff\x90\xfd\xff\xff\x81\x15\x00" +
		"\x00\xc7\"\x00\x00\r\xe4\xff\xff^\xfe\xff\xff\x1f\xde\xff\xff\xbc\xf0\xff" +
		"\xff\x87\xdf\xff\xff:\x06\x00\x00\xce\f\x00\x00%\x03\x00\x00\x98\xfe\xff" +
		"\xff\xe8\xe4\xff\xffR\t\x00\x00y\xe3\xff\xff)\xf4\xff\xff\xc0\xe6\xff" +
		"\xff\xf0!\x00\x00\xa2&\x00\x00\xae\xd9\xff\xffZ\xda\xff\xff\xcd#\x00" +
		"\x00\xa4\xe7\xff\xff/\xe0\xff\xff\xa3 \x00\x00\x93\x1e\x00\x00\x0f\xf1\xff" +
		"\xff\xe0\x1c\x00\x00\xcb\xec\xff\xff\x8a\xef\xff\xff\x9c\xe8\xff\xff\xee\xff\xff" +
		"\xff\x00\xfe\xff\xff\xed\x17\x00\x00\x90\x0f\x00\x00\xbe\xde\xff\xff@$\x00" +
		"\x00\xfa\x1a\x00\x00\xb2\x00\x00\x00f\xda\xff\xff\xb9\x0e\x00\x00H\xf3\xff" +
		"\xffl\x00\x00\x00\x88\x13\x00\x00u\xf0\xff\xff\x8d\xfc\xff\xffq\xd9\xff" +
		"\xff\x89\xef\xff\xff\x8d\x1d\x00\x00\xc6\x13\x00\x00K\xed\xff\xff\x92\xf5\xff" +
		"\xff\x81!\x00\x001\xf2\xff\xff2\x1d\x00\x00\x8a\f\x00\x00\x18\xec\xff" +
		"\xff\xa4\xe4\xff\xff\u007f\x14\x00\x00\xb1\x0e\x00\x00}\xf1\xff\xff\xa6\xf0\xff" +
		"\xff\x97\xf7\xff\xffZ\xe7\xff\xff\x9f\x04\x00\x00\xd0\x0f\x00\x00~\xe6\xff" +
		"\xffe\xf6\xff\xfff\x18\x00\x00h\v\x00\x00\xe0\xd9\xff\xff\x94\x18\x00" +
		"\x00\x8f\"\x00\x00\x12\x1a\x00\x00L\xe0\xff\xff<\x11\x00\x00\x1b\xfe\xff" +
		"\xffr\x17\x00\x00F\x0e\x00\x00j\x1e\x00\x00]\xdc\xff\xff6\x06\x00" +
		"\x004\x1e\x00\x00\x13\xf6\xff\xff\x85\xfe\xff\xffU\xef\xff\xff\xec\xfb\xff" +
		"\xffW\xde\xff\xff-\xe1\xff\xff'\xfc\xff\xff\xbc\xde\xff\xff\\\xf7\xff" +
		"\xff\x89\xee\xff\xff'\x12\x00\x00\xd8\v\x00\x00\x90\xf2\xff\xffj\xf8\xff" +
		"\xff\xa8\xeb\xff\xff\xe4 \x00\x00\x89\x1c\x00\x00\xfa\x06\x00\x00\xff%\x00" +
		"\x00}\xda\xff\xff\b\x18\x00\x00\xc1 \x00\x00\x88\xe5\xff\xff\x15\x00\x15" +
		"\xc6\x06\x15\xc6\x06,\x15\xee\x05\x15\x04\x15\x06\x15\x06\x1c\x18\x04\xdf&" +
		"\x00\x00\x18\x042\xd9\xff\xff\x16\x8a\x01(\x04\xdf&\x00\x00\x18\x042" +
		"\xd9\xff\xff\x00\x00\x00>\x00\x00\x00\x03\xdf\x16\x01\r\xbe\xee}}\xbd" +
		"\xe7\x12\x01\a\xe6\xef\xcf\x14\x01\a\xfe\xf7\xee\x10\x01\x03\xf4\x1e\x01\x03" +
		"\xbe2\x01\x15\xecϽ\xe7\xfb\xeb\u05fd\xfe\xb7\x10\x01\x03\xe8\x16\x01" +
		"\v\xda\u05fa\xfd\xcf\x12\x01\a\x00\x00\x00 O\x15\x02\x19\x9c5\x00" +
		"\x18\x06schema\x15\f\x00\x15\x02%\x02\x18\x01a% " +
		"L\xac\x13\x10\x11\x00\x00\x00\x15\n%\x02\x18\x01b\x00\x15\f%\x02" +
		"\x18\x01c%\x00L\x1c\x00\x00\x005\x02\x18\x01d\x15\x02\x15\x06L" +
		"<\x00\x00\x005\x04\x18\x04list\x15\x02\x00\x15\x04%\x02\x18" +
		"\x04item\x00\x15\x02%\x02\x18\x01e% L\xac\x13\x10\x11" +
		"\x00\x00\x00\x15\f%\x02\x18\ano_dict%\x00L\x1c" +
		"\x00\x00\x00\x16\xd0\x0f\x19<\x19l&\xd2\x1a\x1c\x15\x02\x195\x04\x00" +
		"\x06\x19\x18\x01a\x15\x00\x16\xee\x05\x16\xca\x1a\x16\xca\x1a&\xaa\x13&" +
		"\b\x1c\x18\x04\xdf&\x00\x00\x18\x042\xd9\xff\xff\x16\x8a\x01(\x04\xdf" +
		"&\x00\x00\x18\x042\xd9\xff\xff\x00\x00\x00&\xc0R\x1c\x15\n\x195" +
		"\x04\x00\x06\x19\x18\x01b\x15\x00\x16\xee\x05\x16\xf26\x16\xf26&\xe0" +
		"J&\xce\x1b\x1c\x18\b|\xa4\xbe\xab\x1c\x97\x02B\x18\b+\xbe_" +
		"}S}\x02\xc2\x16\x00(\b|\xa4\xbe\xab\x1c\x97\x02B\x18\b+" +
		"\xbe_}S}\x02\xc2\x00\x00\x00&\x8en\x1c\x15\f\x195\x04\x00" +
		"\x06\x19\x18\x01c\x15\x00\x16\xee\x05\x16\xb2\x1a\x16\xb2\x1a&\xeeg&" +
		"\xdcS\x1c6\x8e\x01(\x03zqb\x18\x00\x00\x00\x00&\xc0\xc2\x04" +
		"\x1c\x15\x04\x195\x04\x00\x06\x198\x01d\x04list\x04it" +
		"em\x15\x00\x16\xa8>\x16\xd6\xd3\x03\x16\xd6\xd3\x03&\xa0\xde\x03&" +
		"\xean\x1c\x18\b\x0f'\x00\x00\x00\x00\x00\x00\x18\b\xf6\xd8\xff\xff\xff" +
		"\xff\xff\xff\x16\xc8\f(\b\x0f'\x00\x00\x00\x00\x00\x00\x18\b\xf6\xd8" +
		"\xff\xff\xff\xff\xff\xff\x00\x00\x00&\x90\xc5\x04\x1c\x15\x02\x195\x04\x00" +
		"\x06\x19\x18\x01e\x15\x00\x16\xee\x05\x16\x96\x01\x16\x96\x01&\x9e\xc4\x04" +
		"&\xfa\xc3\x04\x1c\x18\x04*\x00\x00\x00\x18\x04*\x00\x00\x00\x16\x00(" +
		"\x04*\x00\x00\x00\x18\x04*\x00\x00\x00\x00\x00\x00&\xe2\x9b\x05\x1c\x15" +
		"\f\x19%\x00\x06\x19\x18\ano_dict\x15\x00\x16\xee\x05" +
		"\x16\xd0U\x16\xd0U&\x92\xc6\x04<6\x9e\x01(\x03zvn\x18" +
		"\x00\x00\x00\x00\x16\xaa\x96\x05\x16\xee\x05&\xd2\x1a\x16\xaa\x96\x05\x14\x00" +
		"\x00\x19l&\x8c\xb6\x05\x1c\x15\x02\x195\x04\x00\x06\x19\x18\x01a\x15" +
		"\x00\x16\xee\x05\x16\xc6\x19\x16\xc6\x19&\x88\xaf\x05&Ɯ\x05\x1c\x18" +
		"\x04\x83&\x00\x00\x18\x04\x12\xd9\xff\xff\x16\x9c\x01(\x04\x83&\x00\x00" +
		"\x18\x04\x12\xd9\xff\xff\x00\x00\x00&\x82\xee\x05\x1c\x15\n\x195\x04\x00" +
		"\x06\x19\x18\x01b\x15\x00\x16\xee\x05\x16\xf26\x16\xf26&\xa2\xe6\x05" +
		"&\x90\xb7\x05\x1c\x18\b0kw^\xebh\x02B\x18\bǔ\xc5" +
		"\x03\xf2\x89\x02\xc2\x16\x00(\b0kw^\xebh\x02B\x18\b\xc7" +
		"\x94\xc5\x03\xf2\x89\x02\xc2\x00\x00\x00&\xf6\x88\x06\x1c\x15\f\x195\x04" +
		"\x00\x06\x19\x18\x01c\x15\x00\x16\xee\x05\x16\xd2\x19\x16\xd2\x19&Ȃ" +
		"\x06&\xa4\xef\x05\x1c6\x8a\x01(\x03zoz\x18\x00\x00\x00\x00&" +
		"\xbc\xcb\t\x1c\x15\x04\x195\x04\x00\x06\x198\x01d\x04list" +
		"\x04item\x15\x00\x16\xc4:\x16\xe4\xc1\x03\x16\xe4\xc1\x03&\xbe" +
		"\xeb\b&؉\x06\x1c\x18\b\x10'\x00\x00\x00\x00\x00\x00\x18\b\x01" +
		"\xd9\xff\xff\xff\xff\xff\xff\x16\xc6\n(\b\x10'\x00\x00\x00\x00\x00\x00" +
		"\x18\b\x01\xd9\xff\xff\xff\xff\xff\xff\x00\x00\x00&\x8e\xce\t\x1c\x15\x02" +
		"\x195\x04\x00\x06\x19\x18\x01e\x15\x00\x16\xee\x05\x16\x96\x01\x16\x96\x01" +
		"&\x9c\xcd\t&\xf8\xcc\t\x1c\x18\x04*\x00\x00\x00\x18\x04*\x00\x00" +
		"\x00\x16\x00(\x04*\x00\x00\x00\x18\x04*\x00\x00\x00\x00\x00\x00&\xa6" +
		"\xb2\n\x1c\x15\f\x19%\x00\x06\x19\x18\ano_dict\x15" +
		"\x00\x16\xee\x05\x16\x96c\x16\x96c&\x90\xcf\t<6v(\x04z" +
		"gHe\x18\x00\x00\x00\x00\x16\x9a\x90\x05\x16\xee\x05&\x8c\xb6\x05\x16" +
		"\x9a\x90\x05\x14\x02\x00\x19l&\xce\xc3\n\x1c\x15\x02\x195\x04\x00\x06" +
		"\x19\x18\x01a\x15\x00\x16\xec\x03\x16\xc4\x10\x16\xc4\x10&\x9c\xbf\n&" +
		"\x8a\xb3\n\x1c\x18\x04\xe7&\x00\x00\x18\x04,\xd9\xff\xff\x16v(\x04" +
		"\xe7&\x00\x00\x18\x04,\xd9\xff\xff\x00\x00\x00&\xa4\xe9\n\x1c\x15\n" +
		"\x195\x04\x00\x06\x19\x18\x01b\x15\x00\x16\xf4\x03\x16\xd4$\x16\xd4$" +
		"&\x92\xe4\n&\xd0\xc4\n\x1c\x18\bL\x98;\x80\vp\x02B\x18" +
		"\b\xf4?\xc2\xd9 w\x02\xc2\x16\x00(\bL\x98;\x80\vp\x02" +
		"B\x18\b\xf4?\xc2\xd9 w\x02\xc2\x00\x00\x00&\xd4\xfc\n\x1c\x15" +
		"\f\x195\x04\x00\x06\x19\x18\x01c\x15\x00\x16\xf4\x03\x16\x8e\x12\x16\x8e" +
		"\x12&\x9c\xf8\n&\xc6\xea\n\x1c6`(\x02zm\x18\x00\x00\x00" +
		"\x00&\xf0\x91\r\x1c\x15\x04\x195\x04\x00\x06\x198\x01d\x04li" +
		"st\x04item\x15\x00\x16\x96$\x16\xbe\x94\x02\x16\xbe\x94\x02" +
		"&\xb8\xda\f&\xb2\xfd\n\x1c\x18\b\x03'\x00\x00\x00\x00\x00\x00\x18" +
		"\b\xf2\xd8\xff\xff\xff\xff\xff\xff\x16\x90\a(\b\x03'\x00\x00\x00\x00" +
		"\x00\x00\x18\b\xf2\xd8\xff\xff\xff\xff\xff\xff\x00\x00\x00&\u0094\r\x1c" +
		"\x15\x02\x195\x04\x00\x06\x19\x18\x01e\x15\x00\x16\xf4\x03\x16\x96\x01\x16" +
		"\x96\x01&Г\r&\xac\x93\r\x1c\x18\x04*\x00\x00\x00\x18\x04*" +
		"\x00\x00\x00\x16\x00(\x04*\x00\x00\x00\x18\x04*\x00\x00\x00\x00\x00\x00" +
		"&\xd4\xcd\r\x1c\x15\f\x19%\x00\x06\x19\x18\ano_dic" +
		"t\x15\x00\x16\xf4\x03\x16\x908\x16\x908&ĕ\r<6r(" +
		"\x02zx\x18\x00\x00\x00\x00\x16\x8a\x95\x03\x16\xf4\x03&\xce\xc3\n\x16" +
		"\x8a\x95\x03\x14\x04\x00(\"parquet-cpp " +
		"version 1.5.1-SNAPSH" +
		"OT\x19l\x1c\x00\x00\x1c\x00\x00\x1c\x00\x00\x1c\x00\x00\x1c\x00\x00\x1c" +
		"\x00\x00\x00\xa9\x05\x00\x00PAR1")

	readAllData(t, data)
}
