// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.3.0
// - protoc             v4.25.7
// source: google/cloud/automl/v1/prediction_service.proto

package automlpb

import (
	context "context"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.32.0 or later.
const _ = grpc.SupportPackageIsVersion7

const (
	PredictionService_Predict_FullMethodName      = "/google.cloud.automl.v1.PredictionService/Predict"
	PredictionService_BatchPredict_FullMethodName = "/google.cloud.automl.v1.PredictionService/BatchPredict"
)

// PredictionServiceClient is the client API for PredictionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
type PredictionServiceClient interface {
	// Perform an online prediction. The prediction result is directly
	// returned in the response.
	// Available for following ML scenarios, and their expected request payloads:
	//
	// # AutoML Vision Classification
	//
	// * An image in .JPEG, .GIF or .PNG format, image_bytes up to 30MB.
	//
	// # AutoML Vision Object Detection
	//
	// * An image in .JPEG, .GIF or .PNG format, image_bytes up to 30MB.
	//
	// # AutoML Natural Language Classification
	//
	// * A TextSnippet up to 60,000 characters, UTF-8 encoded or a document in
	// .PDF, .TIF or .TIFF format with size upto 2MB.
	//
	// # AutoML Natural Language Entity Extraction
	//
	//   - A TextSnippet up to 10,000 characters, UTF-8 NFC encoded or a document
	//     in .PDF, .TIF or .TIFF format with size upto 20MB.
	//
	// # AutoML Natural Language Sentiment Analysis
	//
	// * A TextSnippet up to 60,000 characters, UTF-8 encoded or a document in
	// .PDF, .TIF or .TIFF format with size upto 2MB.
	//
	// # AutoML Translation
	//
	// * A TextSnippet up to 25,000 characters, UTF-8 encoded.
	//
	// # AutoML Tables
	//
	//   - A row with column values matching
	//     the columns of the model, up to 5MB. Not available for FORECASTING
	//     `prediction_type`.
	Predict(ctx context.Context, in *PredictRequest, opts ...grpc.CallOption) (*PredictResponse, error)
	// Perform a batch prediction. Unlike the online [Predict][google.cloud.automl.v1.PredictionService.Predict], batch
	// prediction result won't be immediately available in the response. Instead,
	// a long running operation object is returned. User can poll the operation
	// result via [GetOperation][google.longrunning.Operations.GetOperation]
	// method. Once the operation is done, [BatchPredictResult][google.cloud.automl.v1.BatchPredictResult] is returned in
	// the [response][google.longrunning.Operation.response] field.
	// Available for following ML scenarios:
	//
	// * AutoML Vision Classification
	// * AutoML Vision Object Detection
	// * AutoML Video Intelligence Classification
	// * AutoML Video Intelligence Object Tracking * AutoML Natural Language Classification
	// * AutoML Natural Language Entity Extraction
	// * AutoML Natural Language Sentiment Analysis
	// * AutoML Tables
	BatchPredict(ctx context.Context, in *BatchPredictRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type predictionServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewPredictionServiceClient(cc grpc.ClientConnInterface) PredictionServiceClient {
	return &predictionServiceClient{cc}
}

func (c *predictionServiceClient) Predict(ctx context.Context, in *PredictRequest, opts ...grpc.CallOption) (*PredictResponse, error) {
	out := new(PredictResponse)
	err := c.cc.Invoke(ctx, PredictionService_Predict_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *predictionServiceClient) BatchPredict(ctx context.Context, in *BatchPredictRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, PredictionService_BatchPredict_FullMethodName, in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PredictionServiceServer is the server API for PredictionService service.
// All implementations should embed UnimplementedPredictionServiceServer
// for forward compatibility
type PredictionServiceServer interface {
	// Perform an online prediction. The prediction result is directly
	// returned in the response.
	// Available for following ML scenarios, and their expected request payloads:
	//
	// # AutoML Vision Classification
	//
	// * An image in .JPEG, .GIF or .PNG format, image_bytes up to 30MB.
	//
	// # AutoML Vision Object Detection
	//
	// * An image in .JPEG, .GIF or .PNG format, image_bytes up to 30MB.
	//
	// # AutoML Natural Language Classification
	//
	// * A TextSnippet up to 60,000 characters, UTF-8 encoded or a document in
	// .PDF, .TIF or .TIFF format with size upto 2MB.
	//
	// # AutoML Natural Language Entity Extraction
	//
	//   - A TextSnippet up to 10,000 characters, UTF-8 NFC encoded or a document
	//     in .PDF, .TIF or .TIFF format with size upto 20MB.
	//
	// # AutoML Natural Language Sentiment Analysis
	//
	// * A TextSnippet up to 60,000 characters, UTF-8 encoded or a document in
	// .PDF, .TIF or .TIFF format with size upto 2MB.
	//
	// # AutoML Translation
	//
	// * A TextSnippet up to 25,000 characters, UTF-8 encoded.
	//
	// # AutoML Tables
	//
	//   - A row with column values matching
	//     the columns of the model, up to 5MB. Not available for FORECASTING
	//     `prediction_type`.
	Predict(context.Context, *PredictRequest) (*PredictResponse, error)
	// Perform a batch prediction. Unlike the online [Predict][google.cloud.automl.v1.PredictionService.Predict], batch
	// prediction result won't be immediately available in the response. Instead,
	// a long running operation object is returned. User can poll the operation
	// result via [GetOperation][google.longrunning.Operations.GetOperation]
	// method. Once the operation is done, [BatchPredictResult][google.cloud.automl.v1.BatchPredictResult] is returned in
	// the [response][google.longrunning.Operation.response] field.
	// Available for following ML scenarios:
	//
	// * AutoML Vision Classification
	// * AutoML Vision Object Detection
	// * AutoML Video Intelligence Classification
	// * AutoML Video Intelligence Object Tracking * AutoML Natural Language Classification
	// * AutoML Natural Language Entity Extraction
	// * AutoML Natural Language Sentiment Analysis
	// * AutoML Tables
	BatchPredict(context.Context, *BatchPredictRequest) (*longrunningpb.Operation, error)
}

// UnimplementedPredictionServiceServer should be embedded to have forward compatible implementations.
type UnimplementedPredictionServiceServer struct {
}

func (UnimplementedPredictionServiceServer) Predict(context.Context, *PredictRequest) (*PredictResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method Predict not implemented")
}
func (UnimplementedPredictionServiceServer) BatchPredict(context.Context, *BatchPredictRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method BatchPredict not implemented")
}

// UnsafePredictionServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to PredictionServiceServer will
// result in compilation errors.
type UnsafePredictionServiceServer interface {
	mustEmbedUnimplementedPredictionServiceServer()
}

func RegisterPredictionServiceServer(s grpc.ServiceRegistrar, srv PredictionServiceServer) {
	s.RegisterService(&PredictionService_ServiceDesc, srv)
}

func _PredictionService_Predict_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PredictRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PredictionServiceServer).Predict(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PredictionService_Predict_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PredictionServiceServer).Predict(ctx, req.(*PredictRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PredictionService_BatchPredict_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchPredictRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PredictionServiceServer).BatchPredict(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: PredictionService_BatchPredict_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PredictionServiceServer).BatchPredict(ctx, req.(*BatchPredictRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// PredictionService_ServiceDesc is the grpc.ServiceDesc for PredictionService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var PredictionService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.automl.v1.PredictionService",
	HandlerType: (*PredictionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "Predict",
			Handler:    _PredictionService_Predict_Handler,
		},
		{
			MethodName: "BatchPredict",
			Handler:    _PredictionService_BatchPredict_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/automl/v1/prediction_service.proto",
}
