// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"errors"
	"fmt"
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/alert"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/decision"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/event"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/machine"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/meta"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/predicate"
)

// AlertUpdate is the builder for updating Alert entities.
type AlertUpdate struct {
	config
	hooks    []Hook
	mutation *AlertMutation
}

// Where appends a list predicates to the AlertUpdate builder.
func (au *AlertUpdate) Where(ps ...predicate.Alert) *AlertUpdate {
	au.mutation.Where(ps...)
	return au
}

// SetUpdatedAt sets the "updated_at" field.
func (au *AlertUpdate) SetUpdatedAt(t time.Time) *AlertUpdate {
	au.mutation.SetUpdatedAt(t)
	return au
}

// SetOwnerID sets the "owner" edge to the Machine entity by ID.
func (au *AlertUpdate) SetOwnerID(id int) *AlertUpdate {
	au.mutation.SetOwnerID(id)
	return au
}

// SetNillableOwnerID sets the "owner" edge to the Machine entity by ID if the given value is not nil.
func (au *AlertUpdate) SetNillableOwnerID(id *int) *AlertUpdate {
	if id != nil {
		au = au.SetOwnerID(*id)
	}
	return au
}

// SetOwner sets the "owner" edge to the Machine entity.
func (au *AlertUpdate) SetOwner(m *Machine) *AlertUpdate {
	return au.SetOwnerID(m.ID)
}

// AddDecisionIDs adds the "decisions" edge to the Decision entity by IDs.
func (au *AlertUpdate) AddDecisionIDs(ids ...int) *AlertUpdate {
	au.mutation.AddDecisionIDs(ids...)
	return au
}

// AddDecisions adds the "decisions" edges to the Decision entity.
func (au *AlertUpdate) AddDecisions(d ...*Decision) *AlertUpdate {
	ids := make([]int, len(d))
	for i := range d {
		ids[i] = d[i].ID
	}
	return au.AddDecisionIDs(ids...)
}

// AddEventIDs adds the "events" edge to the Event entity by IDs.
func (au *AlertUpdate) AddEventIDs(ids ...int) *AlertUpdate {
	au.mutation.AddEventIDs(ids...)
	return au
}

// AddEvents adds the "events" edges to the Event entity.
func (au *AlertUpdate) AddEvents(e ...*Event) *AlertUpdate {
	ids := make([]int, len(e))
	for i := range e {
		ids[i] = e[i].ID
	}
	return au.AddEventIDs(ids...)
}

// AddMetaIDs adds the "metas" edge to the Meta entity by IDs.
func (au *AlertUpdate) AddMetaIDs(ids ...int) *AlertUpdate {
	au.mutation.AddMetaIDs(ids...)
	return au
}

// AddMetas adds the "metas" edges to the Meta entity.
func (au *AlertUpdate) AddMetas(m ...*Meta) *AlertUpdate {
	ids := make([]int, len(m))
	for i := range m {
		ids[i] = m[i].ID
	}
	return au.AddMetaIDs(ids...)
}

// Mutation returns the AlertMutation object of the builder.
func (au *AlertUpdate) Mutation() *AlertMutation {
	return au.mutation
}

// ClearOwner clears the "owner" edge to the Machine entity.
func (au *AlertUpdate) ClearOwner() *AlertUpdate {
	au.mutation.ClearOwner()
	return au
}

// ClearDecisions clears all "decisions" edges to the Decision entity.
func (au *AlertUpdate) ClearDecisions() *AlertUpdate {
	au.mutation.ClearDecisions()
	return au
}

// RemoveDecisionIDs removes the "decisions" edge to Decision entities by IDs.
func (au *AlertUpdate) RemoveDecisionIDs(ids ...int) *AlertUpdate {
	au.mutation.RemoveDecisionIDs(ids...)
	return au
}

// RemoveDecisions removes "decisions" edges to Decision entities.
func (au *AlertUpdate) RemoveDecisions(d ...*Decision) *AlertUpdate {
	ids := make([]int, len(d))
	for i := range d {
		ids[i] = d[i].ID
	}
	return au.RemoveDecisionIDs(ids...)
}

// ClearEvents clears all "events" edges to the Event entity.
func (au *AlertUpdate) ClearEvents() *AlertUpdate {
	au.mutation.ClearEvents()
	return au
}

// RemoveEventIDs removes the "events" edge to Event entities by IDs.
func (au *AlertUpdate) RemoveEventIDs(ids ...int) *AlertUpdate {
	au.mutation.RemoveEventIDs(ids...)
	return au
}

// RemoveEvents removes "events" edges to Event entities.
func (au *AlertUpdate) RemoveEvents(e ...*Event) *AlertUpdate {
	ids := make([]int, len(e))
	for i := range e {
		ids[i] = e[i].ID
	}
	return au.RemoveEventIDs(ids...)
}

// ClearMetas clears all "metas" edges to the Meta entity.
func (au *AlertUpdate) ClearMetas() *AlertUpdate {
	au.mutation.ClearMetas()
	return au
}

// RemoveMetaIDs removes the "metas" edge to Meta entities by IDs.
func (au *AlertUpdate) RemoveMetaIDs(ids ...int) *AlertUpdate {
	au.mutation.RemoveMetaIDs(ids...)
	return au
}

// RemoveMetas removes "metas" edges to Meta entities.
func (au *AlertUpdate) RemoveMetas(m ...*Meta) *AlertUpdate {
	ids := make([]int, len(m))
	for i := range m {
		ids[i] = m[i].ID
	}
	return au.RemoveMetaIDs(ids...)
}

// Save executes the query and returns the number of nodes affected by the update operation.
func (au *AlertUpdate) Save(ctx context.Context) (int, error) {
	au.defaults()
	return withHooks(ctx, au.sqlSave, au.mutation, au.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (au *AlertUpdate) SaveX(ctx context.Context) int {
	affected, err := au.Save(ctx)
	if err != nil {
		panic(err)
	}
	return affected
}

// Exec executes the query.
func (au *AlertUpdate) Exec(ctx context.Context) error {
	_, err := au.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (au *AlertUpdate) ExecX(ctx context.Context) {
	if err := au.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (au *AlertUpdate) defaults() {
	if _, ok := au.mutation.UpdatedAt(); !ok {
		v := alert.UpdateDefaultUpdatedAt()
		au.mutation.SetUpdatedAt(v)
	}
}

func (au *AlertUpdate) sqlSave(ctx context.Context) (n int, err error) {
	_spec := sqlgraph.NewUpdateSpec(alert.Table, alert.Columns, sqlgraph.NewFieldSpec(alert.FieldID, field.TypeInt))
	if ps := au.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := au.mutation.UpdatedAt(); ok {
		_spec.SetField(alert.FieldUpdatedAt, field.TypeTime, value)
	}
	if au.mutation.BucketIdCleared() {
		_spec.ClearField(alert.FieldBucketId, field.TypeString)
	}
	if au.mutation.MessageCleared() {
		_spec.ClearField(alert.FieldMessage, field.TypeString)
	}
	if au.mutation.EventsCountCleared() {
		_spec.ClearField(alert.FieldEventsCount, field.TypeInt32)
	}
	if au.mutation.StartedAtCleared() {
		_spec.ClearField(alert.FieldStartedAt, field.TypeTime)
	}
	if au.mutation.StoppedAtCleared() {
		_spec.ClearField(alert.FieldStoppedAt, field.TypeTime)
	}
	if au.mutation.SourceIpCleared() {
		_spec.ClearField(alert.FieldSourceIp, field.TypeString)
	}
	if au.mutation.SourceRangeCleared() {
		_spec.ClearField(alert.FieldSourceRange, field.TypeString)
	}
	if au.mutation.SourceAsNumberCleared() {
		_spec.ClearField(alert.FieldSourceAsNumber, field.TypeString)
	}
	if au.mutation.SourceAsNameCleared() {
		_spec.ClearField(alert.FieldSourceAsName, field.TypeString)
	}
	if au.mutation.SourceCountryCleared() {
		_spec.ClearField(alert.FieldSourceCountry, field.TypeString)
	}
	if au.mutation.SourceLatitudeCleared() {
		_spec.ClearField(alert.FieldSourceLatitude, field.TypeFloat32)
	}
	if au.mutation.SourceLongitudeCleared() {
		_spec.ClearField(alert.FieldSourceLongitude, field.TypeFloat32)
	}
	if au.mutation.SourceScopeCleared() {
		_spec.ClearField(alert.FieldSourceScope, field.TypeString)
	}
	if au.mutation.SourceValueCleared() {
		_spec.ClearField(alert.FieldSourceValue, field.TypeString)
	}
	if au.mutation.CapacityCleared() {
		_spec.ClearField(alert.FieldCapacity, field.TypeInt32)
	}
	if au.mutation.LeakSpeedCleared() {
		_spec.ClearField(alert.FieldLeakSpeed, field.TypeString)
	}
	if au.mutation.ScenarioVersionCleared() {
		_spec.ClearField(alert.FieldScenarioVersion, field.TypeString)
	}
	if au.mutation.ScenarioHashCleared() {
		_spec.ClearField(alert.FieldScenarioHash, field.TypeString)
	}
	if au.mutation.UUIDCleared() {
		_spec.ClearField(alert.FieldUUID, field.TypeString)
	}
	if au.mutation.RemediationCleared() {
		_spec.ClearField(alert.FieldRemediation, field.TypeBool)
	}
	if au.mutation.OwnerCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   alert.OwnerTable,
			Columns: []string{alert.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(machine.FieldID, field.TypeInt),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := au.mutation.OwnerIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   alert.OwnerTable,
			Columns: []string{alert.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(machine.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if au.mutation.DecisionsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   alert.DecisionsTable,
			Columns: []string{alert.DecisionsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(decision.FieldID, field.TypeInt),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := au.mutation.RemovedDecisionsIDs(); len(nodes) > 0 && !au.mutation.DecisionsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   alert.DecisionsTable,
			Columns: []string{alert.DecisionsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(decision.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := au.mutation.DecisionsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   alert.DecisionsTable,
			Columns: []string{alert.DecisionsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(decision.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if au.mutation.EventsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   alert.EventsTable,
			Columns: []string{alert.EventsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(event.FieldID, field.TypeInt),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := au.mutation.RemovedEventsIDs(); len(nodes) > 0 && !au.mutation.EventsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   alert.EventsTable,
			Columns: []string{alert.EventsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(event.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := au.mutation.EventsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   alert.EventsTable,
			Columns: []string{alert.EventsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(event.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if au.mutation.MetasCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   alert.MetasTable,
			Columns: []string{alert.MetasColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(meta.FieldID, field.TypeInt),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := au.mutation.RemovedMetasIDs(); len(nodes) > 0 && !au.mutation.MetasCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   alert.MetasTable,
			Columns: []string{alert.MetasColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(meta.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := au.mutation.MetasIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   alert.MetasTable,
			Columns: []string{alert.MetasColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(meta.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if n, err = sqlgraph.UpdateNodes(ctx, au.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{alert.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return 0, err
	}
	au.mutation.done = true
	return n, nil
}

// AlertUpdateOne is the builder for updating a single Alert entity.
type AlertUpdateOne struct {
	config
	fields   []string
	hooks    []Hook
	mutation *AlertMutation
}

// SetUpdatedAt sets the "updated_at" field.
func (auo *AlertUpdateOne) SetUpdatedAt(t time.Time) *AlertUpdateOne {
	auo.mutation.SetUpdatedAt(t)
	return auo
}

// SetOwnerID sets the "owner" edge to the Machine entity by ID.
func (auo *AlertUpdateOne) SetOwnerID(id int) *AlertUpdateOne {
	auo.mutation.SetOwnerID(id)
	return auo
}

// SetNillableOwnerID sets the "owner" edge to the Machine entity by ID if the given value is not nil.
func (auo *AlertUpdateOne) SetNillableOwnerID(id *int) *AlertUpdateOne {
	if id != nil {
		auo = auo.SetOwnerID(*id)
	}
	return auo
}

// SetOwner sets the "owner" edge to the Machine entity.
func (auo *AlertUpdateOne) SetOwner(m *Machine) *AlertUpdateOne {
	return auo.SetOwnerID(m.ID)
}

// AddDecisionIDs adds the "decisions" edge to the Decision entity by IDs.
func (auo *AlertUpdateOne) AddDecisionIDs(ids ...int) *AlertUpdateOne {
	auo.mutation.AddDecisionIDs(ids...)
	return auo
}

// AddDecisions adds the "decisions" edges to the Decision entity.
func (auo *AlertUpdateOne) AddDecisions(d ...*Decision) *AlertUpdateOne {
	ids := make([]int, len(d))
	for i := range d {
		ids[i] = d[i].ID
	}
	return auo.AddDecisionIDs(ids...)
}

// AddEventIDs adds the "events" edge to the Event entity by IDs.
func (auo *AlertUpdateOne) AddEventIDs(ids ...int) *AlertUpdateOne {
	auo.mutation.AddEventIDs(ids...)
	return auo
}

// AddEvents adds the "events" edges to the Event entity.
func (auo *AlertUpdateOne) AddEvents(e ...*Event) *AlertUpdateOne {
	ids := make([]int, len(e))
	for i := range e {
		ids[i] = e[i].ID
	}
	return auo.AddEventIDs(ids...)
}

// AddMetaIDs adds the "metas" edge to the Meta entity by IDs.
func (auo *AlertUpdateOne) AddMetaIDs(ids ...int) *AlertUpdateOne {
	auo.mutation.AddMetaIDs(ids...)
	return auo
}

// AddMetas adds the "metas" edges to the Meta entity.
func (auo *AlertUpdateOne) AddMetas(m ...*Meta) *AlertUpdateOne {
	ids := make([]int, len(m))
	for i := range m {
		ids[i] = m[i].ID
	}
	return auo.AddMetaIDs(ids...)
}

// Mutation returns the AlertMutation object of the builder.
func (auo *AlertUpdateOne) Mutation() *AlertMutation {
	return auo.mutation
}

// ClearOwner clears the "owner" edge to the Machine entity.
func (auo *AlertUpdateOne) ClearOwner() *AlertUpdateOne {
	auo.mutation.ClearOwner()
	return auo
}

// ClearDecisions clears all "decisions" edges to the Decision entity.
func (auo *AlertUpdateOne) ClearDecisions() *AlertUpdateOne {
	auo.mutation.ClearDecisions()
	return auo
}

// RemoveDecisionIDs removes the "decisions" edge to Decision entities by IDs.
func (auo *AlertUpdateOne) RemoveDecisionIDs(ids ...int) *AlertUpdateOne {
	auo.mutation.RemoveDecisionIDs(ids...)
	return auo
}

// RemoveDecisions removes "decisions" edges to Decision entities.
func (auo *AlertUpdateOne) RemoveDecisions(d ...*Decision) *AlertUpdateOne {
	ids := make([]int, len(d))
	for i := range d {
		ids[i] = d[i].ID
	}
	return auo.RemoveDecisionIDs(ids...)
}

// ClearEvents clears all "events" edges to the Event entity.
func (auo *AlertUpdateOne) ClearEvents() *AlertUpdateOne {
	auo.mutation.ClearEvents()
	return auo
}

// RemoveEventIDs removes the "events" edge to Event entities by IDs.
func (auo *AlertUpdateOne) RemoveEventIDs(ids ...int) *AlertUpdateOne {
	auo.mutation.RemoveEventIDs(ids...)
	return auo
}

// RemoveEvents removes "events" edges to Event entities.
func (auo *AlertUpdateOne) RemoveEvents(e ...*Event) *AlertUpdateOne {
	ids := make([]int, len(e))
	for i := range e {
		ids[i] = e[i].ID
	}
	return auo.RemoveEventIDs(ids...)
}

// ClearMetas clears all "metas" edges to the Meta entity.
func (auo *AlertUpdateOne) ClearMetas() *AlertUpdateOne {
	auo.mutation.ClearMetas()
	return auo
}

// RemoveMetaIDs removes the "metas" edge to Meta entities by IDs.
func (auo *AlertUpdateOne) RemoveMetaIDs(ids ...int) *AlertUpdateOne {
	auo.mutation.RemoveMetaIDs(ids...)
	return auo
}

// RemoveMetas removes "metas" edges to Meta entities.
func (auo *AlertUpdateOne) RemoveMetas(m ...*Meta) *AlertUpdateOne {
	ids := make([]int, len(m))
	for i := range m {
		ids[i] = m[i].ID
	}
	return auo.RemoveMetaIDs(ids...)
}

// Where appends a list predicates to the AlertUpdate builder.
func (auo *AlertUpdateOne) Where(ps ...predicate.Alert) *AlertUpdateOne {
	auo.mutation.Where(ps...)
	return auo
}

// Select allows selecting one or more fields (columns) of the returned entity.
// The default is selecting all fields defined in the entity schema.
func (auo *AlertUpdateOne) Select(field string, fields ...string) *AlertUpdateOne {
	auo.fields = append([]string{field}, fields...)
	return auo
}

// Save executes the query and returns the updated Alert entity.
func (auo *AlertUpdateOne) Save(ctx context.Context) (*Alert, error) {
	auo.defaults()
	return withHooks(ctx, auo.sqlSave, auo.mutation, auo.hooks)
}

// SaveX is like Save, but panics if an error occurs.
func (auo *AlertUpdateOne) SaveX(ctx context.Context) *Alert {
	node, err := auo.Save(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// Exec executes the query on the entity.
func (auo *AlertUpdateOne) Exec(ctx context.Context) error {
	_, err := auo.Save(ctx)
	return err
}

// ExecX is like Exec, but panics if an error occurs.
func (auo *AlertUpdateOne) ExecX(ctx context.Context) {
	if err := auo.Exec(ctx); err != nil {
		panic(err)
	}
}

// defaults sets the default values of the builder before save.
func (auo *AlertUpdateOne) defaults() {
	if _, ok := auo.mutation.UpdatedAt(); !ok {
		v := alert.UpdateDefaultUpdatedAt()
		auo.mutation.SetUpdatedAt(v)
	}
}

func (auo *AlertUpdateOne) sqlSave(ctx context.Context) (_node *Alert, err error) {
	_spec := sqlgraph.NewUpdateSpec(alert.Table, alert.Columns, sqlgraph.NewFieldSpec(alert.FieldID, field.TypeInt))
	id, ok := auo.mutation.ID()
	if !ok {
		return nil, &ValidationError{Name: "id", err: errors.New(`ent: missing "Alert.id" for update`)}
	}
	_spec.Node.ID.Value = id
	if fields := auo.fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, alert.FieldID)
		for _, f := range fields {
			if !alert.ValidColumn(f) {
				return nil, &ValidationError{Name: f, err: fmt.Errorf("ent: invalid field %q for query", f)}
			}
			if f != alert.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, f)
			}
		}
	}
	if ps := auo.mutation.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if value, ok := auo.mutation.UpdatedAt(); ok {
		_spec.SetField(alert.FieldUpdatedAt, field.TypeTime, value)
	}
	if auo.mutation.BucketIdCleared() {
		_spec.ClearField(alert.FieldBucketId, field.TypeString)
	}
	if auo.mutation.MessageCleared() {
		_spec.ClearField(alert.FieldMessage, field.TypeString)
	}
	if auo.mutation.EventsCountCleared() {
		_spec.ClearField(alert.FieldEventsCount, field.TypeInt32)
	}
	if auo.mutation.StartedAtCleared() {
		_spec.ClearField(alert.FieldStartedAt, field.TypeTime)
	}
	if auo.mutation.StoppedAtCleared() {
		_spec.ClearField(alert.FieldStoppedAt, field.TypeTime)
	}
	if auo.mutation.SourceIpCleared() {
		_spec.ClearField(alert.FieldSourceIp, field.TypeString)
	}
	if auo.mutation.SourceRangeCleared() {
		_spec.ClearField(alert.FieldSourceRange, field.TypeString)
	}
	if auo.mutation.SourceAsNumberCleared() {
		_spec.ClearField(alert.FieldSourceAsNumber, field.TypeString)
	}
	if auo.mutation.SourceAsNameCleared() {
		_spec.ClearField(alert.FieldSourceAsName, field.TypeString)
	}
	if auo.mutation.SourceCountryCleared() {
		_spec.ClearField(alert.FieldSourceCountry, field.TypeString)
	}
	if auo.mutation.SourceLatitudeCleared() {
		_spec.ClearField(alert.FieldSourceLatitude, field.TypeFloat32)
	}
	if auo.mutation.SourceLongitudeCleared() {
		_spec.ClearField(alert.FieldSourceLongitude, field.TypeFloat32)
	}
	if auo.mutation.SourceScopeCleared() {
		_spec.ClearField(alert.FieldSourceScope, field.TypeString)
	}
	if auo.mutation.SourceValueCleared() {
		_spec.ClearField(alert.FieldSourceValue, field.TypeString)
	}
	if auo.mutation.CapacityCleared() {
		_spec.ClearField(alert.FieldCapacity, field.TypeInt32)
	}
	if auo.mutation.LeakSpeedCleared() {
		_spec.ClearField(alert.FieldLeakSpeed, field.TypeString)
	}
	if auo.mutation.ScenarioVersionCleared() {
		_spec.ClearField(alert.FieldScenarioVersion, field.TypeString)
	}
	if auo.mutation.ScenarioHashCleared() {
		_spec.ClearField(alert.FieldScenarioHash, field.TypeString)
	}
	if auo.mutation.UUIDCleared() {
		_spec.ClearField(alert.FieldUUID, field.TypeString)
	}
	if auo.mutation.RemediationCleared() {
		_spec.ClearField(alert.FieldRemediation, field.TypeBool)
	}
	if auo.mutation.OwnerCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   alert.OwnerTable,
			Columns: []string{alert.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(machine.FieldID, field.TypeInt),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := auo.mutation.OwnerIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.M2O,
			Inverse: true,
			Table:   alert.OwnerTable,
			Columns: []string{alert.OwnerColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(machine.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if auo.mutation.DecisionsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   alert.DecisionsTable,
			Columns: []string{alert.DecisionsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(decision.FieldID, field.TypeInt),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := auo.mutation.RemovedDecisionsIDs(); len(nodes) > 0 && !auo.mutation.DecisionsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   alert.DecisionsTable,
			Columns: []string{alert.DecisionsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(decision.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := auo.mutation.DecisionsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   alert.DecisionsTable,
			Columns: []string{alert.DecisionsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(decision.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if auo.mutation.EventsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   alert.EventsTable,
			Columns: []string{alert.EventsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(event.FieldID, field.TypeInt),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := auo.mutation.RemovedEventsIDs(); len(nodes) > 0 && !auo.mutation.EventsCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   alert.EventsTable,
			Columns: []string{alert.EventsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(event.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := auo.mutation.EventsIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   alert.EventsTable,
			Columns: []string{alert.EventsColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(event.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	if auo.mutation.MetasCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   alert.MetasTable,
			Columns: []string{alert.MetasColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(meta.FieldID, field.TypeInt),
			},
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := auo.mutation.RemovedMetasIDs(); len(nodes) > 0 && !auo.mutation.MetasCleared() {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   alert.MetasTable,
			Columns: []string{alert.MetasColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(meta.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Clear = append(_spec.Edges.Clear, edge)
	}
	if nodes := auo.mutation.MetasIDs(); len(nodes) > 0 {
		edge := &sqlgraph.EdgeSpec{
			Rel:     sqlgraph.O2M,
			Inverse: false,
			Table:   alert.MetasTable,
			Columns: []string{alert.MetasColumn},
			Bidi:    false,
			Target: &sqlgraph.EdgeTarget{
				IDSpec: sqlgraph.NewFieldSpec(meta.FieldID, field.TypeInt),
			},
		}
		for _, k := range nodes {
			edge.Target.Nodes = append(edge.Target.Nodes, k)
		}
		_spec.Edges.Add = append(_spec.Edges.Add, edge)
	}
	_node = &Alert{config: auo.config}
	_spec.Assign = _node.assignValues
	_spec.ScanValues = _node.scanValues
	if err = sqlgraph.UpdateNode(ctx, auo.driver, _spec); err != nil {
		if _, ok := err.(*sqlgraph.NotFoundError); ok {
			err = &NotFoundError{alert.Label}
		} else if sqlgraph.IsConstraintError(err) {
			err = &ConstraintError{msg: err.Error(), wrap: err}
		}
		return nil, err
	}
	auo.mutation.done = true
	return _node, nil
}
