// Code generated by ent, DO NOT EDIT.

package ent

import (
	"context"
	"database/sql/driver"
	"fmt"
	"math"

	"entgo.io/ent"
	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"entgo.io/ent/schema/field"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/allowlist"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/allowlistitem"
	"github.com/crowdsecurity/crowdsec/pkg/database/ent/predicate"
)

// AllowListItemQuery is the builder for querying AllowListItem entities.
type AllowListItemQuery struct {
	config
	ctx           *QueryContext
	order         []allowlistitem.OrderOption
	inters        []Interceptor
	predicates    []predicate.AllowListItem
	withAllowlist *AllowListQuery
	// intermediate query (i.e. traversal path).
	sql  *sql.Selector
	path func(context.Context) (*sql.Selector, error)
}

// Where adds a new predicate for the AllowListItemQuery builder.
func (aliq *AllowListItemQuery) Where(ps ...predicate.AllowListItem) *AllowListItemQuery {
	aliq.predicates = append(aliq.predicates, ps...)
	return aliq
}

// Limit the number of records to be returned by this query.
func (aliq *AllowListItemQuery) Limit(limit int) *AllowListItemQuery {
	aliq.ctx.Limit = &limit
	return aliq
}

// Offset to start from.
func (aliq *AllowListItemQuery) Offset(offset int) *AllowListItemQuery {
	aliq.ctx.Offset = &offset
	return aliq
}

// Unique configures the query builder to filter duplicate records on query.
// By default, unique is set to true, and can be disabled using this method.
func (aliq *AllowListItemQuery) Unique(unique bool) *AllowListItemQuery {
	aliq.ctx.Unique = &unique
	return aliq
}

// Order specifies how the records should be ordered.
func (aliq *AllowListItemQuery) Order(o ...allowlistitem.OrderOption) *AllowListItemQuery {
	aliq.order = append(aliq.order, o...)
	return aliq
}

// QueryAllowlist chains the current query on the "allowlist" edge.
func (aliq *AllowListItemQuery) QueryAllowlist() *AllowListQuery {
	query := (&AllowListClient{config: aliq.config}).Query()
	query.path = func(ctx context.Context) (fromU *sql.Selector, err error) {
		if err := aliq.prepareQuery(ctx); err != nil {
			return nil, err
		}
		selector := aliq.sqlQuery(ctx)
		if err := selector.Err(); err != nil {
			return nil, err
		}
		step := sqlgraph.NewStep(
			sqlgraph.From(allowlistitem.Table, allowlistitem.FieldID, selector),
			sqlgraph.To(allowlist.Table, allowlist.FieldID),
			sqlgraph.Edge(sqlgraph.M2M, true, allowlistitem.AllowlistTable, allowlistitem.AllowlistPrimaryKey...),
		)
		fromU = sqlgraph.SetNeighbors(aliq.driver.Dialect(), step)
		return fromU, nil
	}
	return query
}

// First returns the first AllowListItem entity from the query.
// Returns a *NotFoundError when no AllowListItem was found.
func (aliq *AllowListItemQuery) First(ctx context.Context) (*AllowListItem, error) {
	nodes, err := aliq.Limit(1).All(setContextOp(ctx, aliq.ctx, ent.OpQueryFirst))
	if err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nil, &NotFoundError{allowlistitem.Label}
	}
	return nodes[0], nil
}

// FirstX is like First, but panics if an error occurs.
func (aliq *AllowListItemQuery) FirstX(ctx context.Context) *AllowListItem {
	node, err := aliq.First(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return node
}

// FirstID returns the first AllowListItem ID from the query.
// Returns a *NotFoundError when no AllowListItem ID was found.
func (aliq *AllowListItemQuery) FirstID(ctx context.Context) (id int, err error) {
	var ids []int
	if ids, err = aliq.Limit(1).IDs(setContextOp(ctx, aliq.ctx, ent.OpQueryFirstID)); err != nil {
		return
	}
	if len(ids) == 0 {
		err = &NotFoundError{allowlistitem.Label}
		return
	}
	return ids[0], nil
}

// FirstIDX is like FirstID, but panics if an error occurs.
func (aliq *AllowListItemQuery) FirstIDX(ctx context.Context) int {
	id, err := aliq.FirstID(ctx)
	if err != nil && !IsNotFound(err) {
		panic(err)
	}
	return id
}

// Only returns a single AllowListItem entity found by the query, ensuring it only returns one.
// Returns a *NotSingularError when more than one AllowListItem entity is found.
// Returns a *NotFoundError when no AllowListItem entities are found.
func (aliq *AllowListItemQuery) Only(ctx context.Context) (*AllowListItem, error) {
	nodes, err := aliq.Limit(2).All(setContextOp(ctx, aliq.ctx, ent.OpQueryOnly))
	if err != nil {
		return nil, err
	}
	switch len(nodes) {
	case 1:
		return nodes[0], nil
	case 0:
		return nil, &NotFoundError{allowlistitem.Label}
	default:
		return nil, &NotSingularError{allowlistitem.Label}
	}
}

// OnlyX is like Only, but panics if an error occurs.
func (aliq *AllowListItemQuery) OnlyX(ctx context.Context) *AllowListItem {
	node, err := aliq.Only(ctx)
	if err != nil {
		panic(err)
	}
	return node
}

// OnlyID is like Only, but returns the only AllowListItem ID in the query.
// Returns a *NotSingularError when more than one AllowListItem ID is found.
// Returns a *NotFoundError when no entities are found.
func (aliq *AllowListItemQuery) OnlyID(ctx context.Context) (id int, err error) {
	var ids []int
	if ids, err = aliq.Limit(2).IDs(setContextOp(ctx, aliq.ctx, ent.OpQueryOnlyID)); err != nil {
		return
	}
	switch len(ids) {
	case 1:
		id = ids[0]
	case 0:
		err = &NotFoundError{allowlistitem.Label}
	default:
		err = &NotSingularError{allowlistitem.Label}
	}
	return
}

// OnlyIDX is like OnlyID, but panics if an error occurs.
func (aliq *AllowListItemQuery) OnlyIDX(ctx context.Context) int {
	id, err := aliq.OnlyID(ctx)
	if err != nil {
		panic(err)
	}
	return id
}

// All executes the query and returns a list of AllowListItems.
func (aliq *AllowListItemQuery) All(ctx context.Context) ([]*AllowListItem, error) {
	ctx = setContextOp(ctx, aliq.ctx, ent.OpQueryAll)
	if err := aliq.prepareQuery(ctx); err != nil {
		return nil, err
	}
	qr := querierAll[[]*AllowListItem, *AllowListItemQuery]()
	return withInterceptors[[]*AllowListItem](ctx, aliq, qr, aliq.inters)
}

// AllX is like All, but panics if an error occurs.
func (aliq *AllowListItemQuery) AllX(ctx context.Context) []*AllowListItem {
	nodes, err := aliq.All(ctx)
	if err != nil {
		panic(err)
	}
	return nodes
}

// IDs executes the query and returns a list of AllowListItem IDs.
func (aliq *AllowListItemQuery) IDs(ctx context.Context) (ids []int, err error) {
	if aliq.ctx.Unique == nil && aliq.path != nil {
		aliq.Unique(true)
	}
	ctx = setContextOp(ctx, aliq.ctx, ent.OpQueryIDs)
	if err = aliq.Select(allowlistitem.FieldID).Scan(ctx, &ids); err != nil {
		return nil, err
	}
	return ids, nil
}

// IDsX is like IDs, but panics if an error occurs.
func (aliq *AllowListItemQuery) IDsX(ctx context.Context) []int {
	ids, err := aliq.IDs(ctx)
	if err != nil {
		panic(err)
	}
	return ids
}

// Count returns the count of the given query.
func (aliq *AllowListItemQuery) Count(ctx context.Context) (int, error) {
	ctx = setContextOp(ctx, aliq.ctx, ent.OpQueryCount)
	if err := aliq.prepareQuery(ctx); err != nil {
		return 0, err
	}
	return withInterceptors[int](ctx, aliq, querierCount[*AllowListItemQuery](), aliq.inters)
}

// CountX is like Count, but panics if an error occurs.
func (aliq *AllowListItemQuery) CountX(ctx context.Context) int {
	count, err := aliq.Count(ctx)
	if err != nil {
		panic(err)
	}
	return count
}

// Exist returns true if the query has elements in the graph.
func (aliq *AllowListItemQuery) Exist(ctx context.Context) (bool, error) {
	ctx = setContextOp(ctx, aliq.ctx, ent.OpQueryExist)
	switch _, err := aliq.FirstID(ctx); {
	case IsNotFound(err):
		return false, nil
	case err != nil:
		return false, fmt.Errorf("ent: check existence: %w", err)
	default:
		return true, nil
	}
}

// ExistX is like Exist, but panics if an error occurs.
func (aliq *AllowListItemQuery) ExistX(ctx context.Context) bool {
	exist, err := aliq.Exist(ctx)
	if err != nil {
		panic(err)
	}
	return exist
}

// Clone returns a duplicate of the AllowListItemQuery builder, including all associated steps. It can be
// used to prepare common query builders and use them differently after the clone is made.
func (aliq *AllowListItemQuery) Clone() *AllowListItemQuery {
	if aliq == nil {
		return nil
	}
	return &AllowListItemQuery{
		config:        aliq.config,
		ctx:           aliq.ctx.Clone(),
		order:         append([]allowlistitem.OrderOption{}, aliq.order...),
		inters:        append([]Interceptor{}, aliq.inters...),
		predicates:    append([]predicate.AllowListItem{}, aliq.predicates...),
		withAllowlist: aliq.withAllowlist.Clone(),
		// clone intermediate query.
		sql:  aliq.sql.Clone(),
		path: aliq.path,
	}
}

// WithAllowlist tells the query-builder to eager-load the nodes that are connected to
// the "allowlist" edge. The optional arguments are used to configure the query builder of the edge.
func (aliq *AllowListItemQuery) WithAllowlist(opts ...func(*AllowListQuery)) *AllowListItemQuery {
	query := (&AllowListClient{config: aliq.config}).Query()
	for _, opt := range opts {
		opt(query)
	}
	aliq.withAllowlist = query
	return aliq
}

// GroupBy is used to group vertices by one or more fields/columns.
// It is often used with aggregate functions, like: count, max, mean, min, sum.
//
// Example:
//
//	var v []struct {
//		CreatedAt time.Time `json:"created_at,omitempty"`
//		Count int `json:"count,omitempty"`
//	}
//
//	client.AllowListItem.Query().
//		GroupBy(allowlistitem.FieldCreatedAt).
//		Aggregate(ent.Count()).
//		Scan(ctx, &v)
func (aliq *AllowListItemQuery) GroupBy(field string, fields ...string) *AllowListItemGroupBy {
	aliq.ctx.Fields = append([]string{field}, fields...)
	grbuild := &AllowListItemGroupBy{build: aliq}
	grbuild.flds = &aliq.ctx.Fields
	grbuild.label = allowlistitem.Label
	grbuild.scan = grbuild.Scan
	return grbuild
}

// Select allows the selection one or more fields/columns for the given query,
// instead of selecting all fields in the entity.
//
// Example:
//
//	var v []struct {
//		CreatedAt time.Time `json:"created_at,omitempty"`
//	}
//
//	client.AllowListItem.Query().
//		Select(allowlistitem.FieldCreatedAt).
//		Scan(ctx, &v)
func (aliq *AllowListItemQuery) Select(fields ...string) *AllowListItemSelect {
	aliq.ctx.Fields = append(aliq.ctx.Fields, fields...)
	sbuild := &AllowListItemSelect{AllowListItemQuery: aliq}
	sbuild.label = allowlistitem.Label
	sbuild.flds, sbuild.scan = &aliq.ctx.Fields, sbuild.Scan
	return sbuild
}

// Aggregate returns a AllowListItemSelect configured with the given aggregations.
func (aliq *AllowListItemQuery) Aggregate(fns ...AggregateFunc) *AllowListItemSelect {
	return aliq.Select().Aggregate(fns...)
}

func (aliq *AllowListItemQuery) prepareQuery(ctx context.Context) error {
	for _, inter := range aliq.inters {
		if inter == nil {
			return fmt.Errorf("ent: uninitialized interceptor (forgotten import ent/runtime?)")
		}
		if trv, ok := inter.(Traverser); ok {
			if err := trv.Traverse(ctx, aliq); err != nil {
				return err
			}
		}
	}
	for _, f := range aliq.ctx.Fields {
		if !allowlistitem.ValidColumn(f) {
			return &ValidationError{Name: f, err: fmt.Errorf("ent: invalid field %q for query", f)}
		}
	}
	if aliq.path != nil {
		prev, err := aliq.path(ctx)
		if err != nil {
			return err
		}
		aliq.sql = prev
	}
	return nil
}

func (aliq *AllowListItemQuery) sqlAll(ctx context.Context, hooks ...queryHook) ([]*AllowListItem, error) {
	var (
		nodes       = []*AllowListItem{}
		_spec       = aliq.querySpec()
		loadedTypes = [1]bool{
			aliq.withAllowlist != nil,
		}
	)
	_spec.ScanValues = func(columns []string) ([]any, error) {
		return (*AllowListItem).scanValues(nil, columns)
	}
	_spec.Assign = func(columns []string, values []any) error {
		node := &AllowListItem{config: aliq.config}
		nodes = append(nodes, node)
		node.Edges.loadedTypes = loadedTypes
		return node.assignValues(columns, values)
	}
	for i := range hooks {
		hooks[i](ctx, _spec)
	}
	if err := sqlgraph.QueryNodes(ctx, aliq.driver, _spec); err != nil {
		return nil, err
	}
	if len(nodes) == 0 {
		return nodes, nil
	}
	if query := aliq.withAllowlist; query != nil {
		if err := aliq.loadAllowlist(ctx, query, nodes,
			func(n *AllowListItem) { n.Edges.Allowlist = []*AllowList{} },
			func(n *AllowListItem, e *AllowList) { n.Edges.Allowlist = append(n.Edges.Allowlist, e) }); err != nil {
			return nil, err
		}
	}
	return nodes, nil
}

func (aliq *AllowListItemQuery) loadAllowlist(ctx context.Context, query *AllowListQuery, nodes []*AllowListItem, init func(*AllowListItem), assign func(*AllowListItem, *AllowList)) error {
	edgeIDs := make([]driver.Value, len(nodes))
	byID := make(map[int]*AllowListItem)
	nids := make(map[int]map[*AllowListItem]struct{})
	for i, node := range nodes {
		edgeIDs[i] = node.ID
		byID[node.ID] = node
		if init != nil {
			init(node)
		}
	}
	query.Where(func(s *sql.Selector) {
		joinT := sql.Table(allowlistitem.AllowlistTable)
		s.Join(joinT).On(s.C(allowlist.FieldID), joinT.C(allowlistitem.AllowlistPrimaryKey[0]))
		s.Where(sql.InValues(joinT.C(allowlistitem.AllowlistPrimaryKey[1]), edgeIDs...))
		columns := s.SelectedColumns()
		s.Select(joinT.C(allowlistitem.AllowlistPrimaryKey[1]))
		s.AppendSelect(columns...)
		s.SetDistinct(false)
	})
	if err := query.prepareQuery(ctx); err != nil {
		return err
	}
	qr := QuerierFunc(func(ctx context.Context, q Query) (Value, error) {
		return query.sqlAll(ctx, func(_ context.Context, spec *sqlgraph.QuerySpec) {
			assign := spec.Assign
			values := spec.ScanValues
			spec.ScanValues = func(columns []string) ([]any, error) {
				values, err := values(columns[1:])
				if err != nil {
					return nil, err
				}
				return append([]any{new(sql.NullInt64)}, values...), nil
			}
			spec.Assign = func(columns []string, values []any) error {
				outValue := int(values[0].(*sql.NullInt64).Int64)
				inValue := int(values[1].(*sql.NullInt64).Int64)
				if nids[inValue] == nil {
					nids[inValue] = map[*AllowListItem]struct{}{byID[outValue]: {}}
					return assign(columns[1:], values[1:])
				}
				nids[inValue][byID[outValue]] = struct{}{}
				return nil
			}
		})
	})
	neighbors, err := withInterceptors[[]*AllowList](ctx, query, qr, query.inters)
	if err != nil {
		return err
	}
	for _, n := range neighbors {
		nodes, ok := nids[n.ID]
		if !ok {
			return fmt.Errorf(`unexpected "allowlist" node returned %v`, n.ID)
		}
		for kn := range nodes {
			assign(kn, n)
		}
	}
	return nil
}

func (aliq *AllowListItemQuery) sqlCount(ctx context.Context) (int, error) {
	_spec := aliq.querySpec()
	_spec.Node.Columns = aliq.ctx.Fields
	if len(aliq.ctx.Fields) > 0 {
		_spec.Unique = aliq.ctx.Unique != nil && *aliq.ctx.Unique
	}
	return sqlgraph.CountNodes(ctx, aliq.driver, _spec)
}

func (aliq *AllowListItemQuery) querySpec() *sqlgraph.QuerySpec {
	_spec := sqlgraph.NewQuerySpec(allowlistitem.Table, allowlistitem.Columns, sqlgraph.NewFieldSpec(allowlistitem.FieldID, field.TypeInt))
	_spec.From = aliq.sql
	if unique := aliq.ctx.Unique; unique != nil {
		_spec.Unique = *unique
	} else if aliq.path != nil {
		_spec.Unique = true
	}
	if fields := aliq.ctx.Fields; len(fields) > 0 {
		_spec.Node.Columns = make([]string, 0, len(fields))
		_spec.Node.Columns = append(_spec.Node.Columns, allowlistitem.FieldID)
		for i := range fields {
			if fields[i] != allowlistitem.FieldID {
				_spec.Node.Columns = append(_spec.Node.Columns, fields[i])
			}
		}
	}
	if ps := aliq.predicates; len(ps) > 0 {
		_spec.Predicate = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	if limit := aliq.ctx.Limit; limit != nil {
		_spec.Limit = *limit
	}
	if offset := aliq.ctx.Offset; offset != nil {
		_spec.Offset = *offset
	}
	if ps := aliq.order; len(ps) > 0 {
		_spec.Order = func(selector *sql.Selector) {
			for i := range ps {
				ps[i](selector)
			}
		}
	}
	return _spec
}

func (aliq *AllowListItemQuery) sqlQuery(ctx context.Context) *sql.Selector {
	builder := sql.Dialect(aliq.driver.Dialect())
	t1 := builder.Table(allowlistitem.Table)
	columns := aliq.ctx.Fields
	if len(columns) == 0 {
		columns = allowlistitem.Columns
	}
	selector := builder.Select(t1.Columns(columns...)...).From(t1)
	if aliq.sql != nil {
		selector = aliq.sql
		selector.Select(selector.Columns(columns...)...)
	}
	if aliq.ctx.Unique != nil && *aliq.ctx.Unique {
		selector.Distinct()
	}
	for _, p := range aliq.predicates {
		p(selector)
	}
	for _, p := range aliq.order {
		p(selector)
	}
	if offset := aliq.ctx.Offset; offset != nil {
		// limit is mandatory for offset clause. We start
		// with default value, and override it below if needed.
		selector.Offset(*offset).Limit(math.MaxInt32)
	}
	if limit := aliq.ctx.Limit; limit != nil {
		selector.Limit(*limit)
	}
	return selector
}

// AllowListItemGroupBy is the group-by builder for AllowListItem entities.
type AllowListItemGroupBy struct {
	selector
	build *AllowListItemQuery
}

// Aggregate adds the given aggregation functions to the group-by query.
func (aligb *AllowListItemGroupBy) Aggregate(fns ...AggregateFunc) *AllowListItemGroupBy {
	aligb.fns = append(aligb.fns, fns...)
	return aligb
}

// Scan applies the selector query and scans the result into the given value.
func (aligb *AllowListItemGroupBy) Scan(ctx context.Context, v any) error {
	ctx = setContextOp(ctx, aligb.build.ctx, ent.OpQueryGroupBy)
	if err := aligb.build.prepareQuery(ctx); err != nil {
		return err
	}
	return scanWithInterceptors[*AllowListItemQuery, *AllowListItemGroupBy](ctx, aligb.build, aligb, aligb.build.inters, v)
}

func (aligb *AllowListItemGroupBy) sqlScan(ctx context.Context, root *AllowListItemQuery, v any) error {
	selector := root.sqlQuery(ctx).Select()
	aggregation := make([]string, 0, len(aligb.fns))
	for _, fn := range aligb.fns {
		aggregation = append(aggregation, fn(selector))
	}
	if len(selector.SelectedColumns()) == 0 {
		columns := make([]string, 0, len(*aligb.flds)+len(aligb.fns))
		for _, f := range *aligb.flds {
			columns = append(columns, selector.C(f))
		}
		columns = append(columns, aggregation...)
		selector.Select(columns...)
	}
	selector.GroupBy(selector.Columns(*aligb.flds...)...)
	if err := selector.Err(); err != nil {
		return err
	}
	rows := &sql.Rows{}
	query, args := selector.Query()
	if err := aligb.build.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}

// AllowListItemSelect is the builder for selecting fields of AllowListItem entities.
type AllowListItemSelect struct {
	*AllowListItemQuery
	selector
}

// Aggregate adds the given aggregation functions to the selector query.
func (alis *AllowListItemSelect) Aggregate(fns ...AggregateFunc) *AllowListItemSelect {
	alis.fns = append(alis.fns, fns...)
	return alis
}

// Scan applies the selector query and scans the result into the given value.
func (alis *AllowListItemSelect) Scan(ctx context.Context, v any) error {
	ctx = setContextOp(ctx, alis.ctx, ent.OpQuerySelect)
	if err := alis.prepareQuery(ctx); err != nil {
		return err
	}
	return scanWithInterceptors[*AllowListItemQuery, *AllowListItemSelect](ctx, alis.AllowListItemQuery, alis, alis.inters, v)
}

func (alis *AllowListItemSelect) sqlScan(ctx context.Context, root *AllowListItemQuery, v any) error {
	selector := root.sqlQuery(ctx)
	aggregation := make([]string, 0, len(alis.fns))
	for _, fn := range alis.fns {
		aggregation = append(aggregation, fn(selector))
	}
	switch n := len(*alis.selector.flds); {
	case n == 0 && len(aggregation) > 0:
		selector.Select(aggregation...)
	case n != 0 && len(aggregation) > 0:
		selector.AppendSelect(aggregation...)
	}
	rows := &sql.Rows{}
	query, args := selector.Query()
	if err := alis.driver.Query(ctx, query, args, rows); err != nil {
		return err
	}
	defer rows.Close()
	return sql.ScanSlice(rows, v)
}
