// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateSkillGroupRequest
type CreateSkillGroupInput struct {
	_ struct{} `type:"structure"`

	// A unique, user-specified identifier for this request that ensures idempotency.
	ClientRequestToken *string `min:"10" type:"string" idempotencyToken:"true"`

	// The description for the skill group.
	Description *string `min:"1" type:"string"`

	// The name for the skill group.
	//
	// SkillGroupName is a required field
	SkillGroupName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateSkillGroupInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSkillGroupInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateSkillGroupInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 10 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientRequestToken", 10))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}

	if s.SkillGroupName == nil {
		invalidParams.Add(aws.NewErrParamRequired("SkillGroupName"))
	}
	if s.SkillGroupName != nil && len(*s.SkillGroupName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SkillGroupName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateSkillGroupResponse
type CreateSkillGroupOutput struct {
	_ struct{} `type:"structure"`

	// The ARN of the newly created skill group in the response.
	SkillGroupArn *string `type:"string"`
}

// String returns the string representation
func (s CreateSkillGroupOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateSkillGroup = "CreateSkillGroup"

// CreateSkillGroupRequest returns a request value for making API operation for
// Alexa For Business.
//
// Creates a skill group with a specified name and description.
//
//    // Example sending a request using CreateSkillGroupRequest.
//    req := client.CreateSkillGroupRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/CreateSkillGroup
func (c *Client) CreateSkillGroupRequest(input *CreateSkillGroupInput) CreateSkillGroupRequest {
	op := &aws.Operation{
		Name:       opCreateSkillGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSkillGroupInput{}
	}

	req := c.newRequest(op, input, &CreateSkillGroupOutput{})
	return CreateSkillGroupRequest{Request: req, Input: input, Copy: c.CreateSkillGroupRequest}
}

// CreateSkillGroupRequest is the request type for the
// CreateSkillGroup API operation.
type CreateSkillGroupRequest struct {
	*aws.Request
	Input *CreateSkillGroupInput
	Copy  func(*CreateSkillGroupInput) CreateSkillGroupRequest
}

// Send marshals and sends the CreateSkillGroup API request.
func (r CreateSkillGroupRequest) Send(ctx context.Context) (*CreateSkillGroupResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateSkillGroupResponse{
		CreateSkillGroupOutput: r.Request.Data.(*CreateSkillGroupOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateSkillGroupResponse is the response type for the
// CreateSkillGroup API operation.
type CreateSkillGroupResponse struct {
	*CreateSkillGroupOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateSkillGroup request.
func (r *CreateSkillGroupResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
