// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

// Requests API Gateway to flush a stage's cache.
type FlushStageCacheInput struct {
	_ struct{} `type:"structure"`

	// [Required] The string identifier of the associated RestApi.
	//
	// RestApiId is a required field
	RestApiId *string `location:"uri" locationName:"restapi_id" type:"string" required:"true"`

	// [Required] The name of the stage to flush its cache.
	//
	// StageName is a required field
	StageName *string `location:"uri" locationName:"stage_name" type:"string" required:"true"`
}

// String returns the string representation
func (s FlushStageCacheInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FlushStageCacheInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "FlushStageCacheInput"}

	if s.RestApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("RestApiId"))
	}

	if s.StageName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StageName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FlushStageCacheInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.RestApiId != nil {
		v := *s.RestApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "restapi_id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StageName != nil {
		v := *s.StageName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "stage_name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type FlushStageCacheOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s FlushStageCacheOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FlushStageCacheOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opFlushStageCache = "FlushStageCache"

// FlushStageCacheRequest returns a request value for making API operation for
// Amazon API Gateway.
//
// Flushes a stage's cache.
//
//    // Example sending a request using FlushStageCacheRequest.
//    req := client.FlushStageCacheRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) FlushStageCacheRequest(input *FlushStageCacheInput) FlushStageCacheRequest {
	op := &aws.Operation{
		Name:       opFlushStageCache,
		HTTPMethod: "DELETE",
		HTTPPath:   "/restapis/{restapi_id}/stages/{stage_name}/cache/data",
	}

	if input == nil {
		input = &FlushStageCacheInput{}
	}

	req := c.newRequest(op, input, &FlushStageCacheOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return FlushStageCacheRequest{Request: req, Input: input, Copy: c.FlushStageCacheRequest}
}

// FlushStageCacheRequest is the request type for the
// FlushStageCache API operation.
type FlushStageCacheRequest struct {
	*aws.Request
	Input *FlushStageCacheInput
	Copy  func(*FlushStageCacheInput) FlushStageCacheRequest
}

// Send marshals and sends the FlushStageCache API request.
func (r FlushStageCacheRequest) Send(ctx context.Context) (*FlushStageCacheResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &FlushStageCacheResponse{
		FlushStageCacheOutput: r.Request.Data.(*FlushStageCacheOutput),
		response:              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// FlushStageCacheResponse is the response type for the
// FlushStageCache API operation.
type FlushStageCacheResponse struct {
	*FlushStageCacheOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// FlushStageCache request.
func (r *FlushStageCacheResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
