// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListVoiceConnectorTerminationCredentialsRequest
type ListVoiceConnectorTerminationCredentialsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Chime Voice Connector ID.
	//
	// VoiceConnectorId is a required field
	VoiceConnectorId *string `location:"uri" locationName:"voiceConnectorId" type:"string" required:"true"`
}

// String returns the string representation
func (s ListVoiceConnectorTerminationCredentialsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListVoiceConnectorTerminationCredentialsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListVoiceConnectorTerminationCredentialsInput"}

	if s.VoiceConnectorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VoiceConnectorId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListVoiceConnectorTerminationCredentialsInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.VoiceConnectorId != nil {
		v := *s.VoiceConnectorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "voiceConnectorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListVoiceConnectorTerminationCredentialsResponse
type ListVoiceConnectorTerminationCredentialsOutput struct {
	_ struct{} `type:"structure"`

	// A list of user names.
	Usernames []string `type:"list"`
}

// String returns the string representation
func (s ListVoiceConnectorTerminationCredentialsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListVoiceConnectorTerminationCredentialsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Usernames) > 0 {
		v := s.Usernames

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "Usernames", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

const opListVoiceConnectorTerminationCredentials = "ListVoiceConnectorTerminationCredentials"

// ListVoiceConnectorTerminationCredentialsRequest returns a request value for making API operation for
// Amazon Chime.
//
// Lists the SIP credentials for the specified Amazon Chime Voice Connector.
//
//    // Example sending a request using ListVoiceConnectorTerminationCredentialsRequest.
//    req := client.ListVoiceConnectorTerminationCredentialsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListVoiceConnectorTerminationCredentials
func (c *Client) ListVoiceConnectorTerminationCredentialsRequest(input *ListVoiceConnectorTerminationCredentialsInput) ListVoiceConnectorTerminationCredentialsRequest {
	op := &aws.Operation{
		Name:       opListVoiceConnectorTerminationCredentials,
		HTTPMethod: "GET",
		HTTPPath:   "/voice-connectors/{voiceConnectorId}/termination/credentials",
	}

	if input == nil {
		input = &ListVoiceConnectorTerminationCredentialsInput{}
	}

	req := c.newRequest(op, input, &ListVoiceConnectorTerminationCredentialsOutput{})
	return ListVoiceConnectorTerminationCredentialsRequest{Request: req, Input: input, Copy: c.ListVoiceConnectorTerminationCredentialsRequest}
}

// ListVoiceConnectorTerminationCredentialsRequest is the request type for the
// ListVoiceConnectorTerminationCredentials API operation.
type ListVoiceConnectorTerminationCredentialsRequest struct {
	*aws.Request
	Input *ListVoiceConnectorTerminationCredentialsInput
	Copy  func(*ListVoiceConnectorTerminationCredentialsInput) ListVoiceConnectorTerminationCredentialsRequest
}

// Send marshals and sends the ListVoiceConnectorTerminationCredentials API request.
func (r ListVoiceConnectorTerminationCredentialsRequest) Send(ctx context.Context) (*ListVoiceConnectorTerminationCredentialsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListVoiceConnectorTerminationCredentialsResponse{
		ListVoiceConnectorTerminationCredentialsOutput: r.Request.Data.(*ListVoiceConnectorTerminationCredentialsOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListVoiceConnectorTerminationCredentialsResponse is the response type for the
// ListVoiceConnectorTerminationCredentials API operation.
type ListVoiceConnectorTerminationCredentialsResponse struct {
	*ListVoiceConnectorTerminationCredentialsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListVoiceConnectorTerminationCredentials request.
func (r *ListVoiceConnectorTerminationCredentialsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
