// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package clouddirectory

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListPublishedSchemaArnsRequest
type ListPublishedSchemaArnsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to retrieve.
	MaxResults *int64 `min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `type:"string"`

	// The response for ListPublishedSchemaArns when this parameter is used will
	// list all minor version ARNs for a major version.
	SchemaArn *string `type:"string"`
}

// String returns the string representation
func (s ListPublishedSchemaArnsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPublishedSchemaArnsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListPublishedSchemaArnsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListPublishedSchemaArnsInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.SchemaArn != nil {
		v := *s.SchemaArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "SchemaArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListPublishedSchemaArnsResponse
type ListPublishedSchemaArnsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token.
	NextToken *string `type:"string"`

	// The ARNs of published schemas.
	SchemaArns []string `type:"list"`
}

// String returns the string representation
func (s ListPublishedSchemaArnsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListPublishedSchemaArnsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.SchemaArns) > 0 {
		v := s.SchemaArns

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SchemaArns", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

const opListPublishedSchemaArns = "ListPublishedSchemaArns"

// ListPublishedSchemaArnsRequest returns a request value for making API operation for
// Amazon CloudDirectory.
//
// Lists the major version families of each published schema. If a major version
// ARN is provided as SchemaArn, the minor version revisions in that family
// are listed instead.
//
//    // Example sending a request using ListPublishedSchemaArnsRequest.
//    req := client.ListPublishedSchemaArnsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/clouddirectory-2017-01-11/ListPublishedSchemaArns
func (c *Client) ListPublishedSchemaArnsRequest(input *ListPublishedSchemaArnsInput) ListPublishedSchemaArnsRequest {
	op := &aws.Operation{
		Name:       opListPublishedSchemaArns,
		HTTPMethod: "POST",
		HTTPPath:   "/amazonclouddirectory/2017-01-11/schema/published",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPublishedSchemaArnsInput{}
	}

	req := c.newRequest(op, input, &ListPublishedSchemaArnsOutput{})
	return ListPublishedSchemaArnsRequest{Request: req, Input: input, Copy: c.ListPublishedSchemaArnsRequest}
}

// ListPublishedSchemaArnsRequest is the request type for the
// ListPublishedSchemaArns API operation.
type ListPublishedSchemaArnsRequest struct {
	*aws.Request
	Input *ListPublishedSchemaArnsInput
	Copy  func(*ListPublishedSchemaArnsInput) ListPublishedSchemaArnsRequest
}

// Send marshals and sends the ListPublishedSchemaArns API request.
func (r ListPublishedSchemaArnsRequest) Send(ctx context.Context) (*ListPublishedSchemaArnsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListPublishedSchemaArnsResponse{
		ListPublishedSchemaArnsOutput: r.Request.Data.(*ListPublishedSchemaArnsOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListPublishedSchemaArnsRequestPaginator returns a paginator for ListPublishedSchemaArns.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListPublishedSchemaArnsRequest(input)
//   p := clouddirectory.NewListPublishedSchemaArnsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListPublishedSchemaArnsPaginator(req ListPublishedSchemaArnsRequest) ListPublishedSchemaArnsPaginator {
	return ListPublishedSchemaArnsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListPublishedSchemaArnsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListPublishedSchemaArnsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListPublishedSchemaArnsPaginator struct {
	aws.Pager
}

func (p *ListPublishedSchemaArnsPaginator) CurrentPage() *ListPublishedSchemaArnsOutput {
	return p.Pager.CurrentPage().(*ListPublishedSchemaArnsOutput)
}

// ListPublishedSchemaArnsResponse is the response type for the
// ListPublishedSchemaArns API operation.
type ListPublishedSchemaArnsResponse struct {
	*ListPublishedSchemaArnsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListPublishedSchemaArns request.
func (r *ListPublishedSchemaArnsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
