// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package cloudwatcheventsiface provides an interface to enable mocking the Amazon CloudWatch Events service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package cloudwatcheventsiface

import (
	"github.com/aws/aws-sdk-go-v2/service/cloudwatchevents"
)

// ClientAPI provides an interface to enable mocking the
// cloudwatchevents.Client methods. This make unit testing your code that
// calls out to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon CloudWatch Events.
//    func myFunc(svc cloudwatcheventsiface.ClientAPI) bool {
//        // Make svc.DeleteRule request
//    }
//
//    func main() {
//        cfg, err := external.LoadDefaultAWSConfig()
//        if err != nil {
//            panic("failed to load config, " + err.Error())
//        }
//
//        svc := cloudwatchevents.New(cfg)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockClientClient struct {
//        cloudwatcheventsiface.ClientPI
//    }
//    func (m *mockClientClient) DeleteRule(input *cloudwatchevents.DeleteRuleInput) (*cloudwatchevents.DeleteRuleOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockClientClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ClientAPI interface {
	DeleteRuleRequest(*cloudwatchevents.DeleteRuleInput) cloudwatchevents.DeleteRuleRequest

	DescribeEventBusRequest(*cloudwatchevents.DescribeEventBusInput) cloudwatchevents.DescribeEventBusRequest

	DescribeRuleRequest(*cloudwatchevents.DescribeRuleInput) cloudwatchevents.DescribeRuleRequest

	DisableRuleRequest(*cloudwatchevents.DisableRuleInput) cloudwatchevents.DisableRuleRequest

	EnableRuleRequest(*cloudwatchevents.EnableRuleInput) cloudwatchevents.EnableRuleRequest

	ListRuleNamesByTargetRequest(*cloudwatchevents.ListRuleNamesByTargetInput) cloudwatchevents.ListRuleNamesByTargetRequest

	ListRulesRequest(*cloudwatchevents.ListRulesInput) cloudwatchevents.ListRulesRequest

	ListTagsForResourceRequest(*cloudwatchevents.ListTagsForResourceInput) cloudwatchevents.ListTagsForResourceRequest

	ListTargetsByRuleRequest(*cloudwatchevents.ListTargetsByRuleInput) cloudwatchevents.ListTargetsByRuleRequest

	PutEventsRequest(*cloudwatchevents.PutEventsInput) cloudwatchevents.PutEventsRequest

	PutPermissionRequest(*cloudwatchevents.PutPermissionInput) cloudwatchevents.PutPermissionRequest

	PutRuleRequest(*cloudwatchevents.PutRuleInput) cloudwatchevents.PutRuleRequest

	PutTargetsRequest(*cloudwatchevents.PutTargetsInput) cloudwatchevents.PutTargetsRequest

	RemovePermissionRequest(*cloudwatchevents.RemovePermissionInput) cloudwatchevents.RemovePermissionRequest

	RemoveTargetsRequest(*cloudwatchevents.RemoveTargetsInput) cloudwatchevents.RemoveTargetsRequest

	TagResourceRequest(*cloudwatchevents.TagResourceInput) cloudwatchevents.TagResourceRequest

	TestEventPatternRequest(*cloudwatchevents.TestEventPatternInput) cloudwatchevents.TestEventPatternRequest

	UntagResourceRequest(*cloudwatchevents.UntagResourceInput) cloudwatchevents.UntagResourceRequest
}

var _ ClientAPI = (*cloudwatchevents.Client)(nil)
