// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codebuild

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/UpdateWebhookInput
type UpdateWebhookInput struct {
	_ struct{} `type:"structure"`

	// A regular expression used to determine which repository branches are built
	// when a webhook is triggered. If the name of a branch matches the regular
	// expression, then it is built. If branchFilter is empty, then all branches
	// are built.
	//
	// It is recommended that you use filterGroups instead of branchFilter.
	BranchFilter *string `locationName:"branchFilter" type:"string"`

	// An array of arrays of WebhookFilter objects used to determine if a webhook
	// event can trigger a build. A filter group must pcontain at least one EVENT
	// WebhookFilter.
	FilterGroups [][]WebhookFilter `locationName:"filterGroups" type:"list"`

	// The name of the AWS CodeBuild project.
	//
	// ProjectName is a required field
	ProjectName *string `locationName:"projectName" min:"2" type:"string" required:"true"`

	// A boolean value that specifies whether the associated GitHub repository's
	// secret token should be updated. If you use Bitbucket for your repository,
	// rotateSecret is ignored.
	RotateSecret *bool `locationName:"rotateSecret" type:"boolean"`
}

// String returns the string representation
func (s UpdateWebhookInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateWebhookInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateWebhookInput"}

	if s.ProjectName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ProjectName"))
	}
	if s.ProjectName != nil && len(*s.ProjectName) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("ProjectName", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/UpdateWebhookOutput
type UpdateWebhookOutput struct {
	_ struct{} `type:"structure"`

	// Information about a repository's webhook that is associated with a project
	// in AWS CodeBuild.
	Webhook *Webhook `locationName:"webhook" type:"structure"`
}

// String returns the string representation
func (s UpdateWebhookOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateWebhook = "UpdateWebhook"

// UpdateWebhookRequest returns a request value for making API operation for
// AWS CodeBuild.
//
// Updates the webhook associated with an AWS CodeBuild build project.
//
// If you use Bitbucket for your repository, rotateSecret is ignored.
//
//    // Example sending a request using UpdateWebhookRequest.
//    req := client.UpdateWebhookRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codebuild-2016-10-06/UpdateWebhook
func (c *Client) UpdateWebhookRequest(input *UpdateWebhookInput) UpdateWebhookRequest {
	op := &aws.Operation{
		Name:       opUpdateWebhook,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateWebhookInput{}
	}

	req := c.newRequest(op, input, &UpdateWebhookOutput{})
	return UpdateWebhookRequest{Request: req, Input: input, Copy: c.UpdateWebhookRequest}
}

// UpdateWebhookRequest is the request type for the
// UpdateWebhook API operation.
type UpdateWebhookRequest struct {
	*aws.Request
	Input *UpdateWebhookInput
	Copy  func(*UpdateWebhookInput) UpdateWebhookRequest
}

// Send marshals and sends the UpdateWebhook API request.
func (r UpdateWebhookRequest) Send(ctx context.Context) (*UpdateWebhookResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateWebhookResponse{
		UpdateWebhookOutput: r.Request.Data.(*UpdateWebhookOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateWebhookResponse is the response type for the
// UpdateWebhook API operation.
type UpdateWebhookResponse struct {
	*UpdateWebhookOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateWebhook request.
func (r *UpdateWebhookResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
