// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package configservice

import (
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

var _ aws.Config
var _ = awsutil.Prettify

// A collection of accounts and regions.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/AccountAggregationSource
type AccountAggregationSource struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the account being aggregated.
	//
	// AccountIds is a required field
	AccountIds []string `min:"1" type:"list" required:"true"`

	// If true, aggregate existing AWS Config regions and future regions.
	AllAwsRegions *bool `type:"boolean"`

	// The source regions being aggregated.
	AwsRegions []string `min:"1" type:"list"`
}

// String returns the string representation
func (s AccountAggregationSource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccountAggregationSource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AccountAggregationSource"}

	if s.AccountIds == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountIds"))
	}
	if s.AccountIds != nil && len(s.AccountIds) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AccountIds", 1))
	}
	if s.AwsRegions != nil && len(s.AwsRegions) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AwsRegions", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Indicates whether an AWS Config rule is compliant based on account ID, region,
// compliance, and rule name.
//
// A rule is compliant if all of the resources that the rule evaluated comply
// with it. It is noncompliant if any of these resources do not comply.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/AggregateComplianceByConfigRule
type AggregateComplianceByConfigRule struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the source account.
	AccountId *string `type:"string"`

	// The source region from where the data is aggregated.
	AwsRegion *string `min:"1" type:"string"`

	// Indicates whether an AWS resource or AWS Config rule is compliant and provides
	// the number of contributors that affect the compliance.
	Compliance *Compliance `type:"structure"`

	// The name of the AWS Config rule.
	ConfigRuleName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AggregateComplianceByConfigRule) String() string {
	return awsutil.Prettify(s)
}

// Returns the number of compliant and noncompliant rules for one or more accounts
// and regions in an aggregator.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/AggregateComplianceCount
type AggregateComplianceCount struct {
	_ struct{} `type:"structure"`

	// The number of compliant and noncompliant AWS Config rules.
	ComplianceSummary *ComplianceSummary `type:"structure"`

	// The 12-digit account ID or region based on the GroupByKey value.
	GroupName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s AggregateComplianceCount) String() string {
	return awsutil.Prettify(s)
}

// The details of an AWS Config evaluation for an account ID and region in an
// aggregator. Provides the AWS resource that was evaluated, the compliance
// of the resource, related time stamps, and supplementary information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/AggregateEvaluationResult
type AggregateEvaluationResult struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the source account.
	AccountId *string `type:"string"`

	// Supplementary information about how the agrregate evaluation determined the
	// compliance.
	Annotation *string `min:"1" type:"string"`

	// The source region from where the data is aggregated.
	AwsRegion *string `min:"1" type:"string"`

	// The resource compliance status.
	//
	// For the AggregationEvaluationResult data type, AWS Config supports only the
	// COMPLIANT and NON_COMPLIANT. AWS Config does not support the NOT_APPLICABLE
	// and INSUFFICIENT_DATA value.
	ComplianceType ComplianceType `type:"string" enum:"true"`

	// The time when the AWS Config rule evaluated the AWS resource.
	ConfigRuleInvokedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Uniquely identifies the evaluation result.
	EvaluationResultIdentifier *EvaluationResultIdentifier `type:"structure"`

	// The time when AWS Config recorded the aggregate evaluation result.
	ResultRecordedTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s AggregateEvaluationResult) String() string {
	return awsutil.Prettify(s)
}

// The details that identify a resource that is collected by AWS Config aggregator,
// including the resource type, ID, (if available) the custom resource name,
// the source account, and source region.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/AggregateResourceIdentifier
type AggregateResourceIdentifier struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS resource.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The name of the AWS resource.
	ResourceName *string `type:"string"`

	// The type of the AWS resource.
	//
	// ResourceType is a required field
	ResourceType ResourceType `type:"string" required:"true" enum:"true"`

	// The 12-digit account ID of the source account.
	//
	// SourceAccountId is a required field
	SourceAccountId *string `type:"string" required:"true"`

	// The source region where data is aggregated.
	//
	// SourceRegion is a required field
	SourceRegion *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AggregateResourceIdentifier) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AggregateResourceIdentifier) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AggregateResourceIdentifier"}

	if s.ResourceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceId", 1))
	}
	if len(s.ResourceType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ResourceType"))
	}

	if s.SourceAccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceAccountId"))
	}

	if s.SourceRegion == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceRegion"))
	}
	if s.SourceRegion != nil && len(*s.SourceRegion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SourceRegion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The current sync status between the source and the aggregator account.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/AggregatedSourceStatus
type AggregatedSourceStatus struct {
	_ struct{} `type:"structure"`

	// The region authorized to collect aggregated data.
	AwsRegion *string `min:"1" type:"string"`

	// The error code that AWS Config returned when the source account aggregation
	// last failed.
	LastErrorCode *string `type:"string"`

	// The message indicating that the source account aggregation failed due to
	// an error.
	LastErrorMessage *string `type:"string"`

	// Filters the last updated status type.
	//
	//    * Valid value FAILED indicates errors while moving data.
	//
	//    * Valid value SUCCEEDED indicates the data was successfully moved.
	//
	//    * Valid value OUTDATED indicates the data is not the most recent.
	LastUpdateStatus AggregatedSourceStatusType `type:"string" enum:"true"`

	// The time of the last update.
	LastUpdateTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The source account ID or an organization.
	SourceId *string `type:"string"`

	// The source account or an organization.
	SourceType AggregatedSourceType `type:"string" enum:"true"`
}

// String returns the string representation
func (s AggregatedSourceStatus) String() string {
	return awsutil.Prettify(s)
}

// An object that represents the authorizations granted to aggregator accounts
// and regions.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/AggregationAuthorization
type AggregationAuthorization struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the aggregation object.
	AggregationAuthorizationArn *string `type:"string"`

	// The 12-digit account ID of the account authorized to aggregate data.
	AuthorizedAccountId *string `type:"string"`

	// The region authorized to collect aggregated data.
	AuthorizedAwsRegion *string `min:"1" type:"string"`

	// The time stamp when the aggregation authorization was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s AggregationAuthorization) String() string {
	return awsutil.Prettify(s)
}

// The detailed configuration of a specified resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/BaseConfigurationItem
type BaseConfigurationItem struct {
	_ struct{} `type:"structure"`

	// The 12-digit AWS account ID associated with the resource.
	AccountId *string `locationName:"accountId" type:"string"`

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string `locationName:"arn" type:"string"`

	// The Availability Zone associated with the resource.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The region where the resource resides.
	AwsRegion *string `locationName:"awsRegion" min:"1" type:"string"`

	// The description of the resource configuration.
	Configuration *string `locationName:"configuration" type:"string"`

	// The time when the configuration recording was initiated.
	ConfigurationItemCaptureTime *time.Time `locationName:"configurationItemCaptureTime" type:"timestamp" timestampFormat:"unix"`

	// The configuration item status.
	ConfigurationItemStatus ConfigurationItemStatus `locationName:"configurationItemStatus" type:"string" enum:"true"`

	// An identifier that indicates the ordering of the configuration items of a
	// resource.
	ConfigurationStateId *string `locationName:"configurationStateId" type:"string"`

	// The time stamp when the resource was created.
	ResourceCreationTime *time.Time `locationName:"resourceCreationTime" type:"timestamp" timestampFormat:"unix"`

	// The ID of the resource (for example., sg-xxxxxx).
	ResourceId *string `locationName:"resourceId" min:"1" type:"string"`

	// The custom name of the resource, if available.
	ResourceName *string `locationName:"resourceName" type:"string"`

	// The type of AWS resource.
	ResourceType ResourceType `locationName:"resourceType" type:"string" enum:"true"`

	// Configuration attributes that AWS Config returns for certain resource types
	// to supplement the information returned for the configuration parameter.
	SupplementaryConfiguration map[string]string `locationName:"supplementaryConfiguration" type:"map"`

	// The version number of the resource configuration.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s BaseConfigurationItem) String() string {
	return awsutil.Prettify(s)
}

// Indicates whether an AWS resource or AWS Config rule is compliant and provides
// the number of contributors that affect the compliance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/Compliance
type Compliance struct {
	_ struct{} `type:"structure"`

	// The number of AWS resources or AWS Config rules that cause a result of NON_COMPLIANT,
	// up to a maximum number.
	ComplianceContributorCount *ComplianceContributorCount `type:"structure"`

	// Indicates whether an AWS resource or AWS Config rule is compliant.
	//
	// A resource is compliant if it complies with all of the AWS Config rules that
	// evaluate it. A resource is noncompliant if it does not comply with one or
	// more of these rules.
	//
	// A rule is compliant if all of the resources that the rule evaluates comply
	// with it. A rule is noncompliant if any of these resources do not comply.
	//
	// AWS Config returns the INSUFFICIENT_DATA value when no evaluation results
	// are available for the AWS resource or AWS Config rule.
	//
	// For the Compliance data type, AWS Config supports only COMPLIANT, NON_COMPLIANT,
	// and INSUFFICIENT_DATA values. AWS Config does not support the NOT_APPLICABLE
	// value for the Compliance data type.
	ComplianceType ComplianceType `type:"string" enum:"true"`
}

// String returns the string representation
func (s Compliance) String() string {
	return awsutil.Prettify(s)
}

// Indicates whether an AWS Config rule is compliant. A rule is compliant if
// all of the resources that the rule evaluated comply with it. A rule is noncompliant
// if any of these resources do not comply.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ComplianceByConfigRule
type ComplianceByConfigRule struct {
	_ struct{} `type:"structure"`

	// Indicates whether the AWS Config rule is compliant.
	Compliance *Compliance `type:"structure"`

	// The name of the AWS Config rule.
	ConfigRuleName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ComplianceByConfigRule) String() string {
	return awsutil.Prettify(s)
}

// Indicates whether an AWS resource that is evaluated according to one or more
// AWS Config rules is compliant. A resource is compliant if it complies with
// all of the rules that evaluate it. A resource is noncompliant if it does
// not comply with one or more of these rules.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ComplianceByResource
type ComplianceByResource struct {
	_ struct{} `type:"structure"`

	// Indicates whether the AWS resource complies with all of the AWS Config rules
	// that evaluated it.
	Compliance *Compliance `type:"structure"`

	// The ID of the AWS resource that was evaluated.
	ResourceId *string `min:"1" type:"string"`

	// The type of the AWS resource that was evaluated.
	ResourceType *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ComplianceByResource) String() string {
	return awsutil.Prettify(s)
}

// The number of AWS resources or AWS Config rules responsible for the current
// compliance of the item, up to a maximum number.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ComplianceContributorCount
type ComplianceContributorCount struct {
	_ struct{} `type:"structure"`

	// Indicates whether the maximum count is reached.
	CapExceeded *bool `type:"boolean"`

	// The number of AWS resources or AWS Config rules responsible for the current
	// compliance of the item.
	CappedCount *int64 `type:"integer"`
}

// String returns the string representation
func (s ComplianceContributorCount) String() string {
	return awsutil.Prettify(s)
}

// The number of AWS Config rules or AWS resources that are compliant and noncompliant.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ComplianceSummary
type ComplianceSummary struct {
	_ struct{} `type:"structure"`

	// The time that AWS Config created the compliance summary.
	ComplianceSummaryTimestamp *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The number of AWS Config rules or AWS resources that are compliant, up to
	// a maximum of 25 for rules and 100 for resources.
	CompliantResourceCount *ComplianceContributorCount `type:"structure"`

	// The number of AWS Config rules or AWS resources that are noncompliant, up
	// to a maximum of 25 for rules and 100 for resources.
	NonCompliantResourceCount *ComplianceContributorCount `type:"structure"`
}

// String returns the string representation
func (s ComplianceSummary) String() string {
	return awsutil.Prettify(s)
}

// The number of AWS resources of a specific type that are compliant or noncompliant,
// up to a maximum of 100 for each.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ComplianceSummaryByResourceType
type ComplianceSummaryByResourceType struct {
	_ struct{} `type:"structure"`

	// The number of AWS resources that are compliant or noncompliant, up to a maximum
	// of 100 for each.
	ComplianceSummary *ComplianceSummary `type:"structure"`

	// The type of AWS resource.
	ResourceType *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ComplianceSummaryByResourceType) String() string {
	return awsutil.Prettify(s)
}

// Provides status of the delivery of the snapshot or the configuration history
// to the specified Amazon S3 bucket. Also provides the status of notifications
// about the Amazon S3 delivery to the specified Amazon SNS topic.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ConfigExportDeliveryInfo
type ConfigExportDeliveryInfo struct {
	_ struct{} `type:"structure"`

	// The time of the last attempted delivery.
	LastAttemptTime *time.Time `locationName:"lastAttemptTime" type:"timestamp" timestampFormat:"unix"`

	// The error code from the last attempted delivery.
	LastErrorCode *string `locationName:"lastErrorCode" type:"string"`

	// The error message from the last attempted delivery.
	LastErrorMessage *string `locationName:"lastErrorMessage" type:"string"`

	// Status of the last attempted delivery.
	LastStatus DeliveryStatus `locationName:"lastStatus" type:"string" enum:"true"`

	// The time of the last successful delivery.
	LastSuccessfulTime *time.Time `locationName:"lastSuccessfulTime" type:"timestamp" timestampFormat:"unix"`

	// The time that the next delivery occurs.
	NextDeliveryTime *time.Time `locationName:"nextDeliveryTime" type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s ConfigExportDeliveryInfo) String() string {
	return awsutil.Prettify(s)
}

// An AWS Config rule represents an AWS Lambda function that you create for
// a custom rule or a predefined function for an AWS managed rule. The function
// evaluates configuration items to assess whether your AWS resources comply
// with your desired configurations. This function can run when AWS Config detects
// a configuration change to an AWS resource and at a periodic frequency that
// you choose (for example, every 24 hours).
//
// You can use the AWS CLI and AWS SDKs if you want to create a rule that triggers
// evaluations for your resources when AWS Config delivers the configuration
// snapshot. For more information, see ConfigSnapshotDeliveryProperties.
//
// For more information about developing and using AWS Config rules, see Evaluating
// AWS Resource Configurations with AWS Config (https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config.html)
// in the AWS Config Developer Guide.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ConfigRule
type ConfigRule struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS Config rule.
	ConfigRuleArn *string `type:"string"`

	// The ID of the AWS Config rule.
	ConfigRuleId *string `type:"string"`

	// The name that you assign to the AWS Config rule. The name is required if
	// you are adding a new rule.
	ConfigRuleName *string `min:"1" type:"string"`

	// Indicates whether the AWS Config rule is active or is currently being deleted
	// by AWS Config. It can also indicate the evaluation status for the AWS Config
	// rule.
	//
	// AWS Config sets the state of the rule to EVALUATING temporarily after you
	// use the StartConfigRulesEvaluation request to evaluate your resources against
	// the AWS Config rule.
	//
	// AWS Config sets the state of the rule to DELETING_RESULTS temporarily after
	// you use the DeleteEvaluationResults request to delete the current evaluation
	// results for the AWS Config rule.
	//
	// AWS Config temporarily sets the state of a rule to DELETING after you use
	// the DeleteConfigRule request to delete the rule. After AWS Config deletes
	// the rule, the rule and all of its evaluations are erased and are no longer
	// available.
	ConfigRuleState ConfigRuleState `type:"string" enum:"true"`

	// Service principal name of the service that created the rule.
	//
	// The field is populated only if the service linked rule is created by a service.
	// The field is empty if you create your own rule.
	CreatedBy *string `min:"1" type:"string"`

	// The description that you provide for the AWS Config rule.
	Description *string `type:"string"`

	// A string, in JSON format, that is passed to the AWS Config rule Lambda function.
	InputParameters *string `min:"1" type:"string"`

	// The maximum frequency with which AWS Config runs evaluations for a rule.
	// You can specify a value for MaximumExecutionFrequency when:
	//
	//    * You are using an AWS managed rule that is triggered at a periodic frequency.
	//
	//    * Your custom rule is triggered when AWS Config delivers the configuration
	//    snapshot. For more information, see ConfigSnapshotDeliveryProperties.
	//
	// By default, rules with a periodic trigger are evaluated every 24 hours. To
	// change the frequency, specify a valid value for the MaximumExecutionFrequency
	// parameter.
	MaximumExecutionFrequency MaximumExecutionFrequency `type:"string" enum:"true"`

	// Defines which resources can trigger an evaluation for the rule. The scope
	// can include one or more resource types, a combination of one resource type
	// and one resource ID, or a combination of a tag key and value. Specify a scope
	// to constrain the resources that can trigger an evaluation for the rule. If
	// you do not specify a scope, evaluations are triggered when any resource in
	// the recording group changes.
	Scope *Scope `type:"structure"`

	// Provides the rule owner (AWS or customer), the rule identifier, and the notifications
	// that cause the function to evaluate your AWS resources.
	//
	// Source is a required field
	Source *Source `type:"structure" required:"true"`
}

// String returns the string representation
func (s ConfigRule) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigRule) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ConfigRule"}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ConfigRuleName", 1))
	}
	if s.CreatedBy != nil && len(*s.CreatedBy) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CreatedBy", 1))
	}
	if s.InputParameters != nil && len(*s.InputParameters) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("InputParameters", 1))
	}

	if s.Source == nil {
		invalidParams.Add(aws.NewErrParamRequired("Source"))
	}
	if s.Scope != nil {
		if err := s.Scope.Validate(); err != nil {
			invalidParams.AddNested("Scope", err.(aws.ErrInvalidParams))
		}
	}
	if s.Source != nil {
		if err := s.Source.Validate(); err != nil {
			invalidParams.AddNested("Source", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Filters the compliance results based on account ID, region, compliance type,
// and rule name.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ConfigRuleComplianceFilters
type ConfigRuleComplianceFilters struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the source account.
	AccountId *string `type:"string"`

	// The source region where the data is aggregated.
	AwsRegion *string `min:"1" type:"string"`

	// The rule compliance status.
	//
	// For the ConfigRuleComplianceFilters data type, AWS Config supports only COMPLIANT
	// and NON_COMPLIANT. AWS Config does not support the NOT_APPLICABLE and the
	// INSUFFICIENT_DATA values.
	ComplianceType ComplianceType `type:"string" enum:"true"`

	// The name of the AWS Config rule.
	ConfigRuleName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ConfigRuleComplianceFilters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigRuleComplianceFilters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ConfigRuleComplianceFilters"}
	if s.AwsRegion != nil && len(*s.AwsRegion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AwsRegion", 1))
	}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ConfigRuleName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Filters the results based on the account IDs and regions.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ConfigRuleComplianceSummaryFilters
type ConfigRuleComplianceSummaryFilters struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the source account.
	AccountId *string `type:"string"`

	// The source region where the data is aggregated.
	AwsRegion *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ConfigRuleComplianceSummaryFilters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigRuleComplianceSummaryFilters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ConfigRuleComplianceSummaryFilters"}
	if s.AwsRegion != nil && len(*s.AwsRegion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AwsRegion", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Status information for your AWS managed Config rules. The status includes
// information such as the last time the rule ran, the last time it failed,
// and the related error for the last failure.
//
// This action does not return status information about custom AWS Config rules.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ConfigRuleEvaluationStatus
type ConfigRuleEvaluationStatus struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the AWS Config rule.
	ConfigRuleArn *string `type:"string"`

	// The ID of the AWS Config rule.
	ConfigRuleId *string `type:"string"`

	// The name of the AWS Config rule.
	ConfigRuleName *string `min:"1" type:"string"`

	// The time that you first activated the AWS Config rule.
	FirstActivatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Indicates whether AWS Config has evaluated your resources against the rule
	// at least once.
	//
	//    * true - AWS Config has evaluated your AWS resources against the rule
	//    at least once.
	//
	//    * false - AWS Config has not once finished evaluating your AWS resources
	//    against the rule.
	FirstEvaluationStarted *bool `type:"boolean"`

	// The error code that AWS Config returned when the rule last failed.
	LastErrorCode *string `type:"string"`

	// The error message that AWS Config returned when the rule last failed.
	LastErrorMessage *string `type:"string"`

	// The time that AWS Config last failed to evaluate your AWS resources against
	// the rule.
	LastFailedEvaluationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The time that AWS Config last failed to invoke the AWS Config rule to evaluate
	// your AWS resources.
	LastFailedInvocationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The time that AWS Config last successfully evaluated your AWS resources against
	// the rule.
	LastSuccessfulEvaluationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The time that AWS Config last successfully invoked the AWS Config rule to
	// evaluate your AWS resources.
	LastSuccessfulInvocationTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s ConfigRuleEvaluationStatus) String() string {
	return awsutil.Prettify(s)
}

// Provides options for how often AWS Config delivers configuration snapshots
// to the Amazon S3 bucket in your delivery channel.
//
// The frequency for a rule that triggers evaluations for your resources when
// AWS Config delivers the configuration snapshot is set by one of two values,
// depending on which is less frequent:
//
//    * The value for the deliveryFrequency parameter within the delivery channel
//    configuration, which sets how often AWS Config delivers configuration
//    snapshots. This value also sets how often AWS Config invokes evaluations
//    for AWS Config rules.
//
//    * The value for the MaximumExecutionFrequency parameter, which sets the
//    maximum frequency with which AWS Config invokes evaluations for the rule.
//    For more information, see ConfigRule.
//
// If the deliveryFrequency value is less frequent than the MaximumExecutionFrequency
// value for a rule, AWS Config invokes the rule only as often as the deliveryFrequency
// value.
//
// For example, you want your rule to run evaluations when AWS Config delivers
// the configuration snapshot.
//
// You specify the MaximumExecutionFrequency value for Six_Hours.
//
// You then specify the delivery channel deliveryFrequency value for TwentyFour_Hours.
//
// Because the value for deliveryFrequency is less frequent than MaximumExecutionFrequency,
// AWS Config invokes evaluations for the rule every 24 hours.
//
// You should set the MaximumExecutionFrequency value to be at least as frequent
// as the deliveryFrequency value. You can view the deliveryFrequency value
// by using the DescribeDeliveryChannnels action.
//
// To update the deliveryFrequency with which AWS Config delivers your configuration
// snapshots, use the PutDeliveryChannel action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ConfigSnapshotDeliveryProperties
type ConfigSnapshotDeliveryProperties struct {
	_ struct{} `type:"structure"`

	// The frequency with which AWS Config delivers configuration snapshots.
	DeliveryFrequency MaximumExecutionFrequency `locationName:"deliveryFrequency" type:"string" enum:"true"`
}

// String returns the string representation
func (s ConfigSnapshotDeliveryProperties) String() string {
	return awsutil.Prettify(s)
}

// A list that contains the status of the delivery of the configuration stream
// notification to the Amazon SNS topic.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ConfigStreamDeliveryInfo
type ConfigStreamDeliveryInfo struct {
	_ struct{} `type:"structure"`

	// The error code from the last attempted delivery.
	LastErrorCode *string `locationName:"lastErrorCode" type:"string"`

	// The error message from the last attempted delivery.
	LastErrorMessage *string `locationName:"lastErrorMessage" type:"string"`

	// Status of the last attempted delivery.
	//
	// Note Providing an SNS topic on a DeliveryChannel (https://docs.aws.amazon.com/config/latest/APIReference/API_DeliveryChannel.html)
	// for AWS Config is optional. If the SNS delivery is turned off, the last status
	// will be Not_Applicable.
	LastStatus DeliveryStatus `locationName:"lastStatus" type:"string" enum:"true"`

	// The time from the last status change.
	LastStatusChangeTime *time.Time `locationName:"lastStatusChangeTime" type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s ConfigStreamDeliveryInfo) String() string {
	return awsutil.Prettify(s)
}

// The details about the configuration aggregator, including information about
// source accounts, regions, and metadata of the aggregator.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ConfigurationAggregator
type ConfigurationAggregator struct {
	_ struct{} `type:"structure"`

	// Provides a list of source accounts and regions to be aggregated.
	AccountAggregationSources []AccountAggregationSource `type:"list"`

	// The Amazon Resource Name (ARN) of the aggregator.
	ConfigurationAggregatorArn *string `type:"string"`

	// The name of the aggregator.
	ConfigurationAggregatorName *string `min:"1" type:"string"`

	// The time stamp when the configuration aggregator was created.
	CreationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The time of the last update.
	LastUpdatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Provides an organization and list of regions to be aggregated.
	OrganizationAggregationSource *OrganizationAggregationSource `type:"structure"`
}

// String returns the string representation
func (s ConfigurationAggregator) String() string {
	return awsutil.Prettify(s)
}

// A list that contains detailed configurations of a specified resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ConfigurationItem
type ConfigurationItem struct {
	_ struct{} `type:"structure"`

	// The 12-digit AWS account ID associated with the resource.
	AccountId *string `locationName:"accountId" type:"string"`

	// accoun
	Arn *string `locationName:"arn" type:"string"`

	// The Availability Zone associated with the resource.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The region where the resource resides.
	AwsRegion *string `locationName:"awsRegion" min:"1" type:"string"`

	// The description of the resource configuration.
	Configuration *string `locationName:"configuration" type:"string"`

	// The time when the configuration recording was initiated.
	ConfigurationItemCaptureTime *time.Time `locationName:"configurationItemCaptureTime" type:"timestamp" timestampFormat:"unix"`

	// Unique MD5 hash that represents the configuration item's state.
	//
	// You can use MD5 hash to compare the states of two or more configuration items
	// that are associated with the same resource.
	ConfigurationItemMD5Hash *string `locationName:"configurationItemMD5Hash" type:"string"`

	// The configuration item status.
	ConfigurationItemStatus ConfigurationItemStatus `locationName:"configurationItemStatus" type:"string" enum:"true"`

	// An identifier that indicates the ordering of the configuration items of a
	// resource.
	ConfigurationStateId *string `locationName:"configurationStateId" type:"string"`

	// A list of CloudTrail event IDs.
	//
	// A populated field indicates that the current configuration was initiated
	// by the events recorded in the CloudTrail log. For more information about
	// CloudTrail, see What Is AWS CloudTrail (https://docs.aws.amazon.com/awscloudtrail/latest/userguide/what_is_cloud_trail_top_level.html).
	//
	// An empty field indicates that the current configuration was not initiated
	// by any event.
	RelatedEvents []string `locationName:"relatedEvents" type:"list"`

	// A list of related AWS resources.
	Relationships []Relationship `locationName:"relationships" type:"list"`

	// The time stamp when the resource was created.
	ResourceCreationTime *time.Time `locationName:"resourceCreationTime" type:"timestamp" timestampFormat:"unix"`

	// The ID of the resource (for example, sg-xxxxxx).
	ResourceId *string `locationName:"resourceId" min:"1" type:"string"`

	// The custom name of the resource, if available.
	ResourceName *string `locationName:"resourceName" type:"string"`

	// The type of AWS resource.
	ResourceType ResourceType `locationName:"resourceType" type:"string" enum:"true"`

	// Configuration attributes that AWS Config returns for certain resource types
	// to supplement the information returned for the configuration parameter.
	SupplementaryConfiguration map[string]string `locationName:"supplementaryConfiguration" type:"map"`

	// A mapping of key value tags associated with the resource.
	Tags map[string]string `locationName:"tags" type:"map"`

	// The version number of the resource configuration.
	Version *string `locationName:"version" type:"string"`
}

// String returns the string representation
func (s ConfigurationItem) String() string {
	return awsutil.Prettify(s)
}

// An object that represents the recording of configuration changes of an AWS
// resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ConfigurationRecorder
type ConfigurationRecorder struct {
	_ struct{} `type:"structure"`

	// The name of the recorder. By default, AWS Config automatically assigns the
	// name "default" when creating the configuration recorder. You cannot change
	// the assigned name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Specifies the types of AWS resources for which AWS Config records configuration
	// changes.
	RecordingGroup *RecordingGroup `locationName:"recordingGroup" type:"structure"`

	// Amazon Resource Name (ARN) of the IAM role used to describe the AWS resources
	// associated with the account.
	RoleARN *string `locationName:"roleARN" type:"string"`
}

// String returns the string representation
func (s ConfigurationRecorder) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConfigurationRecorder) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ConfigurationRecorder"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The current status of the configuration recorder.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ConfigurationRecorderStatus
type ConfigurationRecorderStatus struct {
	_ struct{} `type:"structure"`

	// The error code indicating that the recording failed.
	LastErrorCode *string `locationName:"lastErrorCode" type:"string"`

	// The message indicating that the recording failed due to an error.
	LastErrorMessage *string `locationName:"lastErrorMessage" type:"string"`

	// The time the recorder was last started.
	LastStartTime *time.Time `locationName:"lastStartTime" type:"timestamp" timestampFormat:"unix"`

	// The last (previous) status of the recorder.
	LastStatus RecorderStatus `locationName:"lastStatus" type:"string" enum:"true"`

	// The time when the status was last changed.
	LastStatusChangeTime *time.Time `locationName:"lastStatusChangeTime" type:"timestamp" timestampFormat:"unix"`

	// The time the recorder was last stopped.
	LastStopTime *time.Time `locationName:"lastStopTime" type:"timestamp" timestampFormat:"unix"`

	// The name of the configuration recorder.
	Name *string `locationName:"name" type:"string"`

	// Specifies whether or not the recorder is currently recording.
	Recording *bool `locationName:"recording" type:"boolean"`
}

// String returns the string representation
func (s ConfigurationRecorderStatus) String() string {
	return awsutil.Prettify(s)
}

// The channel through which AWS Config delivers notifications and updated configuration
// states.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeliveryChannel
type DeliveryChannel struct {
	_ struct{} `type:"structure"`

	// The options for how often AWS Config delivers configuration snapshots to
	// the Amazon S3 bucket.
	ConfigSnapshotDeliveryProperties *ConfigSnapshotDeliveryProperties `locationName:"configSnapshotDeliveryProperties" type:"structure"`

	// The name of the delivery channel. By default, AWS Config assigns the name
	// "default" when creating the delivery channel. To change the delivery channel
	// name, you must use the DeleteDeliveryChannel action to delete your current
	// delivery channel, and then you must use the PutDeliveryChannel command to
	// create a delivery channel that has the desired name.
	Name *string `locationName:"name" min:"1" type:"string"`

	// The name of the Amazon S3 bucket to which AWS Config delivers configuration
	// snapshots and configuration history files.
	//
	// If you specify a bucket that belongs to another AWS account, that bucket
	// must have policies that grant access permissions to AWS Config. For more
	// information, see Permissions for the Amazon S3 Bucket (https://docs.aws.amazon.com/config/latest/developerguide/s3-bucket-policy.html)
	// in the AWS Config Developer Guide.
	S3BucketName *string `locationName:"s3BucketName" type:"string"`

	// The prefix for the specified Amazon S3 bucket.
	S3KeyPrefix *string `locationName:"s3KeyPrefix" type:"string"`

	// The Amazon Resource Name (ARN) of the Amazon SNS topic to which AWS Config
	// sends notifications about configuration changes.
	//
	// If you choose a topic from another account, the topic must have policies
	// that grant access permissions to AWS Config. For more information, see Permissions
	// for the Amazon SNS Topic (https://docs.aws.amazon.com/config/latest/developerguide/sns-topic-policy.html)
	// in the AWS Config Developer Guide.
	SnsTopicARN *string `locationName:"snsTopicARN" type:"string"`
}

// String returns the string representation
func (s DeliveryChannel) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeliveryChannel) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeliveryChannel"}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The status of a specified delivery channel.
//
// Valid values: Success | Failure
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/DeliveryChannelStatus
type DeliveryChannelStatus struct {
	_ struct{} `type:"structure"`

	// A list that contains the status of the delivery of the configuration history
	// to the specified Amazon S3 bucket.
	ConfigHistoryDeliveryInfo *ConfigExportDeliveryInfo `locationName:"configHistoryDeliveryInfo" type:"structure"`

	// A list containing the status of the delivery of the snapshot to the specified
	// Amazon S3 bucket.
	ConfigSnapshotDeliveryInfo *ConfigExportDeliveryInfo `locationName:"configSnapshotDeliveryInfo" type:"structure"`

	// A list containing the status of the delivery of the configuration stream
	// notification to the specified Amazon SNS topic.
	ConfigStreamDeliveryInfo *ConfigStreamDeliveryInfo `locationName:"configStreamDeliveryInfo" type:"structure"`

	// The name of the delivery channel.
	Name *string `locationName:"name" type:"string"`
}

// String returns the string representation
func (s DeliveryChannelStatus) String() string {
	return awsutil.Prettify(s)
}

// Identifies an AWS resource and indicates whether it complies with the AWS
// Config rule that it was evaluated against.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/Evaluation
type Evaluation struct {
	_ struct{} `type:"structure"`

	// Supplementary information about how the evaluation determined the compliance.
	Annotation *string `min:"1" type:"string"`

	// The ID of the AWS resource that was evaluated.
	//
	// ComplianceResourceId is a required field
	ComplianceResourceId *string `min:"1" type:"string" required:"true"`

	// The type of AWS resource that was evaluated.
	//
	// ComplianceResourceType is a required field
	ComplianceResourceType *string `min:"1" type:"string" required:"true"`

	// Indicates whether the AWS resource complies with the AWS Config rule that
	// it was evaluated against.
	//
	// For the Evaluation data type, AWS Config supports only the COMPLIANT, NON_COMPLIANT,
	// and NOT_APPLICABLE values. AWS Config does not support the INSUFFICIENT_DATA
	// value for this data type.
	//
	// Similarly, AWS Config does not accept INSUFFICIENT_DATA as the value for
	// ComplianceType from a PutEvaluations request. For example, an AWS Lambda
	// function for a custom AWS Config rule cannot pass an INSUFFICIENT_DATA value
	// to AWS Config.
	//
	// ComplianceType is a required field
	ComplianceType ComplianceType `type:"string" required:"true" enum:"true"`

	// The time of the event in AWS Config that triggered the evaluation. For event-based
	// evaluations, the time indicates when AWS Config created the configuration
	// item that triggered the evaluation. For periodic evaluations, the time indicates
	// when AWS Config triggered the evaluation at the frequency that you specified
	// (for example, every 24 hours).
	//
	// OrderingTimestamp is a required field
	OrderingTimestamp *time.Time `type:"timestamp" timestampFormat:"unix" required:"true"`
}

// String returns the string representation
func (s Evaluation) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Evaluation) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Evaluation"}
	if s.Annotation != nil && len(*s.Annotation) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Annotation", 1))
	}

	if s.ComplianceResourceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ComplianceResourceId"))
	}
	if s.ComplianceResourceId != nil && len(*s.ComplianceResourceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ComplianceResourceId", 1))
	}

	if s.ComplianceResourceType == nil {
		invalidParams.Add(aws.NewErrParamRequired("ComplianceResourceType"))
	}
	if s.ComplianceResourceType != nil && len(*s.ComplianceResourceType) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ComplianceResourceType", 1))
	}
	if len(s.ComplianceType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ComplianceType"))
	}

	if s.OrderingTimestamp == nil {
		invalidParams.Add(aws.NewErrParamRequired("OrderingTimestamp"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The details of an AWS Config evaluation. Provides the AWS resource that was
// evaluated, the compliance of the resource, related time stamps, and supplementary
// information.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/EvaluationResult
type EvaluationResult struct {
	_ struct{} `type:"structure"`

	// Supplementary information about how the evaluation determined the compliance.
	Annotation *string `min:"1" type:"string"`

	// Indicates whether the AWS resource complies with the AWS Config rule that
	// evaluated it.
	//
	// For the EvaluationResult data type, AWS Config supports only the COMPLIANT,
	// NON_COMPLIANT, and NOT_APPLICABLE values. AWS Config does not support the
	// INSUFFICIENT_DATA value for the EvaluationResult data type.
	ComplianceType ComplianceType `type:"string" enum:"true"`

	// The time when the AWS Config rule evaluated the AWS resource.
	ConfigRuleInvokedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// Uniquely identifies the evaluation result.
	EvaluationResultIdentifier *EvaluationResultIdentifier `type:"structure"`

	// The time when AWS Config recorded the evaluation result.
	ResultRecordedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// An encrypted token that associates an evaluation with an AWS Config rule.
	// The token identifies the rule, the AWS resource being evaluated, and the
	// event that triggered the evaluation.
	ResultToken *string `type:"string"`
}

// String returns the string representation
func (s EvaluationResult) String() string {
	return awsutil.Prettify(s)
}

// Uniquely identifies an evaluation result.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/EvaluationResultIdentifier
type EvaluationResultIdentifier struct {
	_ struct{} `type:"structure"`

	// Identifies an AWS Config rule used to evaluate an AWS resource, and provides
	// the type and ID of the evaluated resource.
	EvaluationResultQualifier *EvaluationResultQualifier `type:"structure"`

	// The time of the event that triggered the evaluation of your AWS resources.
	// The time can indicate when AWS Config delivered a configuration item change
	// notification, or it can indicate when AWS Config delivered the configuration
	// snapshot, depending on which event triggered the evaluation.
	OrderingTimestamp *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s EvaluationResultIdentifier) String() string {
	return awsutil.Prettify(s)
}

// Identifies an AWS Config rule that evaluated an AWS resource, and provides
// the type and ID of the resource that the rule evaluated.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/EvaluationResultQualifier
type EvaluationResultQualifier struct {
	_ struct{} `type:"structure"`

	// The name of the AWS Config rule that was used in the evaluation.
	ConfigRuleName *string `min:"1" type:"string"`

	// The ID of the evaluated AWS resource.
	ResourceId *string `min:"1" type:"string"`

	// The type of AWS resource that was evaluated.
	ResourceType *string `min:"1" type:"string"`
}

// String returns the string representation
func (s EvaluationResultQualifier) String() string {
	return awsutil.Prettify(s)
}

// List of each of the failed remediations with specific reasons.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/FailedRemediationBatch
type FailedRemediationBatch struct {
	_ struct{} `type:"structure"`

	// Returns remediation configurations of the failed items.
	FailedItems []RemediationConfiguration `type:"list"`

	// Returns a failure message. For example, the resource is already compliant.
	FailureMessage *string `type:"string"`
}

// String returns the string representation
func (s FailedRemediationBatch) String() string {
	return awsutil.Prettify(s)
}

// Details about the fields such as name of the field.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/FieldInfo
type FieldInfo struct {
	_ struct{} `type:"structure"`

	// Name of the field.
	Name *string `type:"string"`
}

// String returns the string representation
func (s FieldInfo) String() string {
	return awsutil.Prettify(s)
}

// The count of resources that are grouped by the group name.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/GroupedResourceCount
type GroupedResourceCount struct {
	_ struct{} `type:"structure"`

	// The name of the group that can be region, account ID, or resource type. For
	// example, region1, region2 if the region was chosen as GroupByKey.
	//
	// GroupName is a required field
	GroupName *string `min:"1" type:"string" required:"true"`

	// The number of resources in the group.
	//
	// ResourceCount is a required field
	ResourceCount *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s GroupedResourceCount) String() string {
	return awsutil.Prettify(s)
}

// This object contains regions to set up the aggregator and an IAM role to
// retrieve organization details.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/OrganizationAggregationSource
type OrganizationAggregationSource struct {
	_ struct{} `type:"structure"`

	// If true, aggregate existing AWS Config regions and future regions.
	AllAwsRegions *bool `type:"boolean"`

	// The source regions being aggregated.
	AwsRegions []string `min:"1" type:"list"`

	// ARN of the IAM role used to retrieve AWS Organization details associated
	// with the aggregator account.
	//
	// RoleArn is a required field
	RoleArn *string `type:"string" required:"true"`
}

// String returns the string representation
func (s OrganizationAggregationSource) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OrganizationAggregationSource) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "OrganizationAggregationSource"}
	if s.AwsRegions != nil && len(s.AwsRegions) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AwsRegions", 1))
	}

	if s.RoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("RoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// An object that represents the account ID and region of an aggregator account
// that is requesting authorization but is not yet authorized.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/PendingAggregationRequest
type PendingAggregationRequest struct {
	_ struct{} `type:"structure"`

	// The 12-digit account ID of the account requesting to aggregate data.
	RequesterAccountId *string `type:"string"`

	// The region requesting to aggregate data.
	RequesterAwsRegion *string `min:"1" type:"string"`
}

// String returns the string representation
func (s PendingAggregationRequest) String() string {
	return awsutil.Prettify(s)
}

// Details about the query.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/QueryInfo
type QueryInfo struct {
	_ struct{} `type:"structure"`

	// Returns a FieldInfo object.
	SelectFields []FieldInfo `type:"list"`
}

// String returns the string representation
func (s QueryInfo) String() string {
	return awsutil.Prettify(s)
}

// Specifies the types of AWS resource for which AWS Config records configuration
// changes.
//
// In the recording group, you specify whether all supported types or specific
// types of resources are recorded.
//
// By default, AWS Config records configuration changes for all supported types
// of regional resources that AWS Config discovers in the region in which it
// is running. Regional resources are tied to a region and can be used only
// in that region. Examples of regional resources are EC2 instances and EBS
// volumes.
//
// You can also have AWS Config record configuration changes for supported types
// of global resources (for example, IAM resources). Global resources are not
// tied to an individual region and can be used in all regions.
//
// The configuration details for any global resource are the same in all regions.
// If you customize AWS Config in multiple regions to record global resources,
// it will create multiple configuration items each time a global resource changes:
// one configuration item for each region. These configuration items will contain
// identical data. To prevent duplicate configuration items, you should consider
// customizing AWS Config in only one region to record global resources, unless
// you want the configuration items to be available in multiple regions.
//
// If you don't want AWS Config to record all resources, you can specify which
// types of resources it will record with the resourceTypes parameter.
//
// For a list of supported resource types, see Supported Resource Types (https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources).
//
// For more information, see Selecting Which Resources AWS Config Records (https://docs.aws.amazon.com/config/latest/developerguide/select-resources.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/RecordingGroup
type RecordingGroup struct {
	_ struct{} `type:"structure"`

	// Specifies whether AWS Config records configuration changes for every supported
	// type of regional resource.
	//
	// If you set this option to true, when AWS Config adds support for a new type
	// of regional resource, it starts recording resources of that type automatically.
	//
	// If you set this option to true, you cannot enumerate a list of resourceTypes.
	AllSupported *bool `locationName:"allSupported" type:"boolean"`

	// Specifies whether AWS Config includes all supported types of global resources
	// (for example, IAM resources) with the resources that it records.
	//
	// Before you can set this option to true, you must set the allSupported option
	// to true.
	//
	// If you set this option to true, when AWS Config adds support for a new type
	// of global resource, it starts recording resources of that type automatically.
	//
	// The configuration details for any global resource are the same in all regions.
	// To prevent duplicate configuration items, you should consider customizing
	// AWS Config in only one region to record global resources.
	IncludeGlobalResourceTypes *bool `locationName:"includeGlobalResourceTypes" type:"boolean"`

	// A comma-separated list that specifies the types of AWS resources for which
	// AWS Config records configuration changes (for example, AWS::EC2::Instance
	// or AWS::CloudTrail::Trail).
	//
	// Before you can set this option to true, you must set the allSupported option
	// to false.
	//
	// If you set this option to true, when AWS Config adds support for a new type
	// of resource, it will not record resources of that type unless you manually
	// add that type to your recording group.
	//
	// For a list of valid resourceTypes values, see the resourceType Value column
	// in Supported AWS Resource Types (https://docs.aws.amazon.com/config/latest/developerguide/resource-config-reference.html#supported-resources).
	ResourceTypes []ResourceType `locationName:"resourceTypes" type:"list"`
}

// String returns the string representation
func (s RecordingGroup) String() string {
	return awsutil.Prettify(s)
}

// The relationship of the related resource to the main resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/Relationship
type Relationship struct {
	_ struct{} `type:"structure"`

	// The type of relationship with the related resource.
	RelationshipName *string `locationName:"relationshipName" type:"string"`

	// The ID of the related resource (for example, sg-xxxxxx).
	ResourceId *string `locationName:"resourceId" min:"1" type:"string"`

	// The custom name of the related resource, if available.
	ResourceName *string `locationName:"resourceName" type:"string"`

	// The resource type of the related resource.
	ResourceType ResourceType `locationName:"resourceType" type:"string" enum:"true"`
}

// String returns the string representation
func (s Relationship) String() string {
	return awsutil.Prettify(s)
}

// An object that represents the details about the remediation configuration
// that includes the remediation action, parameters, and data to execute the
// action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/RemediationConfiguration
type RemediationConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the AWS Config rule.
	//
	// ConfigRuleName is a required field
	ConfigRuleName *string `min:"1" type:"string" required:"true"`

	// An object of the RemediationParameterValue.
	Parameters map[string]RemediationParameterValue `type:"map"`

	// The type of a resource.
	ResourceType *string `type:"string"`

	// Target ID is the name of the public document.
	//
	// TargetId is a required field
	TargetId *string `min:"1" type:"string" required:"true"`

	// The type of the target. Target executes remediation. For example, SSM document.
	//
	// TargetType is a required field
	TargetType RemediationTargetType `type:"string" required:"true" enum:"true"`

	// Version of the target. For example, version of the SSM document.
	TargetVersion *string `type:"string"`
}

// String returns the string representation
func (s RemediationConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RemediationConfiguration) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RemediationConfiguration"}

	if s.ConfigRuleName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ConfigRuleName"))
	}
	if s.ConfigRuleName != nil && len(*s.ConfigRuleName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ConfigRuleName", 1))
	}

	if s.TargetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetId"))
	}
	if s.TargetId != nil && len(*s.TargetId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TargetId", 1))
	}
	if len(s.TargetType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("TargetType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides details of the current status of the invoked remediation action
// for that resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/RemediationExecutionStatus
type RemediationExecutionStatus struct {
	_ struct{} `type:"structure"`

	// Start time when the remediation was executed.
	InvocationTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The time when the remediation execution was last updated.
	LastUpdatedTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The details that identify a resource within AWS Config, including the resource
	// type and resource ID.
	ResourceKey *ResourceKey `type:"structure"`

	// ENUM of the values.
	State RemediationExecutionState `type:"string" enum:"true"`

	// Details of every step.
	StepDetails []RemediationExecutionStep `type:"list"`
}

// String returns the string representation
func (s RemediationExecutionStatus) String() string {
	return awsutil.Prettify(s)
}

// Name of the step from the SSM document.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/RemediationExecutionStep
type RemediationExecutionStep struct {
	_ struct{} `type:"structure"`

	// An error message if the step was interrupted during execution.
	ErrorMessage *string `type:"string"`

	// The details of the step.
	Name *string `type:"string"`

	// The time when the step started.
	StartTime *time.Time `type:"timestamp" timestampFormat:"unix"`

	// The valid status of the step.
	State RemediationExecutionStepState `type:"string" enum:"true"`

	// The time when the step stopped.
	StopTime *time.Time `type:"timestamp" timestampFormat:"unix"`
}

// String returns the string representation
func (s RemediationExecutionStep) String() string {
	return awsutil.Prettify(s)
}

// The value is either a dynamic (resource) value or a static value. You must
// select either a dynamic value or a static value.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/RemediationParameterValue
type RemediationParameterValue struct {
	_ struct{} `type:"structure"`

	// The value is dynamic and changes at run-time.
	ResourceValue *ResourceValue `type:"structure"`

	// The value is static and does not change at run-time.
	StaticValue *StaticValue `type:"structure"`
}

// String returns the string representation
func (s RemediationParameterValue) String() string {
	return awsutil.Prettify(s)
}

// An object that contains the resource type and the number of resources.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ResourceCount
type ResourceCount struct {
	_ struct{} `type:"structure"`

	// The number of resources.
	Count *int64 `locationName:"count" type:"long"`

	// The resource type (for example, "AWS::EC2::Instance").
	ResourceType ResourceType `locationName:"resourceType" type:"string" enum:"true"`
}

// String returns the string representation
func (s ResourceCount) String() string {
	return awsutil.Prettify(s)
}

// Filters the resource count based on account ID, region, and resource type.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ResourceCountFilters
type ResourceCountFilters struct {
	_ struct{} `type:"structure"`

	// The 12-digit ID of the account.
	AccountId *string `type:"string"`

	// The region where the account is located.
	Region *string `min:"1" type:"string"`

	// The type of the AWS resource.
	ResourceType ResourceType `type:"string" enum:"true"`
}

// String returns the string representation
func (s ResourceCountFilters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceCountFilters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResourceCountFilters"}
	if s.Region != nil && len(*s.Region) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Region", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Filters the results by resource account ID, region, resource ID, and resource
// name.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ResourceFilters
type ResourceFilters struct {
	_ struct{} `type:"structure"`

	// The 12-digit source account ID.
	AccountId *string `type:"string"`

	// The source region.
	Region *string `min:"1" type:"string"`

	// The ID of the resource.
	ResourceId *string `min:"1" type:"string"`

	// The name of the resource.
	ResourceName *string `type:"string"`
}

// String returns the string representation
func (s ResourceFilters) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceFilters) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResourceFilters"}
	if s.Region != nil && len(*s.Region) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Region", 1))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The details that identify a resource that is discovered by AWS Config, including
// the resource type, ID, and (if available) the custom resource name.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ResourceIdentifier
type ResourceIdentifier struct {
	_ struct{} `type:"structure"`

	// The time that the resource was deleted.
	ResourceDeletionTime *time.Time `locationName:"resourceDeletionTime" type:"timestamp" timestampFormat:"unix"`

	// The ID of the resource (for example, sg-xxxxxx).
	ResourceId *string `locationName:"resourceId" min:"1" type:"string"`

	// The custom name of the resource (if available).
	ResourceName *string `locationName:"resourceName" type:"string"`

	// The type of resource.
	ResourceType ResourceType `locationName:"resourceType" type:"string" enum:"true"`
}

// String returns the string representation
func (s ResourceIdentifier) String() string {
	return awsutil.Prettify(s)
}

// The details that identify a resource within AWS Config, including the resource
// type and resource ID.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ResourceKey
type ResourceKey struct {
	_ struct{} `type:"structure"`

	// The ID of the resource (for example., sg-xxxxxx).
	//
	// ResourceId is a required field
	ResourceId *string `locationName:"resourceId" min:"1" type:"string" required:"true"`

	// The resource type.
	//
	// ResourceType is a required field
	ResourceType ResourceType `locationName:"resourceType" type:"string" required:"true" enum:"true"`
}

// String returns the string representation
func (s ResourceKey) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourceKey) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ResourceKey"}

	if s.ResourceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceId", 1))
	}
	if len(s.ResourceType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("ResourceType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The dynamic value of the resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/ResourceValue
type ResourceValue struct {
	_ struct{} `type:"structure"`

	// The value is a resource ID.
	Value ResourceValueType `type:"string" enum:"true"`
}

// String returns the string representation
func (s ResourceValue) String() string {
	return awsutil.Prettify(s)
}

// An object with the name of the retention configuration and the retention
// period in days. The object stores the configuration for data retention in
// AWS Config.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/RetentionConfiguration
type RetentionConfiguration struct {
	_ struct{} `type:"structure"`

	// The name of the retention configuration object.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Number of days AWS Config stores your historical information.
	//
	// Currently, only applicable to the configuration item history.
	//
	// RetentionPeriodInDays is a required field
	RetentionPeriodInDays *int64 `min:"30" type:"integer" required:"true"`
}

// String returns the string representation
func (s RetentionConfiguration) String() string {
	return awsutil.Prettify(s)
}

// Defines which resources trigger an evaluation for an AWS Config rule. The
// scope can include one or more resource types, a combination of a tag key
// and value, or a combination of one resource type and one resource ID. Specify
// a scope to constrain which resources trigger an evaluation for a rule. Otherwise,
// evaluations for the rule are triggered when any resource in your recording
// group changes in configuration.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/Scope
type Scope struct {
	_ struct{} `type:"structure"`

	// The ID of the only AWS resource that you want to trigger an evaluation for
	// the rule. If you specify a resource ID, you must specify one resource type
	// for ComplianceResourceTypes.
	ComplianceResourceId *string `min:"1" type:"string"`

	// The resource types of only those AWS resources that you want to trigger an
	// evaluation for the rule. You can only specify one type if you also specify
	// a resource ID for ComplianceResourceId.
	ComplianceResourceTypes []string `type:"list"`

	// The tag key that is applied to only those AWS resources that you want to
	// trigger an evaluation for the rule.
	TagKey *string `min:"1" type:"string"`

	// The tag value applied to only those AWS resources that you want to trigger
	// an evaluation for the rule. If you specify a value for TagValue, you must
	// also specify a value for TagKey.
	TagValue *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Scope) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Scope) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Scope"}
	if s.ComplianceResourceId != nil && len(*s.ComplianceResourceId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ComplianceResourceId", 1))
	}
	if s.TagKey != nil && len(*s.TagKey) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TagKey", 1))
	}
	if s.TagValue != nil && len(*s.TagValue) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TagValue", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides the AWS Config rule owner (AWS or customer), the rule identifier,
// and the events that trigger the evaluation of your AWS resources.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/Source
type Source struct {
	_ struct{} `type:"structure"`

	// Indicates whether AWS or the customer owns and manages the AWS Config rule.
	//
	// Owner is a required field
	Owner Owner `type:"string" required:"true" enum:"true"`

	// Provides the source and type of the event that causes AWS Config to evaluate
	// your AWS resources.
	SourceDetails []SourceDetail `type:"list"`

	// For AWS Config managed rules, a predefined identifier from a list. For example,
	// IAM_PASSWORD_POLICY is a managed rule. To reference a managed rule, see Using
	// AWS Managed Config Rules (https://docs.aws.amazon.com/config/latest/developerguide/evaluate-config_use-managed-rules.html).
	//
	// For custom rules, the identifier is the Amazon Resource Name (ARN) of the
	// rule's AWS Lambda function, such as arn:aws:lambda:us-east-2:123456789012:function:custom_rule_name.
	//
	// SourceIdentifier is a required field
	SourceIdentifier *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Source) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Source) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Source"}
	if len(s.Owner) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Owner"))
	}

	if s.SourceIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("SourceIdentifier"))
	}
	if s.SourceIdentifier != nil && len(*s.SourceIdentifier) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SourceIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Provides the source and the message types that trigger AWS Config to evaluate
// your AWS resources against a rule. It also provides the frequency with which
// you want AWS Config to run evaluations for the rule if the trigger type is
// periodic. You can specify the parameter values for SourceDetail only for
// custom rules.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/SourceDetail
type SourceDetail struct {
	_ struct{} `type:"structure"`

	// The source of the event, such as an AWS service, that triggers AWS Config
	// to evaluate your AWS resources.
	EventSource EventSource `type:"string" enum:"true"`

	// The frequency at which you want AWS Config to run evaluations for a custom
	// rule with a periodic trigger. If you specify a value for MaximumExecutionFrequency,
	// then MessageType must use the ScheduledNotification value.
	//
	// By default, rules with a periodic trigger are evaluated every 24 hours. To
	// change the frequency, specify a valid value for the MaximumExecutionFrequency
	// parameter.
	//
	// Based on the valid value you choose, AWS Config runs evaluations once for
	// each valid value. For example, if you choose Three_Hours, AWS Config runs
	// evaluations once every three hours. In this case, Three_Hours is the frequency
	// of this rule.
	MaximumExecutionFrequency MaximumExecutionFrequency `type:"string" enum:"true"`

	// The type of notification that triggers AWS Config to run an evaluation for
	// a rule. You can specify the following notification types:
	//
	//    * ConfigurationItemChangeNotification - Triggers an evaluation when AWS
	//    Config delivers a configuration item as a result of a resource change.
	//
	//    * OversizedConfigurationItemChangeNotification - Triggers an evaluation
	//    when AWS Config delivers an oversized configuration item. AWS Config may
	//    generate this notification type when a resource changes and the notification
	//    exceeds the maximum size allowed by Amazon SNS.
	//
	//    * ScheduledNotification - Triggers a periodic evaluation at the frequency
	//    specified for MaximumExecutionFrequency.
	//
	//    * ConfigurationSnapshotDeliveryCompleted - Triggers a periodic evaluation
	//    when AWS Config delivers a configuration snapshot.
	//
	// If you want your custom rule to be triggered by configuration changes, specify
	// two SourceDetail objects, one for ConfigurationItemChangeNotification and
	// one for OversizedConfigurationItemChangeNotification.
	MessageType MessageType `type:"string" enum:"true"`
}

// String returns the string representation
func (s SourceDetail) String() string {
	return awsutil.Prettify(s)
}

// The static value of the resource.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/StaticValue
type StaticValue struct {
	_ struct{} `type:"structure"`

	// A list of values. For example, the ARN of the assumed role.
	Values []string `type:"list"`
}

// String returns the string representation
func (s StaticValue) String() string {
	return awsutil.Prettify(s)
}

// The tags for the resource. The metadata that you apply to a resource to help
// you categorize and organize them. Each tag consists of a key and an optional
// value, both of which you define. Tag keys can have a maximum character length
// of 128 characters, and tag values can have a maximum length of 256 characters.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/config-2014-11-12/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// One part of a key-value pair that make up a tag. A key is a general label
	// that acts like a category for more specific tag values.
	Key *string `min:"1" type:"string"`

	// The optional part of a key-value pair that make up a tag. A value acts as
	// a descriptor within a tag category (key).
	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "Tag"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}
