// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package dlm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/dlm-2018-01-12/UpdateLifecyclePolicyRequest
type UpdateLifecyclePolicyInput struct {
	_ struct{} `type:"structure"`

	// A description of the lifecycle policy.
	Description *string `type:"string"`

	// The Amazon Resource Name (ARN) of the IAM role used to run the operations
	// specified by the lifecycle policy.
	ExecutionRoleArn *string `type:"string"`

	// The configuration of the lifecycle policy.
	//
	// Target tags cannot be re-used across policies.
	PolicyDetails *PolicyDetails `type:"structure"`

	// The identifier of the lifecycle policy.
	//
	// PolicyId is a required field
	PolicyId *string `location:"uri" locationName:"policyId" type:"string" required:"true"`

	// The desired activation state of the lifecycle policy after creation.
	State SettablePolicyStateValues `type:"string" enum:"true"`
}

// String returns the string representation
func (s UpdateLifecyclePolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateLifecyclePolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateLifecyclePolicyInput"}

	if s.PolicyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("PolicyId"))
	}
	if s.PolicyDetails != nil {
		if err := s.PolicyDetails.Validate(); err != nil {
			invalidParams.AddNested("PolicyDetails", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateLifecyclePolicyInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ExecutionRoleArn != nil {
		v := *s.ExecutionRoleArn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ExecutionRoleArn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PolicyDetails != nil {
		v := s.PolicyDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "PolicyDetails", v, metadata)
	}
	if len(s.State) > 0 {
		v := s.State

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "State", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.PolicyId != nil {
		v := *s.PolicyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "policyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/dlm-2018-01-12/UpdateLifecyclePolicyResponse
type UpdateLifecyclePolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateLifecyclePolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UpdateLifecyclePolicyOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opUpdateLifecyclePolicy = "UpdateLifecyclePolicy"

// UpdateLifecyclePolicyRequest returns a request value for making API operation for
// Amazon Data Lifecycle Manager.
//
// Updates the specified lifecycle policy.
//
//    // Example sending a request using UpdateLifecyclePolicyRequest.
//    req := client.UpdateLifecyclePolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dlm-2018-01-12/UpdateLifecyclePolicy
func (c *Client) UpdateLifecyclePolicyRequest(input *UpdateLifecyclePolicyInput) UpdateLifecyclePolicyRequest {
	op := &aws.Operation{
		Name:       opUpdateLifecyclePolicy,
		HTTPMethod: "PATCH",
		HTTPPath:   "/policies/{policyId}",
	}

	if input == nil {
		input = &UpdateLifecyclePolicyInput{}
	}

	req := c.newRequest(op, input, &UpdateLifecyclePolicyOutput{})
	return UpdateLifecyclePolicyRequest{Request: req, Input: input, Copy: c.UpdateLifecyclePolicyRequest}
}

// UpdateLifecyclePolicyRequest is the request type for the
// UpdateLifecyclePolicy API operation.
type UpdateLifecyclePolicyRequest struct {
	*aws.Request
	Input *UpdateLifecyclePolicyInput
	Copy  func(*UpdateLifecyclePolicyInput) UpdateLifecyclePolicyRequest
}

// Send marshals and sends the UpdateLifecyclePolicy API request.
func (r UpdateLifecyclePolicyRequest) Send(ctx context.Context) (*UpdateLifecyclePolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateLifecyclePolicyResponse{
		UpdateLifecyclePolicyOutput: r.Request.Data.(*UpdateLifecyclePolicyOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateLifecyclePolicyResponse is the response type for the
// UpdateLifecyclePolicy API operation.
type UpdateLifecyclePolicyResponse struct {
	*UpdateLifecyclePolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateLifecyclePolicy request.
func (r *UpdateLifecyclePolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
