// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the parameters for DescribeVpcEndpointServices.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcEndpointServicesRequest
type DescribeVpcEndpointServicesInput struct {
	_ struct{} `type:"structure"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// One or more filters.
	//
	//    * service-name: The name of the service.
	//
	//    * tag:<key> - The key/value combination of a tag assigned to the resource.
	//    Use the tag key in the filter name and the tag value as the filter value.
	//    For example, to find all resources that have a tag with the key Owner
	//    and the value TeamA, specify tag:Owner for the filter name and TeamA for
	//    the filter value.
	//
	//    * tag-key - The key of a tag assigned to the resource. Use this filter
	//    to find all resources assigned a tag with a specific key, regardless of
	//    the tag value.
	Filters []Filter `locationName:"Filter" locationNameList:"Filter" type:"list"`

	// The maximum number of items to return for this request. The request returns
	// a token that you can specify in a subsequent call to get the next set of
	// results.
	//
	// Constraint: If the value is greater than 1000, we return only 1000 items.
	MaxResults *int64 `type:"integer"`

	// The token for the next set of items to return. (You received this token from
	// a prior call.)
	NextToken *string `type:"string"`

	// One or more service names.
	ServiceNames []string `locationName:"ServiceName" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeVpcEndpointServicesInput) String() string {
	return awsutil.Prettify(s)
}

// Contains the output of DescribeVpcEndpointServices.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcEndpointServicesResult
type DescribeVpcEndpointServicesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use when requesting the next set of items. If there are no additional
	// items to return, the string is empty.
	NextToken *string `locationName:"nextToken" type:"string"`

	// Information about the service.
	ServiceDetails []ServiceDetail `locationName:"serviceDetailSet" locationNameList:"item" type:"list"`

	// A list of supported services.
	ServiceNames []string `locationName:"serviceNameSet" locationNameList:"item" type:"list"`
}

// String returns the string representation
func (s DescribeVpcEndpointServicesOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeVpcEndpointServices = "DescribeVpcEndpointServices"

// DescribeVpcEndpointServicesRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Describes available services to which you can create a VPC endpoint.
//
//    // Example sending a request using DescribeVpcEndpointServicesRequest.
//    req := client.DescribeVpcEndpointServicesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/DescribeVpcEndpointServices
func (c *Client) DescribeVpcEndpointServicesRequest(input *DescribeVpcEndpointServicesInput) DescribeVpcEndpointServicesRequest {
	op := &aws.Operation{
		Name:       opDescribeVpcEndpointServices,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeVpcEndpointServicesInput{}
	}

	req := c.newRequest(op, input, &DescribeVpcEndpointServicesOutput{})
	return DescribeVpcEndpointServicesRequest{Request: req, Input: input, Copy: c.DescribeVpcEndpointServicesRequest}
}

// DescribeVpcEndpointServicesRequest is the request type for the
// DescribeVpcEndpointServices API operation.
type DescribeVpcEndpointServicesRequest struct {
	*aws.Request
	Input *DescribeVpcEndpointServicesInput
	Copy  func(*DescribeVpcEndpointServicesInput) DescribeVpcEndpointServicesRequest
}

// Send marshals and sends the DescribeVpcEndpointServices API request.
func (r DescribeVpcEndpointServicesRequest) Send(ctx context.Context) (*DescribeVpcEndpointServicesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeVpcEndpointServicesResponse{
		DescribeVpcEndpointServicesOutput: r.Request.Data.(*DescribeVpcEndpointServicesOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeVpcEndpointServicesResponse is the response type for the
// DescribeVpcEndpointServices API operation.
type DescribeVpcEndpointServicesResponse struct {
	*DescribeVpcEndpointServicesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeVpcEndpointServices request.
func (r *DescribeVpcEndpointServicesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
