// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyInstanceCapacityReservationAttributesRequest
type ModifyInstanceCapacityReservationAttributesInput struct {
	_ struct{} `type:"structure"`

	// Information about the Capacity Reservation targeting option.
	//
	// CapacityReservationSpecification is a required field
	CapacityReservationSpecification *CapacityReservationSpecification `type:"structure" required:"true"`

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have
	// the required permissions, the error response is DryRunOperation. Otherwise,
	// it is UnauthorizedOperation.
	DryRun *bool `type:"boolean"`

	// The ID of the instance to be modified.
	//
	// InstanceId is a required field
	InstanceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s ModifyInstanceCapacityReservationAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyInstanceCapacityReservationAttributesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModifyInstanceCapacityReservationAttributesInput"}

	if s.CapacityReservationSpecification == nil {
		invalidParams.Add(aws.NewErrParamRequired("CapacityReservationSpecification"))
	}

	if s.InstanceId == nil {
		invalidParams.Add(aws.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyInstanceCapacityReservationAttributesResult
type ModifyInstanceCapacityReservationAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Returns true if the request succeeds; otherwise, it returns an error.
	Return *bool `locationName:"return" type:"boolean"`
}

// String returns the string representation
func (s ModifyInstanceCapacityReservationAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifyInstanceCapacityReservationAttributes = "ModifyInstanceCapacityReservationAttributes"

// ModifyInstanceCapacityReservationAttributesRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Modifies the Capacity Reservation settings for a stopped instance. Use this
// action to configure an instance to target a specific Capacity Reservation,
// run in any open Capacity Reservation with matching attributes, or run On-Demand
// Instance capacity.
//
//    // Example sending a request using ModifyInstanceCapacityReservationAttributesRequest.
//    req := client.ModifyInstanceCapacityReservationAttributesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifyInstanceCapacityReservationAttributes
func (c *Client) ModifyInstanceCapacityReservationAttributesRequest(input *ModifyInstanceCapacityReservationAttributesInput) ModifyInstanceCapacityReservationAttributesRequest {
	op := &aws.Operation{
		Name:       opModifyInstanceCapacityReservationAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyInstanceCapacityReservationAttributesInput{}
	}

	req := c.newRequest(op, input, &ModifyInstanceCapacityReservationAttributesOutput{})
	return ModifyInstanceCapacityReservationAttributesRequest{Request: req, Input: input, Copy: c.ModifyInstanceCapacityReservationAttributesRequest}
}

// ModifyInstanceCapacityReservationAttributesRequest is the request type for the
// ModifyInstanceCapacityReservationAttributes API operation.
type ModifyInstanceCapacityReservationAttributesRequest struct {
	*aws.Request
	Input *ModifyInstanceCapacityReservationAttributesInput
	Copy  func(*ModifyInstanceCapacityReservationAttributesInput) ModifyInstanceCapacityReservationAttributesRequest
}

// Send marshals and sends the ModifyInstanceCapacityReservationAttributes API request.
func (r ModifyInstanceCapacityReservationAttributesRequest) Send(ctx context.Context) (*ModifyInstanceCapacityReservationAttributesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifyInstanceCapacityReservationAttributesResponse{
		ModifyInstanceCapacityReservationAttributesOutput: r.Request.Data.(*ModifyInstanceCapacityReservationAttributesOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifyInstanceCapacityReservationAttributesResponse is the response type for the
// ModifyInstanceCapacityReservationAttributes API operation.
type ModifyInstanceCapacityReservationAttributesResponse struct {
	*ModifyInstanceCapacityReservationAttributesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifyInstanceCapacityReservationAttributes request.
func (r *ModifyInstanceCapacityReservationAttributesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
