// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticsearchservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Container for request parameters to GetCompatibleElasticsearchVersions operation.
type GetCompatibleElasticsearchVersionsInput struct {
	_ struct{} `type:"structure"`

	// The name of an Elasticsearch domain. Domain names are unique across the domains
	// owned by an account within an AWS region. Domain names start with a letter
	// or number and can contain the following characters: a-z (lowercase), 0-9,
	// and - (hyphen).
	DomainName *string `location:"querystring" locationName:"domainName" min:"3" type:"string"`
}

// String returns the string representation
func (s GetCompatibleElasticsearchVersionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetCompatibleElasticsearchVersionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetCompatibleElasticsearchVersionsInput"}
	if s.DomainName != nil && len(*s.DomainName) < 3 {
		invalidParams.Add(aws.NewErrParamMinLen("DomainName", 3))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetCompatibleElasticsearchVersionsInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.DomainName != nil {
		v := *s.DomainName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "domainName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Container for response returned by GetCompatibleElasticsearchVersions operation.
type GetCompatibleElasticsearchVersionsOutput struct {
	_ struct{} `type:"structure"`

	// A map of compatible Elasticsearch versions returned as part of the GetCompatibleElasticsearchVersions
	// operation.
	CompatibleElasticsearchVersions []CompatibleVersionsMap `type:"list"`
}

// String returns the string representation
func (s GetCompatibleElasticsearchVersionsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetCompatibleElasticsearchVersionsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.CompatibleElasticsearchVersions) > 0 {
		v := s.CompatibleElasticsearchVersions

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "CompatibleElasticsearchVersions", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opGetCompatibleElasticsearchVersions = "GetCompatibleElasticsearchVersions"

// GetCompatibleElasticsearchVersionsRequest returns a request value for making API operation for
// Amazon Elasticsearch Service.
//
// Returns a list of upgrade compatible Elastisearch versions. You can optionally
// pass a DomainName to get all upgrade compatible Elasticsearch versions for
// that specific domain.
//
//    // Example sending a request using GetCompatibleElasticsearchVersionsRequest.
//    req := client.GetCompatibleElasticsearchVersionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) GetCompatibleElasticsearchVersionsRequest(input *GetCompatibleElasticsearchVersionsInput) GetCompatibleElasticsearchVersionsRequest {
	op := &aws.Operation{
		Name:       opGetCompatibleElasticsearchVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/2015-01-01/es/compatibleVersions",
	}

	if input == nil {
		input = &GetCompatibleElasticsearchVersionsInput{}
	}

	req := c.newRequest(op, input, &GetCompatibleElasticsearchVersionsOutput{})
	return GetCompatibleElasticsearchVersionsRequest{Request: req, Input: input, Copy: c.GetCompatibleElasticsearchVersionsRequest}
}

// GetCompatibleElasticsearchVersionsRequest is the request type for the
// GetCompatibleElasticsearchVersions API operation.
type GetCompatibleElasticsearchVersionsRequest struct {
	*aws.Request
	Input *GetCompatibleElasticsearchVersionsInput
	Copy  func(*GetCompatibleElasticsearchVersionsInput) GetCompatibleElasticsearchVersionsRequest
}

// Send marshals and sends the GetCompatibleElasticsearchVersions API request.
func (r GetCompatibleElasticsearchVersionsRequest) Send(ctx context.Context) (*GetCompatibleElasticsearchVersionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetCompatibleElasticsearchVersionsResponse{
		GetCompatibleElasticsearchVersionsOutput: r.Request.Data.(*GetCompatibleElasticsearchVersionsOutput),
		response:                                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetCompatibleElasticsearchVersionsResponse is the response type for the
// GetCompatibleElasticsearchVersions API operation.
type GetCompatibleElasticsearchVersionsResponse struct {
	*GetCompatibleElasticsearchVersionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetCompatibleElasticsearchVersions request.
func (r *GetCompatibleElasticsearchVersionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
