// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccessKeysRequest
type ListAccessKeysInput struct {
	_ struct{} `type:"structure"`

	// Use this parameter only when paginating results and only after you receive
	// a response indicating that the results are truncated. Set it to the value
	// of the Marker element in the response that you received to indicate where
	// the next call should start.
	Marker *string `min:"1" type:"string"`

	// Use this only when paginating results to indicate the maximum number of items
	// you want in the response. If additional items exist beyond the maximum you
	// specify, the IsTruncated response element is true.
	//
	// If you do not include this parameter, the number of items defaults to 100.
	// Note that IAM might return fewer results, even when there are more results
	// available. In that case, the IsTruncated response element returns true, and
	// Marker contains a value to include in the subsequent call that tells the
	// service where to continue from.
	MaxItems *int64 `min:"1" type:"integer"`

	// The name of the user.
	//
	// This parameter allows (through its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: _+=,.@-
	UserName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAccessKeysInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAccessKeysInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListAccessKeysInput"}
	if s.Marker != nil && len(*s.Marker) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Marker", 1))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxItems", 1))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the response to a successful ListAccessKeys request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccessKeysResponse
type ListAccessKeysOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects containing metadata about the access keys.
	//
	// AccessKeyMetadata is a required field
	AccessKeyMetadata []AccessKeyMetadata `type:"list" required:"true"`

	// A flag that indicates whether there are more items to return. If your results
	// were truncated, you can make a subsequent pagination request using the Marker
	// request parameter to retrieve more items. Note that IAM might return fewer
	// than the MaxItems number of results even when there are more results available.
	// We recommend that you check IsTruncated after every call to ensure that you
	// receive all your results.
	IsTruncated *bool `type:"boolean"`

	// When IsTruncated is true, this element is present and contains the value
	// to use for the Marker parameter in a subsequent pagination request.
	Marker *string `type:"string"`
}

// String returns the string representation
func (s ListAccessKeysOutput) String() string {
	return awsutil.Prettify(s)
}

const opListAccessKeys = "ListAccessKeys"

// ListAccessKeysRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Returns information about the access key IDs associated with the specified
// IAM user. If there is none, the operation returns an empty list.
//
// Although each user is limited to a small number of keys, you can still paginate
// the results using the MaxItems and Marker parameters.
//
// If the UserName field is not specified, the user name is determined implicitly
// based on the AWS access key ID used to sign the request. This operation works
// for access keys under the AWS account. Consequently, you can use this operation
// to manage AWS account root user credentials even if the AWS account has no
// associated users.
//
// To ensure the security of your AWS account, the secret access key is accessible
// only during key and user creation.
//
//    // Example sending a request using ListAccessKeysRequest.
//    req := client.ListAccessKeysRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/ListAccessKeys
func (c *Client) ListAccessKeysRequest(input *ListAccessKeysInput) ListAccessKeysRequest {
	op := &aws.Operation{
		Name:       opListAccessKeys,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxItems",
			TruncationToken: "IsTruncated",
		},
	}

	if input == nil {
		input = &ListAccessKeysInput{}
	}

	req := c.newRequest(op, input, &ListAccessKeysOutput{})
	return ListAccessKeysRequest{Request: req, Input: input, Copy: c.ListAccessKeysRequest}
}

// ListAccessKeysRequest is the request type for the
// ListAccessKeys API operation.
type ListAccessKeysRequest struct {
	*aws.Request
	Input *ListAccessKeysInput
	Copy  func(*ListAccessKeysInput) ListAccessKeysRequest
}

// Send marshals and sends the ListAccessKeys API request.
func (r ListAccessKeysRequest) Send(ctx context.Context) (*ListAccessKeysResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListAccessKeysResponse{
		ListAccessKeysOutput: r.Request.Data.(*ListAccessKeysOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListAccessKeysRequestPaginator returns a paginator for ListAccessKeys.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListAccessKeysRequest(input)
//   p := iam.NewListAccessKeysRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListAccessKeysPaginator(req ListAccessKeysRequest) ListAccessKeysPaginator {
	return ListAccessKeysPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListAccessKeysInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListAccessKeysPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListAccessKeysPaginator struct {
	aws.Pager
}

func (p *ListAccessKeysPaginator) CurrentPage() *ListAccessKeysOutput {
	return p.Pager.CurrentPage().(*ListAccessKeysOutput)
}

// ListAccessKeysResponse is the response type for the
// ListAccessKeys API operation.
type ListAccessKeysResponse struct {
	*ListAccessKeysOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListAccessKeys request.
func (r *ListAccessKeysResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
