// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kinesisvideo

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisvideo-2017-09-30/DeleteStreamInput
type DeleteStreamInput struct {
	_ struct{} `type:"structure"`

	// Optional: The version of the stream that you want to delete.
	//
	// Specify the version as a safeguard to ensure that your are deleting the correct
	// stream. To get the stream version, use the DescribeStream API.
	//
	// If not specified, only the CreationTime is checked before deleting the stream.
	CurrentVersion *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the stream that you want to delete.
	//
	// StreamARN is a required field
	StreamARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteStreamInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteStreamInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteStreamInput"}
	if s.CurrentVersion != nil && len(*s.CurrentVersion) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CurrentVersion", 1))
	}

	if s.StreamARN == nil {
		invalidParams.Add(aws.NewErrParamRequired("StreamARN"))
	}
	if s.StreamARN != nil && len(*s.StreamARN) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StreamARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteStreamInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.CurrentVersion != nil {
		v := *s.CurrentVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "CurrentVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.StreamARN != nil {
		v := *s.StreamARN

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "StreamARN", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisvideo-2017-09-30/DeleteStreamOutput
type DeleteStreamOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteStreamOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteStreamOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteStream = "DeleteStream"

// DeleteStreamRequest returns a request value for making API operation for
// Amazon Kinesis Video Streams.
//
// Deletes a Kinesis video stream and the data contained in the stream.
//
// This method marks the stream for deletion, and makes the data in the stream
// inaccessible immediately.
//
// To ensure that you have the latest version of the stream before deleting
// it, you can specify the stream version. Kinesis Video Streams assigns a version
// to each stream. When you update a stream, Kinesis Video Streams assigns a
// new version number. To get the latest stream version, use the DescribeStream
// API.
//
// This operation requires permission for the KinesisVideo:DeleteStream action.
//
//    // Example sending a request using DeleteStreamRequest.
//    req := client.DeleteStreamRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kinesisvideo-2017-09-30/DeleteStream
func (c *Client) DeleteStreamRequest(input *DeleteStreamInput) DeleteStreamRequest {
	op := &aws.Operation{
		Name:       opDeleteStream,
		HTTPMethod: "POST",
		HTTPPath:   "/deleteStream",
	}

	if input == nil {
		input = &DeleteStreamInput{}
	}

	req := c.newRequest(op, input, &DeleteStreamOutput{})
	return DeleteStreamRequest{Request: req, Input: input, Copy: c.DeleteStreamRequest}
}

// DeleteStreamRequest is the request type for the
// DeleteStream API operation.
type DeleteStreamRequest struct {
	*aws.Request
	Input *DeleteStreamInput
	Copy  func(*DeleteStreamInput) DeleteStreamRequest
}

// Send marshals and sends the DeleteStream API request.
func (r DeleteStreamRequest) Send(ctx context.Context) (*DeleteStreamResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteStreamResponse{
		DeleteStreamOutput: r.Request.Data.(*DeleteStreamOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteStreamResponse is the response type for the
// DeleteStream API operation.
type DeleteStreamResponse struct {
	*DeleteStreamOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteStream request.
func (r *DeleteStreamResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
