// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GetKeyRotationStatusRequest
type GetKeyRotationStatusInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the customer master key (CMK).
	//
	// Specify the key ID or the Amazon Resource Name (ARN) of the CMK. To specify
	// a CMK in a different AWS account, you must use the key ARN.
	//
	// For example:
	//
	//    * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
	//
	//    * Key ARN: arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	//
	// To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.
	//
	// KeyId is a required field
	KeyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetKeyRotationStatusInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetKeyRotationStatusInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetKeyRotationStatusInput"}

	if s.KeyId == nil {
		invalidParams.Add(aws.NewErrParamRequired("KeyId"))
	}
	if s.KeyId != nil && len(*s.KeyId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("KeyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GetKeyRotationStatusResponse
type GetKeyRotationStatusOutput struct {
	_ struct{} `type:"structure"`

	// A Boolean value that specifies whether key rotation is enabled.
	KeyRotationEnabled *bool `type:"boolean"`
}

// String returns the string representation
func (s GetKeyRotationStatusOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetKeyRotationStatus = "GetKeyRotationStatus"

// GetKeyRotationStatusRequest returns a request value for making API operation for
// AWS Key Management Service.
//
// Gets a Boolean value that indicates whether automatic rotation of the key
// material (https://docs.aws.amazon.com/kms/latest/developerguide/rotate-keys.html)
// is enabled for the specified customer master key (CMK).
//
// The result of this operation varies with the key state of the CMK. For details,
// see How Key State Affects Use of a Customer Master Key (https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html)
// in the AWS Key Management Service Developer Guide.
//
//    * Disabled: The key rotation status does not change when you disable a
//    CMK. However, while the CMK is disabled, AWS KMS does not rotate the backing
//    key.
//
//    * Pending deletion: While a CMK is pending deletion, its key rotation
//    status is false and AWS KMS does not rotate the backing key. If you cancel
//    the deletion, the original key rotation status is restored.
//
// To perform this operation on a CMK in a different AWS account, specify the
// key ARN in the value of the KeyId parameter.
//
//    // Example sending a request using GetKeyRotationStatusRequest.
//    req := client.GetKeyRotationStatusRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/kms-2014-11-01/GetKeyRotationStatus
func (c *Client) GetKeyRotationStatusRequest(input *GetKeyRotationStatusInput) GetKeyRotationStatusRequest {
	op := &aws.Operation{
		Name:       opGetKeyRotationStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetKeyRotationStatusInput{}
	}

	req := c.newRequest(op, input, &GetKeyRotationStatusOutput{})
	return GetKeyRotationStatusRequest{Request: req, Input: input, Copy: c.GetKeyRotationStatusRequest}
}

// GetKeyRotationStatusRequest is the request type for the
// GetKeyRotationStatus API operation.
type GetKeyRotationStatusRequest struct {
	*aws.Request
	Input *GetKeyRotationStatusInput
	Copy  func(*GetKeyRotationStatusInput) GetKeyRotationStatusRequest
}

// Send marshals and sends the GetKeyRotationStatus API request.
func (r GetKeyRotationStatusRequest) Send(ctx context.Context) (*GetKeyRotationStatusResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetKeyRotationStatusResponse{
		GetKeyRotationStatusOutput: r.Request.Data.(*GetKeyRotationStatusOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetKeyRotationStatusResponse is the response type for the
// GetKeyRotationStatus API operation.
type GetKeyRotationStatusResponse struct {
	*GetKeyRotationStatusOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetKeyRotationStatus request.
func (r *GetKeyRotationStatusResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
