// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDiskRequest
type GetDiskInput struct {
	_ struct{} `type:"structure"`

	// The name of the disk (e.g., my-disk).
	//
	// DiskName is a required field
	DiskName *string `locationName:"diskName" type:"string" required:"true"`
}

// String returns the string representation
func (s GetDiskInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDiskInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetDiskInput"}

	if s.DiskName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DiskName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDiskResult
type GetDiskOutput struct {
	_ struct{} `type:"structure"`

	// An object containing information about the disk.
	Disk *Disk `locationName:"disk" type:"structure"`
}

// String returns the string representation
func (s GetDiskOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetDisk = "GetDisk"

// GetDiskRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Returns information about a specific block storage disk.
//
//    // Example sending a request using GetDiskRequest.
//    req := client.GetDiskRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/GetDisk
func (c *Client) GetDiskRequest(input *GetDiskInput) GetDiskRequest {
	op := &aws.Operation{
		Name:       opGetDisk,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDiskInput{}
	}

	req := c.newRequest(op, input, &GetDiskOutput{})
	return GetDiskRequest{Request: req, Input: input, Copy: c.GetDiskRequest}
}

// GetDiskRequest is the request type for the
// GetDisk API operation.
type GetDiskRequest struct {
	*aws.Request
	Input *GetDiskInput
	Copy  func(*GetDiskInput) GetDiskRequest
}

// Send marshals and sends the GetDisk API request.
func (r GetDiskRequest) Send(ctx context.Context) (*GetDiskResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetDiskResponse{
		GetDiskOutput: r.Request.Data.(*GetDiskOutput),
		response:      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetDiskResponse is the response type for the
// GetDisk API operation.
type GetDiskResponse struct {
	*GetDiskOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetDisk request.
func (r *GetDiskResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
