// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/IsVpcPeeredRequest
type IsVpcPeeredInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s IsVpcPeeredInput) String() string {
	return awsutil.Prettify(s)
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/IsVpcPeeredResult
type IsVpcPeeredOutput struct {
	_ struct{} `type:"structure"`

	// Returns true if the Lightsail VPC is peered; otherwise, false.
	IsPeered *bool `locationName:"isPeered" type:"boolean"`
}

// String returns the string representation
func (s IsVpcPeeredOutput) String() string {
	return awsutil.Prettify(s)
}

const opIsVpcPeered = "IsVpcPeered"

// IsVpcPeeredRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Returns a Boolean value indicating whether your Lightsail VPC is peered.
//
//    // Example sending a request using IsVpcPeeredRequest.
//    req := client.IsVpcPeeredRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/IsVpcPeered
func (c *Client) IsVpcPeeredRequest(input *IsVpcPeeredInput) IsVpcPeeredRequest {
	op := &aws.Operation{
		Name:       opIsVpcPeered,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &IsVpcPeeredInput{}
	}

	req := c.newRequest(op, input, &IsVpcPeeredOutput{})
	return IsVpcPeeredRequest{Request: req, Input: input, Copy: c.IsVpcPeeredRequest}
}

// IsVpcPeeredRequest is the request type for the
// IsVpcPeered API operation.
type IsVpcPeeredRequest struct {
	*aws.Request
	Input *IsVpcPeeredInput
	Copy  func(*IsVpcPeeredInput) IsVpcPeeredRequest
}

// Send marshals and sends the IsVpcPeered API request.
func (r IsVpcPeeredRequest) Send(ctx context.Context) (*IsVpcPeeredResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &IsVpcPeeredResponse{
		IsVpcPeeredOutput: r.Request.Data.(*IsVpcPeeredOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// IsVpcPeeredResponse is the response type for the
// IsVpcPeered API operation.
type IsVpcPeeredResponse struct {
	*IsVpcPeeredOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// IsVpcPeered request.
func (r *IsVpcPeeredResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
