// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package mediastore

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/GetContainerPolicyInput
type GetContainerPolicyInput struct {
	_ struct{} `type:"structure"`

	// The name of the container.
	//
	// ContainerName is a required field
	ContainerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetContainerPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetContainerPolicyInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetContainerPolicyInput"}

	if s.ContainerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ContainerName"))
	}
	if s.ContainerName != nil && len(*s.ContainerName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ContainerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/GetContainerPolicyOutput
type GetContainerPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The contents of the access policy.
	//
	// Policy is a required field
	Policy *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetContainerPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetContainerPolicy = "GetContainerPolicy"

// GetContainerPolicyRequest returns a request value for making API operation for
// AWS Elemental MediaStore.
//
// Retrieves the access policy for the specified container. For information
// about the data that is included in an access policy, see the AWS Identity
// and Access Management User Guide (https://aws.amazon.com/documentation/iam/).
//
//    // Example sending a request using GetContainerPolicyRequest.
//    req := client.GetContainerPolicyRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/mediastore-2017-09-01/GetContainerPolicy
func (c *Client) GetContainerPolicyRequest(input *GetContainerPolicyInput) GetContainerPolicyRequest {
	op := &aws.Operation{
		Name:       opGetContainerPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetContainerPolicyInput{}
	}

	req := c.newRequest(op, input, &GetContainerPolicyOutput{})
	return GetContainerPolicyRequest{Request: req, Input: input, Copy: c.GetContainerPolicyRequest}
}

// GetContainerPolicyRequest is the request type for the
// GetContainerPolicy API operation.
type GetContainerPolicyRequest struct {
	*aws.Request
	Input *GetContainerPolicyInput
	Copy  func(*GetContainerPolicyInput) GetContainerPolicyRequest
}

// Send marshals and sends the GetContainerPolicy API request.
func (r GetContainerPolicyRequest) Send(ctx context.Context) (*GetContainerPolicyResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetContainerPolicyResponse{
		GetContainerPolicyOutput: r.Request.Data.(*GetContainerPolicyOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetContainerPolicyResponse is the response type for the
// GetContainerPolicy API operation.
type GetContainerPolicyResponse struct {
	*GetContainerPolicyOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetContainerPolicy request.
func (r *GetContainerPolicyResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
