// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53domains

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// The RegisterDomain request includes the following elements.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/RegisterDomainRequest
type RegisterDomainInput struct {
	_ struct{} `type:"structure"`

	// Provides detailed contact information.
	//
	// AdminContact is a required field
	AdminContact *ContactDetail `type:"structure" required:"true"`

	// Indicates whether the domain will be automatically renewed (true) or not
	// (false). Autorenewal only takes effect after the account is charged.
	//
	// Default: true
	AutoRenew *bool `type:"boolean"`

	// The domain name that you want to register.
	//
	// Constraints: The domain name can contain only the letters a through z, the
	// numbers 0 through 9, and hyphen (-). Internationalized Domain Names are not
	// supported.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// The number of years that you want to register the domain for. Domains are
	// registered for a minimum of one year. The maximum period depends on the top-level
	// domain. For the range of valid values for your domain, see Domains that You
	// Can Register with Amazon Route 53 (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html)
	// in the Amazon Route 53 Developer Guide.
	//
	// Default: 1
	//
	// DurationInYears is a required field
	DurationInYears *int64 `min:"1" type:"integer" required:"true"`

	// Reserved for future use.
	IdnLangCode *string `type:"string"`

	// Whether you want to conceal contact information from WHOIS queries. If you
	// specify true, WHOIS ("who is") queries return contact information either
	// for Amazon Registrar (for .com, .net, and .org domains) or for our registrar
	// associate, Gandi (for all other TLDs). If you specify false, WHOIS queries
	// return the information that you entered for the admin contact.
	//
	// Default: true
	PrivacyProtectAdminContact *bool `type:"boolean"`

	// Whether you want to conceal contact information from WHOIS queries. If you
	// specify true, WHOIS ("who is") queries return contact information either
	// for Amazon Registrar (for .com, .net, and .org domains) or for our registrar
	// associate, Gandi (for all other TLDs). If you specify false, WHOIS queries
	// return the information that you entered for the registrant contact (the domain
	// owner).
	//
	// Default: true
	PrivacyProtectRegistrantContact *bool `type:"boolean"`

	// Whether you want to conceal contact information from WHOIS queries. If you
	// specify true, WHOIS ("who is") queries return contact information either
	// for Amazon Registrar (for .com, .net, and .org domains) or for our registrar
	// associate, Gandi (for all other TLDs). If you specify false, WHOIS queries
	// return the information that you entered for the technical contact.
	//
	// Default: true
	PrivacyProtectTechContact *bool `type:"boolean"`

	// Provides detailed contact information.
	//
	// RegistrantContact is a required field
	RegistrantContact *ContactDetail `type:"structure" required:"true"`

	// Provides detailed contact information.
	//
	// TechContact is a required field
	TechContact *ContactDetail `type:"structure" required:"true"`
}

// String returns the string representation
func (s RegisterDomainInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterDomainInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RegisterDomainInput"}

	if s.AdminContact == nil {
		invalidParams.Add(aws.NewErrParamRequired("AdminContact"))
	}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}

	if s.DurationInYears == nil {
		invalidParams.Add(aws.NewErrParamRequired("DurationInYears"))
	}
	if s.DurationInYears != nil && *s.DurationInYears < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("DurationInYears", 1))
	}

	if s.RegistrantContact == nil {
		invalidParams.Add(aws.NewErrParamRequired("RegistrantContact"))
	}

	if s.TechContact == nil {
		invalidParams.Add(aws.NewErrParamRequired("TechContact"))
	}
	if s.AdminContact != nil {
		if err := s.AdminContact.Validate(); err != nil {
			invalidParams.AddNested("AdminContact", err.(aws.ErrInvalidParams))
		}
	}
	if s.RegistrantContact != nil {
		if err := s.RegistrantContact.Validate(); err != nil {
			invalidParams.AddNested("RegistrantContact", err.(aws.ErrInvalidParams))
		}
	}
	if s.TechContact != nil {
		if err := s.TechContact.Validate(); err != nil {
			invalidParams.AddNested("TechContact", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The RegisterDomain response includes the following element.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/RegisterDomainResponse
type RegisterDomainOutput struct {
	_ struct{} `type:"structure"`

	// Identifier for tracking the progress of the request. To use this ID to query
	// the operation status, use GetOperationDetail.
	//
	// OperationId is a required field
	OperationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RegisterDomainOutput) String() string {
	return awsutil.Prettify(s)
}

const opRegisterDomain = "RegisterDomain"

// RegisterDomainRequest returns a request value for making API operation for
// Amazon Route 53 Domains.
//
// This operation registers a domain. Domains are registered either by Amazon
// Registrar (for .com, .net, and .org domains) or by our registrar associate,
// Gandi (for all other domains). For some top-level domains (TLDs), this operation
// requires extra parameters.
//
// When you register a domain, Amazon Route 53 does the following:
//
//    * Creates a Amazon Route 53 hosted zone that has the same name as the
//    domain. Amazon Route 53 assigns four name servers to your hosted zone
//    and automatically updates your domain registration with the names of these
//    name servers.
//
//    * Enables autorenew, so your domain registration will renew automatically
//    each year. We'll notify you in advance of the renewal date so you can
//    choose whether to renew the registration.
//
//    * Optionally enables privacy protection, so WHOIS queries return contact
//    information either for Amazon Registrar (for .com, .net, and .org domains)
//    or for our registrar associate, Gandi (for all other TLDs). If you don't
//    enable privacy protection, WHOIS queries return the information that you
//    entered for the registrant, admin, and tech contacts.
//
//    * If registration is successful, returns an operation ID that you can
//    use to track the progress and completion of the action. If the request
//    is not completed successfully, the domain registrant is notified by email.
//
//    * Charges your AWS account an amount based on the top-level domain. For
//    more information, see Amazon Route 53 Pricing (http://aws.amazon.com/route53/pricing/).
//
//    // Example sending a request using RegisterDomainRequest.
//    req := client.RegisterDomainRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/RegisterDomain
func (c *Client) RegisterDomainRequest(input *RegisterDomainInput) RegisterDomainRequest {
	op := &aws.Operation{
		Name:       opRegisterDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterDomainInput{}
	}

	req := c.newRequest(op, input, &RegisterDomainOutput{})
	return RegisterDomainRequest{Request: req, Input: input, Copy: c.RegisterDomainRequest}
}

// RegisterDomainRequest is the request type for the
// RegisterDomain API operation.
type RegisterDomainRequest struct {
	*aws.Request
	Input *RegisterDomainInput
	Copy  func(*RegisterDomainInput) RegisterDomainRequest
}

// Send marshals and sends the RegisterDomain API request.
func (r RegisterDomainRequest) Send(ctx context.Context) (*RegisterDomainResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RegisterDomainResponse{
		RegisterDomainOutput: r.Request.Data.(*RegisterDomainOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RegisterDomainResponse is the response type for the
// RegisterDomain API operation.
type RegisterDomainResponse struct {
	*RegisterDomainOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RegisterDomain request.
func (r *RegisterDomainResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
