// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53domains

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// A RenewDomain request includes the number of years that you want to renew
// for and the current expiration year.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/RenewDomainRequest
type RenewDomainInput struct {
	_ struct{} `type:"structure"`

	// The year when the registration for the domain is set to expire. This value
	// must match the current expiration date for the domain.
	//
	// CurrentExpiryYear is a required field
	CurrentExpiryYear *int64 `type:"integer" required:"true"`

	// The name of the domain that you want to renew.
	//
	// DomainName is a required field
	DomainName *string `type:"string" required:"true"`

	// The number of years that you want to renew the domain for. The maximum number
	// of years depends on the top-level domain. For the range of valid values for
	// your domain, see Domains that You Can Register with Amazon Route 53 (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/registrar-tld-list.html)
	// in the Amazon Route 53 Developer Guide.
	//
	// Default: 1
	DurationInYears *int64 `min:"1" type:"integer"`
}

// String returns the string representation
func (s RenewDomainInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RenewDomainInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "RenewDomainInput"}

	if s.CurrentExpiryYear == nil {
		invalidParams.Add(aws.NewErrParamRequired("CurrentExpiryYear"))
	}

	if s.DomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainName"))
	}
	if s.DurationInYears != nil && *s.DurationInYears < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("DurationInYears", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/RenewDomainResponse
type RenewDomainOutput struct {
	_ struct{} `type:"structure"`

	// The identifier for tracking the progress of the request. To use this ID to
	// query the operation status, use GetOperationDetail.
	//
	// OperationId is a required field
	OperationId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s RenewDomainOutput) String() string {
	return awsutil.Prettify(s)
}

const opRenewDomain = "RenewDomain"

// RenewDomainRequest returns a request value for making API operation for
// Amazon Route 53 Domains.
//
// This operation renews a domain for the specified number of years. The cost
// of renewing your domain is billed to your AWS account.
//
// We recommend that you renew your domain several weeks before the expiration
// date. Some TLD registries delete domains before the expiration date if you
// haven't renewed far enough in advance. For more information about renewing
// domain registration, see Renewing Registration for a Domain (http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/domain-renew.html)
// in the Amazon Route 53 Developer Guide.
//
//    // Example sending a request using RenewDomainRequest.
//    req := client.RenewDomainRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/route53domains-2014-05-15/RenewDomain
func (c *Client) RenewDomainRequest(input *RenewDomainInput) RenewDomainRequest {
	op := &aws.Operation{
		Name:       opRenewDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RenewDomainInput{}
	}

	req := c.newRequest(op, input, &RenewDomainOutput{})
	return RenewDomainRequest{Request: req, Input: input, Copy: c.RenewDomainRequest}
}

// RenewDomainRequest is the request type for the
// RenewDomain API operation.
type RenewDomainRequest struct {
	*aws.Request
	Input *RenewDomainInput
	Copy  func(*RenewDomainInput) RenewDomainRequest
}

// Send marshals and sends the RenewDomain API request.
func (r RenewDomainRequest) Send(ctx context.Context) (*RenewDomainResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &RenewDomainResponse{
		RenewDomainOutput: r.Request.Data.(*RenewDomainOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// RenewDomainResponse is the response type for the
// RenewDomain API operation.
type RenewDomainResponse struct {
	*RenewDomainOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// RenewDomain request.
func (r *RenewDomainResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
