// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package s3

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restxml"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketLifecycleRequest
type DeleteBucketLifecycleInput struct {
	_ struct{} `type:"structure"`

	// Bucket is a required field
	Bucket *string `location:"uri" locationName:"Bucket" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBucketLifecycleInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBucketLifecycleInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteBucketLifecycleInput"}

	if s.Bucket == nil {
		invalidParams.Add(aws.NewErrParamRequired("Bucket"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

func (s *DeleteBucketLifecycleInput) getBucket() (v string) {
	if s.Bucket == nil {
		return v
	}
	return *s.Bucket
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteBucketLifecycleInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.Bucket != nil {
		v := *s.Bucket

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "Bucket", protocol.StringValue(v), metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketLifecycleOutput
type DeleteBucketLifecycleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBucketLifecycleOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteBucketLifecycleOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteBucketLifecycle = "DeleteBucketLifecycle"

// DeleteBucketLifecycleRequest returns a request value for making API operation for
// Amazon Simple Storage Service.
//
// Deletes the lifecycle configuration from the bucket.
//
//    // Example sending a request using DeleteBucketLifecycleRequest.
//    req := client.DeleteBucketLifecycleRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/s3-2006-03-01/DeleteBucketLifecycle
func (c *Client) DeleteBucketLifecycleRequest(input *DeleteBucketLifecycleInput) DeleteBucketLifecycleRequest {
	op := &aws.Operation{
		Name:       opDeleteBucketLifecycle,
		HTTPMethod: "DELETE",
		HTTPPath:   "/{Bucket}?lifecycle",
	}

	if input == nil {
		input = &DeleteBucketLifecycleInput{}
	}

	req := c.newRequest(op, input, &DeleteBucketLifecycleOutput{})
	req.Handlers.Unmarshal.Remove(restxml.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteBucketLifecycleRequest{Request: req, Input: input, Copy: c.DeleteBucketLifecycleRequest}
}

// DeleteBucketLifecycleRequest is the request type for the
// DeleteBucketLifecycle API operation.
type DeleteBucketLifecycleRequest struct {
	*aws.Request
	Input *DeleteBucketLifecycleInput
	Copy  func(*DeleteBucketLifecycleInput) DeleteBucketLifecycleRequest
}

// Send marshals and sends the DeleteBucketLifecycle API request.
func (r DeleteBucketLifecycleRequest) Send(ctx context.Context) (*DeleteBucketLifecycleResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteBucketLifecycleResponse{
		DeleteBucketLifecycleOutput: r.Request.Data.(*DeleteBucketLifecycleOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteBucketLifecycleResponse is the response type for the
// DeleteBucketLifecycle API operation.
type DeleteBucketLifecycleResponse struct {
	*DeleteBucketLifecycleOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteBucketLifecycle request.
func (r *DeleteBucketLifecycleResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
