// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ses

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents a request to return the details of a receipt rule set. You use
// receipt rule sets to receive email with Amazon SES. For more information,
// see the Amazon SES Developer Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-concepts.html).
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeReceiptRuleSetRequest
type DescribeReceiptRuleSetInput struct {
	_ struct{} `type:"structure"`

	// The name of the receipt rule set to describe.
	//
	// RuleSetName is a required field
	RuleSetName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeReceiptRuleSetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeReceiptRuleSetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeReceiptRuleSetInput"}

	if s.RuleSetName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RuleSetName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the details of the specified receipt rule set.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeReceiptRuleSetResponse
type DescribeReceiptRuleSetOutput struct {
	_ struct{} `type:"structure"`

	// The metadata for the receipt rule set, which consists of the rule set name
	// and the timestamp of when the rule set was created.
	Metadata *ReceiptRuleSetMetadata `type:"structure"`

	// A list of the receipt rules that belong to the specified receipt rule set.
	Rules []ReceiptRule `type:"list"`
}

// String returns the string representation
func (s DescribeReceiptRuleSetOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeReceiptRuleSet = "DescribeReceiptRuleSet"

// DescribeReceiptRuleSetRequest returns a request value for making API operation for
// Amazon Simple Email Service.
//
// Returns the details of the specified receipt rule set.
//
// For information about managing receipt rule sets, see the Amazon SES Developer
// Guide (http://docs.aws.amazon.com/ses/latest/DeveloperGuide/receiving-email-managing-receipt-rule-sets.html).
//
// You can execute this operation no more than once per second.
//
//    // Example sending a request using DescribeReceiptRuleSetRequest.
//    req := client.DescribeReceiptRuleSetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/DescribeReceiptRuleSet
func (c *Client) DescribeReceiptRuleSetRequest(input *DescribeReceiptRuleSetInput) DescribeReceiptRuleSetRequest {
	op := &aws.Operation{
		Name:       opDescribeReceiptRuleSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeReceiptRuleSetInput{}
	}

	req := c.newRequest(op, input, &DescribeReceiptRuleSetOutput{})
	return DescribeReceiptRuleSetRequest{Request: req, Input: input, Copy: c.DescribeReceiptRuleSetRequest}
}

// DescribeReceiptRuleSetRequest is the request type for the
// DescribeReceiptRuleSet API operation.
type DescribeReceiptRuleSetRequest struct {
	*aws.Request
	Input *DescribeReceiptRuleSetInput
	Copy  func(*DescribeReceiptRuleSetInput) DescribeReceiptRuleSetRequest
}

// Send marshals and sends the DescribeReceiptRuleSet API request.
func (r DescribeReceiptRuleSetRequest) Send(ctx context.Context) (*DescribeReceiptRuleSetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeReceiptRuleSetResponse{
		DescribeReceiptRuleSetOutput: r.Request.Data.(*DescribeReceiptRuleSetOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeReceiptRuleSetResponse is the response type for the
// DescribeReceiptRuleSet API operation.
type DescribeReceiptRuleSetResponse struct {
	*DescribeReceiptRuleSetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeReceiptRuleSet request.
func (r *DescribeReceiptRuleSetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
