// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package support

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/CreateCaseRequest
type CreateCaseInput struct {
	_ struct{} `type:"structure"`

	// The ID of a set of one or more attachments for the case. Create the set by
	// using AddAttachmentsToSet.
	AttachmentSetId *string `locationName:"attachmentSetId" type:"string"`

	// The category of problem for the AWS Support case.
	CategoryCode *string `locationName:"categoryCode" type:"string"`

	// A list of email addresses that AWS Support copies on case correspondence.
	CcEmailAddresses []string `locationName:"ccEmailAddresses" type:"list"`

	// The communication body text when you create an AWS Support case by calling
	// CreateCase.
	//
	// CommunicationBody is a required field
	CommunicationBody *string `locationName:"communicationBody" min:"1" type:"string" required:"true"`

	// The type of issue for the case. You can specify either "customer-service"
	// or "technical." If you do not indicate a value, the default is "technical."
	IssueType *string `locationName:"issueType" type:"string"`

	// The ISO 639-1 code for the language in which AWS provides support. AWS Support
	// currently supports English ("en") and Japanese ("ja"). Language parameters
	// must be passed explicitly for operations that take them.
	Language *string `locationName:"language" type:"string"`

	// The code for the AWS service returned by the call to DescribeServices.
	ServiceCode *string `locationName:"serviceCode" type:"string"`

	// The code for the severity level returned by the call to DescribeSeverityLevels.
	//
	// The availability of severity levels depends on each customer's support subscription.
	// In other words, your subscription may not necessarily require the urgent
	// level of response time.
	SeverityCode *string `locationName:"severityCode" type:"string"`

	// The title of the AWS Support case.
	//
	// Subject is a required field
	Subject *string `locationName:"subject" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateCaseInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateCaseInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateCaseInput"}

	if s.CommunicationBody == nil {
		invalidParams.Add(aws.NewErrParamRequired("CommunicationBody"))
	}
	if s.CommunicationBody != nil && len(*s.CommunicationBody) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("CommunicationBody", 1))
	}

	if s.Subject == nil {
		invalidParams.Add(aws.NewErrParamRequired("Subject"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The AWS Support case ID returned by a successful completion of the CreateCase
// operation.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/CreateCaseResponse
type CreateCaseOutput struct {
	_ struct{} `type:"structure"`

	// The AWS Support case ID requested or returned in the call. The case ID is
	// an alphanumeric string formatted as shown in this example: case-12345678910-2013-c4c1d2bf33c5cf47
	CaseId *string `locationName:"caseId" type:"string"`
}

// String returns the string representation
func (s CreateCaseOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateCase = "CreateCase"

// CreateCaseRequest returns a request value for making API operation for
// AWS Support.
//
// Creates a new case in the AWS Support Center. This operation is modeled on
// the behavior of the AWS Support Center Create Case (https://console.aws.amazon.com/support/home#/case/create)
// page. Its parameters require you to specify the following information:
//
//    * issueType. The type of issue for the case. You can specify either "customer-service"
//    or "technical." If you do not indicate a value, the default is "technical."
//
//    * serviceCode. The code for an AWS service. You obtain the serviceCode
//    by calling DescribeServices.
//
//    * categoryCode. The category for the service defined for the serviceCode
//    value. You also obtain the category code for a service by calling DescribeServices.
//    Each AWS service defines its own set of category codes.
//
//    * severityCode. A value that indicates the urgency of the case, which
//    in turn determines the response time according to your service level agreement
//    with AWS Support. You obtain the SeverityCode by calling DescribeSeverityLevels.
//
//    * subject. The Subject field on the AWS Support Center Create Case (https://console.aws.amazon.com/support/home#/case/create)
//    page.
//
//    * communicationBody. The Description field on the AWS Support Center Create
//    Case (https://console.aws.amazon.com/support/home#/case/create) page.
//
//    * attachmentSetId. The ID of a set of attachments that has been created
//    by using AddAttachmentsToSet.
//
//    * language. The human language in which AWS Support handles the case.
//    English and Japanese are currently supported.
//
//    * ccEmailAddresses. The AWS Support Center CC field on the Create Case
//    (https://console.aws.amazon.com/support/home#/case/create) page. You can
//    list email addresses to be copied on any correspondence about the case.
//    The account that opens the case is already identified by passing the AWS
//    Credentials in the HTTP POST method or in a method or function call from
//    one of the programming languages supported by an AWS SDK (http://aws.amazon.com/tools/).
//
// To add additional communication or attachments to an existing case, use AddCommunicationToCase.
//
// A successful CreateCase request returns an AWS Support case number. Case
// numbers are used by the DescribeCases operation to retrieve existing AWS
// Support cases.
//
//    // Example sending a request using CreateCaseRequest.
//    req := client.CreateCaseRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/support-2013-04-15/CreateCase
func (c *Client) CreateCaseRequest(input *CreateCaseInput) CreateCaseRequest {
	op := &aws.Operation{
		Name:       opCreateCase,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateCaseInput{}
	}

	req := c.newRequest(op, input, &CreateCaseOutput{})
	return CreateCaseRequest{Request: req, Input: input, Copy: c.CreateCaseRequest}
}

// CreateCaseRequest is the request type for the
// CreateCase API operation.
type CreateCaseRequest struct {
	*aws.Request
	Input *CreateCaseInput
	Copy  func(*CreateCaseInput) CreateCaseRequest
}

// Send marshals and sends the CreateCase API request.
func (r CreateCaseRequest) Send(ctx context.Context) (*CreateCaseResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateCaseResponse{
		CreateCaseOutput: r.Request.Data.(*CreateCaseOutput),
		response:         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateCaseResponse is the response type for the
// CreateCase API operation.
type CreateCaseResponse struct {
	*CreateCaseOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateCase request.
func (r *CreateCaseResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
