// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// The GET request to get all the usage plans of the caller's account.
type GetUsagePlansInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the API key associated with the usage plans.
	KeyId *string `location:"querystring" locationName:"keyId" type:"string"`

	// The maximum number of returned results per page. The default value is 25
	// and the maximum value is 500.
	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	// The current pagination position in the paged result set.
	Position *string `location:"querystring" locationName:"position" type:"string"`
}

// String returns the string representation
func (s GetUsagePlansInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetUsagePlansInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.KeyId != nil {
		v := *s.KeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "keyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Limit != nil {
		v := *s.Limit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "limit", protocol.Int64Value(v), metadata)
	}
	if s.Position != nil {
		v := *s.Position

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "position", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents a collection of usage plans for an AWS account.
//
// Create and Use Usage Plans (https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html)
type GetUsagePlansOutput struct {
	_ struct{} `type:"structure"`

	// The current page of elements from this collection.
	Items []UsagePlan `locationName:"item" type:"list"`

	Position *string `locationName:"position" type:"string"`
}

// String returns the string representation
func (s GetUsagePlansOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetUsagePlansOutput) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Items) > 0 {
		v := s.Items

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "item", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Position != nil {
		v := *s.Position

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "position", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGetUsagePlans = "GetUsagePlans"

// GetUsagePlansRequest returns a request value for making API operation for
// Amazon API Gateway.
//
// Gets all the usage plans of the caller's account.
//
//    // Example sending a request using GetUsagePlansRequest.
//    req := client.GetUsagePlansRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) GetUsagePlansRequest(input *GetUsagePlansInput) GetUsagePlansRequest {
	op := &aws.Operation{
		Name:       opGetUsagePlans,
		HTTPMethod: "GET",
		HTTPPath:   "/usageplans",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"position"},
			OutputTokens:    []string{"position"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetUsagePlansInput{}
	}

	req := c.newRequest(op, input, &GetUsagePlansOutput{})
	return GetUsagePlansRequest{Request: req, Input: input, Copy: c.GetUsagePlansRequest}
}

// GetUsagePlansRequest is the request type for the
// GetUsagePlans API operation.
type GetUsagePlansRequest struct {
	*aws.Request
	Input *GetUsagePlansInput
	Copy  func(*GetUsagePlansInput) GetUsagePlansRequest
}

// Send marshals and sends the GetUsagePlans API request.
func (r GetUsagePlansRequest) Send(ctx context.Context) (*GetUsagePlansResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetUsagePlansResponse{
		GetUsagePlansOutput: r.Request.Data.(*GetUsagePlansOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetUsagePlansRequestPaginator returns a paginator for GetUsagePlans.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetUsagePlansRequest(input)
//   p := apigateway.NewGetUsagePlansRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetUsagePlansPaginator(req GetUsagePlansRequest) GetUsagePlansPaginator {
	return GetUsagePlansPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetUsagePlansInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetUsagePlansPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetUsagePlansPaginator struct {
	aws.Pager
}

func (p *GetUsagePlansPaginator) CurrentPage() *GetUsagePlansOutput {
	return p.Pager.CurrentPage().(*GetUsagePlansOutput)
}

// GetUsagePlansResponse is the response type for the
// GetUsagePlans API operation.
type GetUsagePlansResponse struct {
	*GetUsagePlansOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetUsagePlans request.
func (r *GetUsagePlansResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
