// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigatewayv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteApiRequest
type DeleteApiInput struct {
	_ struct{} `type:"structure"`

	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteApiInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApiInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteApiInput"}

	if s.ApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApiId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteApiInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteApiOutput
type DeleteApiOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteApiOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DeleteApiOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opDeleteApi = "DeleteApi"

// DeleteApiRequest returns a request value for making API operation for
// AmazonApiGatewayV2.
//
// Deletes an Api resource.
//
//    // Example sending a request using DeleteApiRequest.
//    req := client.DeleteApiRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/apigatewayv2-2018-11-29/DeleteApi
func (c *Client) DeleteApiRequest(input *DeleteApiInput) DeleteApiRequest {
	op := &aws.Operation{
		Name:       opDeleteApi,
		HTTPMethod: "DELETE",
		HTTPPath:   "/v2/apis/{apiId}",
	}

	if input == nil {
		input = &DeleteApiInput{}
	}

	req := c.newRequest(op, input, &DeleteApiOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return DeleteApiRequest{Request: req, Input: input, Copy: c.DeleteApiRequest}
}

// DeleteApiRequest is the request type for the
// DeleteApi API operation.
type DeleteApiRequest struct {
	*aws.Request
	Input *DeleteApiInput
	Copy  func(*DeleteApiInput) DeleteApiRequest
}

// Send marshals and sends the DeleteApi API request.
func (r DeleteApiRequest) Send(ctx context.Context) (*DeleteApiResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteApiResponse{
		DeleteApiOutput: r.Request.Data.(*DeleteApiOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteApiResponse is the response type for the
// DeleteApi API operation.
type DeleteApiResponse struct {
	*DeleteApiOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteApi request.
func (r *DeleteApiResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
