// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appstream

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeUsersRequest
type DescribeUsersInput struct {
	_ struct{} `type:"structure"`

	// The authentication type for the users in the user pool to describe. You must
	// specify USERPOOL.
	//
	// AuthenticationType is a required field
	AuthenticationType AuthenticationType `type:"string" required:"true" enum:"true"`

	// The maximum size of each page of results.
	MaxResults *int64 `type:"integer"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeUsersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeUsersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeUsersInput"}
	if len(s.AuthenticationType) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("AuthenticationType"))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeUsersResult
type DescribeUsersOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"1" type:"string"`

	// Information about users in the user pool.
	Users []User `type:"list"`
}

// String returns the string representation
func (s DescribeUsersOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeUsers = "DescribeUsers"

// DescribeUsersRequest returns a request value for making API operation for
// Amazon AppStream.
//
// Retrieves a list that describes one or more specified users in the user pool.
//
//    // Example sending a request using DescribeUsersRequest.
//    req := client.DescribeUsersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeUsers
func (c *Client) DescribeUsersRequest(input *DescribeUsersInput) DescribeUsersRequest {
	op := &aws.Operation{
		Name:       opDescribeUsers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeUsersInput{}
	}

	req := c.newRequest(op, input, &DescribeUsersOutput{})
	return DescribeUsersRequest{Request: req, Input: input, Copy: c.DescribeUsersRequest}
}

// DescribeUsersRequest is the request type for the
// DescribeUsers API operation.
type DescribeUsersRequest struct {
	*aws.Request
	Input *DescribeUsersInput
	Copy  func(*DescribeUsersInput) DescribeUsersRequest
}

// Send marshals and sends the DescribeUsers API request.
func (r DescribeUsersRequest) Send(ctx context.Context) (*DescribeUsersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeUsersResponse{
		DescribeUsersOutput: r.Request.Data.(*DescribeUsersOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeUsersResponse is the response type for the
// DescribeUsers API operation.
type DescribeUsersResponse struct {
	*DescribeUsersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeUsers request.
func (r *DescribeUsersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
