// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appstream

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ExpireSessionRequest
type ExpireSessionInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the streaming session.
	//
	// SessionId is a required field
	SessionId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ExpireSessionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExpireSessionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ExpireSessionInput"}

	if s.SessionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SessionId"))
	}
	if s.SessionId != nil && len(*s.SessionId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SessionId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ExpireSessionResult
type ExpireSessionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ExpireSessionOutput) String() string {
	return awsutil.Prettify(s)
}

const opExpireSession = "ExpireSession"

// ExpireSessionRequest returns a request value for making API operation for
// Amazon AppStream.
//
// Immediately stops the specified streaming session.
//
//    // Example sending a request using ExpireSessionRequest.
//    req := client.ExpireSessionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ExpireSession
func (c *Client) ExpireSessionRequest(input *ExpireSessionInput) ExpireSessionRequest {
	op := &aws.Operation{
		Name:       opExpireSession,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ExpireSessionInput{}
	}

	req := c.newRequest(op, input, &ExpireSessionOutput{})
	return ExpireSessionRequest{Request: req, Input: input, Copy: c.ExpireSessionRequest}
}

// ExpireSessionRequest is the request type for the
// ExpireSession API operation.
type ExpireSessionRequest struct {
	*aws.Request
	Input *ExpireSessionInput
	Copy  func(*ExpireSessionInput) ExpireSessionRequest
}

// Send marshals and sends the ExpireSession API request.
func (r ExpireSessionRequest) Send(ctx context.Context) (*ExpireSessionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ExpireSessionResponse{
		ExpireSessionOutput: r.Request.Data.(*ExpireSessionOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ExpireSessionResponse is the response type for the
// ExpireSession API operation.
type ExpireSessionResponse struct {
	*ExpireSessionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ExpireSession request.
func (r *ExpireSessionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
