// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appstream

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListAssociatedFleetsRequest
type ListAssociatedFleetsInput struct {
	_ struct{} `type:"structure"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If this value is null, it retrieves the first page.
	NextToken *string `min:"1" type:"string"`

	// The name of the stack.
	//
	// StackName is a required field
	StackName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListAssociatedFleetsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssociatedFleetsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListAssociatedFleetsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if s.StackName == nil {
		invalidParams.Add(aws.NewErrParamRequired("StackName"))
	}
	if s.StackName != nil && len(*s.StackName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("StackName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListAssociatedFleetsResult
type ListAssociatedFleetsOutput struct {
	_ struct{} `type:"structure"`

	// The name of the fleet.
	Names []string `type:"list"`

	// The pagination token to use to retrieve the next page of results for this
	// operation. If there are no more pages, this value is null.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListAssociatedFleetsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListAssociatedFleets = "ListAssociatedFleets"

// ListAssociatedFleetsRequest returns a request value for making API operation for
// Amazon AppStream.
//
// Retrieves the name of the fleet that is associated with the specified stack.
//
//    // Example sending a request using ListAssociatedFleetsRequest.
//    req := client.ListAssociatedFleetsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListAssociatedFleets
func (c *Client) ListAssociatedFleetsRequest(input *ListAssociatedFleetsInput) ListAssociatedFleetsRequest {
	op := &aws.Operation{
		Name:       opListAssociatedFleets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAssociatedFleetsInput{}
	}

	req := c.newRequest(op, input, &ListAssociatedFleetsOutput{})
	return ListAssociatedFleetsRequest{Request: req, Input: input, Copy: c.ListAssociatedFleetsRequest}
}

// ListAssociatedFleetsRequest is the request type for the
// ListAssociatedFleets API operation.
type ListAssociatedFleetsRequest struct {
	*aws.Request
	Input *ListAssociatedFleetsInput
	Copy  func(*ListAssociatedFleetsInput) ListAssociatedFleetsRequest
}

// Send marshals and sends the ListAssociatedFleets API request.
func (r ListAssociatedFleetsRequest) Send(ctx context.Context) (*ListAssociatedFleetsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListAssociatedFleetsResponse{
		ListAssociatedFleetsOutput: r.Request.Data.(*ListAssociatedFleetsOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListAssociatedFleetsResponse is the response type for the
// ListAssociatedFleets API operation.
type ListAssociatedFleetsResponse struct {
	*ListAssociatedFleetsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListAssociatedFleets request.
func (r *ListAssociatedFleetsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
