// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package chime

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListPhoneNumberOrdersRequest
type ListPhoneNumberOrdersInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of results to return in a single call.
	MaxResults *int64 `location:"querystring" locationName:"max-results" min:"1" type:"integer"`

	// The token to use to retrieve the next page of results.
	NextToken *string `location:"querystring" locationName:"next-token" type:"string"`
}

// String returns the string representation
func (s ListPhoneNumberOrdersInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPhoneNumberOrdersInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListPhoneNumberOrdersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListPhoneNumberOrdersInput) MarshalFields(e protocol.FieldEncoder) error {

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "max-results", protocol.Int64Value(v), metadata)
	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "next-token", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListPhoneNumberOrdersResponse
type ListPhoneNumberOrdersOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results.
	NextToken *string `type:"string"`

	// The phone number order details.
	PhoneNumberOrders []PhoneNumberOrder `type:"list"`
}

// String returns the string representation
func (s ListPhoneNumberOrdersOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListPhoneNumberOrdersOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.PhoneNumberOrders) > 0 {
		v := s.PhoneNumberOrders

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "PhoneNumberOrders", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListPhoneNumberOrders = "ListPhoneNumberOrders"

// ListPhoneNumberOrdersRequest returns a request value for making API operation for
// Amazon Chime.
//
// Lists the phone number orders for the administrator's Amazon Chime account.
//
//    // Example sending a request using ListPhoneNumberOrdersRequest.
//    req := client.ListPhoneNumberOrdersRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/chime-2018-05-01/ListPhoneNumberOrders
func (c *Client) ListPhoneNumberOrdersRequest(input *ListPhoneNumberOrdersInput) ListPhoneNumberOrdersRequest {
	op := &aws.Operation{
		Name:       opListPhoneNumberOrders,
		HTTPMethod: "GET",
		HTTPPath:   "/phone-number-orders",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPhoneNumberOrdersInput{}
	}

	req := c.newRequest(op, input, &ListPhoneNumberOrdersOutput{})
	return ListPhoneNumberOrdersRequest{Request: req, Input: input, Copy: c.ListPhoneNumberOrdersRequest}
}

// ListPhoneNumberOrdersRequest is the request type for the
// ListPhoneNumberOrders API operation.
type ListPhoneNumberOrdersRequest struct {
	*aws.Request
	Input *ListPhoneNumberOrdersInput
	Copy  func(*ListPhoneNumberOrdersInput) ListPhoneNumberOrdersRequest
}

// Send marshals and sends the ListPhoneNumberOrders API request.
func (r ListPhoneNumberOrdersRequest) Send(ctx context.Context) (*ListPhoneNumberOrdersResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListPhoneNumberOrdersResponse{
		ListPhoneNumberOrdersOutput: r.Request.Data.(*ListPhoneNumberOrdersOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListPhoneNumberOrdersRequestPaginator returns a paginator for ListPhoneNumberOrders.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListPhoneNumberOrdersRequest(input)
//   p := chime.NewListPhoneNumberOrdersRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListPhoneNumberOrdersPaginator(req ListPhoneNumberOrdersRequest) ListPhoneNumberOrdersPaginator {
	return ListPhoneNumberOrdersPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListPhoneNumberOrdersInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListPhoneNumberOrdersPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListPhoneNumberOrdersPaginator struct {
	aws.Pager
}

func (p *ListPhoneNumberOrdersPaginator) CurrentPage() *ListPhoneNumberOrdersOutput {
	return p.Pager.CurrentPage().(*ListPhoneNumberOrdersOutput)
}

// ListPhoneNumberOrdersResponse is the response type for the
// ListPhoneNumberOrders API operation.
type ListPhoneNumberOrdersResponse struct {
	*ListPhoneNumberOrdersOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListPhoneNumberOrders request.
func (r *ListPhoneNumberOrdersResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
