// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codepipeline

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input of an AcknowledgeThirdPartyJob action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/AcknowledgeThirdPartyJobInput
type AcknowledgeThirdPartyJobInput struct {
	_ struct{} `type:"structure"`

	// The clientToken portion of the clientId and clientToken pair used to verify
	// that the calling entity is allowed access to the job and its details.
	//
	// ClientToken is a required field
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" required:"true"`

	// The unique system-generated ID of the job.
	//
	// JobId is a required field
	JobId *string `locationName:"jobId" min:"1" type:"string" required:"true"`

	// A system-generated random number that AWS CodePipeline uses to ensure that
	// the job is being worked on by only one job worker. Get this number from the
	// response to a GetThirdPartyJobDetails request.
	//
	// Nonce is a required field
	Nonce *string `locationName:"nonce" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AcknowledgeThirdPartyJobInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AcknowledgeThirdPartyJobInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AcknowledgeThirdPartyJobInput"}

	if s.ClientToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("ClientToken"))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientToken", 1))
	}

	if s.JobId == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobId", 1))
	}

	if s.Nonce == nil {
		invalidParams.Add(aws.NewErrParamRequired("Nonce"))
	}
	if s.Nonce != nil && len(*s.Nonce) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Nonce", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the output of an AcknowledgeThirdPartyJob action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/AcknowledgeThirdPartyJobOutput
type AcknowledgeThirdPartyJobOutput struct {
	_ struct{} `type:"structure"`

	// The status information for the third party job, if any.
	Status JobStatus `locationName:"status" type:"string" enum:"true"`
}

// String returns the string representation
func (s AcknowledgeThirdPartyJobOutput) String() string {
	return awsutil.Prettify(s)
}

const opAcknowledgeThirdPartyJob = "AcknowledgeThirdPartyJob"

// AcknowledgeThirdPartyJobRequest returns a request value for making API operation for
// AWS CodePipeline.
//
// Confirms a job worker has received the specified job. Only used for partner
// actions.
//
//    // Example sending a request using AcknowledgeThirdPartyJobRequest.
//    req := client.AcknowledgeThirdPartyJobRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codepipeline-2015-07-09/AcknowledgeThirdPartyJob
func (c *Client) AcknowledgeThirdPartyJobRequest(input *AcknowledgeThirdPartyJobInput) AcknowledgeThirdPartyJobRequest {
	op := &aws.Operation{
		Name:       opAcknowledgeThirdPartyJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AcknowledgeThirdPartyJobInput{}
	}

	req := c.newRequest(op, input, &AcknowledgeThirdPartyJobOutput{})
	return AcknowledgeThirdPartyJobRequest{Request: req, Input: input, Copy: c.AcknowledgeThirdPartyJobRequest}
}

// AcknowledgeThirdPartyJobRequest is the request type for the
// AcknowledgeThirdPartyJob API operation.
type AcknowledgeThirdPartyJobRequest struct {
	*aws.Request
	Input *AcknowledgeThirdPartyJobInput
	Copy  func(*AcknowledgeThirdPartyJobInput) AcknowledgeThirdPartyJobRequest
}

// Send marshals and sends the AcknowledgeThirdPartyJob API request.
func (r AcknowledgeThirdPartyJobRequest) Send(ctx context.Context) (*AcknowledgeThirdPartyJobResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &AcknowledgeThirdPartyJobResponse{
		AcknowledgeThirdPartyJobOutput: r.Request.Data.(*AcknowledgeThirdPartyJobOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// AcknowledgeThirdPartyJobResponse is the response type for the
// AcknowledgeThirdPartyJob API operation.
type AcknowledgeThirdPartyJobResponse struct {
	*AcknowledgeThirdPartyJobOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// AcknowledgeThirdPartyJob request.
func (r *AcknowledgeThirdPartyJobResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
