// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package cognitoidentityprovider

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the request to list the user import jobs.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserImportJobsRequest
type ListUserImportJobsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of import jobs you want the request to return.
	//
	// MaxResults is a required field
	MaxResults *int64 `min:"1" type:"integer" required:"true"`

	// An identifier that was returned from the previous call to ListUserImportJobs,
	// which can be used to return the next set of import jobs in the list.
	PaginationToken *string `min:"1" type:"string"`

	// The user pool ID for the user pool that the users are being imported into.
	//
	// UserPoolId is a required field
	UserPoolId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListUserImportJobsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListUserImportJobsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListUserImportJobsInput"}

	if s.MaxResults == nil {
		invalidParams.Add(aws.NewErrParamRequired("MaxResults"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.PaginationToken != nil && len(*s.PaginationToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("PaginationToken", 1))
	}

	if s.UserPoolId == nil {
		invalidParams.Add(aws.NewErrParamRequired("UserPoolId"))
	}
	if s.UserPoolId != nil && len(*s.UserPoolId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("UserPoolId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the response from the server to the request to list the user import
// jobs.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserImportJobsResponse
type ListUserImportJobsOutput struct {
	_ struct{} `type:"structure"`

	// An identifier that can be used to return the next set of user import jobs
	// in the list.
	PaginationToken *string `min:"1" type:"string"`

	// The user import jobs.
	UserImportJobs []UserImportJobType `min:"1" type:"list"`
}

// String returns the string representation
func (s ListUserImportJobsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListUserImportJobs = "ListUserImportJobs"

// ListUserImportJobsRequest returns a request value for making API operation for
// Amazon Cognito Identity Provider.
//
// Lists the user import jobs.
//
//    // Example sending a request using ListUserImportJobsRequest.
//    req := client.ListUserImportJobsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/cognito-idp-2016-04-18/ListUserImportJobs
func (c *Client) ListUserImportJobsRequest(input *ListUserImportJobsInput) ListUserImportJobsRequest {
	op := &aws.Operation{
		Name:       opListUserImportJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListUserImportJobsInput{}
	}

	req := c.newRequest(op, input, &ListUserImportJobsOutput{})
	return ListUserImportJobsRequest{Request: req, Input: input, Copy: c.ListUserImportJobsRequest}
}

// ListUserImportJobsRequest is the request type for the
// ListUserImportJobs API operation.
type ListUserImportJobsRequest struct {
	*aws.Request
	Input *ListUserImportJobsInput
	Copy  func(*ListUserImportJobsInput) ListUserImportJobsRequest
}

// Send marshals and sends the ListUserImportJobs API request.
func (r ListUserImportJobsRequest) Send(ctx context.Context) (*ListUserImportJobsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListUserImportJobsResponse{
		ListUserImportJobsOutput: r.Request.Data.(*ListUserImportJobsOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListUserImportJobsResponse is the response type for the
// ListUserImportJobs API operation.
type ListUserImportJobsResponse struct {
	*ListUserImportJobsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListUserImportJobs request.
func (r *ListUserImportJobsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
