// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package databasemigrationservice

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribePendingMaintenanceActionsMessage
type DescribePendingMaintenanceActionsInput struct {
	_ struct{} `type:"structure"`

	Filters []Filter `type:"list"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The maximum number of records to include in the response. If more records
	// exist than the specified MaxRecords value, a pagination token called a marker
	// is included in the response so that the remaining results can be retrieved.
	//
	// Default: 100
	//
	// Constraints: Minimum 20, maximum 100.
	MaxRecords *int64 `type:"integer"`

	// The ARN of the replication instance.
	ReplicationInstanceArn *string `type:"string"`
}

// String returns the string representation
func (s DescribePendingMaintenanceActionsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribePendingMaintenanceActionsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribePendingMaintenanceActionsInput"}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribePendingMaintenanceActionsResponse
type DescribePendingMaintenanceActionsOutput struct {
	_ struct{} `type:"structure"`

	// An optional pagination token provided by a previous request. If this parameter
	// is specified, the response includes only records beyond the marker, up to
	// the value specified by MaxRecords.
	Marker *string `type:"string"`

	// The pending maintenance action.
	PendingMaintenanceActions []ResourcePendingMaintenanceActions `type:"list"`
}

// String returns the string representation
func (s DescribePendingMaintenanceActionsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribePendingMaintenanceActions = "DescribePendingMaintenanceActions"

// DescribePendingMaintenanceActionsRequest returns a request value for making API operation for
// AWS Database Migration Service.
//
// For internal use only
//
//    // Example sending a request using DescribePendingMaintenanceActionsRequest.
//    req := client.DescribePendingMaintenanceActionsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/dms-2016-01-01/DescribePendingMaintenanceActions
func (c *Client) DescribePendingMaintenanceActionsRequest(input *DescribePendingMaintenanceActionsInput) DescribePendingMaintenanceActionsRequest {
	op := &aws.Operation{
		Name:       opDescribePendingMaintenanceActions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"Marker"},
			OutputTokens:    []string{"Marker"},
			LimitToken:      "MaxRecords",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribePendingMaintenanceActionsInput{}
	}

	req := c.newRequest(op, input, &DescribePendingMaintenanceActionsOutput{})
	return DescribePendingMaintenanceActionsRequest{Request: req, Input: input, Copy: c.DescribePendingMaintenanceActionsRequest}
}

// DescribePendingMaintenanceActionsRequest is the request type for the
// DescribePendingMaintenanceActions API operation.
type DescribePendingMaintenanceActionsRequest struct {
	*aws.Request
	Input *DescribePendingMaintenanceActionsInput
	Copy  func(*DescribePendingMaintenanceActionsInput) DescribePendingMaintenanceActionsRequest
}

// Send marshals and sends the DescribePendingMaintenanceActions API request.
func (r DescribePendingMaintenanceActionsRequest) Send(ctx context.Context) (*DescribePendingMaintenanceActionsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribePendingMaintenanceActionsResponse{
		DescribePendingMaintenanceActionsOutput: r.Request.Data.(*DescribePendingMaintenanceActionsOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewDescribePendingMaintenanceActionsRequestPaginator returns a paginator for DescribePendingMaintenanceActions.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.DescribePendingMaintenanceActionsRequest(input)
//   p := databasemigrationservice.NewDescribePendingMaintenanceActionsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewDescribePendingMaintenanceActionsPaginator(req DescribePendingMaintenanceActionsRequest) DescribePendingMaintenanceActionsPaginator {
	return DescribePendingMaintenanceActionsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *DescribePendingMaintenanceActionsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// DescribePendingMaintenanceActionsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type DescribePendingMaintenanceActionsPaginator struct {
	aws.Pager
}

func (p *DescribePendingMaintenanceActionsPaginator) CurrentPage() *DescribePendingMaintenanceActionsOutput {
	return p.Pager.CurrentPage().(*DescribePendingMaintenanceActionsOutput)
}

// DescribePendingMaintenanceActionsResponse is the response type for the
// DescribePendingMaintenanceActions API operation.
type DescribePendingMaintenanceActionsResponse struct {
	*DescribePendingMaintenanceActionsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribePendingMaintenanceActions request.
func (r *DescribePendingMaintenanceActionsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
