// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package datasync

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// ListTasksRequest
// Please also see https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTasksRequest
type ListTasksInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of tasks to return.
	MaxResults *int64 `type:"integer"`

	// An opaque string that indicates the position at which to begin the next list
	// of tasks.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListTasksInput) String() string {
	return awsutil.Prettify(s)
}

// ListTasksResponse
// Please also see https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTasksResponse
type ListTasksOutput struct {
	_ struct{} `type:"structure"`

	// An opaque string that indicates the position at which to begin returning
	// the next list of tasks.
	NextToken *string `type:"string"`

	// A list of all the tasks that are returned.
	Tasks []TaskListEntry `type:"list"`
}

// String returns the string representation
func (s ListTasksOutput) String() string {
	return awsutil.Prettify(s)
}

const opListTasks = "ListTasks"

// ListTasksRequest returns a request value for making API operation for
// AWS DataSync.
//
// Returns a list of all the tasks.
//
//    // Example sending a request using ListTasksRequest.
//    req := client.ListTasksRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/datasync-2018-11-09/ListTasks
func (c *Client) ListTasksRequest(input *ListTasksInput) ListTasksRequest {
	op := &aws.Operation{
		Name:       opListTasks,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTasksInput{}
	}

	req := c.newRequest(op, input, &ListTasksOutput{})
	return ListTasksRequest{Request: req, Input: input, Copy: c.ListTasksRequest}
}

// ListTasksRequest is the request type for the
// ListTasks API operation.
type ListTasksRequest struct {
	*aws.Request
	Input *ListTasksInput
	Copy  func(*ListTasksInput) ListTasksRequest
}

// Send marshals and sends the ListTasks API request.
func (r ListTasksRequest) Send(ctx context.Context) (*ListTasksResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListTasksResponse{
		ListTasksOutput: r.Request.Data.(*ListTasksOutput),
		response:        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListTasksRequestPaginator returns a paginator for ListTasks.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListTasksRequest(input)
//   p := datasync.NewListTasksRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListTasksPaginator(req ListTasksRequest) ListTasksPaginator {
	return ListTasksPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListTasksInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListTasksPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListTasksPaginator struct {
	aws.Pager
}

func (p *ListTasksPaginator) CurrentPage() *ListTasksOutput {
	return p.Pager.CurrentPage().(*ListTasksOutput)
}

// ListTasksResponse is the response type for the
// ListTasks API operation.
type ListTasksResponse struct {
	*ListTasksOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListTasks request.
func (r *ListTasksResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
