// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package devicefarm

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateInstanceProfileRequest
type CreateInstanceProfileInput struct {
	_ struct{} `type:"structure"`

	// The description of your instance profile.
	Description *string `locationName:"description" type:"string"`

	// An array of strings specifying the list of app packages that should not be
	// cleaned up from the device after a test run is over.
	//
	// The list of packages is only considered if you set packageCleanup to true.
	ExcludeAppPackagesFromCleanup []string `locationName:"excludeAppPackagesFromCleanup" type:"list"`

	// The name of your instance profile.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`

	// When set to true, Device Farm will remove app packages after a test run.
	// The default value is false for private devices.
	PackageCleanup *bool `locationName:"packageCleanup" type:"boolean"`

	// When set to true, Device Farm will reboot the instance after a test run.
	// The default value is true.
	RebootAfterUse *bool `locationName:"rebootAfterUse" type:"boolean"`
}

// String returns the string representation
func (s CreateInstanceProfileInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInstanceProfileInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateInstanceProfileInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateInstanceProfileResult
type CreateInstanceProfileOutput struct {
	_ struct{} `type:"structure"`

	// An object containing information about your instance profile.
	InstanceProfile *InstanceProfile `locationName:"instanceProfile" type:"structure"`
}

// String returns the string representation
func (s CreateInstanceProfileOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateInstanceProfile = "CreateInstanceProfile"

// CreateInstanceProfileRequest returns a request value for making API operation for
// AWS Device Farm.
//
// Creates a profile that can be applied to one or more private fleet device
// instances.
//
//    // Example sending a request using CreateInstanceProfileRequest.
//    req := client.CreateInstanceProfileRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/devicefarm-2015-06-23/CreateInstanceProfile
func (c *Client) CreateInstanceProfileRequest(input *CreateInstanceProfileInput) CreateInstanceProfileRequest {
	op := &aws.Operation{
		Name:       opCreateInstanceProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInstanceProfileInput{}
	}

	req := c.newRequest(op, input, &CreateInstanceProfileOutput{})
	return CreateInstanceProfileRequest{Request: req, Input: input, Copy: c.CreateInstanceProfileRequest}
}

// CreateInstanceProfileRequest is the request type for the
// CreateInstanceProfile API operation.
type CreateInstanceProfileRequest struct {
	*aws.Request
	Input *CreateInstanceProfileInput
	Copy  func(*CreateInstanceProfileInput) CreateInstanceProfileRequest
}

// Send marshals and sends the CreateInstanceProfile API request.
func (r CreateInstanceProfileRequest) Send(ctx context.Context) (*CreateInstanceProfileResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateInstanceProfileResponse{
		CreateInstanceProfileOutput: r.Request.Data.(*CreateInstanceProfileOutput),
		response:                    &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateInstanceProfileResponse is the response type for the
// CreateInstanceProfile API operation.
type CreateInstanceProfileResponse struct {
	*CreateInstanceProfileOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateInstanceProfile request.
func (r *CreateInstanceProfileResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
