// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package directoryservice

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Deletes a conditional forwarder.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteConditionalForwarderRequest
type DeleteConditionalForwarderInput struct {
	_ struct{} `type:"structure"`

	// The directory ID for which you are deleting the conditional forwarder.
	//
	// DirectoryId is a required field
	DirectoryId *string `type:"string" required:"true"`

	// The fully qualified domain name (FQDN) of the remote domain with which you
	// are deleting the conditional forwarder.
	//
	// RemoteDomainName is a required field
	RemoteDomainName *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteConditionalForwarderInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConditionalForwarderInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteConditionalForwarderInput"}

	if s.DirectoryId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DirectoryId"))
	}

	if s.RemoteDomainName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RemoteDomainName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The result of a DeleteConditionalForwarder request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteConditionalForwarderResult
type DeleteConditionalForwarderOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteConditionalForwarderOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteConditionalForwarder = "DeleteConditionalForwarder"

// DeleteConditionalForwarderRequest returns a request value for making API operation for
// AWS Directory Service.
//
// Deletes a conditional forwarder that has been set up for your AWS directory.
//
//    // Example sending a request using DeleteConditionalForwarderRequest.
//    req := client.DeleteConditionalForwarderRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ds-2015-04-16/DeleteConditionalForwarder
func (c *Client) DeleteConditionalForwarderRequest(input *DeleteConditionalForwarderInput) DeleteConditionalForwarderRequest {
	op := &aws.Operation{
		Name:       opDeleteConditionalForwarder,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConditionalForwarderInput{}
	}

	req := c.newRequest(op, input, &DeleteConditionalForwarderOutput{})
	return DeleteConditionalForwarderRequest{Request: req, Input: input, Copy: c.DeleteConditionalForwarderRequest}
}

// DeleteConditionalForwarderRequest is the request type for the
// DeleteConditionalForwarder API operation.
type DeleteConditionalForwarderRequest struct {
	*aws.Request
	Input *DeleteConditionalForwarderInput
	Copy  func(*DeleteConditionalForwarderInput) DeleteConditionalForwarderRequest
}

// Send marshals and sends the DeleteConditionalForwarder API request.
func (r DeleteConditionalForwarderRequest) Send(ctx context.Context) (*DeleteConditionalForwarderResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteConditionalForwarderResponse{
		DeleteConditionalForwarderOutput: r.Request.Data.(*DeleteConditionalForwarderOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteConditionalForwarderResponse is the response type for the
// DeleteConditionalForwarder API operation.
type DeleteConditionalForwarderResponse struct {
	*DeleteConditionalForwarderOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteConditionalForwarder request.
func (r *DeleteConditionalForwarderResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
