// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package docdb

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input to CreateDBInstance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CreateDBInstanceMessage
type CreateDBInstanceInput struct {
	_ struct{} `type:"structure"`

	// Indicates that minor engine upgrades are applied automatically to the DB
	// instance during the maintenance window.
	//
	// Default: true
	AutoMinorVersionUpgrade *bool `type:"boolean"`

	// The Amazon EC2 Availability Zone that the DB instance is created in.
	//
	// Default: A random, system-chosen Availability Zone in the endpoint's AWS
	// Region.
	//
	// Example: us-east-1d
	//
	// Constraint: The AvailabilityZone parameter can't be specified if the MultiAZ
	// parameter is set to true. The specified Availability Zone must be in the
	// same AWS Region as the current endpoint.
	AvailabilityZone *string `type:"string"`

	// The identifier of the DB cluster that the instance will belong to.
	//
	// DBClusterIdentifier is a required field
	DBClusterIdentifier *string `type:"string" required:"true"`

	// The compute and memory capacity of the DB instance; for example, db.m4.large.
	//
	// DBInstanceClass is a required field
	DBInstanceClass *string `type:"string" required:"true"`

	// The DB instance identifier. This parameter is stored as a lowercase string.
	//
	// Constraints:
	//
	//    * Must contain from 1 to 63 letters, numbers, or hyphens.
	//
	//    * The first character must be a letter.
	//
	//    * Cannot end with a hyphen or contain two consecutive hyphens.
	//
	// Example: mydbinstance
	//
	// DBInstanceIdentifier is a required field
	DBInstanceIdentifier *string `type:"string" required:"true"`

	// The name of the database engine to be used for this instance.
	//
	// Valid value: docdb
	//
	// Engine is a required field
	Engine *string `type:"string" required:"true"`

	// The time range each week during which system maintenance can occur, in Universal
	// Coordinated Time (UTC).
	//
	// Format: ddd:hh24:mi-ddd:hh24:mi
	//
	// The default is a 30-minute window selected at random from an 8-hour block
	// of time for each AWS Region, occurring on a random day of the week.
	//
	// Valid days: Mon, Tue, Wed, Thu, Fri, Sat, Sun
	//
	// Constraints: Minimum 30-minute window.
	PreferredMaintenanceWindow *string `type:"string"`

	// A value that specifies the order in which an Amazon DocumentDB replica is
	// promoted to the primary instance after a failure of the existing primary
	// instance.
	//
	// Default: 1
	//
	// Valid values: 0-15
	PromotionTier *int64 `type:"integer"`

	// The tags to be assigned to the DB instance.
	Tags []Tag `locationNameList:"Tag" type:"list"`
}

// String returns the string representation
func (s CreateDBInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDBInstanceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateDBInstanceInput"}

	if s.DBClusterIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("DBClusterIdentifier"))
	}

	if s.DBInstanceClass == nil {
		invalidParams.Add(aws.NewErrParamRequired("DBInstanceClass"))
	}

	if s.DBInstanceIdentifier == nil {
		invalidParams.Add(aws.NewErrParamRequired("DBInstanceIdentifier"))
	}

	if s.Engine == nil {
		invalidParams.Add(aws.NewErrParamRequired("Engine"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CreateDBInstanceResult
type CreateDBInstanceOutput struct {
	_ struct{} `type:"structure"`

	// Detailed information about a DB instance.
	DBInstance *DBInstance `type:"structure"`
}

// String returns the string representation
func (s CreateDBInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateDBInstance = "CreateDBInstance"

// CreateDBInstanceRequest returns a request value for making API operation for
// Amazon DocumentDB with MongoDB compatibility.
//
// Creates a new DB instance.
//
//    // Example sending a request using CreateDBInstanceRequest.
//    req := client.CreateDBInstanceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/docdb-2014-10-31/CreateDBInstance
func (c *Client) CreateDBInstanceRequest(input *CreateDBInstanceInput) CreateDBInstanceRequest {
	op := &aws.Operation{
		Name:       opCreateDBInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateDBInstanceInput{}
	}

	req := c.newRequest(op, input, &CreateDBInstanceOutput{})
	return CreateDBInstanceRequest{Request: req, Input: input, Copy: c.CreateDBInstanceRequest}
}

// CreateDBInstanceRequest is the request type for the
// CreateDBInstance API operation.
type CreateDBInstanceRequest struct {
	*aws.Request
	Input *CreateDBInstanceInput
	Copy  func(*CreateDBInstanceInput) CreateDBInstanceRequest
}

// Send marshals and sends the CreateDBInstance API request.
func (r CreateDBInstanceRequest) Send(ctx context.Context) (*CreateDBInstanceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateDBInstanceResponse{
		CreateDBInstanceOutput: r.Request.Data.(*CreateDBInstanceOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateDBInstanceResponse is the response type for the
// CreateDBInstance API operation.
type CreateDBInstanceResponse struct {
	*CreateDBInstanceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateDBInstance request.
func (r *CreateDBInstanceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
