// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ec2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Contains the parameters for ModifySpotFleetRequest.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifySpotFleetRequestRequest
type ModifySpotFleetRequestInput struct {
	_ struct{} `type:"structure"`

	// Indicates whether running Spot Instances should be terminated if the target
	// capacity of the Spot Fleet request is decreased below the current size of
	// the Spot Fleet.
	ExcessCapacityTerminationPolicy ExcessCapacityTerminationPolicy `locationName:"excessCapacityTerminationPolicy" type:"string" enum:"true"`

	// The ID of the Spot Fleet request.
	//
	// SpotFleetRequestId is a required field
	SpotFleetRequestId *string `locationName:"spotFleetRequestId" type:"string" required:"true"`

	// The size of the fleet.
	TargetCapacity *int64 `locationName:"targetCapacity" type:"integer"`
}

// String returns the string representation
func (s ModifySpotFleetRequestInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifySpotFleetRequestInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModifySpotFleetRequestInput"}

	if s.SpotFleetRequestId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SpotFleetRequestId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the output of ModifySpotFleetRequest.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifySpotFleetRequestResponse
type ModifySpotFleetRequestOutput struct {
	_ struct{} `type:"structure"`

	// Is true if the request succeeds, and an error otherwise.
	Return *bool `locationName:"return" type:"boolean"`
}

// String returns the string representation
func (s ModifySpotFleetRequestOutput) String() string {
	return awsutil.Prettify(s)
}

const opModifySpotFleetRequest = "ModifySpotFleetRequest"

// ModifySpotFleetRequestRequest returns a request value for making API operation for
// Amazon Elastic Compute Cloud.
//
// Modifies the specified Spot Fleet request.
//
// You can only modify a Spot Fleet request of type maintain.
//
// While the Spot Fleet request is being modified, it is in the modifying state.
//
// To scale up your Spot Fleet, increase its target capacity. The Spot Fleet
// launches the additional Spot Instances according to the allocation strategy
// for the Spot Fleet request. If the allocation strategy is lowestPrice, the
// Spot Fleet launches instances using the Spot pool with the lowest price.
// If the allocation strategy is diversified, the Spot Fleet distributes the
// instances across the Spot pools.
//
// To scale down your Spot Fleet, decrease its target capacity. First, the Spot
// Fleet cancels any open requests that exceed the new target capacity. You
// can request that the Spot Fleet terminate Spot Instances until the size of
// the fleet no longer exceeds the new target capacity. If the allocation strategy
// is lowestPrice, the Spot Fleet terminates the instances with the highest
// price per unit. If the allocation strategy is diversified, the Spot Fleet
// terminates instances across the Spot pools. Alternatively, you can request
// that the Spot Fleet keep the fleet at its current size, but not replace any
// Spot Instances that are interrupted or that you terminate manually.
//
// If you are finished with your Spot Fleet for now, but will use it again later,
// you can set the target capacity to 0.
//
//    // Example sending a request using ModifySpotFleetRequestRequest.
//    req := client.ModifySpotFleetRequestRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ec2-2016-11-15/ModifySpotFleetRequest
func (c *Client) ModifySpotFleetRequestRequest(input *ModifySpotFleetRequestInput) ModifySpotFleetRequestRequest {
	op := &aws.Operation{
		Name:       opModifySpotFleetRequest,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifySpotFleetRequestInput{}
	}

	req := c.newRequest(op, input, &ModifySpotFleetRequestOutput{})
	return ModifySpotFleetRequestRequest{Request: req, Input: input, Copy: c.ModifySpotFleetRequestRequest}
}

// ModifySpotFleetRequestRequest is the request type for the
// ModifySpotFleetRequest API operation.
type ModifySpotFleetRequestRequest struct {
	*aws.Request
	Input *ModifySpotFleetRequestInput
	Copy  func(*ModifySpotFleetRequestInput) ModifySpotFleetRequestRequest
}

// Send marshals and sends the ModifySpotFleetRequest API request.
func (r ModifySpotFleetRequestRequest) Send(ctx context.Context) (*ModifySpotFleetRequestResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifySpotFleetRequestResponse{
		ModifySpotFleetRequestOutput: r.Request.Data.(*ModifySpotFleetRequestOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifySpotFleetRequestResponse is the response type for the
// ModifySpotFleetRequest API operation.
type ModifySpotFleetRequestResponse struct {
	*ModifySpotFleetRequestOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifySpotFleetRequest request.
func (r *ModifySpotFleetRequestResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
