// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticbeanstalk

import (
	"context"
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Request to create a configuration template.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateConfigurationTemplateMessage
type CreateConfigurationTemplateInput struct {
	_ struct{} `type:"structure"`

	// The name of the application to associate with this configuration template.
	// If no application is found with this name, AWS Elastic Beanstalk returns
	// an InvalidParameterValue error.
	//
	// ApplicationName is a required field
	ApplicationName *string `min:"1" type:"string" required:"true"`

	// Describes this configuration.
	Description *string `type:"string"`

	// The ID of the environment used with this configuration template.
	EnvironmentId *string `type:"string"`

	// If specified, AWS Elastic Beanstalk sets the specified configuration option
	// to the requested value. The new value overrides the value obtained from the
	// solution stack or the source configuration template.
	OptionSettings []ConfigurationOptionSetting `type:"list"`

	// The ARN of the custom platform.
	PlatformArn *string `type:"string"`

	// The name of the solution stack used by this configuration. The solution stack
	// specifies the operating system, architecture, and application server for
	// a configuration template. It determines the set of configuration options
	// as well as the possible and default values.
	//
	// Use ListAvailableSolutionStacks to obtain a list of available solution stacks.
	//
	// A solution stack name or a source configuration parameter must be specified,
	// otherwise AWS Elastic Beanstalk returns an InvalidParameterValue error.
	//
	// If a solution stack name is not specified and the source configuration parameter
	// is specified, AWS Elastic Beanstalk uses the same solution stack as the source
	// configuration template.
	SolutionStackName *string `type:"string"`

	// If specified, AWS Elastic Beanstalk uses the configuration values from the
	// specified configuration template to create a new configuration.
	//
	// Values specified in the OptionSettings parameter of this call overrides any
	// values obtained from the SourceConfiguration.
	//
	// If no configuration template is found, returns an InvalidParameterValue error.
	//
	// Constraint: If both the solution stack name parameter and the source configuration
	// parameters are specified, the solution stack of the source configuration
	// template must match the specified solution stack name or else AWS Elastic
	// Beanstalk returns an InvalidParameterCombination error.
	SourceConfiguration *SourceConfiguration `type:"structure"`

	// Specifies the tags applied to the configuration template.
	Tags []Tag `type:"list"`

	// The name of the configuration template.
	//
	// Constraint: This name must be unique per application.
	//
	// Default: If a configuration template already exists with this name, AWS Elastic
	// Beanstalk returns an InvalidParameterValue error.
	//
	// TemplateName is a required field
	TemplateName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateConfigurationTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConfigurationTemplateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateConfigurationTemplateInput"}

	if s.ApplicationName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApplicationName"))
	}
	if s.ApplicationName != nil && len(*s.ApplicationName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ApplicationName", 1))
	}

	if s.TemplateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TemplateName"))
	}
	if s.TemplateName != nil && len(*s.TemplateName) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("TemplateName", 1))
	}
	if s.OptionSettings != nil {
		for i, v := range s.OptionSettings {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "OptionSettings", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.SourceConfiguration != nil {
		if err := s.SourceConfiguration.Validate(); err != nil {
			invalidParams.AddNested("SourceConfiguration", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Describes the settings for a configuration set.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/ConfigurationSettingsDescription
type CreateConfigurationTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The name of the application associated with this configuration set.
	ApplicationName *string `min:"1" type:"string"`

	// The date (in UTC time) when this configuration set was created.
	DateCreated *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// The date (in UTC time) when this configuration set was last modified.
	DateUpdated *time.Time `type:"timestamp" timestampFormat:"iso8601"`

	// If this configuration set is associated with an environment, the DeploymentStatus
	// parameter indicates the deployment status of this configuration set:
	//
	//    * null: This configuration is not associated with a running environment.
	//
	//    * pending: This is a draft configuration that is not deployed to the associated
	//    environment but is in the process of deploying.
	//
	//    * deployed: This is the configuration that is currently deployed to the
	//    associated running environment.
	//
	//    * failed: This is a draft configuration that failed to successfully deploy.
	DeploymentStatus ConfigurationDeploymentStatus `type:"string" enum:"true"`

	// Describes this configuration set.
	Description *string `type:"string"`

	// If not null, the name of the environment for this configuration set.
	EnvironmentName *string `min:"4" type:"string"`

	// A list of the configuration options and their values in this configuration
	// set.
	OptionSettings []ConfigurationOptionSetting `type:"list"`

	// The ARN of the platform.
	PlatformArn *string `type:"string"`

	// The name of the solution stack this configuration set uses.
	SolutionStackName *string `type:"string"`

	// If not null, the name of the configuration template for this configuration
	// set.
	TemplateName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateConfigurationTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateConfigurationTemplate = "CreateConfigurationTemplate"

// CreateConfigurationTemplateRequest returns a request value for making API operation for
// AWS Elastic Beanstalk.
//
// Creates a configuration template. Templates are associated with a specific
// application and are used to deploy different versions of the application
// with the same configuration settings.
//
// Templates aren't associated with any environment. The EnvironmentName response
// element is always null.
//
// Related Topics
//
//    * DescribeConfigurationOptions
//
//    * DescribeConfigurationSettings
//
//    * ListAvailableSolutionStacks
//
//    // Example sending a request using CreateConfigurationTemplateRequest.
//    req := client.CreateConfigurationTemplateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticbeanstalk-2010-12-01/CreateConfigurationTemplate
func (c *Client) CreateConfigurationTemplateRequest(input *CreateConfigurationTemplateInput) CreateConfigurationTemplateRequest {
	op := &aws.Operation{
		Name:       opCreateConfigurationTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateConfigurationTemplateInput{}
	}

	req := c.newRequest(op, input, &CreateConfigurationTemplateOutput{})
	return CreateConfigurationTemplateRequest{Request: req, Input: input, Copy: c.CreateConfigurationTemplateRequest}
}

// CreateConfigurationTemplateRequest is the request type for the
// CreateConfigurationTemplate API operation.
type CreateConfigurationTemplateRequest struct {
	*aws.Request
	Input *CreateConfigurationTemplateInput
	Copy  func(*CreateConfigurationTemplateInput) CreateConfigurationTemplateRequest
}

// Send marshals and sends the CreateConfigurationTemplate API request.
func (r CreateConfigurationTemplateRequest) Send(ctx context.Context) (*CreateConfigurationTemplateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateConfigurationTemplateResponse{
		CreateConfigurationTemplateOutput: r.Request.Data.(*CreateConfigurationTemplateOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateConfigurationTemplateResponse is the response type for the
// CreateConfigurationTemplate API operation.
type CreateConfigurationTemplateResponse struct {
	*CreateConfigurationTemplateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateConfigurationTemplate request.
func (r *CreateConfigurationTemplateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
