// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package elasticloadbalancingv2

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeregisterTargetsInput
type DeregisterTargetsInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the target group.
	//
	// TargetGroupArn is a required field
	TargetGroupArn *string `type:"string" required:"true"`

	// The targets. If you specified a port override when you registered a target,
	// you must specify both the target ID and the port when you deregister it.
	//
	// Targets is a required field
	Targets []TargetDescription `type:"list" required:"true"`
}

// String returns the string representation
func (s DeregisterTargetsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterTargetsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeregisterTargetsInput"}

	if s.TargetGroupArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("TargetGroupArn"))
	}

	if s.Targets == nil {
		invalidParams.Add(aws.NewErrParamRequired("Targets"))
	}
	if s.Targets != nil {
		for i, v := range s.Targets {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Targets", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeregisterTargetsOutput
type DeregisterTargetsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeregisterTargetsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeregisterTargets = "DeregisterTargets"

// DeregisterTargetsRequest returns a request value for making API operation for
// Elastic Load Balancing.
//
// Deregisters the specified targets from the specified target group. After
// the targets are deregistered, they no longer receive traffic from the load
// balancer.
//
//    // Example sending a request using DeregisterTargetsRequest.
//    req := client.DeregisterTargetsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticloadbalancingv2-2015-12-01/DeregisterTargets
func (c *Client) DeregisterTargetsRequest(input *DeregisterTargetsInput) DeregisterTargetsRequest {
	op := &aws.Operation{
		Name:       opDeregisterTargets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterTargetsInput{}
	}

	req := c.newRequest(op, input, &DeregisterTargetsOutput{})
	return DeregisterTargetsRequest{Request: req, Input: input, Copy: c.DeregisterTargetsRequest}
}

// DeregisterTargetsRequest is the request type for the
// DeregisterTargets API operation.
type DeregisterTargetsRequest struct {
	*aws.Request
	Input *DeregisterTargetsInput
	Copy  func(*DeregisterTargetsInput) DeregisterTargetsRequest
}

// Send marshals and sends the DeregisterTargets API request.
func (r DeregisterTargetsRequest) Send(ctx context.Context) (*DeregisterTargetsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeregisterTargetsResponse{
		DeregisterTargetsOutput: r.Request.Data.(*DeregisterTargetsOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeregisterTargetsResponse is the response type for the
// DeregisterTargets API operation.
type DeregisterTargetsResponse struct {
	*DeregisterTargetsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeregisterTargets request.
func (r *DeregisterTargetsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
