// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package gamelift

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents the input for a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingRuleSetsInput
type DescribeMatchmakingRuleSetsInput struct {
	_ struct{} `type:"structure"`

	// Maximum number of results to return. Use this parameter with NextToken to
	// get results as a set of sequential pages.
	Limit *int64 `min:"1" type:"integer"`

	// List of one or more matchmaking rule set names to retrieve details for. (Note:
	// The rule set name is different from the optional "name" field in the rule
	// set body.)
	Names []string `min:"1" type:"list"`

	// Token that indicates the start of the next sequential page of results. Use
	// the token that is returned with a previous call to this action. To start
	// at the beginning of the result set, do not specify a value.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeMatchmakingRuleSetsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeMatchmakingRuleSetsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeMatchmakingRuleSetsInput"}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("Limit", 1))
	}
	if s.Names != nil && len(s.Names) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Names", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Represents the returned data in response to a request action.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingRuleSetsOutput
type DescribeMatchmakingRuleSetsOutput struct {
	_ struct{} `type:"structure"`

	// Token that indicates where to resume retrieving results on the next call
	// to this action. If no token is returned, these results represent the end
	// of the list.
	NextToken *string `min:"1" type:"string"`

	// Collection of requested matchmaking rule set objects.
	//
	// RuleSets is a required field
	RuleSets []MatchmakingRuleSet `type:"list" required:"true"`
}

// String returns the string representation
func (s DescribeMatchmakingRuleSetsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeMatchmakingRuleSets = "DescribeMatchmakingRuleSets"

// DescribeMatchmakingRuleSetsRequest returns a request value for making API operation for
// Amazon GameLift.
//
// Retrieves the details for FlexMatch matchmaking rule sets. You can request
// all existing rule sets for the region, or provide a list of one or more rule
// set names. When requesting multiple items, use the pagination parameters
// to retrieve results as a set of sequential pages. If successful, a rule set
// is returned for each requested name.
//
// Learn more
//
//    * Build a Rule Set (https://docs.aws.amazon.com/gamelift/latest/developerguide/match-rulesets.html)
//
// Related operations
//
//    * CreateMatchmakingConfiguration
//
//    * DescribeMatchmakingConfigurations
//
//    * UpdateMatchmakingConfiguration
//
//    * DeleteMatchmakingConfiguration
//
//    * CreateMatchmakingRuleSet
//
//    * DescribeMatchmakingRuleSets
//
//    * ValidateMatchmakingRuleSet
//
//    * DeleteMatchmakingRuleSet
//
//    // Example sending a request using DescribeMatchmakingRuleSetsRequest.
//    req := client.DescribeMatchmakingRuleSetsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/gamelift-2015-10-01/DescribeMatchmakingRuleSets
func (c *Client) DescribeMatchmakingRuleSetsRequest(input *DescribeMatchmakingRuleSetsInput) DescribeMatchmakingRuleSetsRequest {
	op := &aws.Operation{
		Name:       opDescribeMatchmakingRuleSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeMatchmakingRuleSetsInput{}
	}

	req := c.newRequest(op, input, &DescribeMatchmakingRuleSetsOutput{})
	return DescribeMatchmakingRuleSetsRequest{Request: req, Input: input, Copy: c.DescribeMatchmakingRuleSetsRequest}
}

// DescribeMatchmakingRuleSetsRequest is the request type for the
// DescribeMatchmakingRuleSets API operation.
type DescribeMatchmakingRuleSetsRequest struct {
	*aws.Request
	Input *DescribeMatchmakingRuleSetsInput
	Copy  func(*DescribeMatchmakingRuleSetsInput) DescribeMatchmakingRuleSetsRequest
}

// Send marshals and sends the DescribeMatchmakingRuleSets API request.
func (r DescribeMatchmakingRuleSetsRequest) Send(ctx context.Context) (*DescribeMatchmakingRuleSetsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeMatchmakingRuleSetsResponse{
		DescribeMatchmakingRuleSetsOutput: r.Request.Data.(*DescribeMatchmakingRuleSetsOutput),
		response:                          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeMatchmakingRuleSetsResponse is the response type for the
// DescribeMatchmakingRuleSets API operation.
type DescribeMatchmakingRuleSetsResponse struct {
	*DescribeMatchmakingRuleSetsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeMatchmakingRuleSets request.
func (r *DescribeMatchmakingRuleSetsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
