// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package guardduty

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Create Threat Intel Set Request
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateThreatIntelSetRequest
type CreateThreatIntelSetInput struct {
	_ struct{} `type:"structure"`

	// A boolean value that indicates whether GuardDuty is to start using the uploaded
	// ThreatIntelSet.
	//
	// Activate is a required field
	Activate *bool `locationName:"activate" type:"boolean" required:"true"`

	// The idempotency token for the create request.
	ClientToken *string `locationName:"clientToken" type:"string" idempotencyToken:"true"`

	// DetectorId is a required field
	DetectorId *string `location:"uri" locationName:"detectorId" type:"string" required:"true"`

	// The format of the file that contains the ThreatIntelSet.
	//
	// Format is a required field
	Format ThreatIntelSetFormat `locationName:"format" type:"string" required:"true" enum:"true"`

	// The URI of the file that contains the ThreatIntelSet. For example (https://s3.us-west-2.amazonaws.com/my-bucket/my-object-key).
	//
	// Location is a required field
	Location *string `locationName:"location" type:"string" required:"true"`

	// A user-friendly ThreatIntelSet name that is displayed in all finding generated
	// by activity that involves IP addresses included in this ThreatIntelSet.
	//
	// Name is a required field
	Name *string `locationName:"name" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateThreatIntelSetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateThreatIntelSetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateThreatIntelSetInput"}

	if s.Activate == nil {
		invalidParams.Add(aws.NewErrParamRequired("Activate"))
	}

	if s.DetectorId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DetectorId"))
	}
	if len(s.Format) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Format"))
	}

	if s.Location == nil {
		invalidParams.Add(aws.NewErrParamRequired("Location"))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateThreatIntelSetInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/x-amz-json-1.1"), protocol.Metadata{})

	if s.Activate != nil {
		v := *s.Activate

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "activate", protocol.BoolValue(v), metadata)
	}
	var ClientToken string
	if s.ClientToken != nil {
		ClientToken = *s.ClientToken
	} else {
		ClientToken = protocol.GetIdempotencyToken()
	}
	{
		v := ClientToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "clientToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.Format) > 0 {
		v := s.Format

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "format", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	if s.Location != nil {
		v := *s.Location

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "location", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DetectorId != nil {
		v := *s.DetectorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "detectorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// CreateThreatIntelSet response object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateThreatIntelSetResponse
type CreateThreatIntelSetOutput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for an threat intel set
	ThreatIntelSetId *string `locationName:"threatIntelSetId" type:"string"`
}

// String returns the string representation
func (s CreateThreatIntelSetOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s CreateThreatIntelSetOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.ThreatIntelSetId != nil {
		v := *s.ThreatIntelSetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "threatIntelSetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opCreateThreatIntelSet = "CreateThreatIntelSet"

// CreateThreatIntelSetRequest returns a request value for making API operation for
// Amazon GuardDuty.
//
// Create a new ThreatIntelSet. ThreatIntelSets consist of known malicious IP
// addresses. GuardDuty generates findings based on ThreatIntelSets.
//
//    // Example sending a request using CreateThreatIntelSetRequest.
//    req := client.CreateThreatIntelSetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/CreateThreatIntelSet
func (c *Client) CreateThreatIntelSetRequest(input *CreateThreatIntelSetInput) CreateThreatIntelSetRequest {
	op := &aws.Operation{
		Name:       opCreateThreatIntelSet,
		HTTPMethod: "POST",
		HTTPPath:   "/detector/{detectorId}/threatintelset",
	}

	if input == nil {
		input = &CreateThreatIntelSetInput{}
	}

	req := c.newRequest(op, input, &CreateThreatIntelSetOutput{})
	return CreateThreatIntelSetRequest{Request: req, Input: input, Copy: c.CreateThreatIntelSetRequest}
}

// CreateThreatIntelSetRequest is the request type for the
// CreateThreatIntelSet API operation.
type CreateThreatIntelSetRequest struct {
	*aws.Request
	Input *CreateThreatIntelSetInput
	Copy  func(*CreateThreatIntelSetInput) CreateThreatIntelSetRequest
}

// Send marshals and sends the CreateThreatIntelSet API request.
func (r CreateThreatIntelSetRequest) Send(ctx context.Context) (*CreateThreatIntelSetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateThreatIntelSetResponse{
		CreateThreatIntelSetOutput: r.Request.Data.(*CreateThreatIntelSetOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateThreatIntelSetResponse is the response type for the
// CreateThreatIntelSet API operation.
type CreateThreatIntelSetResponse struct {
	*CreateThreatIntelSetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateThreatIntelSet request.
func (r *CreateThreatIntelSetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
