// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package guardduty

import (
	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

var _ aws.Config
var _ = awsutil.Prettify

// The IAM access key details (IAM user information) of a user that engaged
// in the activity that prompted GuardDuty to generate a finding.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/AccessKeyDetails
type AccessKeyDetails struct {
	_ struct{} `type:"structure"`

	// Access key ID of the user.
	AccessKeyId *string `locationName:"accessKeyId" type:"string"`

	// The principal ID of the user.
	PrincipalId *string `locationName:"principalId" type:"string"`

	// The name of the user.
	UserName *string `locationName:"userName" type:"string"`

	// The type of the user.
	UserType *string `locationName:"userType" type:"string"`
}

// String returns the string representation
func (s AccessKeyDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AccessKeyDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccessKeyId != nil {
		v := *s.AccessKeyId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accessKeyId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PrincipalId != nil {
		v := *s.PrincipalId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "principalId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UserName != nil {
		v := *s.UserName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "userName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UserType != nil {
		v := *s.UserType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "userType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object containing the member's accountId and email address.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/AccountDetail
type AccountDetail struct {
	_ struct{} `type:"structure"`

	// Member account ID.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" type:"string" required:"true"`

	// Member account's email address.
	//
	// Email is a required field
	Email *string `locationName:"email" type:"string" required:"true"`
}

// String returns the string representation
func (s AccountDetail) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AccountDetail) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "AccountDetail"}

	if s.AccountId == nil {
		invalidParams.Add(aws.NewErrParamRequired("AccountId"))
	}

	if s.Email == nil {
		invalidParams.Add(aws.NewErrParamRequired("Email"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AccountDetail) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Email != nil {
		v := *s.Email

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "email", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about the activity described in a finding.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/Action
type Action struct {
	_ struct{} `type:"structure"`

	// GuardDuty Finding activity type.
	ActionType *string `locationName:"actionType" type:"string"`

	// Information about the AWS_API_CALL action described in this finding.
	AwsApiCallAction *AwsApiCallAction `locationName:"awsApiCallAction" type:"structure"`

	// Information about the DNS_REQUEST action described in this finding.
	DnsRequestAction *DnsRequestAction `locationName:"dnsRequestAction" type:"structure"`

	// Information about the NETWORK_CONNECTION action described in this finding.
	NetworkConnectionAction *NetworkConnectionAction `locationName:"networkConnectionAction" type:"structure"`

	// Information about the PORT_PROBE action described in this finding.
	PortProbeAction *PortProbeAction `locationName:"portProbeAction" type:"structure"`
}

// String returns the string representation
func (s Action) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Action) MarshalFields(e protocol.FieldEncoder) error {
	if s.ActionType != nil {
		v := *s.ActionType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "actionType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AwsApiCallAction != nil {
		v := s.AwsApiCallAction

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "awsApiCallAction", v, metadata)
	}
	if s.DnsRequestAction != nil {
		v := s.DnsRequestAction

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "dnsRequestAction", v, metadata)
	}
	if s.NetworkConnectionAction != nil {
		v := s.NetworkConnectionAction

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "networkConnectionAction", v, metadata)
	}
	if s.PortProbeAction != nil {
		v := s.PortProbeAction

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "portProbeAction", v, metadata)
	}
	return nil
}

// Information about the AWS_API_CALL action described in this finding.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/AwsApiCallAction
type AwsApiCallAction struct {
	_ struct{} `type:"structure"`

	// AWS API name.
	Api *string `locationName:"api" type:"string"`

	// AWS API caller type.
	CallerType *string `locationName:"callerType" type:"string"`

	// Domain information for the AWS API call.
	DomainDetails *DomainDetails `locationName:"domainDetails" type:"structure"`

	// Remote IP information of the connection.
	RemoteIpDetails *RemoteIpDetails `locationName:"remoteIpDetails" type:"structure"`

	// AWS service name whose API was invoked.
	ServiceName *string `locationName:"serviceName" type:"string"`
}

// String returns the string representation
func (s AwsApiCallAction) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s AwsApiCallAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.Api != nil {
		v := *s.Api

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "api", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CallerType != nil {
		v := *s.CallerType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "callerType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DomainDetails != nil {
		v := s.DomainDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "domainDetails", v, metadata)
	}
	if s.RemoteIpDetails != nil {
		v := s.RemoteIpDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "remoteIpDetails", v, metadata)
	}
	if s.ServiceName != nil {
		v := *s.ServiceName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "serviceName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// City information of the remote IP address.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/City
type City struct {
	_ struct{} `type:"structure"`

	// City name of the remote IP address.
	CityName *string `locationName:"cityName" type:"string"`
}

// String returns the string representation
func (s City) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s City) MarshalFields(e protocol.FieldEncoder) error {
	if s.CityName != nil {
		v := *s.CityName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "cityName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Finding attribute (for example, accountId) for which conditions and values
// must be specified when querying findings.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/Condition
type Condition struct {
	_ struct{} `type:"structure"`

	// Represents the equal condition to be applied to a single field when querying
	// for findings.
	Eq []string `locationName:"eq" type:"list"`

	// Represents the greater than condition to be applied to a single field when
	// querying for findings.
	Gt *int64 `locationName:"gt" type:"integer"`

	// Represents the greater than equal condition to be applied to a single field
	// when querying for findings.
	Gte *int64 `locationName:"gte" type:"integer"`

	// Represents the less than condition to be applied to a single field when querying
	// for findings.
	Lt *int64 `locationName:"lt" type:"integer"`

	// Represents the less than equal condition to be applied to a single field
	// when querying for findings.
	Lte *int64 `locationName:"lte" type:"integer"`

	// Represents the not equal condition to be applied to a single field when querying
	// for findings.
	Neq []string `locationName:"neq" type:"list"`
}

// String returns the string representation
func (s Condition) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Condition) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Eq) > 0 {
		v := s.Eq

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "eq", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.Gt != nil {
		v := *s.Gt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "gt", protocol.Int64Value(v), metadata)
	}
	if s.Gte != nil {
		v := *s.Gte

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "gte", protocol.Int64Value(v), metadata)
	}
	if s.Lt != nil {
		v := *s.Lt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lt", protocol.Int64Value(v), metadata)
	}
	if s.Lte != nil {
		v := *s.Lte

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lte", protocol.Int64Value(v), metadata)
	}
	if len(s.Neq) > 0 {
		v := s.Neq

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "neq", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

// Country information of the remote IP address.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/Country
type Country struct {
	_ struct{} `type:"structure"`

	// Country code of the remote IP address.
	CountryCode *string `locationName:"countryCode" type:"string"`

	// Country name of the remote IP address.
	CountryName *string `locationName:"countryName" type:"string"`
}

// String returns the string representation
func (s Country) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Country) MarshalFields(e protocol.FieldEncoder) error {
	if s.CountryCode != nil {
		v := *s.CountryCode

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "countryCode", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.CountryName != nil {
		v := *s.CountryName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "countryName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about the DNS_REQUEST action described in this finding.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DnsRequestAction
type DnsRequestAction struct {
	_ struct{} `type:"structure"`

	// Domain information for the DNS request.
	Domain *string `locationName:"domain" type:"string"`
}

// String returns the string representation
func (s DnsRequestAction) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DnsRequestAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.Domain != nil {
		v := *s.Domain

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "domain", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Domain information for the AWS API call.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/DomainDetails
type DomainDetails struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DomainDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s DomainDetails) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

// Representation of a abnormal or suspicious activity.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/Finding
type Finding struct {
	_ struct{} `type:"structure"`

	// AWS account ID where the activity occurred that prompted GuardDuty to generate
	// a finding.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" type:"string" required:"true"`

	// The ARN of a finding described by the action.
	//
	// Arn is a required field
	Arn *string `locationName:"arn" type:"string" required:"true"`

	// The confidence level of a finding.
	Confidence *float64 `locationName:"confidence" type:"double"`

	// The time stamp at which a finding was generated.
	//
	// CreatedAt is a required field
	CreatedAt *string `locationName:"createdAt" type:"string" required:"true"`

	// The description of a finding.
	Description *string `locationName:"description" type:"string"`

	// The identifier that corresponds to a finding described by the action.
	//
	// Id is a required field
	Id *string `locationName:"id" type:"string" required:"true"`

	// The AWS resource partition.
	Partition *string `locationName:"partition" type:"string"`

	// The AWS region where the activity occurred that prompted GuardDuty to generate
	// a finding.
	//
	// Region is a required field
	Region *string `locationName:"region" type:"string" required:"true"`

	// The AWS resource associated with the activity that prompted GuardDuty to
	// generate a finding.
	//
	// Resource is a required field
	Resource *Resource `locationName:"resource" type:"structure" required:"true"`

	// Findings' schema version.
	//
	// SchemaVersion is a required field
	SchemaVersion *string `locationName:"schemaVersion" type:"string" required:"true"`

	// Additional information assigned to the generated finding by GuardDuty.
	Service *Service `locationName:"service" type:"structure"`

	// The severity of a finding.
	//
	// Severity is a required field
	Severity *float64 `locationName:"severity" type:"double" required:"true"`

	// The title of a finding.
	Title *string `locationName:"title" type:"string"`

	// The type of a finding described by the action.
	//
	// Type is a required field
	Type *string `locationName:"type" type:"string" required:"true"`

	// The time stamp at which a finding was last updated.
	//
	// UpdatedAt is a required field
	UpdatedAt *string `locationName:"updatedAt" type:"string" required:"true"`
}

// String returns the string representation
func (s Finding) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Finding) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Confidence != nil {
		v := *s.Confidence

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "confidence", protocol.Float64Value(v), metadata)
	}
	if s.CreatedAt != nil {
		v := *s.CreatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "createdAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Description != nil {
		v := *s.Description

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "description", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Partition != nil {
		v := *s.Partition

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "partition", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Region != nil {
		v := *s.Region

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "region", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Resource != nil {
		v := s.Resource

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "resource", v, metadata)
	}
	if s.SchemaVersion != nil {
		v := *s.SchemaVersion

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "schemaVersion", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Service != nil {
		v := s.Service

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "service", v, metadata)
	}
	if s.Severity != nil {
		v := *s.Severity

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "severity", protocol.Float64Value(v), metadata)
	}
	if s.Title != nil {
		v := *s.Title

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "title", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Type != nil {
		v := *s.Type

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "type", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UpdatedAt != nil {
		v := *s.UpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "updatedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents the criteria used for querying findings.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/FindingCriteria
type FindingCriteria struct {
	_ struct{} `type:"structure"`

	// Represents a map of finding properties that match specified conditions and
	// values when querying findings.
	Criterion map[string]Condition `locationName:"criterion" type:"map"`
}

// String returns the string representation
func (s FindingCriteria) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FindingCriteria) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Criterion) > 0 {
		v := s.Criterion

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "criterion", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetFields(k1, v1)
		}
		ms0.End()

	}
	return nil
}

// Finding statistics object.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/FindingStatistics
type FindingStatistics struct {
	_ struct{} `type:"structure"`

	// Represents a map of severity to count statistic for a set of findings
	CountBySeverity map[string]int64 `locationName:"countBySeverity" type:"map"`
}

// String returns the string representation
func (s FindingStatistics) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s FindingStatistics) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.CountBySeverity) > 0 {
		v := s.CountBySeverity

		metadata := protocol.Metadata{}
		ms0 := e.Map(protocol.BodyTarget, "countBySeverity", metadata)
		ms0.Start()
		for k1, v1 := range v {
			ms0.MapSetValue(k1, protocol.Int64Value(v1))
		}
		ms0.End()

	}
	return nil
}

// Location information of the remote IP address.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/GeoLocation
type GeoLocation struct {
	_ struct{} `type:"structure"`

	// Latitude information of remote IP address.
	Lat *float64 `locationName:"lat" type:"double"`

	// Longitude information of remote IP address.
	Lon *float64 `locationName:"lon" type:"double"`
}

// String returns the string representation
func (s GeoLocation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GeoLocation) MarshalFields(e protocol.FieldEncoder) error {
	if s.Lat != nil {
		v := *s.Lat

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lat", protocol.Float64Value(v), metadata)
	}
	if s.Lon != nil {
		v := *s.Lon

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "lon", protocol.Float64Value(v), metadata)
	}
	return nil
}

// The profile information of the EC2 instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/IamInstanceProfile
type IamInstanceProfile struct {
	_ struct{} `type:"structure"`

	// AWS EC2 instance profile ARN.
	Arn *string `locationName:"arn" type:"string"`

	// AWS EC2 instance profile ID.
	Id *string `locationName:"id" type:"string"`
}

// String returns the string representation
func (s IamInstanceProfile) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s IamInstanceProfile) MarshalFields(e protocol.FieldEncoder) error {
	if s.Arn != nil {
		v := *s.Arn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "arn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The information about the EC2 instance associated with the activity that
// prompted GuardDuty to generate a finding.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/InstanceDetails
type InstanceDetails struct {
	_ struct{} `type:"structure"`

	// The availability zone of the EC2 instance.
	AvailabilityZone *string `locationName:"availabilityZone" type:"string"`

	// The profile information of the EC2 instance.
	IamInstanceProfile *IamInstanceProfile `locationName:"iamInstanceProfile" type:"structure"`

	// The image description of the EC2 instance.
	ImageDescription *string `locationName:"imageDescription" type:"string"`

	// The image ID of the EC2 instance.
	ImageId *string `locationName:"imageId" type:"string"`

	// The ID of the EC2 instance.
	InstanceId *string `locationName:"instanceId" type:"string"`

	// The state of the EC2 instance.
	InstanceState *string `locationName:"instanceState" type:"string"`

	// The type of the EC2 instance.
	InstanceType *string `locationName:"instanceType" type:"string"`

	// The launch time of the EC2 instance.
	LaunchTime *string `locationName:"launchTime" type:"string"`

	// The network interface information of the EC2 instance.
	NetworkInterfaces []NetworkInterface `locationName:"networkInterfaces" type:"list"`

	// The platform of the EC2 instance.
	Platform *string `locationName:"platform" type:"string"`

	// The product code of the EC2 instance.
	ProductCodes []ProductCode `locationName:"productCodes" type:"list"`

	// The tags of the EC2 instance.
	Tags []Tag `locationName:"tags" type:"list"`
}

// String returns the string representation
func (s InstanceDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InstanceDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.AvailabilityZone != nil {
		v := *s.AvailabilityZone

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "availabilityZone", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.IamInstanceProfile != nil {
		v := s.IamInstanceProfile

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "iamInstanceProfile", v, metadata)
	}
	if s.ImageDescription != nil {
		v := *s.ImageDescription

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "imageDescription", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ImageId != nil {
		v := *s.ImageId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "imageId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InstanceId != nil {
		v := *s.InstanceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "instanceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InstanceState != nil {
		v := *s.InstanceState

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "instanceState", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InstanceType != nil {
		v := *s.InstanceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "instanceType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LaunchTime != nil {
		v := *s.LaunchTime

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "launchTime", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.NetworkInterfaces) > 0 {
		v := s.NetworkInterfaces

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "networkInterfaces", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Platform != nil {
		v := *s.Platform

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "platform", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.ProductCodes) > 0 {
		v := s.ProductCodes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "productCodes", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if len(s.Tags) > 0 {
		v := s.Tags

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "tags", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Invitation from an AWS account to become the current account's master.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/Invitation
type Invitation struct {
	_ struct{} `type:"structure"`

	// Inviter account ID
	AccountId *string `locationName:"accountId" type:"string"`

	// This value is used to validate the inviter account to the member account.
	InvitationId *string `locationName:"invitationId" type:"string"`

	// Timestamp at which the invitation was sent
	InvitedAt *string `locationName:"invitedAt" type:"string"`

	// The status of the relationship between the inviter and invitee accounts.
	RelationshipStatus *string `locationName:"relationshipStatus" type:"string"`
}

// String returns the string representation
func (s Invitation) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Invitation) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InvitationId != nil {
		v := *s.InvitationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "invitationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InvitedAt != nil {
		v := *s.InvitedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "invitedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RelationshipStatus != nil {
		v := *s.RelationshipStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "relationshipStatus", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Local port information of the connection.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/LocalPortDetails
type LocalPortDetails struct {
	_ struct{} `type:"structure"`

	// Port number of the local connection.
	Port *int64 `locationName:"port" type:"integer"`

	// Port name of the local connection.
	PortName *string `locationName:"portName" type:"string"`
}

// String returns the string representation
func (s LocalPortDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s LocalPortDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.Port != nil {
		v := *s.Port

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "port", protocol.Int64Value(v), metadata)
	}
	if s.PortName != nil {
		v := *s.PortName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "portName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains details about the master account.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/Master
type Master struct {
	_ struct{} `type:"structure"`

	// Master account ID
	AccountId *string `locationName:"accountId" type:"string"`

	// This value is used to validate the master account to the member account.
	InvitationId *string `locationName:"invitationId" type:"string"`

	// Timestamp at which the invitation was sent
	InvitedAt *string `locationName:"invitedAt" type:"string"`

	// The status of the relationship between the master and member accounts.
	RelationshipStatus *string `locationName:"relationshipStatus" type:"string"`
}

// String returns the string representation
func (s Master) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Master) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InvitationId != nil {
		v := *s.InvitationId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "invitationId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InvitedAt != nil {
		v := *s.InvitedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "invitedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RelationshipStatus != nil {
		v := *s.RelationshipStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "relationshipStatus", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Contains details about the member account.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/Member
type Member struct {
	_ struct{} `type:"structure"`

	// AWS account ID.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" type:"string" required:"true"`

	// The unique identifier for a detector.
	DetectorId *string `locationName:"detectorId" type:"string"`

	// Member account's email address.
	//
	// Email is a required field
	Email *string `locationName:"email" type:"string" required:"true"`

	// Timestamp at which the invitation was sent
	InvitedAt *string `locationName:"invitedAt" type:"string"`

	// The master account ID.
	//
	// MasterId is a required field
	MasterId *string `locationName:"masterId" type:"string" required:"true"`

	// The status of the relationship between the member and the master.
	//
	// RelationshipStatus is a required field
	RelationshipStatus *string `locationName:"relationshipStatus" type:"string" required:"true"`

	// The first time a resource was created. The format will be ISO-8601.
	//
	// UpdatedAt is a required field
	UpdatedAt *string `locationName:"updatedAt" type:"string" required:"true"`
}

// String returns the string representation
func (s Member) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Member) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DetectorId != nil {
		v := *s.DetectorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "detectorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Email != nil {
		v := *s.Email

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "email", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.InvitedAt != nil {
		v := *s.InvitedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "invitedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.MasterId != nil {
		v := *s.MasterId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "masterId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RelationshipStatus != nil {
		v := *s.RelationshipStatus

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "relationshipStatus", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UpdatedAt != nil {
		v := *s.UpdatedAt

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "updatedAt", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about the NETWORK_CONNECTION action described in this finding.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/NetworkConnectionAction
type NetworkConnectionAction struct {
	_ struct{} `type:"structure"`

	// Network connection blocked information.
	Blocked *bool `locationName:"blocked" type:"boolean"`

	// Network connection direction.
	ConnectionDirection *string `locationName:"connectionDirection" type:"string"`

	// Local port information of the connection.
	LocalPortDetails *LocalPortDetails `locationName:"localPortDetails" type:"structure"`

	// Network connection protocol.
	Protocol *string `locationName:"protocol" type:"string"`

	// Remote IP information of the connection.
	RemoteIpDetails *RemoteIpDetails `locationName:"remoteIpDetails" type:"structure"`

	// Remote port information of the connection.
	RemotePortDetails *RemotePortDetails `locationName:"remotePortDetails" type:"structure"`
}

// String returns the string representation
func (s NetworkConnectionAction) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NetworkConnectionAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.Blocked != nil {
		v := *s.Blocked

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "blocked", protocol.BoolValue(v), metadata)
	}
	if s.ConnectionDirection != nil {
		v := *s.ConnectionDirection

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "connectionDirection", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.LocalPortDetails != nil {
		v := s.LocalPortDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "localPortDetails", v, metadata)
	}
	if s.Protocol != nil {
		v := *s.Protocol

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "protocol", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RemoteIpDetails != nil {
		v := s.RemoteIpDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "remoteIpDetails", v, metadata)
	}
	if s.RemotePortDetails != nil {
		v := s.RemotePortDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "remotePortDetails", v, metadata)
	}
	return nil
}

// The network interface information of the EC2 instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/NetworkInterface
type NetworkInterface struct {
	_ struct{} `type:"structure"`

	// A list of EC2 instance IPv6 address information.
	Ipv6Addresses []string `locationName:"ipv6Addresses" type:"list"`

	// The ID of the network interface
	NetworkInterfaceId *string `locationName:"networkInterfaceId" type:"string"`

	// Private DNS name of the EC2 instance.
	PrivateDnsName *string `locationName:"privateDnsName" type:"string"`

	// Private IP address of the EC2 instance.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`

	// Other private IP address information of the EC2 instance.
	PrivateIpAddresses []PrivateIpAddressDetails `locationName:"privateIpAddresses" type:"list"`

	// Public DNS name of the EC2 instance.
	PublicDnsName *string `locationName:"publicDnsName" type:"string"`

	// Public IP address of the EC2 instance.
	PublicIp *string `locationName:"publicIp" type:"string"`

	// Security groups associated with the EC2 instance.
	SecurityGroups []SecurityGroup `locationName:"securityGroups" type:"list"`

	// The subnet ID of the EC2 instance.
	SubnetId *string `locationName:"subnetId" type:"string"`

	// The VPC ID of the EC2 instance.
	VpcId *string `locationName:"vpcId" type:"string"`
}

// String returns the string representation
func (s NetworkInterface) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s NetworkInterface) MarshalFields(e protocol.FieldEncoder) error {
	if len(s.Ipv6Addresses) > 0 {
		v := s.Ipv6Addresses

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "ipv6Addresses", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.NetworkInterfaceId != nil {
		v := *s.NetworkInterfaceId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "networkInterfaceId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PrivateDnsName != nil {
		v := *s.PrivateDnsName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "privateDnsName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PrivateIpAddress != nil {
		v := *s.PrivateIpAddress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "privateIpAddress", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.PrivateIpAddresses) > 0 {
		v := s.PrivateIpAddresses

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "privateIpAddresses", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.PublicDnsName != nil {
		v := *s.PublicDnsName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "publicDnsName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PublicIp != nil {
		v := *s.PublicIp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "publicIp", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.SecurityGroups) > 0 {
		v := s.SecurityGroups

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "securityGroups", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.SubnetId != nil {
		v := *s.SubnetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "subnetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.VpcId != nil {
		v := *s.VpcId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "vpcId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// ISP Organization information of the remote IP address.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/Organization
type Organization struct {
	_ struct{} `type:"structure"`

	// Autonomous system number of the internet provider of the remote IP address.
	Asn *string `locationName:"asn" type:"string"`

	// Organization that registered this ASN.
	AsnOrg *string `locationName:"asnOrg" type:"string"`

	// ISP information for the internet provider.
	Isp *string `locationName:"isp" type:"string"`

	// Name of the internet provider.
	Org *string `locationName:"org" type:"string"`
}

// String returns the string representation
func (s Organization) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Organization) MarshalFields(e protocol.FieldEncoder) error {
	if s.Asn != nil {
		v := *s.Asn

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "asn", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AsnOrg != nil {
		v := *s.AsnOrg

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "asnOrg", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Isp != nil {
		v := *s.Isp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "isp", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Org != nil {
		v := *s.Org

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "org", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Information about the PORT_PROBE action described in this finding.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/PortProbeAction
type PortProbeAction struct {
	_ struct{} `type:"structure"`

	// Port probe blocked information.
	Blocked *bool `locationName:"blocked" type:"boolean"`

	// A list of port probe details objects.
	PortProbeDetails []PortProbeDetail `locationName:"portProbeDetails" type:"list"`
}

// String returns the string representation
func (s PortProbeAction) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PortProbeAction) MarshalFields(e protocol.FieldEncoder) error {
	if s.Blocked != nil {
		v := *s.Blocked

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "blocked", protocol.BoolValue(v), metadata)
	}
	if len(s.PortProbeDetails) > 0 {
		v := s.PortProbeDetails

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "portProbeDetails", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

// Details about the port probe finding.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/PortProbeDetail
type PortProbeDetail struct {
	_ struct{} `type:"structure"`

	// Local port information of the connection.
	LocalPortDetails *LocalPortDetails `locationName:"localPortDetails" type:"structure"`

	// Remote IP information of the connection.
	RemoteIpDetails *RemoteIpDetails `locationName:"remoteIpDetails" type:"structure"`
}

// String returns the string representation
func (s PortProbeDetail) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PortProbeDetail) MarshalFields(e protocol.FieldEncoder) error {
	if s.LocalPortDetails != nil {
		v := s.LocalPortDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "localPortDetails", v, metadata)
	}
	if s.RemoteIpDetails != nil {
		v := s.RemoteIpDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "remoteIpDetails", v, metadata)
	}
	return nil
}

// Other private IP address information of the EC2 instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/PrivateIpAddressDetails
type PrivateIpAddressDetails struct {
	_ struct{} `type:"structure"`

	// Private DNS name of the EC2 instance.
	PrivateDnsName *string `locationName:"privateDnsName" type:"string"`

	// Private IP address of the EC2 instance.
	PrivateIpAddress *string `locationName:"privateIpAddress" type:"string"`
}

// String returns the string representation
func (s PrivateIpAddressDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s PrivateIpAddressDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.PrivateDnsName != nil {
		v := *s.PrivateDnsName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "privateDnsName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.PrivateIpAddress != nil {
		v := *s.PrivateIpAddress

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "privateIpAddress", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The product code of the EC2 instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/ProductCode
type ProductCode struct {
	_ struct{} `type:"structure"`

	// Product code information.
	Code *string `locationName:"code" type:"string"`

	// Product code type.
	ProductType *string `locationName:"productType" type:"string"`
}

// String returns the string representation
func (s ProductCode) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ProductCode) MarshalFields(e protocol.FieldEncoder) error {
	if s.Code != nil {
		v := *s.Code

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "code", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ProductType != nil {
		v := *s.ProductType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "productType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Remote IP information of the connection.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/RemoteIpDetails
type RemoteIpDetails struct {
	_ struct{} `type:"structure"`

	// City information of the remote IP address.
	City *City `locationName:"city" type:"structure"`

	// Country code of the remote IP address.
	Country *Country `locationName:"country" type:"structure"`

	// Location information of the remote IP address.
	GeoLocation *GeoLocation `locationName:"geoLocation" type:"structure"`

	// IPV4 remote address of the connection.
	IpAddressV4 *string `locationName:"ipAddressV4" type:"string"`

	// ISP Organization information of the remote IP address.
	Organization *Organization `locationName:"organization" type:"structure"`
}

// String returns the string representation
func (s RemoteIpDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RemoteIpDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.City != nil {
		v := s.City

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "city", v, metadata)
	}
	if s.Country != nil {
		v := s.Country

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "country", v, metadata)
	}
	if s.GeoLocation != nil {
		v := s.GeoLocation

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "geoLocation", v, metadata)
	}
	if s.IpAddressV4 != nil {
		v := *s.IpAddressV4

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ipAddressV4", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Organization != nil {
		v := s.Organization

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "organization", v, metadata)
	}
	return nil
}

// Remote port information of the connection.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/RemotePortDetails
type RemotePortDetails struct {
	_ struct{} `type:"structure"`

	// Port number of the remote connection.
	Port *int64 `locationName:"port" type:"integer"`

	// Port name of the remote connection.
	PortName *string `locationName:"portName" type:"string"`
}

// String returns the string representation
func (s RemotePortDetails) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s RemotePortDetails) MarshalFields(e protocol.FieldEncoder) error {
	if s.Port != nil {
		v := *s.Port

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "port", protocol.Int64Value(v), metadata)
	}
	if s.PortName != nil {
		v := *s.PortName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "portName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// The AWS resource associated with the activity that prompted GuardDuty to
// generate a finding.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/Resource
type Resource struct {
	_ struct{} `type:"structure"`

	// The IAM access key details (IAM user information) of a user that engaged
	// in the activity that prompted GuardDuty to generate a finding.
	AccessKeyDetails *AccessKeyDetails `locationName:"accessKeyDetails" type:"structure"`

	// The information about the EC2 instance associated with the activity that
	// prompted GuardDuty to generate a finding.
	InstanceDetails *InstanceDetails `locationName:"instanceDetails" type:"structure"`

	// The type of the AWS resource.
	ResourceType *string `locationName:"resourceType" type:"string"`
}

// String returns the string representation
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Resource) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccessKeyDetails != nil {
		v := s.AccessKeyDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "accessKeyDetails", v, metadata)
	}
	if s.InstanceDetails != nil {
		v := s.InstanceDetails

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "instanceDetails", v, metadata)
	}
	if s.ResourceType != nil {
		v := *s.ResourceType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "resourceType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Security groups associated with the EC2 instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/SecurityGroup
type SecurityGroup struct {
	_ struct{} `type:"structure"`

	// EC2 instance's security group ID.
	GroupId *string `locationName:"groupId" type:"string"`

	// EC2 instance's security group name.
	GroupName *string `locationName:"groupName" type:"string"`
}

// String returns the string representation
func (s SecurityGroup) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SecurityGroup) MarshalFields(e protocol.FieldEncoder) error {
	if s.GroupId != nil {
		v := *s.GroupId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "groupId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.GroupName != nil {
		v := *s.GroupName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "groupName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Additional information assigned to the generated finding by GuardDuty.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/Service
type Service struct {
	_ struct{} `type:"structure"`

	// Information about the activity described in a finding.
	Action *Action `locationName:"action" type:"structure"`

	// Indicates whether this finding is archived.
	Archived *bool `locationName:"archived" type:"boolean"`

	// Total count of the occurrences of this finding type.
	Count *int64 `locationName:"count" type:"integer"`

	// Detector ID for the GuardDuty service.
	DetectorId *string `locationName:"detectorId" type:"string"`

	// First seen timestamp of the activity that prompted GuardDuty to generate
	// this finding.
	EventFirstSeen *string `locationName:"eventFirstSeen" type:"string"`

	// Last seen timestamp of the activity that prompted GuardDuty to generate this
	// finding.
	EventLastSeen *string `locationName:"eventLastSeen" type:"string"`

	// Resource role information for this finding.
	ResourceRole *string `locationName:"resourceRole" type:"string"`

	// The name of the AWS service (GuardDuty) that generated a finding.
	ServiceName *string `locationName:"serviceName" type:"string"`

	// Feedback left about the finding.
	UserFeedback *string `locationName:"userFeedback" type:"string"`
}

// String returns the string representation
func (s Service) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Service) MarshalFields(e protocol.FieldEncoder) error {
	if s.Action != nil {
		v := s.Action

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "action", v, metadata)
	}
	if s.Archived != nil {
		v := *s.Archived

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "archived", protocol.BoolValue(v), metadata)
	}
	if s.Count != nil {
		v := *s.Count

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "count", protocol.Int64Value(v), metadata)
	}
	if s.DetectorId != nil {
		v := *s.DetectorId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "detectorId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EventFirstSeen != nil {
		v := *s.EventFirstSeen

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "eventFirstSeen", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.EventLastSeen != nil {
		v := *s.EventLastSeen

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "eventLastSeen", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ResourceRole != nil {
		v := *s.ResourceRole

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "resourceRole", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ServiceName != nil {
		v := *s.ServiceName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "serviceName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.UserFeedback != nil {
		v := *s.UserFeedback

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "userFeedback", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents the criteria used for sorting findings.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/SortCriteria
type SortCriteria struct {
	_ struct{} `type:"structure"`

	// Represents the finding attribute (for example, accountId) by which to sort
	// findings.
	AttributeName *string `locationName:"attributeName" type:"string"`

	// Order by which the sorted findings are to be displayed.
	OrderBy OrderBy `locationName:"orderBy" type:"string" enum:"true"`
}

// String returns the string representation
func (s SortCriteria) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s SortCriteria) MarshalFields(e protocol.FieldEncoder) error {
	if s.AttributeName != nil {
		v := *s.AttributeName

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "attributeName", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if len(s.OrderBy) > 0 {
		v := s.OrderBy

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "orderBy", protocol.QuotedValue{ValueMarshaler: v}, metadata)
	}
	return nil
}

// A tag of the EC2 instance.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/Tag
type Tag struct {
	_ struct{} `type:"structure"`

	// EC2 instance tag key.
	Key *string `locationName:"key" type:"string"`

	// EC2 instance tag value.
	Value *string `locationName:"value" type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s Tag) MarshalFields(e protocol.FieldEncoder) error {
	if s.Key != nil {
		v := *s.Key

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "key", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Value != nil {
		v := *s.Value

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "value", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// An object containing the unprocessed account and a result string explaining
// why it was unprocessed.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/guardduty-2017-11-28/UnprocessedAccount
type UnprocessedAccount struct {
	_ struct{} `type:"structure"`

	// AWS Account ID.
	//
	// AccountId is a required field
	AccountId *string `locationName:"accountId" type:"string" required:"true"`

	// A reason why the account hasn't been processed.
	//
	// Result is a required field
	Result *string `locationName:"result" type:"string" required:"true"`
}

// String returns the string representation
func (s UnprocessedAccount) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s UnprocessedAccount) MarshalFields(e protocol.FieldEncoder) error {
	if s.AccountId != nil {
		v := *s.AccountId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "accountId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Result != nil {
		v := *s.Result

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "result", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}
