// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package health

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventDetailsRequest
type DescribeEventDetailsInput struct {
	_ struct{} `type:"structure"`

	// A list of event ARNs (unique identifiers). For example: "arn:aws:health:us-east-1::event/EC2/EC2_INSTANCE_RETIREMENT_SCHEDULED/EC2_INSTANCE_RETIREMENT_SCHEDULED_ABC123-CDE456",
	// "arn:aws:health:us-west-1::event/EBS/AWS_EBS_LOST_VOLUME/AWS_EBS_LOST_VOLUME_CHI789_JKL101"
	//
	// EventArns is a required field
	EventArns []string `locationName:"eventArns" min:"1" type:"list" required:"true"`

	// The locale (language) to return information in. English (en) is the default
	// and the only supported value at this time.
	Locale *string `locationName:"locale" min:"2" type:"string"`
}

// String returns the string representation
func (s DescribeEventDetailsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEventDetailsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeEventDetailsInput"}

	if s.EventArns == nil {
		invalidParams.Add(aws.NewErrParamRequired("EventArns"))
	}
	if s.EventArns != nil && len(s.EventArns) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("EventArns", 1))
	}
	if s.Locale != nil && len(*s.Locale) < 2 {
		invalidParams.Add(aws.NewErrParamMinLen("Locale", 2))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Please also see https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventDetailsResponse
type DescribeEventDetailsOutput struct {
	_ struct{} `type:"structure"`

	// Error messages for any events that could not be retrieved.
	FailedSet []EventDetailsErrorItem `locationName:"failedSet" type:"list"`

	// Information about the events that could be retrieved.
	SuccessfulSet []EventDetails `locationName:"successfulSet" type:"list"`
}

// String returns the string representation
func (s DescribeEventDetailsOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeEventDetails = "DescribeEventDetails"

// DescribeEventDetailsRequest returns a request value for making API operation for
// AWS Health APIs and Notifications.
//
// Returns detailed information about one or more specified events. Information
// includes standard event data (region, service, etc., as returned by DescribeEvents),
// a detailed event description, and possible additional metadata that depends
// upon the nature of the event. Affected entities are not included; to retrieve
// those, use the DescribeAffectedEntities operation.
//
// If a specified event cannot be retrieved, an error message is returned for
// that event.
//
//    // Example sending a request using DescribeEventDetailsRequest.
//    req := client.DescribeEventDetailsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/health-2016-08-04/DescribeEventDetails
func (c *Client) DescribeEventDetailsRequest(input *DescribeEventDetailsInput) DescribeEventDetailsRequest {
	op := &aws.Operation{
		Name:       opDescribeEventDetails,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEventDetailsInput{}
	}

	req := c.newRequest(op, input, &DescribeEventDetailsOutput{})
	return DescribeEventDetailsRequest{Request: req, Input: input, Copy: c.DescribeEventDetailsRequest}
}

// DescribeEventDetailsRequest is the request type for the
// DescribeEventDetails API operation.
type DescribeEventDetailsRequest struct {
	*aws.Request
	Input *DescribeEventDetailsInput
	Copy  func(*DescribeEventDetailsInput) DescribeEventDetailsRequest
}

// Send marshals and sends the DescribeEventDetails API request.
func (r DescribeEventDetailsRequest) Send(ctx context.Context) (*DescribeEventDetailsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeEventDetailsResponse{
		DescribeEventDetailsOutput: r.Request.Data.(*DescribeEventDetailsOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeEventDetailsResponse is the response type for the
// DescribeEventDetails API operation.
type DescribeEventDetailsResponse struct {
	*DescribeEventDetailsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeEventDetails request.
func (r *DescribeEventDetailsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
