// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateSAMLProviderRequest
type CreateSAMLProviderInput struct {
	_ struct{} `type:"structure"`

	// The name of the provider to create.
	//
	// This parameter allows (through its regex pattern (http://wikipedia.org/wiki/regex))
	// a string of characters consisting of upper and lowercase alphanumeric characters
	// with no spaces. You can also include any of the following characters: _+=,.@-
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// An XML document generated by an identity provider (IdP) that supports SAML
	// 2.0. The document includes the issuer's name, expiration information, and
	// keys that can be used to validate the SAML authentication response (assertions)
	// that are received from the IdP. You must generate the metadata document using
	// the identity management software that is used as your organization's IdP.
	//
	// For more information, see About SAML 2.0-based Federation (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html)
	// in the IAM User Guide
	//
	// SAMLMetadataDocument is a required field
	SAMLMetadataDocument *string `min:"1000" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateSAMLProviderInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSAMLProviderInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateSAMLProviderInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.SAMLMetadataDocument == nil {
		invalidParams.Add(aws.NewErrParamRequired("SAMLMetadataDocument"))
	}
	if s.SAMLMetadataDocument != nil && len(*s.SAMLMetadataDocument) < 1000 {
		invalidParams.Add(aws.NewErrParamMinLen("SAMLMetadataDocument", 1000))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Contains the response to a successful CreateSAMLProvider request.
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateSAMLProviderResponse
type CreateSAMLProviderOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the new SAML provider resource in IAM.
	SAMLProviderArn *string `min:"20" type:"string"`
}

// String returns the string representation
func (s CreateSAMLProviderOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateSAMLProvider = "CreateSAMLProvider"

// CreateSAMLProviderRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Creates an IAM resource that describes an identity provider (IdP) that supports
// SAML 2.0.
//
// The SAML provider resource that you create with this operation can be used
// as a principal in an IAM role's trust policy. Such a policy can enable federated
// users who sign in using the SAML IdP to assume the role. You can create an
// IAM role that supports Web-based single sign-on (SSO) to the AWS Management
// Console or one that supports API access to AWS.
//
// When you create the SAML provider resource, you upload a SAML metadata document
// that you get from your IdP. That document includes the issuer's name, expiration
// information, and keys that can be used to validate the SAML authentication
// response (assertions) that the IdP sends. You must generate the metadata
// document using the identity management software that is used as your organization's
// IdP.
//
// This operation requires Signature Version 4 (https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
//
// For more information, see Enabling SAML 2.0 Federated Users to Access the
// AWS Management Console (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-saml.html)
// and About SAML 2.0-based Federation (https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html)
// in the IAM User Guide.
//
//    // Example sending a request using CreateSAMLProviderRequest.
//    req := client.CreateSAMLProviderRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/CreateSAMLProvider
func (c *Client) CreateSAMLProviderRequest(input *CreateSAMLProviderInput) CreateSAMLProviderRequest {
	op := &aws.Operation{
		Name:       opCreateSAMLProvider,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSAMLProviderInput{}
	}

	req := c.newRequest(op, input, &CreateSAMLProviderOutput{})
	return CreateSAMLProviderRequest{Request: req, Input: input, Copy: c.CreateSAMLProviderRequest}
}

// CreateSAMLProviderRequest is the request type for the
// CreateSAMLProvider API operation.
type CreateSAMLProviderRequest struct {
	*aws.Request
	Input *CreateSAMLProviderInput
	Copy  func(*CreateSAMLProviderInput) CreateSAMLProviderRequest
}

// Send marshals and sends the CreateSAMLProvider API request.
func (r CreateSAMLProviderRequest) Send(ctx context.Context) (*CreateSAMLProviderResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateSAMLProviderResponse{
		CreateSAMLProviderOutput: r.Request.Data.(*CreateSAMLProviderOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateSAMLProviderResponse is the response type for the
// CreateSAMLProvider API operation.
type CreateSAMLProviderResponse struct {
	*CreateSAMLProviderOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateSAMLProvider request.
func (r *CreateSAMLProviderResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
